/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.ChannelJXCAccountBookFactory;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillInfo;
import com.kingdee.eas.scm.sd.channel.app.AbstractChannelSaleIssueBillControllerBean;
import com.kingdee.eas.scm.sd.channel.app.AutoSaleIssueProcessor;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelInventoryHelper;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class ChannelSaleIssueBillControllerBean
extends AbstractChannelSaleIssueBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ChannelSaleIssueBillControllerBean");
    private static final BigDecimal DONE = new BigDecimal("-1");
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.fromSaleOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.fromSaleOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.fromSaleOrgUnit.number"));
        ChannelSaleIssueBillInfo billInfo = this.getChannelSaleIssueBillInfo(ctx, pk, sic);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        int j = billInfo.getEntries().size();
        for (int i = 0; i < j; ++i) {
            billInfo.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.AUDITED);
        }
        this.update(ctx, pk, billInfo);
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)billInfo, BizActionEnum.AUDIT);
            }
            this.autoCreateBill(ctx, billInfo);
            try {
                ChannelJXCAccountBookFactory.getLocalInstance(ctx).audit(pk.toString(), billInfo.getBizDate(), billInfo.getSaleOrgUnit().getId().toString(), billInfo.getChannel().getId().toString(), false);
            }
            catch (BOSException e) {
                logger.error((Object)"Bill updated failed books\uff01", (Throwable)e);
                throw e;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _alert(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelSaleIssueBillInfo billInfo = (ChannelSaleIssueBillInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
        ChannelSaleIssueBillInfo tempBillInfo = this.getChannelSaleIssueBillInfo(ctx, (IObjectPK)pk);
        if (this.isUpdateChannelInventory(ctx, (IObjectPK)pk, billInfo)) {
            try {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)this.alterQty(tempBillInfo, billInfo), BizActionEnum.AUDIT);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        tempBillInfo.setId(null);
        tempBillInfo.setVersion(billInfo.getVersion() + 1);
        tempBillInfo.setAlterDate(new Date());
        tempBillInfo.setBaseStatus(BillBaseStatusEnum.VERSION);
        ChannelSaleIssueBillEntryCollection entries = tempBillInfo.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entries.get(i).setId(null);
        }
        this.addnew(ctx, tempBillInfo);
        billInfo.setAlterDate(new Date());
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    @Override
    protected void _alterSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelSaleIssueBillInfo billInfo = (ChannelSaleIssueBillInfo)model;
        if (billInfo.getBaseStatus().getValue() != 4 && billInfo.getBaseStatus().getValue() != -2) {
            throw new ChannelBillException(ChannelBillException.SUBMIT_IS_AUDIT);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    private ChannelSaleIssueBillInfo alterQty(ChannelSaleIssueBillInfo oldInfo, ChannelSaleIssueBillInfo newInfo) {
        ChannelSaleIssueBillEntryInfo entryInfo;
        ChannelSaleIssueBillEntryInfo entryInfoOld;
        ChannelSaleIssueBillEntryInfo entryInfoNew;
        int i;
        int size;
        ChannelSaleIssueBillEntryCollection entries;
        ChannelSaleIssueBillEntryCollection entriesOld;
        ChannelSaleIssueBillEntryCollection entriesNew;
        ChannelSaleIssueBillInfo tempInfo = (ChannelSaleIssueBillInfo)newInfo.clone();
        if (newInfo.getSaleIssueType().getValue() == 3) {
            entriesNew = newInfo.getEntries();
            entriesOld = oldInfo.getEntries();
            entries = tempInfo.getEntries();
            size = entriesNew.size();
            for (i = 0; i < size; ++i) {
                entryInfoNew = entriesNew.get(i);
                entryInfoOld = entriesOld.get(i);
                entryInfo = entries.get(i);
                entryInfo.setAssistQty(entryInfoNew.getAssistQty() != null ? entryInfoOld.getAssistQty().subtract(entryInfoNew.getAssistQty()) : entryInfoNew.getAssistQty());
                entryInfo.setAssociateQty(entryInfoNew.getAssociateQty() != null ? entryInfoOld.getAssociateQty().subtract(entryInfoNew.getAssociateQty()) : entryInfoNew.getAssociateQty());
                entryInfo.setBaseQty(entryInfoNew.getBaseQty() != null ? entryInfoOld.getBaseQty().subtract(entryInfoNew.getBaseQty()) : entryInfoNew.getBaseQty());
                entryInfo.setQty(entryInfoNew.getQty() != null ? entryInfoOld.getQty().subtract(entryInfoNew.getQty()) : entryInfoNew.getQty());
                entryInfo.setAmount(entryInfoNew.getAmount() != null ? entryInfoOld.getAmount().subtract(entryInfoNew.getAmount()) : entryInfoNew.getAmount());
                entryInfo.setLocalAmount(entryInfoNew.getAmount() != null ? entryInfoOld.getAmount().subtract(entryInfoNew.getLocalAmount()) : entryInfoNew.getAmount());
            }
        }
        if (newInfo.getSaleIssueType().getValue() == 1) {
            entriesNew = newInfo.getEntries();
            entriesOld = oldInfo.getEntries();
            entries = tempInfo.getEntries();
            size = entriesNew.size();
            for (i = 0; i < size; ++i) {
                entryInfoNew = entriesNew.get(i);
                entryInfoOld = entriesOld.get(i);
                entryInfo = entries.get(i);
                entryInfo.setAssistQty(entryInfoNew.getAssistQty() != null ? entryInfoNew.getAssistQty().subtract(entryInfoOld.getAssistQty()) : entryInfoNew.getAssistQty());
                entryInfo.setAssociateQty(entryInfoNew.getAssociateQty() != null ? entryInfoNew.getAssociateQty().subtract(entryInfoOld.getAssociateQty()) : entryInfoNew.getAssociateQty());
                entryInfo.setBaseQty(entryInfoNew.getBaseQty() != null ? entryInfoNew.getBaseQty().subtract(entryInfoOld.getBaseQty()) : entryInfoNew.getBaseQty());
                entryInfo.setQty(entryInfoNew.getQty() != null ? entryInfoNew.getQty().subtract(entryInfoOld.getQty()) : entryInfoNew.getQty());
                entryInfo.setAmount(entryInfoNew.getAmount() != null ? entryInfoNew.getAmount().subtract(entryInfoOld.getAmount()) : entryInfoNew.getAmount());
                entryInfo.setLocalAmount(entryInfoNew.getAmount() != null ? entryInfoNew.getAmount().subtract(entryInfoOld.getLocalAmount()) : entryInfoNew.getAmount());
            }
        }
        return tempInfo;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.audit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelSaleIssueBillInfo billInfo = this.getChannelSaleIssueBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYAUDITCANUNAUDIT, new String[]{billInfo.getNumber()});
        }
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (!this.isUnAudit(ctx, billInfo, orgUnitID, 2)) {
            throw new ChannelBillException(ChannelBillException.NOALLOWUNADUIT);
        }
        if (!this.isAutoDeleteBill(ctx, billInfo)) {
            throw new ChannelBillException(ChannelBillException.NOALLOWUNADUITFORINWAREHS);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        this.update(ctx, pk, billInfo);
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                ChannelSaleIssueBillInfo tempInfo = (ChannelSaleIssueBillInfo)billInfo.clone();
                this.updateQtyByBillType(tempInfo);
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)tempInfo, BizActionEnum.UNAUDIT);
            }
            this.autoDeleteBill(ctx, billInfo);
            try {
                ChannelJXCAccountBookFactory.getLocalInstance(ctx).unAudit(pk.toString(), billInfo.getBizDate(), billInfo.getSaleOrgUnit().getId().toString(), billInfo.getChannel().getId().toString(), false);
            }
            catch (BOSException e) {
                logger.error((Object)"Bill updated failed books\uff01", (Throwable)e);
                throw e;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }

    private void autoCreateBill(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        AutoSaleIssueProcessor.getInstance().autoCreate(ctx, billInfo);
    }

    private void autoDeleteBill(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        AutoSaleIssueProcessor.getInstance().autoDelete(ctx, billInfo);
    }

    private boolean isAutoDeleteBill(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        return AutoSaleIssueProcessor.getInstance().isAutoDelete(ctx, billInfo);
    }

    private boolean isUpdateChannelInventory(Context ctx, IObjectPK pk, ChannelSaleIssueBillInfo billInfo) throws BOSException, EASBizException {
        DataCollectionTypeEnum channelUpdateType;
        ChannelBaseInfo channelBaseInfo = billInfo.getChannel();
        if (channelBaseInfo != null) {
            channelBaseInfo = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseInfo((IObjectPK)new ObjectUuidPK(channelBaseInfo.getId().toString()));
        }
        return (channelUpdateType = channelBaseInfo.getDataCollectionType()).getValue().equals("1");
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelSaleIssueBillInfo billInfo = (ChannelSaleIssueBillInfo)model;
        ObjectUuidPK pk = null;
        if (!this.isAddNew(ctx, (IObjectValue)billInfo)) {
            pk = new ObjectUuidPK(billInfo.getId());
            this.checkSubmit(ctx, billInfo);
        }
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("pGlaTAEaEADgAABEwKg9C0Y+1VI="));
        billInfo.setBillType(billTypeInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        this.updateQtyByBillType(billInfo);
        pk = super._submit(ctx, model);
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, billInfo, orgUnitID, 2)) {
            this.auditAndLog(ctx, (IObjectPK)pk, billInfo.getBOSType(), billInfo.getNumber(), null);
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelSaleIssueBillInfo billInfo = (ChannelSaleIssueBillInfo)model;
        this.checkSave(ctx, billInfo);
        this.updateQtyByBillType(billInfo);
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelSaleIssueBillInfo billInfo = this.getChannelSaleIssueBillInfo(ctx, pk);
        this.checkDelete(ctx, billInfo);
        super._delete(ctx, pk);
    }

    private void checkDelete(Context ctx, ChannelSaleIssueBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.DELETE_IS_AUDIT);
        }
    }

    private void checkSubmit(Context ctx, ChannelSaleIssueBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.SUBMIT_IS_AUDIT);
        }
    }

    private void checkSave(Context ctx, ChannelSaleIssueBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null) {
            if (billInfo.getBaseStatus().getValue() == 4) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_AUDIT);
            }
            if (billInfo.getBaseStatus().getValue() == 2) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_SUBMIT);
            }
        }
    }

    private void updateQtyByBillType(ChannelSaleIssueBillInfo billInfo) {
        if (billInfo == null || billInfo != null && billInfo.getSaleIssueType() == null) {
            return;
        }
        if (billInfo.getSaleIssueType().getValue() == 3) {
            ChannelSaleIssueBillEntryCollection entries = billInfo.getEntries();
            ChannelSaleIssueBillEntryInfo entryInfo = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entries.get(i);
                entryInfo.setAssistQty(this.dealNegativeQty(entryInfo.getAssistQty()));
                entryInfo.setAssociateQty(this.dealNegativeQty(entryInfo.getAssociateQty()));
                entryInfo.setBaseQty(this.dealNegativeQty(entryInfo.getBaseQty()));
                entryInfo.setQty(this.dealNegativeQty(entryInfo.getQty()));
                entryInfo.setAmount(this.dealNegativeQty(entryInfo.getAmount()));
                entryInfo.setLocalAmount(this.dealNegativeQty(entryInfo.getAmount()));
            }
            billInfo.setSumMoney(this.dealNegativeQty(billInfo.getSumMoney()));
            billInfo.setSumQty(this.dealNegativeQty(billInfo.getSumQty()));
        }
    }

    private BigDecimal dealNegativeQty(BigDecimal qty) {
        if (qty != null && qty.compareTo(ZERO) > 0) {
            qty = qty.multiply(DONE);
        }
        return qty;
    }
}

