/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.credit.CreditParamFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditAnalysisRptFacadeControllerBean;
import com.kingdee.eas.scm.sd.channel.app.AbstractCreditFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditFacadeControllerBean
extends AbstractCreditFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)CreditFacadeControllerBean.class.getName());

    @Override
    protected boolean _isChannelCredited(Context ctx, String customerId, String companyId) throws BOSException {
        boolean isChannelCredited = false;
        if (!StringUtil.isEmpty((String)customerId) && !StringUtil.isEmpty((String)companyId)) {
            CreditParamInfo creditParam = null;
            try {
                creditParam = CreditParamFacadeFactory.getLocalInstance((Context)ctx).getParameter(companyId);
            }
            catch (EASBizException e) {
                throw new BOSException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"3_CreditFacadeControllerBean", (Locale)ctx.getLocale()), companyId), (Throwable)e);
            }
            if (creditParam != null && creditParam.isCompnayCredited()) {
                CustomerInfo customer = null;
                try {
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add("isCredited");
                    customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(customerId), selectors);
                }
                catch (EASBizException e) {
                    throw new BOSException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"5_CreditFacadeControllerBean", (Locale)ctx.getLocale()), customerId), (Throwable)e);
                }
                if (customer != null && customer.isIsCredited()) {
                    isChannelCredited = true;
                }
            }
        }
        return isChannelCredited;
    }

    @Override
    protected Map _queryCreditAmounts(Context ctx, String customerId, String companyId) throws BOSException, EASBizException {
        HashMap<String, Comparable<Boolean>> creditAmounts = new HashMap<String, Comparable<Boolean>>(10);
        if (!StringUtil.isEmpty((String)customerId) && !StringUtil.isEmpty((String)companyId)) {
            boolean isCredited = this._isChannelCredited(ctx, customerId, companyId);
            creditAmounts.put("isCredited", new Boolean(isCredited));
            if (isCredited) {
                RptParams creditParams = new RptParams();
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyId));
                creditParams.setObject("company", (Object)company);
                creditParams.setString("customerId", customerId);
                creditParams.setBoolean("isForControl", false);
                creditParams.setInt("ControlScene", 1);
                CreditAnalysisRptFacadeControllerBean creditFacade = new CreditAnalysisRptFacadeControllerBean();
                String tempTableName = creditFacade.processData(ctx, creditParams);
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT FUnOutSaleOrderBillAmt,FUnAuditSOAmt,FUnArBillOrderAmt,FArBalance,FAmount,UsedAmount,CreditBalance,ImcomeAmt,PayAmt");
                sql.append(" FROM ").append(tempTableName);
                Connection con = this.getConnection(ctx);
                RptRowSet rs = null;
                try {
                    rs = DBUtil.executeQuery((String)sql.toString(), null, (Connection)con);
                    if (rs != null) {
                        while (rs.next()) {
                            creditAmounts.put("CreditBalance", rs.getBigDecimal("CreditBalance"));
                            creditAmounts.put("FUnOutSaleOrderBillAmt", rs.getBigDecimal("FUnOutSaleOrderBillAmt"));
                            creditAmounts.put("FUnAuditSOAmt", rs.getBigDecimal("FUnAuditSOAmt"));
                            creditAmounts.put("FUnArBillOrderAmt", rs.getBigDecimal("FUnArBillOrderAmt"));
                            creditAmounts.put("FArBalance", rs.getBigDecimal("FArBalance"));
                            creditAmounts.put("FAmount", rs.getBigDecimal("FAmount"));
                            creditAmounts.put("UsedAmount", rs.getBigDecimal("UsedAmount"));
                            creditAmounts.put("ImcomeAmt", rs.getBigDecimal("ImcomeAmt"));
                            creditAmounts.put("PayAmt", rs.getBigDecimal("PayAmt"));
                        }
                    }
                }
                catch (SQLException e) {
                    e.setNextException(new SQLException("SQL: " + sql));
                    throw new SQLDataException(e);
                }
                finally {
                    SQLUtils.cleanup(null, null, (Connection)con);
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                }
            }
        }
        return creditAmounts;
    }
}

