/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.sd.channel.app.AbstractCustomersMaterialsTransactionFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CustomersMaterialsTransactionFacadeControllerBean
extends AbstractCustomersMaterialsTransactionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.CustomersMaterialsTransactionFacadeControllerBean");
    String saleOrgNumbers;
    String saleOrgids;

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String displaySql = this.getDisplaySql(params, ctx);
        StringBuffer tempSql = new StringBuffer();
        tempSql.append(displaySql);
        if (params.getString("orderQty") != null) {
            tempSql.append("\n WHERE FQty <= ");
            tempSql.append(params.getString("orderQty") + "");
            tempSql.append("\n or FQty is null ");
        }
        tempSql.append("\n ORDER BY FCustomerNumber,FCustomerName,FSaleOrgUnitName,FmaterialNum");
        RptRowSet rs = this.executeQuery(tempSql.toString(), null, from, len, ctx);
        RptParams rptParams = new RptParams();
        rptParams.setObject("rowset", (Object)rs);
        return rptParams;
    }

    private String getDisplaySql(RptParams params, Context ctx) {
        String tempTable = params.getString("tempTable");
        StringBuffer displaySql = new StringBuffer();
        displaySql.append("SELECT ");
        displaySql.append("\r\n FCustomerNumber FCusNumber");
        displaySql.append("\r\n ,FCustomerName FCusName");
        displaySql.append("\r\n ,FSaleOrgUnitName FSaleOrgName");
        displaySql.append("\r\n ,FmaterialNum FMatNumber");
        displaySql.append("\r\n ,FmaterialName FMatName");
        displaySql.append("\r\n ,FMode FMode");
        displaySql.append("\r\n ,FUnit FUnit");
        displaySql.append("\r\n ,FQty FQty");
        displaySql.append("\r\n ,FBaseUnit FBaseUnit");
        displaySql.append("\r\n ,FBaseQty FBaseQty");
        displaySql.append("\r\n FROM  ");
        displaySql.append(tempTable + " temp ");
        return displaySql.toString();
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        StringBuffer fid = new StringBuffer("temp.FId IN (  '").append(idList.get(0).toString()).append("'");
        int n = idList.size();
        for (int i = 1; i < n; ++i) {
            fid.append(", '").append(idList.get(i).toString()).append("'");
        }
        fid.append(" ) ");
        StringBuffer sql = new StringBuffer();
        sql.append(this.getDisplaySql(params, ctx));
        sql.append("\n WHERE ");
        sql.append(fid);
        if (params.getString("orderQty") != null) {
            sql.append("\n and FQty <= ");
            sql.append(params.getString("orderQty") + "");
            sql.append("\n or FQty is null ");
        }
        sql.append("\n ORDER BY temp.FCustomerNumber,temp.FCustomerName,temp.FSaleOrgUnitName,temp.FmaterialNum");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams rptParams = new RptParams();
        rptParams.setObject("rowset", (Object)rs);
        return rptParams;
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String tempTable = param.getString("tempTable");
        StringBuffer rsList = new StringBuffer();
        rsList.append("SELECT ");
        rsList.append("\r\n temp.FID");
        rsList.append("\r\n FROM  ");
        rsList.append(tempTable + " temp ");
        rsList.append("\n ORDER BY temp.FCustomerNumber,temp.FCustomerName,temp.FSaleOrgUnitName,temp.FmaterialNum");
        return DbUtil.executeQuery((Context)ctx, (String)rsList.toString());
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"CusMaterialTrans", (Locale)ctx.getLocale()) + "_derekee", ctx);
        params.setString("TempTable", tempTable);
        Object[] purChaseOrg = (Object[])params.getObject("fullOrgUnit");
        StringBuffer orgUnit = new StringBuffer();
        StringBuffer orgUnitids = new StringBuffer();
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            orgUnit.append(",");
            orgUnit.append("'");
            orgUnit.append(((FullOrgUnitInfo)purChaseOrg[i]).getNumber());
            orgUnit.append("'");
            orgUnitids.append(",");
            orgUnitids.append("'");
            orgUnitids.append(((FullOrgUnitInfo)purChaseOrg[i]).getId());
            orgUnitids.append("'");
        }
        this.saleOrgNumbers = orgUnit.delete(0, 1).toString();
        this.saleOrgids = orgUnitids.delete(0, 1).toString();
        this.createTempTableAndInsertData(ctx, tempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setInventoryReportHead(header, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String createSql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, createSql);
        String insertSql = this.getQtyFromInventory(params, tempTable, ctx);
        this.executeUpdate(insertSql, null, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer createsql = new StringBuffer();
        createsql.append("Create Table " + tempTable + "(\r\n");
        createsql.append("FID Varchar(44) \r\n");
        createsql.append(",FCustomerID Varchar(44) \r\n");
        createsql.append(",FCustomerNumber Varchar(44) \r\n");
        createsql.append(",FCustomerName Varchar(80) \r\n");
        createsql.append(",FSaleOrgUnitName Varchar(80) \r\n");
        createsql.append(",FmaterialID Varchar(44) \r\n");
        createsql.append(",FmaterialNum Varchar(80) \r\n");
        createsql.append(",FmaterialName Varchar(80) \r\n");
        createsql.append(",FMode Varchar(80) \r\n");
        createsql.append(",FUnit Varchar(80) \r\n");
        createsql.append(",FQty  Decimal(28,10)\r\n");
        createsql.append(",FBaseUnit Varchar(80) \r\n");
        createsql.append(",FBaseQty  Decimal(28,10)\r\n");
        createsql.append(");");
        return createsql.toString();
    }

    private String getQtyFromInventory(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        StringBuffer groupCols = new StringBuffer();
        tempSql.append("INSERT INTO ");
        tempSql.append(tableName);
        tempSql.append(this.getQtyUnionChaBase(params, tableName, ctx));
        tempSql.append(groupCols.toString());
        return tempSql.toString();
    }

    private String getQtyUnionChaBase(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer cusMatCols = new StringBuffer();
        cusMatCols.append("\r\n cus.fid FCustomerID");
        cusMatCols.append("\r\n ,cus.fnumber FCustomernumber");
        cusMatCols.append("\r\n ,cus.fname_" + ctx.getLocale().getLanguage() + " FCustomerName");
        cusMatCols.append("\r\n ,null FSaleOrgUnitName");
        cusMatCols.append("\r\n ,mat.fid FMaterialid");
        cusMatCols.append("\r\n ,mat.fnumber Fmaterialnumber");
        cusMatCols.append("\r\n ,mat.fname_" + ctx.getLocale().getLanguage() + " Fmaterialname");
        cusMatCols.append("\r\n ,mat.FModel FMode");
        cusMatCols.append("\r\n ,null FUnit");
        cusMatCols.append("\r\n ,0 FQty");
        cusMatCols.append("\r\n ,null FBaseUnit");
        cusMatCols.append("\r\n ,0 FBaseQty");
        cusMatCols.append("\n FROM");
        cusMatCols.append("\r\n T_CHA_CustomersMR cusMR");
        cusMatCols.append("\r\n  LEFT JOIN T_BD_Customer cus");
        cusMatCols.append("\r\n ON cus.fid = cusMR.FCustomerID");
        cusMatCols.append("\r\n  LEFT JOIN T_BD_Material mat");
        cusMatCols.append("\r\n ON mat.fid = cusMR.FMaterialID");
        cusMatCols.append("\n WHERE ");
        cusMatCols.append("\r\n  cus.FCONTROLUNITID in (select FControlUnitID from T_ORG_BaseUnit where fid in (" + this.saleOrgids + "))");
        cusMatCols.append("\r\n and mat.FCONTROLUNITID in (select FControlUnitID from T_ORG_BaseUnit where fid in (" + this.saleOrgids + "))");
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\r\n cus.fid FCustomerID");
        selCols.append("\r\n ,cus.fnumber FCustomernumber");
        selCols.append("\r\n ,cus.fname_" + ctx.getLocale().getLanguage() + " FCustomerName");
        selCols.append("\r\n ,saleOrg.fname_" + ctx.getLocale().getLanguage() + " FSaleOrgUnitName");
        selCols.append("\r\n ,mat.fid FMaterialid");
        selCols.append("\r\n ,mat.fnumber Fmaterialnumber");
        selCols.append("\r\n ,mat.fname_" + ctx.getLocale().getLanguage() + " Fmaterialname");
        selCols.append("\r\n ,mat.FModel FMode");
        selCols.append("\r\n ,unit.fname_" + ctx.getLocale().getLanguage() + " FUnit");
        selCols.append("\r\n ,sum(saleOrderentry.FQty) FQty");
        selCols.append("\r\n ,baseUnit.FName_" + ctx.getLocale().getLanguage() + " FBaseUnit");
        selCols.append("\r\n ,sum(saleOrderentry.FBaseQty) FBaseQty");
        fromTable.append("\r\n T_CHA_CustomersMR cusMR");
        fromTable.append("\r\n  LEFT JOIN T_BD_Customer cus");
        fromTable.append("\r\n ON cus.fid = cusMR.FCustomerID");
        fromTable.append("\r\n  LEFT JOIN T_BD_Material mat");
        fromTable.append("\r\n ON mat.fid = cusMR.FMaterialID");
        fromTable.append("\r\n  LEFT JOIN T_SD_SaleOrderEntry saleOrderentry");
        fromTable.append("\r\n ON saleOrderentry.FMaterialID = mat.fid ");
        fromTable.append("\r\n  LEFT JOIN T_SD_SaleOrder saleOrder");
        fromTable.append("\r\n ON cus.fid = saleOrder.FOrderCustomerID and saleOrder.fid = saleOrderentry.FParentID");
        fromTable.append("\r\n  LEFT JOIN T_ORG_Sale saleOrg");
        fromTable.append("\r\n ON saleOrder.FSaleOrgUnitID = saleOrg.fid");
        fromTable.append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit unit  ");
        fromTable.append("\r\n ON saleOrderentry.FUnitID = unit.fid");
        fromTable.append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit baseUnit  ");
        fromTable.append("\r\n ON saleOrderentry.FBaseUnitID = baseUnit.fid");
        StringBuffer filter = new StringBuffer();
        StringBuffer cusMatfilter = new StringBuffer();
        if (params.getString("bizDateFrom") != null) {
            filter.append("\r\n AND saleOrder.FBizDate >= to_date('");
            filter.append(params.getString("bizDateFrom") + "')");
        }
        if (params.getString("bizDateTo") != null) {
            filter.append("\r\n AND saleOrder.FBizDate <= to_date('");
            filter.append(params.getString("bizDateTo") + "')");
        }
        if (params.getString("customerFrom") != null) {
            cusMatfilter.append("\r\n AND cus.FNumber >= '");
            cusMatfilter.append(params.getString("customerFrom") + "'");
        }
        if (params.getString("customerTo") != null) {
            cusMatfilter.append("\r\n AND cus.FNumber <='");
            cusMatfilter.append(params.getString("customerTo") + "'");
        }
        if (params.getString("materialFrom") != null) {
            cusMatfilter.append("\r\n AND mat.FNumber >= '");
            cusMatfilter.append(params.getString("materialFrom") + "'");
        }
        if (params.getString("materialTo") != null) {
            cusMatfilter.append("\r\n AND mat.FNumber <='");
            cusMatfilter.append(params.getString("materialTo") + "'");
        }
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n select newbosid('88888888') fid,cusTable.FCustomerID,cusTable.FCustomerNumber,");
        tempSql.append("cusTable.FCustomerName,saleTable.FSaleOrgUnitName,");
        tempSql.append("cusTable.FMaterialid,cusTable.Fmaterialnumber,");
        tempSql.append("cusTable.Fmaterialname,cusTable.FMode,saleTable.FUnit,");
        tempSql.append("isnull(saleTable.FQty,0),saleTable.FBaseUnit,isnull(saleTable.FBaseQty,0)from");
        tempSql.append("\n (SELECT");
        tempSql.append(cusMatCols);
        tempSql.append(cusMatfilter);
        tempSql.append(") cusTable left outer join ");
        tempSql.append("\n (SELECT");
        tempSql.append(selCols);
        tempSql.append("\n FROM ");
        tempSql.append(fromTable);
        tempSql.append("\n WHERE saleOrg.FNumber IN (");
        tempSql.append(this.saleOrgNumbers + ") ");
        tempSql.append("\r\n and saleOrder.FBaseStatus in (4,7)");
        cusMatCols.append("\r\n and cus.FCONTROLUNITID in (select FControlUnitID from T_ORG_BaseUnit where fid in (" + this.saleOrgids + "))");
        cusMatCols.append("\r\n and mat.FCONTROLUNITID in (select FControlUnitID from T_ORG_BaseUnit where fid in (" + this.saleOrgids + "))");
        tempSql.append(filter);
        tempSql.append(cusMatfilter);
        tempSql.append("\n  GROUP BY \r\n cus.Fnumber,\r\n cus.FName_" + ctx.getLocale().getLanguage() + ", \r\n saleOrg.FName_" + ctx.getLocale().getLanguage() + ",  \r\n mat.FNumber, \r\n mat.FName_" + ctx.getLocale().getLanguage() + ", \r\n mat.FModel, \r\n unit.FName_" + ctx.getLocale().getLanguage() + ", \r\n baseUnit.FName_" + ctx.getLocale().getLanguage() + ", \r\n cus.FID, \r\n mat.FID)");
        tempSql.append(" saleTable on cusTable.FCustomerID=saleTable.FCustomerID and cusTable.FMaterialid=saleTable.FMaterialid");
        return tempSql.toString();
    }

    private void setInventoryReportHead(RptTableHeader header, Context ctx) {
        String customerNumber = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"7_CustomersMaterialsTransactionFacadeControllerBean", (Locale)ctx.getLocale());
        String customerName = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"customerName", (Locale)ctx.getLocale());
        String saleOrgUnitName = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"saleOrgUnitName", (Locale)ctx.getLocale());
        String materialNumber = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"materialNumber", (Locale)ctx.getLocale());
        String materialName = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"materialName", (Locale)ctx.getLocale());
        String materialModel = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"materialModel", (Locale)ctx.getLocale());
        String unitName = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"unitName", (Locale)ctx.getLocale());
        String qty = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"qty", (Locale)ctx.getLocale());
        String baseUnitName = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"baseUnitName", (Locale)ctx.getLocale());
        String baseQty = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CustomersMaterialsTransactionResource", (String)"baseQty", (Locale)ctx.getLocale());
        String[] cols = new String[]{"customerNumber", "customerName", "saleOrgUnitName", "materialNumber", "materialName", "materialModel", "unitName", "qty", "baseUnitName", "baseQty"};
        this.setHeaderColumns(header, cols);
        header.setLabels((Object[][])new Object[][]{{customerNumber, customerName, saleOrgUnitName, materialNumber, materialName, materialModel, unitName, qty, baseUnitName, baseQty}});
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns) {
        RptTableColumn col = null;
        int c = 10;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(120);
            if (i == 0) {
                col.setWidth(90);
            }
            if (i == 1) {
                col.setWidth(200);
            }
            if (i == 3) {
                col.setWidth(150);
            }
            if (i == 7 || i == 9) {
                col.setAligment(2);
            }
            header.addColumn(col);
        }
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }
}

