/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.AutoAuditEnum;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.NetOrderCollectManagerEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillStatusEnum;
import com.kingdee.eas.scm.sd.channel.NetOrderCollectionManagerFacadeFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderFacadeFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderManagerException;
import com.kingdee.eas.scm.sd.channel.app.AbstractNetOrderBillControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class NetOrderBillControllerBean
extends AbstractNetOrderBillControllerBean {
    private static final long serialVersionUID = -7345391450194L;

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        NetOrderBillInfo billInfo = this.getNetOrderBillInfo(ctx, pk);
        ChannelBaseInfo channelBaseInfo = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseInfo((IObjectPK)new ObjectUuidPK(billInfo.getChannel().getId().toString()));
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        if (channelBaseInfo.getIsCollectManager().compareTo((Object)NetOrderCollectManagerEnum.YES) == 0) {
            billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            billInfo.setBillStatus(NetOrderBillStatusEnum.AUDITED);
            billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
            billInfo.setAduitRows(billInfo.getEntries().size());
            this.setEntryStatus(billInfo, EntryBaseStatusEnum.AUDITED, NetOrderBillStatusEnum.AUDITED);
            this.update(ctx, pk, billInfo);
        } else {
            billInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
            billInfo.setBillStatus(NetOrderBillStatusEnum.TREATED);
            billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
            this.setEntryStatus(billInfo, EntryBaseStatusEnum.CLOSED, NetOrderBillStatusEnum.READYSEND);
            NetOrderBillEntryCollection entriesCol = billInfo.getEntries();
            ArrayList<ObjectUuidPK> pklList = new ArrayList<ObjectUuidPK>();
            ArrayList<String> entryIds = new ArrayList<String>();
            ArrayList<NetOrderBillInfo> billIds = new ArrayList<NetOrderBillInfo>();
            billIds.add(billInfo);
            HashMap warehouseIds = new HashMap();
            Object warehouseId = null;
            int day = -3;
            HashMap<String, Date> sendDateMap = new HashMap<String, Date>();
            NetOrderBillEntryInfo entryInfo = null;
            for (int i = 0; i < entriesCol.size(); ++i) {
                entryInfo = entriesCol.get(i);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
                entryInfo.setEntryStatus(NetOrderBillStatusEnum.READYSEND);
                pklList.add(new ObjectUuidPK(entryInfo.getId()));
                entryIds.add(entryInfo.getId().toString());
                sendDateMap.put(entryInfo.getId().toString(), entryInfo.getAskArriveDate());
                entryInfo.setApprovePrice(entryInfo.getPrice());
                entryInfo.setApproveAmount(entryInfo.getAmount());
                entryInfo.setApproveQty(entryInfo.getQty());
            }
            try {
                NetOrderCollectionManagerFacadeFactory.getLocalInstance(ctx).transformForBotp(billIds, entryIds, ContextUtil.getCurrentCtrlUnit((Context)ctx), warehouseIds, sendDateMap, null);
            }
            catch (Exception e) {
                throw new NetOrderManagerException(NetOrderManagerException.SUBMIT_BOTP_ERROR, e);
            }
            this.update(ctx, pk, billInfo);
            if (AutoAuditEnum.YES.getValue() != channelBaseInfo.getIsAutoAudit().getValue()) {
                try {
                    NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(this.pkListToArray(pklList), billInfo.getSaleOrgUnit().getId().toString());
                }
                catch (Exception e) {
                    throw new NetOrderManagerException(NetOrderManagerException.UNLOCK_STORAGE_ERROR, e);
                }
            }
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.audit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        NetOrderBillInfo billInfo = this.getNetOrderBillInfo(ctx, pk);
        if (!billInfo.getBillStatus().equals((Object)NetOrderBillStatusEnum.AUDITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYAUDITCANUNAUDIT1, new String[]{billInfo.getNumber()});
        }
        try {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.UNAUDIT);
        }
        catch (Exception e) {
            throw new NetOrderManagerException(NetOrderManagerException.RELEASE_CREDIT_ERROR, e);
        }
        NetOrderBillEntryCollection entryInfo = billInfo.getEntries();
        ArrayList<ObjectUuidPK> pklList = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < entryInfo.size(); ++i) {
            pklList.add(new ObjectUuidPK(entryInfo.get(i).getId()));
        }
        try {
            NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(this.pkListToArray(pklList), billInfo.getSaleOrgUnit().getId().toString());
        }
        catch (Exception e) {
            throw new NetOrderManagerException(NetOrderManagerException.UNLOCK_STORAGE_ERROR, e);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setBillStatus(NetOrderBillStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setAduitRows(0);
        this.setEntryStatus(billInfo, EntryBaseStatusEnum.TEMPORARILYSAVED, NetOrderBillStatusEnum.TEMPORARILYSAVED);
        this.update(ctx, pk, billInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        block3: {
            NetOrderBillInfo billInfo = (NetOrderBillInfo)model;
            this.checkSave(ctx, billInfo);
            if (this.isAddNew(ctx, (IObjectValue)billInfo)) {
                this._checkNumberDup(ctx, null, model);
            }
            billInfo.setBillStatus(NetOrderBillStatusEnum.TEMPORARILYSAVED);
            this.setEntryStatus(billInfo, EntryBaseStatusEnum.TEMPORARILYSAVED, NetOrderBillStatusEnum.TEMPORARILYSAVED);
            BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("PQmB0qv6S02gx+xypWAQo8LWunc="));
            billInfo.setBillType(billTypeInfo);
            billInfo.setBotpCallSave(false);
            pk = null;
            try {
                pk = super._save(ctx, model);
            }
            catch (EASBizException ex) {
                if (!this.isAddNew(ctx, (IObjectValue)billInfo)) break block3;
                billInfo.setBillStatus(NetOrderBillStatusEnum.ADD);
                throw ex;
            }
        }
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        NetOrderBillInfo billInfo = (NetOrderBillInfo)model;
        ObjectUuidPK pk = null;
        IRowSet rs = null;
        if (!this.isAddNew(ctx, (IObjectValue)billInfo)) {
            pk = new ObjectUuidPK(billInfo.getId());
            this.checkSubmit(ctx, billInfo);
            if (billInfo.getBaseStatus().getValue() != 1) {
                rs = CreditUpdateHelper.getPreUpdateData((Context)ctx, (Object[])new Object[]{pk});
            }
        } else {
            this._checkNumberDup(ctx, null, model);
        }
        ChannelBaseInfo channelBaseInfo = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseInfo((IObjectPK)new ObjectUuidPK(billInfo.getChannel().getId().toString()));
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("PQmB0qv6S02gx+xypWAQo8LWunc="));
        billInfo.setBillType(billTypeInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        billInfo.setBillStatus(NetOrderBillStatusEnum.SUBMITED);
        this.setEntryStatus(billInfo, EntryBaseStatusEnum.SUBMITED, NetOrderBillStatusEnum.SUBMITED);
        pk = super._submit(ctx, model);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, rs, CreditOperationEnum.SUBMIT);
        if (channelBaseInfo.getIsCollectManager() != null && channelBaseInfo.getIsCollectManager().compareTo((Object)NetOrderCollectManagerEnum.YES) == 0) {
            String paramValue;
            if (billInfo.getId() != null && billInfo.getBaseStatus().compareTo((Object)BillBaseStatusEnum.SUBMITED) == 0) {
                NetOrderBillEntryCollection entryInfo = billInfo.getEntries();
                ArrayList<ObjectUuidPK> pklList = new ArrayList<ObjectUuidPK>();
                for (int i = 0; i < entryInfo.size(); ++i) {
                    pklList.add(new ObjectUuidPK(entryInfo.get(i).getId()));
                }
                try {
                    NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(this.pkListToArray(pklList), billInfo.getSaleOrgUnit().getId().toString());
                }
                catch (Exception e) {
                    throw new NetOrderManagerException(NetOrderManagerException.UNLOCK_STORAGE_ERROR, e);
                }
            }
            if (Boolean.valueOf(paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(billInfo.getSaleOrgUnit().getId().toString()), (String)"NETORDERLOCKEDINV")).booleanValue()) {
                NetOrderFacadeFactory.getLocalInstance(ctx).lockInventory((IObjectPK)pk);
            }
        }
        if (channelBaseInfo.getIsAutoAudit() != null && AutoAuditEnum.YES.getValue() == channelBaseInfo.getIsAutoAudit().getValue()) {
            this._audit(ctx, (IObjectPK)pk);
        }
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        NetOrderBillInfo billInfo = this.getNetOrderBillInfo(ctx, pk);
        this.checkDelete(ctx, billInfo);
        super._delete(ctx, pk);
    }

    private void checkDelete(Context ctx, NetOrderBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null) {
            int status = billInfo.getBaseStatus().getValue();
            if (status == 2) {
                CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{billInfo.getId()}, CreditOperationEnum.DELETE);
                NetOrderBillEntryCollection entryInfo = billInfo.getEntries();
                ArrayList<ObjectUuidPK> pklList = new ArrayList<ObjectUuidPK>();
                for (int i = 0; i < entryInfo.size(); ++i) {
                    pklList.add(new ObjectUuidPK(entryInfo.get(i).getId()));
                }
                try {
                    NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(this.pkListToArray(pklList), billInfo.getSaleOrgUnit().getId().toString());
                }
                catch (Exception e) {
                    throw new NetOrderManagerException(NetOrderManagerException.UNLOCK_STORAGE_ERROR, e);
                }
            } else if (status != 1) {
                throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANDELETE, new Object[]{""});
            }
        }
    }

    private void checkSave(Context ctx, NetOrderBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() != 1 && billInfo.getBaseStatus().getValue() != 0) {
            throw new ChannelBillException(ChannelBillException.CANNOT_SAVE);
        }
    }

    private void checkSubmit(Context ctx, NetOrderBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() >= 4) {
            throw new ChannelBillException(ChannelBillException.CANNOT_SUBMIT);
        }
    }

    private void setEntryStatus(NetOrderBillInfo billInfo, EntryBaseStatusEnum status, NetOrderBillStatusEnum item) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null) {
            NetOrderBillEntryCollection entryInfo = billInfo.getEntries();
            for (int i = 0; i < entryInfo.size(); ++i) {
                entryInfo.get(i).setBaseStatus(status);
                entryInfo.get(i).setEntryStatus(item);
            }
        }
    }

    @Override
    protected void _handelClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        NetOrderBillInfo billInfo = this.getNetOrderBillInfo(ctx, pk);
        if (billInfo.getBillStatus() != null && billInfo.getBillStatus().getValue() != 4 && billInfo.getBillStatus().getValue() != 8) {
            throw new ChannelBillException(ChannelBillException.CLOSE_SUBMIT);
        }
        NetOrderBillEntryCollection entryInfoCollection = billInfo.getEntries();
        ArrayList<ObjectUuidPK> pklList = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < entryInfoCollection.size(); ++i) {
            NetOrderBillEntryInfo entryInfo = entryInfoCollection.get(i);
            if (entryInfo.getBaseStatus().compareTo((Object)EntryBaseStatusEnum.AUDITED) != 0) continue;
            entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            entryInfo.setEntryStatus(NetOrderBillStatusEnum.CANCEL);
            entryInfo.setApproveQty(SysConstant.BIGZERO);
            entryInfo.setApprovePrice(SysConstant.BIGZERO);
            entryInfo.setApproveAmount(SysConstant.BIGZERO);
            pklList.add(new ObjectUuidPK(entryInfo.getId()));
        }
        try {
            NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(this.pkListToArray(pklList), billInfo.getSaleOrgUnit().getId().toString());
        }
        catch (Exception e) {
            throw new NetOrderManagerException(NetOrderManagerException.UNLOCK_STORAGE_ERROR, e);
        }
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.CLOSE);
        billInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
        billInfo.setBillStatus(NetOrderBillStatusEnum.TREATED);
        this.update(ctx, pk, billInfo);
    }

    public Date addDate(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(field, amount);
        return calendar.getTime();
    }

    private String getWarehouseId(String StorageOrgUnitId, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("where storageOrg.id='").append(StorageOrgUnitId).append("' and  whState= ").append("1");
        WarehouseCollection collection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(sql.toString());
        if (collection != null || collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    private IObjectPK[] pkListToArray(List pklList) {
        int size = pklList.size();
        if (size < 1) {
            return null;
        }
        IObjectPK[] pkArray = new IObjectPK[size];
        for (int i = 0; i < size; ++i) {
            pkArray[i] = (IObjectPK)pklList.get(i);
        }
        return pkArray;
    }

    @Override
    protected void _fightBack(Context ctx, IObjectPK[] pks, Object reasonCodeInfo) throws BOSException, EASBizException {
        NetOrderBillInfo billInfo = this._unAuditNotUpdate(ctx, pks[0]);
        billInfo.setIsFightBack(true);
        if (reasonCodeInfo != null) {
            if (reasonCodeInfo instanceof ReasonCodeInfo) {
                billInfo.setFightBackReason(((ReasonCodeInfo)reasonCodeInfo).getName());
            } else {
                billInfo.setFightBackReason(reasonCodeInfo.toString());
            }
        }
        NetOrderBillEntryCollection entryInfoConn = billInfo.getEntries();
        NetOrderBillEntryInfo entryInfo = null;
        for (int i = 0; i < entryInfoConn.size(); ++i) {
            entryInfo = entryInfoConn.get(i);
            entryInfo.setApprovePrice(null);
            entryInfo.setApproveAmount(null);
        }
        this.update(ctx, pks[0], billInfo);
    }

    private NetOrderBillInfo _unAuditNotUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        NetOrderBillInfo billInfo = this.getNetOrderBillInfo(ctx, pk);
        if (!billInfo.getBillStatus().equals((Object)NetOrderBillStatusEnum.AUDITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYAUDITCANUNAUDIT1, new String[]{billInfo.getNumber()});
        }
        try {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.UNAUDIT);
        }
        catch (Exception e) {
            throw new NetOrderManagerException(NetOrderManagerException.RELEASE_CREDIT_ERROR, e);
        }
        NetOrderBillEntryCollection entryInfo = billInfo.getEntries();
        ArrayList<ObjectUuidPK> pklList = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < entryInfo.size(); ++i) {
            pklList.add(new ObjectUuidPK(entryInfo.get(i).getId()));
        }
        try {
            NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(this.pkListToArray(pklList), billInfo.getSaleOrgUnit().getId().toString());
        }
        catch (Exception e) {
            throw new NetOrderManagerException(NetOrderManagerException.UNLOCK_STORAGE_ERROR, e);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setBillStatus(NetOrderBillStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setAduitRows(0);
        this.setEntryStatus(billInfo, EntryBaseStatusEnum.TEMPORARILYSAVED, NetOrderBillStatusEnum.TEMPORARILYSAVED);
        return billInfo;
    }
}

