/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class NetOrderBillHeadImport
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.NetOrderBillHeadImport");
    NetOrderBillInfo netOrderBillInfo = null;
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    Locale local = new Locale("l2");

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return NetOrderBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    private NetOrderBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FChannel_name", rs.getString("channel.name"));
            this.putTable(result, "FSaleOrgUnit_name", rs.getString("saleOrgUnit.name"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FBaseStatus", rs.getString("billStatus"));
            this.putTable(result, "FCustomer", rs.getString("customer.name"));
            this.putTable(result, "FEntries_qty", this.dealPrecisioin(rs.getBigDecimal("entries.qty"), 2));
            this.putTable(result, "FEntries_amount", this.dealPrecisioin(rs.getBigDecimal("entries.amount"), 2));
            this.putTable(result, "FEntries_askArriveDate", rs.getString("askArriveDate"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private String dealPrecisioin(BigDecimal number, int precision) {
        if (number != null && number.toString().indexOf("0E") != -1) {
            number = ZERO.setScale(precision);
        } else if (number != null) {
            number = number.setScale(precision, 4);
        }
        return number != null ? number.toString() : null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.NetOrderBillSimpleQuery";
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }
}

