/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class NetOrderBillImport
extends AbstractDataTransmission {
    NetOrderBillInfo netOrderBillInfo = null;
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    Locale local = new Locale("l2");

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return NetOrderBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    private NetOrderBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FChannel_number", rs.getString("channel.number"));
            this.putTable(result, "FSaleOrgUnit_number", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FBaseStatus", rs.getString("billStatus"));
            this.putTable(result, "FEntries_seq", rs.getString("entries.seq"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries$material_name", rs.getString("material.name"));
            this.putTable(result, "FEntries$material_model", rs.getString("material.model"));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            String qtyPrecision = rs.getString("multiMeasureUnit.qtyPrecision");
            int _qtyPrecision = qtyPrecision != null ? Integer.parseInt(qtyPrecision) : 2;
            int pricePrecision = 2;
            try {
                pricePrecision = Integer.parseInt(rs.getString("entries.pricePrecision"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.putTable(result, "FEntries_qty", this.dealPrecisioin(rs.getBigDecimal("entries.qty"), _qtyPrecision));
            this.putTable(result, "FEntries_price", this.dealPrecisioin(rs.getBigDecimal("entries.price"), pricePrecision));
            this.putTable(result, "FEntries_amount", this.dealPrecisioin(rs.getBigDecimal("entries.amount"), pricePrecision));
            this.putTable(result, "FEntries_approveQty", this.dealPrecisioin(rs.getBigDecimal("entries.approveQty"), _qtyPrecision));
            this.putTable(result, "FEntries_approvePrice", this.dealPrecisioin(rs.getBigDecimal("entries.approvePrice"), pricePrecision));
            this.putTable(result, "FEntries_approveAmount", this.dealPrecisioin(rs.getBigDecimal("entries.approveAmount"), pricePrecision));
            this.putTable(result, "FEntries_askArriveDate", rs.getString("entries.askArriveDate"));
            this.putTable(result, "FEntries_address", rs.getString("entries.address"));
            this.putTable(result, "FEntries_storageOrgUnit", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FEntries_warehouse", rs.getString("warehouse.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private String dealPrecisioin(BigDecimal number, int precision) {
        if (number != null && number.toString().indexOf("0E") != -1) {
            number = ZERO.setScale(precision);
        } else if (number != null) {
            number = number.setScale(precision, 4);
        }
        return number != null ? number.toString() : null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.NetOrderBillExportQuery";
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }
}

