/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.util.CollectionUtil;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.sd.channel.ChannelParamFacadeFactory;
import com.kingdee.eas.scm.sd.channel.INetOrderBill;
import com.kingdee.eas.scm.sd.channel.INetOrderBillEntry;
import com.kingdee.eas.scm.sd.channel.NetOrderBatchModifyFieldEnum;
import com.kingdee.eas.scm.sd.channel.NetOrderBillCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillStatusEnum;
import com.kingdee.eas.scm.sd.channel.NetOrderFacadeFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderManagerException;
import com.kingdee.eas.scm.sd.channel.app.AbstractNetOrderCollectionManagerFacadeControllerBean;
import com.kingdee.eas.scm.sd.channel.util.PriceService;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SupplyModeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NetOrderCollectionManagerFacadeControllerBean
extends AbstractNetOrderCollectionManagerFacadeControllerBean {
    private static final long serialVersionUID = -1993841840022815914L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.NetOrderCollectionManagerFacadeControllerBean");
    private PriceParamInfo priceParamInfo = null;
    private static final BigDecimal ONE = new BigDecimal("1.0");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final BigDecimal Hundred = new BigDecimal("100.0");

    @Override
    protected IRowSet _getInventoryInfo(Context ctx, String material, String queryType) throws BOSException {
        if (material != null) {
            StringBuffer sql = new StringBuffer();
            String warehouse = "null as warehouse,";
            String location = "null as location,";
            String lot = "null as lot,";
            String groupBy = " ";
            String permStorageIds = null;
            try {
                permStorageIds = this.getPermissionStorage(ctx);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (queryType != null) {
                if (queryType.indexOf("a") != -1) {
                    warehouse = "warehouse.fname_" + ctx.getLocale().getLanguage() + " as warehouse,";
                    groupBy = groupBy + "warehouse.fname_" + ctx.getLocale().getLanguage() + ",";
                }
                if (queryType.indexOf("b") != -1) {
                    location = "location.fname_" + ctx.getLocale().getLanguage() + " as location,";
                    groupBy = groupBy + "location.fname_" + ctx.getLocale().getLanguage() + ",";
                }
                if (queryType.indexOf("c") != -1) {
                    lot = "case when inv.flot = 'YNi0IQEOEADgBT3mfwAAAcznrtQ=' then null else inv.flot end as lot,";
                    groupBy = groupBy + "inv.flot,";
                }
            }
            sql.append(" select material.fname_" + ctx.getLocale().getLanguage() + " as material ,storage.fname_" + ctx.getLocale().getLanguage() + " as storageOrg,").append(warehouse).append(location).append(lot).append("sum(inv.fbaseqty) as qty,measureunit.fname_" + ctx.getLocale().getLanguage() + "  as unit from t_im_inventory inv").append(" inner join t_bd_material material on inv.fmaterialid=material.fid ").append(" left outer join t_org_storage storage on inv.fstorageorgunitid=storage.fid").append(" left outer join  t_db_warehouse warehouse on inv.fwarehouseid=warehouse.fid ").append(" left outer join t_db_location location on inv.flocationid=location.fid ").append(" left outer join t_bd_measureunit measureunit on inv.fbaseunitid=measureunit.fid").append(" left outer join T_IM_STORESTATE storeState on inv.FStoreStatusID=storeState.fid").append(" left outer join T_IM_STORETYPE storeType on inv.fStoreTypeId=storeType.fid ").append(" where inv.fbaseqty<>0 and storeType.fnumber='G' and  material.fid='").append(material).append("' and storeState.fnumber='1' ");
            if (permStorageIds != null) {
                sql.append(" and storage.fid in  ");
                sql.append(permStorageIds);
            }
            sql.append(" group by material.fname_" + ctx.getLocale().getLanguage() + ",storage.fname_" + ctx.getLocale().getLanguage() + ",");
            sql.append(groupBy);
            sql.append("measureunit.fname_" + ctx.getLocale().getLanguage() + "");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            return rs;
        }
        return null;
    }

    protected String getPermissionStorage(Context ctx) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(((UserInfo)ctx.get((Object)"UserInfo")).getId());
        FullOrgUnitCollection coll = null;
        StringBuffer storageIds = null;
        coll = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, "inventory");
        if (coll.size() > 0) {
            storageIds = new StringBuffer();
            storageIds.append("('");
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                storageIds.append(coll.get(i).getId());
                storageIds.append("','");
            }
            storageIds.delete(storageIds.length() - 2, storageIds.length());
            storageIds.append(")");
        }
        return storageIds == null ? null : storageIds.toString();
    }

    @Override
    protected void _updataEntryState(Context ctx, String idList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CHA_NetOrderBillEntry set fentrystatus=8 where fid in (");
        sql.append(idList);
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_CHA_NetOrderBill set fbillstatus=8 where fid in (select fparentid from T_CHA_NetOrderBillEntry where fid in (");
        sql.append(idList);
        sql.append("))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)sql.toString());
    }

    @Override
    protected IObjectValue _getWarehouseByStorage(Context ctx, String storageId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        WarehouseInfo warehouse = null;
        String warehousePk = null;
        sql.append("select top 1 fid from t_db_warehouse  where fstorageOrgid='");
        sql.append(storageId);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                warehousePk = rowSet.getString("fid");
                warehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehousePk));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new NetOrderManagerException(NetOrderManagerException.SQL_EXCE_ERROR);
        }
        return warehouse;
    }

    @Override
    protected int _transformForBotp(Context ctx, List bills, List entryIds, IObjectValue cu, HashMap warehouseIds, HashMap sendDate, IObjectCollection splitNetOrderBillEntryColl) throws BOSException, EASBizException {
        if (entryIds == null || entryIds.size() == 0) {
            throw new NetOrderManagerException(NetOrderManagerException.DATACOLL_NONE);
        }
        String srcBillBosType = new NetOrderBillInfo().getBOSType().toString();
        String desBillBosType = new SaleOrderInfo().getBOSType().toString();
        HashMap<String, IObjectValue> transmitCtx = new HashMap<String, IObjectValue>();
        transmitCtx.put("TRANSMITCU", cu);
        BOTMappingCollection botCollection = null;
        botCollection = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBillBosType, (String)desBillBosType, null, transmitCtx);
        BOTMappingInfo mappingInfo = null;
        if (botCollection == null || botCollection.size() < 1) {
            throw new NetOrderManagerException(NetOrderManagerException.BOTP_NOT_EXIST);
        }
        int size = botCollection.size();
        for (int i = 0; i < size && !(mappingInfo = botCollection.get(i)).getName().equals("NetOrder_SaleOrder_CollectManager"); ++i) {
        }
        if (mappingInfo == null) {
            throw new NetOrderManagerException(NetOrderManagerException.BOTP_NOT_EXIST);
        }
        IObjectCollection srcBillCols = null;
        try {
            srcBillCols = this.getBillList(ctx, bills, entryIds, srcBillBosType, BotpHelper.getBOTPSelectors((BOTMappingInfo)mappingInfo));
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"8_NetOrderCollectionManagerFacadeControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
        }
        HashMap materialCache = new HashMap();
        HashMap measureUnitCache = new HashMap();
        if (srcBillCols != null && srcBillCols.size() > 0) {
            BTPTransformResult result = null;
            result = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseCollection)srcBillCols, desBillBosType);
            this.saveBotpBill(result, ctx);
            SaleOrderInfo saleOrder = null;
            CoreBaseCollection colBaseColl = new CoreBaseCollection();
            SaleOrderCollection saleOrderColl = new SaleOrderCollection();
            this.priceParamInfo = PriceParamFactory.getLocalInstance((Context)ctx).getParameter(((CtrlUnitInfo)cu).getId().toString());
            ArrayList<BOSUuid> saleOrglist = new ArrayList<BOSUuid>();
            IObjectCollection coll = result.getBills();
            int size2 = coll.size();
            for (int i = 0; i < size2; ++i) {
                saleOrder = (SaleOrderInfo)coll.getObject(i);
                try {
                    saleOrder = this.loadSaleOrderDataAfterBOTP(ctx, saleOrder, warehouseIds, sendDate, materialCache, measureUnitCache);
                    if (!saleOrglist.contains(saleOrder.getSaleOrgUnit().getId())) {
                        saleOrglist.add(saleOrder.getSaleOrgUnit().getId());
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (splitNetOrderBillEntryColl != null) {
                    saleOrder = this.addSplitEntry(ctx, saleOrder, splitNetOrderBillEntryColl, materialCache, measureUnitCache);
                }
                if (saleOrder.getEntries().size() <= 0) continue;
                saleOrderColl.add(saleOrder);
            }
            ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < saleOrderColl.size(); ++i) {
                iSaleOrder.submit((CoreBaseInfo)saleOrderColl.get(i));
            }
            ctx.put((Object)"disablePermissionForKScript", ctx.get((Object)"disablePermissionForKScript"));
        }
        ArrayList<String> billIds = new ArrayList<String>();
        Iterator it = bills.iterator();
        while (it.hasNext()) {
            billIds.add(((NetOrderBillInfo)it.next()).getId().toString());
        }
        this.updataBillStatus(ctx, billIds);
        if (srcBillCols != null) {
            return srcBillCols.size();
        }
        return 0;
    }

    private void updateNetOrderBillStatus(INetOrderBill iNetOrder, List bills) throws EASBizException, BOSException {
        if (CollectionUtil.isNotEmptyCollection((Collection)bills)) {
            HashSet<String> netOrderIds = new HashSet<String>(bills.size());
            int size = bills.size();
            for (int i = 0; i < size; ++i) {
                netOrderIds.add(((NetOrderBillInfo)bills.get(i)).getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", netOrderIds, CompareType.INCLUDE));
            NetOrderBillCollection col = iNetOrder.getNetOrderBillCollection(view);
            CoreBaseCollection updateNetOrderCol = new CoreBaseCollection();
            NetOrderBillInfo netOrder = null;
            NetOrderBillEntryInfo netOrderEntry = null;
            int size2 = col.size();
            for (int i = 0; i < size2; ++i) {
                netOrder = col.get(i);
                boolean flag = true;
                int netOrderEntrySize = netOrder.getEntries().size();
                for (int j = 0; j < netOrderEntrySize; ++j) {
                    netOrderEntry = netOrder.getEntries().get(j);
                    if (!NetOrderBillStatusEnum.AUDITED.equals((Object)netOrderEntry.getEntryStatus()) && !NetOrderBillStatusEnum.DEALING.equals((Object)netOrderEntry.getEntryStatus())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                netOrder.setBillStatus(NetOrderBillStatusEnum.TREATED);
                netOrder.setBaseStatus(BillBaseStatusEnum.CLOSED);
                updateNetOrderCol.add((CoreBaseInfo)netOrder);
            }
            iNetOrder.updateBatchData(updateNetOrderCol);
        }
    }

    private WarehouseInfo getDefaultWareHouse(Context ctx, String storageOrgUnitId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("whState", (Object)new Integer(1), CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        WarehouseCollection collection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(view);
        WarehouseInfo defaultWarehouse = null;
        if (collection.size() > 0) {
            defaultWarehouse = collection.get(0);
        }
        return defaultWarehouse;
    }

    private StorageOrgUnitInfo getDefaultStorageOrgUnit(Context ctx, String saleOrgUnitId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        StorageOrgUnitInfo storageOrgUnit = null;
        StorageOrgUnitInfo tempStorageOrgUnit = null;
        OrgUnitCollection collection = iOrgUnitRelation.getFromUnit(saleOrgUnitId, 2, 4);
        if (collection.size() > 0) {
            CompanyOrgUnitInfo companyOrgUnit = this.getCompanyOrgUnit(iOrgUnitRelation, saleOrgUnitId, OrgType.Sale);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                tempStorageOrgUnit = (StorageOrgUnitInfo)collection.get(i);
                if (!companyOrgUnit.equals((Object)this.getCompanyOrgUnit(iOrgUnitRelation, tempStorageOrgUnit.getId().toString(), OrgType.Storage))) continue;
                storageOrgUnit = tempStorageOrgUnit;
                break;
            }
        }
        return storageOrgUnit;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnit(IOrgUnitRelation iOrgUnitRelation, String srcOrgId, OrgType srcOrgType) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnit = null;
        OrgUnitCollection collection = iOrgUnitRelation.getToUnit(srcOrgId, srcOrgType.getValue(), 1);
        if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
            companyOrgUnit = (CompanyOrgUnitInfo)collection.get(0);
        }
        return companyOrgUnit;
    }

    private boolean updataBillStatus(Context ctx, List billIdList) throws BOSException {
        StringBuffer billIds = new StringBuffer();
        boolean isFirst = true;
        Iterator iterator = billIdList.iterator();
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                billIds.append(",");
            }
            billIds.append("'").append(iterator.next().toString()).append("'");
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_CHA_NetOrderBill set FBillStatus = 9, FBaseStatus=7 where fid in (").append(billIds).append(") and not exists (select 1 from T_CHA_NetOrderBillEntry entry where ").append(" entry.FParentID = T_CHA_NetOrderBill.fid and entry.FEntryStatus not in (5,6,7,9,10,11))");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        return true;
    }

    private SaleOrderInfo loadSaleOrderDataAfterBOTP(Context ctx, SaleOrderInfo saleOrder, HashMap warehouseIds, HashMap sendDates, HashMap materialCache, HashMap measureUnitCache) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        PersonInfo person = null;
        AdminOrgUnitInfo admin = null;
        PayConditionInfo payCondition = null;
        PaymentTypeInfo paymentType = null;
        SettlementTypeInfo settlementType = null;
        PaymentTypeInfo defaultPaymentType = null;
        HashMap<String, PersonInfo> defaultSalePersonMap = new HashMap<String, PersonInfo>();
        HashMap<BOSUuid, AdminOrgUnitInfo> defaultAdminOrgUnitMap = new HashMap<BOSUuid, AdminOrgUnitInfo>();
        int transAdvDay = 0;
        sql.append(" select distinct person.fid as personId,admin.fid as adminId,FPayConditionID,FPaymentTypeID,FSettlementTypeID,FTransAdvDay from t_bd_customer customer ").append("  left outer join t_bd_customersaleinfo customersaleinfo on customer.fid=customersaleinfo.fcustomerid ").append("  left outer join t_bd_customerSaler cutomerSaler on cutomerSaler.fcustomersaleid=customersaleinfo.fid ").append("  left Outer join t_bd_person person on cutomerSaler.fpersonid=person.fid").append("  left Outer join T_ORG_PositionMember PositionMember on person.fid=positionMember.fpersonid ").append("  left outer join T_ORG_Position position on PositionMember.FPositionID=position.fid").append("  left outer join T_ORG_Admin admin on position.FAdminOrgUnitID =admin.fid ").append("  left outer join t_bd_customercompanyinfo customerCompany on customer.fid= customerCompany.fcustomerid where customer.fid='").append(saleOrder.getOrderCustomer().getId()).append("' and customerCompany.fcomorgid='").append(saleOrder.getCompanyOrgUnit().getId()).append("' and customersaleinfo.fsaleorgid='").append(saleOrder.getSaleOrgUnit().getId()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.next()) {
            if (rowSet.getString("personId") != null) {
                person = new PersonInfo();
                person.setId(BOSUuid.read((String)rowSet.getString("personId")));
            } else if (defaultSalePersonMap.get(saleOrder.getSaleOrgUnit().getId().toString()) == null) {
                person = this.getDefaultSalePerson(ctx, saleOrder.getSaleOrgUnit().getId().toString());
                defaultSalePersonMap.put(saleOrder.getSaleOrgUnit().getId().toString(), person);
            } else {
                person = (PersonInfo)defaultSalePersonMap.get(saleOrder.getSaleOrgUnit().getId().toString());
            }
            if (rowSet.getString("adminId") != null) {
                admin = new AdminOrgUnitInfo();
                admin.setId(BOSUuid.read((String)rowSet.getString("adminId")));
            } else if (person != null && person.getId() != null) {
                if (defaultAdminOrgUnitMap.get(person.getId()) == null) {
                    admin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(person.getId());
                    defaultAdminOrgUnitMap.put(person.getId(), admin);
                } else {
                    admin = (AdminOrgUnitInfo)defaultAdminOrgUnitMap.get(person.getId());
                }
            }
            if (rowSet.getString("FPayConditionID") != null) {
                payCondition = new PayConditionInfo();
                payCondition.setId(BOSUuid.read((String)rowSet.getString("FPayConditionID")));
            }
            if (rowSet.getString("FPaymentTypeID") != null) {
                paymentType = new PaymentTypeInfo();
                paymentType.setId(BOSUuid.read((String)rowSet.getString("FPaymentTypeID")));
            } else {
                if (defaultPaymentType == null) {
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)"002", CompareType.EQUALS));
                    ev.setFilter(filter);
                    CoreBaseCollection paymentTypeColl = PaymentTypeFactory.getLocalInstance((Context)ctx).getCollection(ev);
                    if (paymentTypeColl != null) {
                        defaultPaymentType = (PaymentTypeInfo)paymentTypeColl.get(0);
                    }
                }
                paymentType = defaultPaymentType;
            }
            if (rowSet.getString("FSettlementTypeID") != null) {
                settlementType = new SettlementTypeInfo();
                settlementType.setId(BOSUuid.read((String)rowSet.getString("FSettlementTypeID")));
            }
            if (rowSet.getString("FTransAdvDay") != null) {
                transAdvDay = rowSet.getInt("FTransAdvDay");
            } else {
                saleOrder.setTransLeadTime(0);
            }
        }
        Map taxRateList = null;
        saleOrder.setSalePerson(person);
        saleOrder.setAdminOrgUnit(admin);
        saleOrder.setReceiveCondition(payCondition);
        saleOrder.setPaymentType(paymentType);
        saleOrder.setSettlementType(settlementType);
        saleOrder.setTransLeadTime(transAdvDay);
        SaleOrderEntryInfo saleOrderEntryInfo = null;
        SaleOrderEntryCollection saleOrderEntryCol = saleOrder.getEntries();
        String[] materialStrId = new String[saleOrderEntryCol.size()];
        String[] unitStrId = new String[saleOrderEntryCol.size()];
        int size = saleOrderEntryCol.size();
        for (int i = 0; i < size; ++i) {
            saleOrderEntryInfo = saleOrderEntryCol.get(i);
            materialStrId[i] = saleOrderEntryInfo.getMaterial().getId().toString();
            unitStrId[i] = saleOrderEntryInfo.getUnit().getId().toString();
        }
        taxRateList = this.getCurrentRate(ctx, materialStrId, saleOrder.getSaleOrgUnit().getId().toString());
        Date sendDate = null;
        String warehouseId = null;
        BigDecimal taxRate = null;
        saleOrder.setTotalAmount(ZERO);
        saleOrder.setTotalTax(ZERO);
        saleOrder.setTotalTaxAmount(ZERO);
        Iterator itor = saleOrderEntryCol.iterator();
        while (itor.hasNext()) {
            SaleOrderEntryInfo entry;
            Object item = itor.next();
            if (item == null || !(item instanceof SaleOrderEntryInfo) || (entry = (SaleOrderEntryInfo)item).getQty().compareTo(ZERO) != 0) continue;
            saleOrder.getEntries().remove(entry);
            itor = saleOrderEntryCol.iterator();
        }
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        ISaleOrgUnit iSaleOrg = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
        CustomerInfo customer = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(saleOrder.getOrderCustomer().getId()));
        CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(saleOrder.getCurrency().getId()));
        SaleOrgUnitInfo saleOrg = iSaleOrg.getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrder.getSaleOrgUnit().getId()));
        int precision = currency.getPrecision();
        CompanyOrgUnitInfo companyOrgUnit = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int size2 = saleOrderEntryCol.size();
        for (int i = 0; i < size2; ++i) {
            String storage2;
            saleOrderEntryInfo = saleOrderEntryCol.get(i);
            saleOrderEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            BigDecimal qty = saleOrderEntryInfo.getQty();
            if (qty.compareTo(ZERO) == 0) continue;
            sendDate = (Date)sendDates.get(saleOrderEntryInfo.getSourceBillEntryId());
            if (warehouseIds.get(saleOrderEntryInfo.getSourceBillEntryId()) != null) {
                warehouseId = warehouseIds.get(saleOrderEntryInfo.getSourceBillEntryId()).toString();
            }
            if (saleOrderEntryInfo.getMaterial().getId() != null) {
                taxRate = taxRateList.get(saleOrderEntryInfo.getMaterial().getId().toString()) != null ? new BigDecimal(taxRateList.get(saleOrderEntryInfo.getMaterial().getId().toString()).toString()) : new BigDecimal(17);
            }
            saleOrderEntryInfo = this.managerSaleOrderEntry(ctx, saleOrderEntryInfo, saleOrder, warehouseId, sendDate, taxRate, saleOrg, customer, currency, precision, materialCache, measureUnitCache);
            saleOrder.setTotalAmount(saleOrder.getTotalAmount().add(saleOrderEntryInfo.getAmount()));
            saleOrder.setTotalTax(saleOrder.getTotalTax().add(saleOrderEntryInfo.getTax()));
            saleOrder.setTotalTaxAmount(saleOrder.getTotalTaxAmount().add(saleOrderEntryInfo.getTaxAmount()));
            saleOrderEntryInfo.setLocalAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)saleOrderEntryInfo.getAmount(), (CompanyOrgUnitInfo)saleOrder.getCompanyOrgUnit(), (CurrencyInfo)currency));
            saleOrderEntryInfo.setLocalTax(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)saleOrderEntryInfo.getTax(), (CompanyOrgUnitInfo)saleOrder.getCompanyOrgUnit(), (CurrencyInfo)currency));
            saleOrderEntryInfo.setLocalTaxAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)saleOrderEntryInfo.getTaxAmount(), (CompanyOrgUnitInfo)saleOrder.getCompanyOrgUnit(), (CurrencyInfo)currency));
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(saleOrg.getId()), (String)"SALEORDER004");
            if (Boolean.valueOf(paramValue).booleanValue()) {
                saleOrderEntryInfo.setQuantityUnCtrl(true);
            } else {
                saleOrderEntryInfo.setQuantityUnCtrl(false);
            }
            companyOrgUnit = this.getCompanyOrgUnit(iOrgUnitRelation, saleOrderEntryInfo.getStorageOrgUnit().getId().toString(), OrgType.Storage);
            saleOrderEntryInfo.setCompanyOrgUnit(companyOrgUnit);
            if (saleOrder.getCompanyOrgUnit().getId().toString().equals(saleOrderEntryInfo.getCompanyOrgUnit().getId().toString())) {
                saleOrderEntryInfo.setIsBetweenCompanySend(false);
            } else {
                saleOrderEntryInfo.setIsBetweenCompanySend(true);
            }
            if (saleOrderEntryInfo.getProStorageOrgUnit() == null) {
                saleOrderEntryInfo.setSupplyMode(SupplyModeEnum.SELF_STORAGE);
                saleOrderEntryInfo.setProStorageOrgUnit(saleOrderEntryInfo.getStorageOrgUnit());
                continue;
            }
            String storage1 = saleOrderEntryInfo.getStorageOrgUnit() != null ? saleOrderEntryInfo.getStorageOrgUnit().getId().toString() : "";
            String string = storage2 = saleOrderEntryInfo.getProStorageOrgUnit() != null ? saleOrderEntryInfo.getProStorageOrgUnit().getId().toString() : "";
            if (saleOrderEntryInfo.getStorageOrgUnit() == null || saleOrderEntryInfo.getProStorageOrgUnit() == null || storage1.equals(storage2)) {
                saleOrderEntryInfo.setSupplyMode(SupplyModeEnum.SELF_STORAGE);
                saleOrderEntryInfo.setProStorageOrgUnit(saleOrderEntryInfo.getStorageOrgUnit());
                continue;
            }
            iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo company1 = this.getCompanyOrgUnit(iOrgUnitRelation, saleOrderEntryInfo.getStorageOrgUnit().getId().toString(), OrgType.Storage);
            CompanyOrgUnitInfo company2 = this.getCompanyOrgUnit(iOrgUnitRelation, saleOrderEntryInfo.getProStorageOrgUnit().getId().toString(), OrgType.Storage);
            if (company1 != null && company2 != null && company1.getId().toString().equals(company2.getId().toString())) {
                saleOrderEntryInfo.setSupplyMode(SupplyModeEnum.INTER_STORAGE);
                continue;
            }
            saleOrderEntryInfo.setSupplyMode(SupplyModeEnum.INTER_COMPANY);
        }
        BigDecimal localTotalAmount = SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)saleOrder.getTotalAmount(), (CompanyOrgUnitInfo)saleOrder.getCompanyOrgUnit(), (CurrencyInfo)currency);
        saleOrder.setLocalTotalAmount(localTotalAmount == null ? ZERO : localTotalAmount);
        BigDecimal localTaxAmount = SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)saleOrder.getTotalTaxAmount(), (CompanyOrgUnitInfo)saleOrder.getCompanyOrgUnit(), (CurrencyInfo)currency);
        saleOrder.setLocalTotalTaxAmount(localTaxAmount == null ? ZERO : localTaxAmount);
        return saleOrder;
    }

    private PersonInfo getDefaultSalePerson(Context ctx, String saleOrgUnitID) throws BOSException, SQLException, EASBizException {
        PersonInfo personInfo = null;
        String personId = null;
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.sd.channel.app", "SalePersonForChannelQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("saleOrg.id", (Object)saleOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        if (rs.next()) {
            personId = rs.getString("person.id");
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
        } else {
            EntityViewInfo viewInfoAll = new EntityViewInfo();
            FilterInfo filterInfoAll = new FilterInfo();
            filterInfoAll.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
            viewInfoAll.setFilter(filterInfoAll);
            IQueryExecutor execAll = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
            execAll.setObjectView(viewInfoAll);
            IRowSet rsAll = execAll.executeQuery();
            if (rsAll.next()) {
                personId = rsAll.getString("person.id");
                personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)personId));
            }
        }
        return personInfo;
    }

    private SaleOrderEntryInfo managerSaleOrderEntry(Context ctx, SaleOrderEntryInfo saleOrderEntryInfo, SaleOrderInfo saleOrder, String warehouseId, Date sendDate, BigDecimal taxRate, SaleOrgUnitInfo saleOrg, CustomerInfo customer, CurrencyInfo currency, int precision, HashMap materialCache, HashMap measureUnitCache) throws EASBizException, BOSException {
        MaterialInfo material = null;
        MeasureUnitInfo baseUnit = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo assUnit = null;
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        BigDecimal taxPrice = ZERO;
        DiscountModeEnum mode = null;
        BigDecimal discount = ZERO;
        Map calAmounts = null;
        BigDecimal price = null;
        WarehouseInfo warehouse = null;
        if (saleOrderEntryInfo.getMaterial() == null || saleOrderEntryInfo.getMaterial().getId() == null || saleOrder.getOrderCustomer() == null || saleOrder.getOrderCustomer().getId() == null) {
            throw new NetOrderManagerException(NetOrderManagerException.NO_PRICETO);
        }
        if (materialCache.get(saleOrderEntryInfo.getMaterial().getId().toString()) == null) {
            material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getMaterial().getId()));
            materialCache.put(saleOrderEntryInfo.getMaterial().getId().toString(), material);
        } else {
            material = (MaterialInfo)materialCache.get(saleOrderEntryInfo.getMaterial().getId().toString());
        }
        if (measureUnitCache.get(saleOrderEntryInfo.getBaseUnit().getId().toString()) == null) {
            baseUnit = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getBaseUnit().getId().toString()));
            measureUnitCache.put(saleOrderEntryInfo.getBaseUnit().getId().toString(), baseUnit);
        } else {
            baseUnit = (MeasureUnitInfo)measureUnitCache.get(saleOrderEntryInfo.getBaseUnit().getId().toString());
        }
        if (measureUnitCache.get(saleOrderEntryInfo.getUnit().getId().toString()) == null) {
            unit = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getUnit().getId().toString()));
            measureUnitCache.put(saleOrderEntryInfo.getUnit().getId().toString(), unit);
        } else {
            unit = (MeasureUnitInfo)measureUnitCache.get(saleOrderEntryInfo.getUnit().getId().toString());
        }
        saleOrderEntryInfo.setBaseQty(this.unitChange(ctx, saleOrderEntryInfo.getQty(), unit, baseUnit));
        if (saleOrderEntryInfo.getAssistUnit() != null) {
            if (measureUnitCache.get(saleOrderEntryInfo.getAssistUnit().getId().toString()) == null) {
                assUnit = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getAssistUnit().getId().toString()));
                measureUnitCache.put(saleOrderEntryInfo.getAssistUnit().getId().toString(), assUnit);
            } else {
                assUnit = (MeasureUnitInfo)measureUnitCache.get(saleOrderEntryInfo.getAssistUnit().getId().toString());
            }
            BigDecimal assistQty = ZERO;
            assistQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)material.getId().toString(), (MeasureUnitInfo)unit, (MeasureUnitInfo)assUnit, (BigDecimal)saleOrderEntryInfo.getQty());
            saleOrderEntryInfo.setAssistQty(assistQty);
        }
        if (sendDate != null) {
            saleOrderEntryInfo.setDeliveryDate(sendDate);
            saleOrderEntryInfo.setSendDate(this.changeDate(sendDate, saleOrder.getTransLeadTime() * -1));
        }
        if (warehouseId != null) {
            warehouse = new WarehouseInfo();
            warehouse.setId(BOSUuid.read((String)warehouseId));
        }
        saleOrderEntryInfo.setBizDate(saleOrder.getBizDate());
        saleOrderEntryInfo.setSaleOrgUnit(saleOrder.getSaleOrgUnit().getId().toString());
        saleOrderEntryInfo.setWarehouse(warehouse);
        PriceCondition priceCondition = new PriceCondition();
        priceCondition.setMaterialInfo(material);
        priceCondition.setCustomerInfo(customer);
        priceCondition.setCurrencyInfo(currency);
        priceCondition.setSaleOrg(saleOrg);
        priceCondition.setOrderQty(saleOrderEntryInfo.getQty());
        priceCondition.setMeasureUnit(saleOrderEntryInfo.getUnit().getId().toString());
        priceCondition.setCurDate(new Date());
        priceCondition.setAssiProperty(saleOrderEntryInfo.getAssistProperty());
        priceCondition.setFetchMode(0);
        PriceCondition[] priceConditionArray = new PriceCondition[]{priceCondition};
        List priceTOs = PriceService.getBatchMatPrices(ctx, priceConditionArray);
        if (priceTOs.size() > 0) {
            int currencyPrecision;
            SalePriceTO priceTO = this.findPriceTO(saleOrderEntryInfo, priceTOs, saleOrder.getSaleOrgUnit().getLongNumber());
            saleOrderEntryInfo.setDiscountType(DiscountModeEnum.PERCENT);
            if (priceTO != null) {
                if (priceTO.discountMode != null && priceTO.discountMode != -1) {
                    saleOrderEntryInfo.setDiscountType(DiscountModeEnum.getEnum((int)priceTO.discountMode));
                }
                if (priceTO.discountCondition != null) {
                    saleOrderEntryInfo.setDiscountCondition(DiscountConditionEnum.getEnum((int)priceTO.discountCondition));
                }
                saleOrderEntryInfo.setDiscount(priceTO.discountValue == null ? ZERO : priceTO.discountValue);
                taxPrice = saleOrderEntryInfo.getTaxPrice() != null && saleOrderEntryInfo.getTaxPrice().compareTo(ZERO) > 0 ? saleOrderEntryInfo.getTaxPrice() : (priceTO.price == null ? ZERO : priceTO.price);
            }
            int pricePrecision = material.getPricePrecision();
            CurrencyInfo currencyInfo = saleOrder.getCurrency();
            int n = currencyPrecision = currencyInfo != null ? currencyInfo.getPrecision() : 0;
            if (this.priceParamInfo.isContainTax()) {
                price = taxPrice.divide(taxRate.divide(Hundred, 10, 6).add(ONE), 10, 6);
            } else {
                price = taxPrice;
                taxPrice = price.multiply(taxRate.divide(Hundred, 10, 6).add(ONE));
            }
            saleOrderEntryInfo.setTaxPrice(taxPrice.setScale(pricePrecision, 4));
            saleOrderEntryInfo.setPrice(price.setScale(pricePrecision, 4));
            calAmounts = this.calDiscountAmount(mode, taxPrice, discount, saleOrderEntryInfo.getQty(), saleOrder.isIsInTax(), taxRate, precision, pricePrecision);
            saleOrderEntryInfo.setDiscountAmount((BigDecimal)calAmounts.get("discountAmount"));
            saleOrderEntryInfo.setTaxAmount((BigDecimal)calAmounts.get("totalTaxAmount"));
            saleOrderEntryInfo.setTax((BigDecimal)calAmounts.get("tax"));
            saleOrderEntryInfo.setTaxRate(taxRate);
            BigDecimal amount = ZERO;
            amount = currencyPrecision == 0 ? (BigDecimal)calAmounts.get("amount") : ((BigDecimal)calAmounts.get("amount")).setScale(currencyPrecision, 4);
            saleOrderEntryInfo.setAmount(amount);
            saleOrderEntryInfo.setActualTaxPrice((BigDecimal)calAmounts.get("actualTaxPrice"));
            saleOrderEntryInfo.setActualPrice((BigDecimal)calAmounts.get("actualPrice"));
            saleOrderEntryInfo.setUnOrderedQty(saleOrderEntryInfo.getQty());
            saleOrderEntryInfo.setTotalUnIssueQty(saleOrderEntryInfo.getQty());
            saleOrderEntryInfo.setTotalUnIssueBaseQty(saleOrderEntryInfo.getQty());
            saleOrderEntryInfo.setLocalAmount(saleOrderEntryInfo.getAmount());
            saleOrderEntryInfo.setLocalTax(saleOrderEntryInfo.getTax());
            saleOrderEntryInfo.setLocalTaxAmount(saleOrderEntryInfo.getLocalTaxAmount());
        } else {
            saleOrderEntryInfo.setDiscountAmount(ZERO);
            saleOrderEntryInfo.setTaxAmount(saleOrderEntryInfo.getAmount());
            saleOrderEntryInfo.setLocalTaxAmount(saleOrderEntryInfo.getAmount());
            saleOrderEntryInfo.setTax(ZERO);
            saleOrderEntryInfo.setLocalTax(ZERO);
            saleOrderEntryInfo.setLocalAmount(saleOrderEntryInfo.getAmount());
            saleOrderEntryInfo.setDiscountAmount(saleOrderEntryInfo.getQty());
        }
        return saleOrderEntryInfo;
    }

    private SaleOrderInfo addSplitEntry(Context ctx, SaleOrderInfo saleOrder, IObjectCollection splitNetOrderBillEntryColl, HashMap materialCache, HashMap measureUnitCache) throws EASBizException, BOSException {
        SaleOrderEntryCollection saleOrderEntryColl = saleOrder.getEntries();
        SaleOrderEntryInfo saleOrderEntry = null;
        NetOrderBillEntryInfo tempNetOrderBillEntryInfo = null;
        NetOrderBillEntryInfo netOrderBillAlreadyEntryInfo = null;
        CoreBaseCollection netOrderBillCollection = new CoreBaseCollection();
        INetOrderBillEntry iNetOrderEntry = NetOrderBillEntryFactory.getLocalInstance(ctx);
        ISaleOrderEntry iSaleOrderEntryInfo = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        ISaleOrgUnit iSaleOrg = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
        String warehouseId = null;
        Date sendDate = null;
        BigDecimal approveQty = ZERO;
        int length = saleOrderEntryColl.size();
        int size = splitNetOrderBillEntryColl.size();
        block0: for (int i = 0; i < size; ++i) {
            tempNetOrderBillEntryInfo = (NetOrderBillEntryInfo)splitNetOrderBillEntryColl.getObject(i);
            warehouseId = tempNetOrderBillEntryInfo.getRemark();
            sendDate = tempNetOrderBillEntryInfo.getAskArriveDate();
            CustomerInfo customer = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(saleOrder.getOrderCustomer().getId()));
            CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(saleOrder.getCurrency().getId()));
            SaleOrgUnitInfo saleOrg = iSaleOrg.getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrder.getSaleOrgUnit().getId()));
            int precision = currency.getPrecision();
            for (int j = 0; j < length; ++j) {
                saleOrderEntry = saleOrderEntryColl.get(j);
                if (!tempNetOrderBillEntryInfo.getId().toString().equals(saleOrderEntry.getSourceBillEntryId())) continue;
                SaleOrderEntryInfo splitSaleOrderEntry = (SaleOrderEntryInfo)saleOrderEntry.clone();
                splitSaleOrderEntry.setId(null);
                splitSaleOrderEntry.setSeq(saleOrderEntryColl.size() + 1);
                splitSaleOrderEntry.setQty(tempNetOrderBillEntryInfo.getApproveQty());
                splitSaleOrderEntry = this.managerSaleOrderEntry(ctx, splitSaleOrderEntry, saleOrder, warehouseId, sendDate, saleOrderEntry.getTaxRate(), saleOrg, customer, currency, precision, materialCache, measureUnitCache);
                splitSaleOrderEntry.setStorageOrgUnit(tempNetOrderBillEntryInfo.getStorageOrgUnit());
                iSaleOrderEntryInfo.addnew((CoreBaseInfo)splitSaleOrderEntry);
                saleOrder.setTotalAmount(saleOrder.getTotalAmount().add(splitSaleOrderEntry.getAmount()));
                saleOrder.setTotalTax(saleOrder.getTotalTax().add(splitSaleOrderEntry.getTax()));
                saleOrder.setTotalTaxAmount(saleOrder.getTotalTaxAmount().add(splitSaleOrderEntry.getTaxAmount()));
                saleOrderEntryColl.add(splitSaleOrderEntry);
                netOrderBillAlreadyEntryInfo = iNetOrderEntry.getNetOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(tempNetOrderBillEntryInfo.getId()));
                approveQty = netOrderBillAlreadyEntryInfo.getApproveQty();
                netOrderBillAlreadyEntryInfo.setApproveQty(approveQty.add(tempNetOrderBillEntryInfo.getApproveQty()));
                netOrderBillAlreadyEntryInfo.setApproveAmount(approveQty.add(tempNetOrderBillEntryInfo.getApproveQty()).multiply(netOrderBillAlreadyEntryInfo.getApprovePrice()));
                netOrderBillCollection.add((CoreBaseInfo)netOrderBillAlreadyEntryInfo);
                continue block0;
            }
        }
        iNetOrderEntry.update(netOrderBillCollection);
        return saleOrder;
    }

    private BigDecimal unitChange(Context ctx, BigDecimal qty, MeasureUnitInfo unit, MeasureUnitInfo changeUnit) {
        BigDecimal changeQty = ZERO;
        changeQty = qty.multiply(unit.getCoefficient()).divide(changeUnit.getCoefficient(), 6);
        return changeQty;
    }

    private Map getCurrentRate(Context ctx, String[] material, String saleOrg) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> taxRate = new HashMap<String, String>();
        IRowSet rateRs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select  fmaterialid,ftaxrate from T_BD_MaterialSales  where FOrgUnit='");
        sql.append(saleOrg);
        sql.append("' and fmaterialid in (");
        for (int i = 0; i < material.length; ++i) {
            sql.append("'").append(material[i]).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        rateRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rateRs.next()) {
            taxRate.put(rateRs.getString("fMaterialId"), rateRs.getString("fTaxRate"));
        }
        return taxRate;
    }

    protected IObjectPK[] saveBotpBill(BTPTransformResult result, Context ctx) throws BOSException, EASBizException {
        if (result == null) {
            return null;
        }
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        IBTPManager iBtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IObjectCollection destBillCols = result.getBills();
        BOTRelationCollection botRelationCols = result.getBOTRelationCollection();
        IObjectPK[] pks = new IObjectPK[destBillCols.size()];
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            pks[i] = iBtpManager.saveRelations(destBillInfo, botRelationCols);
        }
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _dealNetOrderBill(Context ctx, IObjectCollection netOrderBillEntryColl, IObjectValue CU, IObjectCollection splitNetOrderBillEntryColl) throws BOSException, EASBizException {
        NetOrderBillEntryCollection NOEntryDBValues = this.findNOEntries(ctx, netOrderBillEntryColl);
        ArrayList netOrderBillIdList = new ArrayList();
        String netOrderBillIds = this.getNetOrderBillIds(NOEntryDBValues, netOrderBillIdList);
        List entryIdList = this.initNetOrderEntryIdList(netOrderBillEntryColl);
        this.getMutex(ctx, netOrderBillIdList);
        try {
            this.updateBalance(ctx, entryIdList);
            NetOrderBillCollection NODBValues = this.findNetOrderBills(ctx, netOrderBillIds);
            this.addEntriesWithClientValues(NODBValues, NOEntryDBValues, (NetOrderBillEntryCollection)netOrderBillEntryColl);
            this.updateNetOrderBillWithEntries(ctx, NODBValues);
            this.unLockInventory(ctx, NODBValues);
            this.removeUnSelect(entryIdList, NODBValues);
            BTPTransformResult result = this.transformForBotp(ctx, NODBValues);
            this.rewriteHeader(ctx, result.getBills());
            this.rewriteEntry(ctx, result.getBills(), NODBValues, splitNetOrderBillEntryColl, CU);
            this.updateSaleOrders(ctx, result.getBills());
            this.writeNOBEntryAfterSplit(ctx, splitNetOrderBillEntryColl, NOEntryDBValues);
            int n = result.getBills().size();
            return n;
        }
        finally {
            this.releaseMutex(ctx, netOrderBillIdList);
        }
    }

    private void writeNOBEntryAfterSplit(Context ctx, IObjectCollection splitNetOrderBillEntryColl, NetOrderBillEntryCollection NOEntryDBValues) throws BOSException, EASBizException {
        if (null == splitNetOrderBillEntryColl || splitNetOrderBillEntryColl.size() <= 0) {
            return;
        }
        NetOrderBillEntryInfo splitEntryInfo = null;
        NetOrderBillEntryInfo netOrderBillAlreadyEntryInfo = null;
        BigDecimal approveQty = ZERO;
        CoreBaseCollection netOrderBillCollection = new CoreBaseCollection();
        INetOrderBillEntry iNetOrderEntry = NetOrderBillEntryFactory.getLocalInstance(ctx);
        int size = splitNetOrderBillEntryColl.size();
        for (int i = 0; i < size; ++i) {
            splitEntryInfo = (NetOrderBillEntryInfo)splitNetOrderBillEntryColl.getObject(i);
            netOrderBillAlreadyEntryInfo = (NetOrderBillEntryInfo)this.findObjectValue((IObjectCollection)NOEntryDBValues, splitEntryInfo.getId().toString());
            if (null == netOrderBillAlreadyEntryInfo || null == splitEntryInfo) continue;
            approveQty = netOrderBillAlreadyEntryInfo.getApproveQty();
            netOrderBillAlreadyEntryInfo.setApproveQty(approveQty.add(splitEntryInfo.getApproveQty()));
            netOrderBillAlreadyEntryInfo.setApproveAmount(approveQty.add(splitEntryInfo.getApproveQty()).multiply(netOrderBillAlreadyEntryInfo.getApprovePrice()));
            netOrderBillCollection.add((CoreBaseInfo)netOrderBillAlreadyEntryInfo);
        }
        iNetOrderEntry.update(netOrderBillCollection);
    }

    private Map initSplitEntryInfoMap(IObjectCollection splitNetOrderBillEntryColl) {
        HashMap<String, NetOrderBillEntryInfo> splitEntryInfoMap = new HashMap<String, NetOrderBillEntryInfo>(splitNetOrderBillEntryColl.size());
        NetOrderBillEntryInfo tempNetOrderBillEntryInfo = null;
        String key = null;
        int size = splitNetOrderBillEntryColl.size();
        for (int i = 0; i < size; ++i) {
            tempNetOrderBillEntryInfo = (NetOrderBillEntryInfo)splitNetOrderBillEntryColl.getObject(i);
            key = tempNetOrderBillEntryInfo.getId().toString() + String.valueOf(i);
            splitEntryInfoMap.put(key, tempNetOrderBillEntryInfo);
        }
        return splitEntryInfoMap;
    }

    private List initNetOrderEntryIdList(IObjectCollection entriesValues) {
        ArrayList<String> entryIdList = new ArrayList<String>();
        int size = entriesValues.size();
        for (int i = 0; i < size; ++i) {
            entryIdList.add(entriesValues.getObject(i).get("id").toString());
        }
        return entryIdList;
    }

    private String getNetOrderBillIds(NetOrderBillEntryCollection entries, List netOrderBillIdList) {
        StringBuffer netOrderBillIdStrb = new StringBuffer();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            String netOrderBillId = entries.get(i).getParent().getId().toString();
            if (netOrderBillIdList.contains(netOrderBillId)) continue;
            netOrderBillIdList.add(netOrderBillId);
            netOrderBillIdStrb.append(netOrderBillId).append(",");
        }
        return netOrderBillIdStrb.toString();
    }

    private void getMutex(Context ctx, List netOrderBillIdList) throws BOSException, NetOrderManagerException {
        boolean hasMutex = true;
        Map requestResult = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(netOrderBillIdList);
        Iterator it = netOrderBillIdList.iterator();
        while (it.hasNext()) {
            Object result = requestResult.get(it.next());
            if (result == null || !(result instanceof Boolean)) continue;
            if (((Boolean)result).booleanValue()) {
                hasMutex = false;
                continue;
            }
            hasMutex = true;
            break;
        }
        if (hasMutex) {
            throw new NetOrderManagerException(NetOrderManagerException.CREATE_SALE_ORDER_MUTEX_ERROR);
        }
    }

    private void releaseMutex(Context ctx, List netOrderBillIdList) throws BOSException {
        MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(netOrderBillIdList);
    }

    private NetOrderBillEntryCollection findNOEntries(Context ctx, IObjectCollection NOBEntriesClientValues) throws BOSException {
        StringBuffer netOrderBillEntryIdStrb = new StringBuffer();
        StringBuffer netOrderBillIdStrb = new StringBuffer();
        int size = NOBEntriesClientValues.size();
        for (int i = 0; i < size; ++i) {
            String netOrderBillEntryId = ((NetOrderBillEntryCollection)NOBEntriesClientValues).get(i).getId().toString();
            netOrderBillEntryIdStrb.append(netOrderBillEntryId).append(",");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)netOrderBillEntryIdStrb.toString(), CompareType.INCLUDE));
        return NetOrderBillEntryFactory.getLocalInstance(ctx).getNetOrderBillEntryCollection(view);
    }

    private NetOrderBillCollection findNetOrderBills(Context ctx, String netOrderBillIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)netOrderBillIds, CompareType.INCLUDE));
        NetOrderBillCollection netOrderConn = NetOrderBillFactory.getLocalInstance(ctx).getNetOrderBillCollection(view);
        return netOrderConn;
    }

    private void addEntriesWithClientValues(NetOrderBillCollection NODBValues, NetOrderBillEntryCollection NOEntryDBValues, NetOrderBillEntryCollection entryClientValues) {
        for (int i = 0; i < entryClientValues.size(); ++i) {
            NetOrderBillEntryInfo entryClientValue = (NetOrderBillEntryInfo)entryClientValues.getObject(i);
            NetOrderBillEntryInfo entryDBValue = (NetOrderBillEntryInfo)this.findObjectValue((IObjectCollection)NOEntryDBValues, entryClientValue.getId().toString());
            NetOrderBillInfo billDBValue = (NetOrderBillInfo)this.findObjectValue((IObjectCollection)NODBValues, entryDBValue.getParent().getId().toString());
            this.populateClientValues(billDBValue, entryDBValue, entryClientValue);
            billDBValue.getEntries().add(entryDBValue);
        }
    }

    private IObjectValue findObjectValue(IObjectCollection coll, String id) {
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.getObject(i).getBOSUuid("id").toString().equals(id)) continue;
            return coll.getObject(i);
        }
        return null;
    }

    private void populateClientValues(NetOrderBillInfo billDBValue, NetOrderBillEntryInfo entryDBValue, NetOrderBillEntryInfo entryClientValue) {
        entryDBValue.setApproveQty(entryClientValue.getApproveQty());
        entryDBValue.setApprovePrice(entryDBValue.getPrice());
        entryDBValue.setApproveAmount(entryClientValue.getApproveQty().multiply(entryDBValue.getApprovePrice()).setScale(billDBValue.getCurrencyPrecision(), 4));
        if (entryClientValue.getApproveQty() == null || entryClientValue.getApproveQty().compareTo(ZERO) < 1) {
            entryDBValue.setEntryStatus(NetOrderBillStatusEnum.AUTOCANCEL);
        } else {
            entryDBValue.setEntryStatus(NetOrderBillStatusEnum.READYSEND);
        }
        entryDBValue.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        entryDBValue.setStorageOrgUnit(entryClientValue.getStorageOrgUnit());
        if (entryClientValue.getWarehouse() != null) {
            entryDBValue.setWarehouse(entryClientValue.getWarehouse());
        }
        if (entryClientValue.getSendDate() != null) {
            entryDBValue.setSendDate(entryClientValue.getSendDate());
        }
    }

    private void unLockInventory(Context ctx, NetOrderBillCollection NODBValues) throws EASBizException, BOSException {
        for (int i = 0; i < NODBValues.size(); ++i) {
            NetOrderBillInfo bill = NODBValues.get(i);
            ArrayList<ObjectUuidPK> releaseIds = new ArrayList<ObjectUuidPK>();
            String saleOrgId = bill.getSaleOrgUnit().getId().toString();
            for (int j = 0; j < bill.getEntries().size(); ++j) {
                releaseIds.add(new ObjectUuidPK(bill.getEntries().get(j).getId().toString()));
            }
            NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(releaseIds.toArray(new IObjectPK[releaseIds.size()]), saleOrgId);
        }
    }

    private void updateNetOrderBillWithEntries(Context ctx, NetOrderBillCollection billDBValues) throws EASBizException, BOSException {
        CoreBaseCollection coll = new CoreBaseCollection();
        ArrayList idList = new ArrayList();
        INetOrderBill iNetOrder = NetOrderBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = null;
        for (int i = 0; i < billDBValues.size(); ++i) {
            NetOrderBillInfo billDBValue = billDBValues.get(i);
            if (this.checkIfNetOrderBillDealDone(billDBValue)) {
                billDBValue.setBillStatus(NetOrderBillStatusEnum.TREATED);
                billDBValue.setBaseStatus(BillBaseStatusEnum.CLOSED);
            } else {
                billDBValue.setBillStatus(NetOrderBillStatusEnum.DEALING);
            }
            pk = new ObjectUuidPK(billDBValue.getId());
            iNetOrder.update((IObjectPK)pk, billDBValue);
        }
    }

    private boolean checkIfNetOrderBillDealDone(NetOrderBillInfo netorderBill) {
        boolean flag = true;
        NetOrderBillEntryCollection entryConn = netorderBill.getEntries();
        NetOrderBillEntryInfo netOrderEntry = null;
        int size = entryConn.size();
        for (int i = 0; i < size; ++i) {
            netOrderEntry = entryConn.get(i);
            if (!NetOrderBillStatusEnum.AUDITED.equals((Object)netOrderEntry.getEntryStatus()) && !NetOrderBillStatusEnum.DEALING.equals((Object)netOrderEntry.getEntryStatus())) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private void updateBalance(Context ctx, List idList) throws EASBizException, BOSException {
        if (idList.size() > 0) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(idList.toArray(), CreditOperationEnum.CLOSE);
        }
    }

    private BTPTransformResult transformForBotp(Context ctx, NetOrderBillCollection NODBValues) throws BOSException, EASBizException {
        CoreBillBaseCollection coll = new CoreBillBaseCollection();
        for (int i = 0; i < NODBValues.size(); ++i) {
            coll.add((CoreBillBaseInfo)NODBValues.get(i));
        }
        BTPTransformResult result = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coll, new SaleOrderInfo().getBOSType().toString());
        this.saveBotp(result, ctx);
        return result;
    }

    protected IObjectPK[] saveBotp(BTPTransformResult result, Context ctx) throws BOSException, EASBizException {
        if (result == null) {
            return null;
        }
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        IBTPManager iBtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IObjectCollection destBillCols = result.getBills();
        BOTRelationCollection botRelationCols = result.getBOTRelationCollection();
        IObjectPK[] pks = new IObjectPK[destBillCols.size()];
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            pks[i] = iBtpManager.saveRelations(destBillInfo, botRelationCols);
        }
        return pks;
    }

    private void rewriteHeader(Context ctx, IObjectCollection saleOrders) throws BOSException, EASBizException {
        IRowSet rowSet = this.findDataWithSaleOrg(ctx, saleOrders);
        try {
            this.populateHeader(ctx, rowSet, saleOrders);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IRowSet findDataWithSaleOrg(Context ctx, IObjectCollection saleOrders) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select distinct person.fid as personId,customer.fid as customerId,customersaleinfo.fsaleorgid as saleOrgId,admin.fid as adminId,FPayConditionID,FPaymentTypeID,FSettlementTypeID,FTransAdvDay from t_bd_customersaleinfo customersaleinfo ").append("  left outer join t_bd_customer customer on customer.fid=customersaleinfo.fcustomerid ").append("  left outer join t_bd_customercompanyinfo customerCompany on customer.fid= customerCompany.fcustomerid ").append("  left outer join t_bd_customerSaler cutomerSaler on cutomerSaler.fcustomersaleid=customersaleinfo.fid ").append("  left outer join t_bd_person person on cutomerSaler.fpersonid=person.fid ").append("  left outer join T_ORG_PositionMember PositionMember on person.fid=positionMember.fpersonid  ").append("  left outer join T_ORG_Position position on PositionMember.FPositionID=position.fid ").append("  left outer join T_ORG_Admin admin on position.FAdminOrgUnitID=admin.fid where customersaleinfo.fsaleorgid in (");
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            sql.append("'").append(saleOrderInfo.getSaleOrgUnit().getId().toString()).append("'");
            if (i >= saleOrders.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private void populateHeader(Context ctx, IRowSet rowSet, IObjectCollection saleOrders) throws SQLException, EASBizException, BOSException {
        AdminOrgUnitInfo adminOrg = null;
        PayConditionInfo payCondition = null;
        SettlementTypeInfo settlementType = null;
        int transAdvDay = 0;
        Map personCache = this.getDefSalePersonCache(ctx, saleOrders);
        PaymentTypeInfo defaultPaymentType = this.getDefaultPaymentType(ctx);
        SaleOrderInfo saleOrderInfo = null;
        StringBuffer personIds = new StringBuffer();
        while (rowSet.next()) {
            PaymentTypeInfo paymentType;
            PersonInfo person;
            saleOrderInfo = this.findSaleOrder(rowSet, saleOrders);
            if (saleOrderInfo == null) continue;
            if (rowSet.getString("personId") != null) {
                person = new PersonInfo();
                person.setId(BOSUuid.read((String)rowSet.getString("personId")));
            } else {
                person = (PersonInfo)personCache.get(rowSet.getString("saleOrgId"));
            }
            if (person == null || person.getId() == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"9_NetOrderCollectionManagerFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            personIds.append(person.getId().toString()).append(",");
            if (rowSet.getString("adminId") != null) {
                adminOrg = new AdminOrgUnitInfo();
                adminOrg.setId(BOSUuid.read((String)rowSet.getString("adminId")));
            }
            if (rowSet.getString("FPayConditionID") != null) {
                payCondition = new PayConditionInfo();
                payCondition.setId(BOSUuid.read((String)rowSet.getString("FPayConditionID")));
            }
            if (rowSet.getString("FPaymentTypeID") != null) {
                paymentType = new PaymentTypeInfo();
                paymentType.setId(BOSUuid.read((String)rowSet.getString("FPaymentTypeID")));
            } else {
                paymentType = defaultPaymentType;
            }
            if (rowSet.getString("FSettlementTypeID") != null) {
                settlementType = new SettlementTypeInfo();
                settlementType.setId(BOSUuid.read((String)rowSet.getString("FSettlementTypeID")));
            }
            if (rowSet.getString("FTransAdvDay") != null) {
                transAdvDay = rowSet.getInt("FTransAdvDay");
            } else {
                saleOrderInfo.setTransLeadTime(transAdvDay);
            }
            saleOrderInfo.setSalePerson(person);
            saleOrderInfo.setAdminOrgUnit(adminOrg);
            saleOrderInfo.setReceiveCondition(payCondition);
            saleOrderInfo.setPaymentType(paymentType);
            saleOrderInfo.setSettlementType(settlementType);
            saleOrderInfo.setTransLeadTime(transAdvDay);
        }
        Map adminCache = this.getAdminOrgCache(ctx, personIds.toString());
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            adminOrg = (AdminOrgUnitInfo)adminCache.get(saleOrderInfo.getSalePerson().getId().toString());
            if (adminOrg == null || saleOrderInfo.getAdminOrgUnit() != null) continue;
            saleOrderInfo.setAdminOrgUnit(adminOrg);
        }
    }

    private SaleOrderInfo findSaleOrder(IRowSet rowSet, IObjectCollection saleOrders) throws SQLException {
        String saleOrgId = rowSet.getString("saleOrgId");
        String customerId = rowSet.getString("customerId");
        if (saleOrgId != null && customerId != null) {
            int size = saleOrders.size();
            for (int i = 0; i < size; ++i) {
                SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
                if (!saleOrgId.equals(saleOrderInfo.getSaleOrgUnit().getId().toString()) || !customerId.equals(saleOrderInfo.getOrderCustomer().getId().toString())) continue;
                return saleOrderInfo;
            }
        }
        return null;
    }

    private Map getDefSalePersonCache(Context ctx, IObjectCollection saleOrders) throws BOSException, SQLException, EASBizException {
        SaleOrderInfo saleOrderInfo;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT salePerson.FPersonID as personId,saleGroup.FSaleOrgID as saleOrgId FROM T_BD_SalePerson as salePerson");
        sql.append(" INNER JOIN T_BD_Person as person on salePerson.FPersonID = person.FID");
        sql.append(" INNER JOIN T_BD_SaleGroup as saleGroup on salePerson.FSaleGroupID=saleGroup.FID");
        sql.append(" INNER JOIN T_ORG_Sale as saleOrg on saleGroup.FSaleOrgID=saleOrg.FID");
        sql.append(" WHERE salePerson.FDeletedStatus=1").append("and saleOrg.FID in (");
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            sql.append("'").append(saleOrderInfo.getSaleOrgUnit().getId().toString()).append("'");
            if (i >= saleOrders.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, PersonInfo> personCache = new HashMap<String, PersonInfo>();
        block1: while (rs.next()) {
            String personId = rs.getString("personId");
            String saleOrgId = rs.getString("saleOrgId");
            if (saleOrgId == null || personId == null) continue;
            int size2 = saleOrders.size();
            for (int i = 0; i < size2; ++i) {
                saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
                if (!saleOrgId.equals(saleOrderInfo.getSaleOrgUnit().getId().toString())) continue;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)personId));
                personCache.put(saleOrgId, personInfo);
                continue block1;
            }
        }
        return personCache;
    }

    private PaymentTypeInfo getDefaultPaymentType(Context ctx) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.getSelector().add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"002", CompareType.EQUALS));
        ev.setFilter(filter);
        return PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeCollection(ev).get(0);
    }

    private Map getAdminOrgCache(Context ctx, String personIds) throws BOSException {
        HashMap<String, AdminOrgUnitInfo> adminCache = new HashMap<String, AdminOrgUnitInfo>();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("isPrimary", (Object)"1");
        FilterItemInfo filterItemPerson = new FilterItemInfo("person.id", (Object)personIds, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItemPerson);
        filter.setMaskString("#0 and #1");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        PositionMemberCollection posiMemberColl = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
        for (int i = 0; i < posiMemberColl.size(); ++i) {
            adminCache.put(posiMemberColl.get(i).getPerson().getId().toString(), posiMemberColl.get(i).getPosition().getAdminOrgUnit());
        }
        return adminCache;
    }

    private void rewriteEntry(Context ctx, IObjectCollection saleOrders, NetOrderBillCollection NODBValues, IObjectCollection splitNetOrderBillEntryColl, IObjectValue CU) throws EASBizException, BOSException {
        this.rewriteEntryWithHeader(ctx, saleOrders, NODBValues, splitNetOrderBillEntryColl);
        this.rewriteEntryWithPrice(ctx, saleOrders, CU);
    }

    private void rewriteEntryWithHeader(Context ctx, IObjectCollection saleOrders, NetOrderBillCollection NODBValues, IObjectCollection splitNetOrderBillEntryColl) throws BOSException, EASBizException {
        Map companyOrgUnitCache = this.getCompanyOrgUnitCache(ctx, saleOrders);
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            this.populateEntryWithHeader(ctx, saleOrderInfo, NODBValues, companyOrgUnitCache, splitNetOrderBillEntryColl);
        }
    }

    private void populateEntryWithHeader(Context ctx, SaleOrderInfo saleOrderInfo, NetOrderBillCollection NODBValues, Map companyOrgUnitCach, IObjectCollection splitNetOrderBillEntryColl) throws EASBizException, BOSException {
        NetOrderBillEntryCollection splitNOBEntryConn = new NetOrderBillEntryCollection();
        SaleOrderEntryCollection splitSOEntryConn = new SaleOrderEntryCollection();
        SaleOrderEntryCollection saleOrderEntryConn = saleOrderInfo.getEntries();
        SaleOrderEntryInfo splitSOEntry = null;
        int entrySize = saleOrderEntryConn.size();
        HashMap paramValueMap = ParamManager.getParamHashMap((Context)ctx, (String[])new String[]{"SALEORDER004", "SALEORDERSEL001"}, (String)saleOrderInfo.getSaleOrgUnit().getId().toString());
        boolean isCentralBalance = false;
        boolean isQuantityUnCtrl = Boolean.valueOf(paramValueMap.get("SALEORDER004").toString());
        for (int i = 0; i < entrySize; ++i) {
            SaleOrderEntryInfo SOEntry = saleOrderEntryConn.get(i);
            if (SOEntry.getQty().compareTo(ZERO) == 0) continue;
            if (SOEntry.getProStorageOrgUnit() == null) {
                SOEntry.setSupplyMode(SupplyModeEnum.SELF_STORAGE);
                SOEntry.setProStorageOrgUnit(SOEntry.getStorageOrgUnit());
            } else {
                String storage2;
                String storage1 = SOEntry.getStorageOrgUnit() != null ? SOEntry.getStorageOrgUnit().getId().toString() : "";
                String string = storage2 = SOEntry.getProStorageOrgUnit() != null ? SOEntry.getProStorageOrgUnit().getId().toString() : "";
                if (SOEntry.getStorageOrgUnit() == null || SOEntry.getProStorageOrgUnit() == null || storage1.equals(storage2)) {
                    SOEntry.setSupplyMode(SupplyModeEnum.SELF_STORAGE);
                    SOEntry.setProStorageOrgUnit(SOEntry.getStorageOrgUnit());
                } else {
                    IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitInfo company1 = this.getCompanyOrgUnit(iOrgUnitRelation, SOEntry.getStorageOrgUnit().getId().toString(), OrgType.Storage);
                    CompanyOrgUnitInfo company2 = this.getCompanyOrgUnit(iOrgUnitRelation, SOEntry.getProStorageOrgUnit().getId().toString(), OrgType.Storage);
                    if (company1 != null && company2 != null && company1.getId().toString().equals(company2.getId().toString())) {
                        SOEntry.setSupplyMode(SupplyModeEnum.INTER_STORAGE);
                    } else {
                        SOEntry.setSupplyMode(SupplyModeEnum.INTER_COMPANY);
                    }
                }
            }
            if (splitNetOrderBillEntryColl != null) {
                int size = splitNetOrderBillEntryColl.size();
                for (int j = 0; j < size; ++j) {
                    NetOrderBillEntryInfo splitNOBEntry = (NetOrderBillEntryInfo)splitNetOrderBillEntryColl.getObject(j);
                    if (!splitNOBEntry.getId().toString().equals(SOEntry.getSourceBillEntryId())) continue;
                    splitSOEntry = (SaleOrderEntryInfo)SOEntry.clone();
                    this.setSaleOrderEntryInfoByNobEntry(ctx, saleOrderInfo, splitSOEntry, splitNOBEntry, companyOrgUnitCach, isQuantityUnCtrl);
                    splitSOEntry.setQty(splitNOBEntry.getApproveQty());
                    splitSOEntry.setId(null);
                    splitSOEntry.setSeq(saleOrderEntryConn.size() + 1);
                    splitSOEntryConn.add(splitSOEntry);
                    splitNOBEntryConn.add(splitNOBEntry);
                }
            }
            NetOrderBillEntryInfo NOBEntry = this.findEntry(NODBValues, SOEntry.getSourceBillEntryId());
            this.setSaleOrderEntryInfoByNobEntry(ctx, saleOrderInfo, SOEntry, NOBEntry, companyOrgUnitCach, isQuantityUnCtrl);
            if (!SOEntry.isIsBetweenCompanySend() && (splitSOEntry == null || !splitSOEntry.isIsBetweenCompanySend()) || isCentralBalance) continue;
            isCentralBalance = Boolean.valueOf(paramValueMap.get("SALEORDERSEL001").toString()) == false;
        }
        if (splitSOEntryConn.size() > 0) {
            saleOrderEntryConn.addCollection(splitSOEntryConn);
        }
        if (isCentralBalance) {
            saleOrderInfo.setIsCentralBalance(isCentralBalance);
            this.setDefaultValueToStorageOrg(ctx, saleOrderInfo);
        }
    }

    private void setSaleOrderEntryInfoByNobEntry(Context ctx, SaleOrderInfo saleOrderInfo, SaleOrderEntryInfo SOEntry, NetOrderBillEntryInfo NOBEntry, Map companyOrgUnitCach, boolean isQuantityUnCtrl) throws EASBizException, BOSException {
        if (NOBEntry != null) {
            this.setEntryDate(saleOrderInfo, SOEntry, NOBEntry);
            this.setEntryWareHouse(SOEntry, NOBEntry);
        }
        SOEntry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        SOEntry.setBizDate(saleOrderInfo.getBizDate());
        SOEntry.setSaleOrgUnit(saleOrderInfo.getSaleOrgUnit().getId().toString());
        this.populateEntryWithQty(ctx, SOEntry, NOBEntry.getApproveQty());
        SOEntry.setTotalUnIssueQty(NOBEntry.getApproveQty());
        SOEntry.setTotalUnIssueBaseQty(NOBEntry.getApproveQty());
        SOEntry.setQuantityUnCtrl(isQuantityUnCtrl);
        CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)companyOrgUnitCach.get(NOBEntry.getStorageOrgUnit().getId().toString());
        SOEntry.setCompanyOrgUnit(companyOrgUnit);
        if (null != companyOrgUnit) {
            if (saleOrderInfo.getCompanyOrgUnit().getId().toString().equals(SOEntry.getCompanyOrgUnit().getId().toString())) {
                SOEntry.setIsBetweenCompanySend(false);
            } else {
                SOEntry.setIsBetweenCompanySend(true);
            }
        } else {
            SOEntry.setIsBetweenCompanySend(false);
        }
    }

    private void populateEntryWithQty(Context ctx, SaleOrderEntryInfo SOEntry, BigDecimal approveQty) throws EASBizException, BOSException {
        if (SOEntry.getMaterial() != null) {
            String materialId = SOEntry.getMaterial().getId().toString();
            MeasureUnitInfo unit = SOEntry.getUnit();
            MeasureUnitInfo baseUnit = SOEntry.getBaseUnit();
            MeasureUnitInfo assitUnit = SOEntry.getAssistUnit();
            if (null != unit && null != baseUnit) {
                BigDecimal baseQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialId, (MeasureUnitInfo)unit, (MeasureUnitInfo)baseUnit, (BigDecimal)approveQty);
                SOEntry.setBaseQty(baseQty);
            } else {
                SOEntry.setBaseQty(approveQty);
            }
            if (null != unit && null != assitUnit) {
                BigDecimal assistQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialId, (MeasureUnitInfo)unit, (MeasureUnitInfo)assitUnit, (BigDecimal)approveQty);
                SOEntry.setAssistQty(assistQty);
            }
        }
    }

    private void setDefaultValueToStorageOrg(Context ctx, SaleOrderInfo saleOrderInfo) throws EASBizException, BOSException {
        block5: {
            int i;
            StorageOrgUnitInfo storageOrgInfo;
            OrgUnitCollection companyOrgUnitCollection;
            block4: {
                SaleOrgUnitInfo saleOrgUnit = saleOrderInfo.getSaleOrgUnit();
                CompanyOrgUnitInfo companyOrgUnitInfo = saleOrderInfo.getCompanyOrgUnit();
                if (saleOrgUnit == null || companyOrgUnitInfo == null) {
                    return;
                }
                companyOrgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Company, (OrgType)OrgType.Storage, (String)companyOrgUnitInfo.getId().toString());
                boolean isEquals = false;
                storageOrgInfo = null;
                int size = companyOrgUnitCollection.size();
                for (i = 0; i < size; ++i) {
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)companyOrgUnitCollection.get(i);
                    if (!saleOrgUnit.getId().equals((Object)storageOrgUnitInfo.getId())) continue;
                    isEquals = true;
                    storageOrgInfo = storageOrgUnitInfo;
                }
                if (!isEquals) break block4;
                saleOrderInfo.setStorageOrgUnit(storageOrgInfo);
                if (storageOrgInfo == null) break block5;
                saleOrderInfo.setWarehouse(SaleOrderFactory.getLocalInstance((Context)ctx).getDefaultWarehouseByStorage(storageOrgInfo.getId().toString()));
                break block5;
            }
            if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
                for (i = 0; i < companyOrgUnitCollection.size(); ++i) {
                    storageOrgInfo = (StorageOrgUnitInfo)companyOrgUnitCollection.get(i);
                    if (storageOrgInfo == null || !storageOrgInfo.isIsBizUnit()) continue;
                    saleOrderInfo.setStorageOrgUnit(storageOrgInfo);
                    saleOrderInfo.setWarehouse(SaleOrderFactory.getLocalInstance((Context)ctx).getDefaultWarehouseByStorage(storageOrgInfo.getId().toString()));
                    break;
                }
            }
        }
    }

    private NetOrderBillEntryInfo findEntry(NetOrderBillCollection NODBValues, String sourceBillEntryId) {
        for (int i = 0; i < NODBValues.size(); ++i) {
            NetOrderBillInfo bill = NODBValues.get(i);
            NetOrderBillEntryInfo entry = (NetOrderBillEntryInfo)this.findObjectValue((IObjectCollection)bill.getEntries(), sourceBillEntryId);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    private void setEntryDate(SaleOrderInfo saleOrderInfo, SaleOrderEntryInfo SOEntryInfo, NetOrderBillEntryInfo NOBEntry) {
        Date askArriveDate = NOBEntry.getAskArriveDate();
        Date sendDate = NOBEntry.getSendDate();
        if (sendDate != null) {
            SOEntryInfo.setSendDate(sendDate);
            SOEntryInfo.setDeliveryDate(askArriveDate);
        } else if (askArriveDate != null) {
            Date needDate = null;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(askArriveDate);
            calendar.add(6, saleOrderInfo.getTransLeadTime() * -1);
            needDate = calendar.getTime();
            SOEntryInfo.setSendDate(needDate);
            SOEntryInfo.setDeliveryDate(askArriveDate);
        }
    }

    private void setEntryWareHouse(SaleOrderEntryInfo SOEntryInfo, NetOrderBillEntryInfo NOBEntry) {
        if (NOBEntry.getWarehouse() != null) {
            WarehouseInfo warehouse = new WarehouseInfo();
            warehouse.setId(BOSUuid.read((String)NOBEntry.getWarehouse().getId().toString()));
            SOEntryInfo.setWarehouse(warehouse);
        }
    }

    private boolean isGetNewPrice(Context ctx, String saleOrgId) throws BOSException {
        return ChannelParamFacadeFactory.getLocalInstance(ctx).getEditPriceForNetOrder(saleOrgId);
    }

    private PriceCondition[] genPriceCondtions(SaleOrderInfo saleOrderInfo) {
        ArrayList<PriceCondition> conditions = new ArrayList<PriceCondition>();
        for (int j = 0; j < saleOrderInfo.getEntries().size(); ++j) {
            SaleOrderEntryInfo entry = saleOrderInfo.getEntries().get(j);
            PriceCondition priceCondition = new PriceCondition();
            entry.getMaterial().setBaseUnit(entry.getBaseUnit());
            priceCondition.setMaterialInfo(entry.getMaterial());
            priceCondition.setCustomerInfo(saleOrderInfo.getOrderCustomer());
            priceCondition.setCurrencyInfo(saleOrderInfo.getCurrency());
            priceCondition.setSaleOrg(saleOrderInfo.getSaleOrgUnit());
            priceCondition.setOrderQty(entry.getQty());
            priceCondition.setMeasureUnit(entry.getUnit().getId().toString());
            priceCondition.setCurDate(new Date());
            priceCondition.setAssiProperty(entry.getAssistProperty());
            priceCondition.setFetchMode(0);
            conditions.add(priceCondition);
        }
        return conditions.toArray(new PriceCondition[conditions.size()]);
    }

    private void initMatPriceCache(Context ctx, IObjectCollection saleOrders, Map taxRateCache, Map pricePrecisionCache) throws EASBizException, BOSException, SQLException {
        ArrayList<String> material = new ArrayList<String>();
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            for (int j = 0; j < saleOrderInfo.getEntries().size(); ++j) {
                material.add(saleOrderInfo.getEntries().get(j).getMaterial().getId().toString());
            }
        }
        this.findMatSales(ctx, material.toArray(new String[material.size()]), taxRateCache, pricePrecisionCache);
    }

    private void findMatSales(Context ctx, String[] material, Map taxRateCache, Map pricePrecisionCache) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select matSales.fOrgUnit as orgUnit,matSales.fmaterialid as matId,matSales.ftaxrate as taxRate,");
        sql.append("mat.FPricePrecision as prciePrecision ");
        sql.append("from T_BD_MaterialSales matSales");
        sql.append(" inner join T_BD_Material mat on mat.fid=matSales.fmaterialid ");
        sql.append(" where fmaterialid in (");
        for (int i = 0; i < material.length; ++i) {
            sql.append("'").append(material[i]).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String key = rs.getString("matId") + rs.getString("orgUnit");
            taxRateCache.put(key, new BigDecimal(rs.getString("taxRate") == null ? "0.00" : rs.getString("taxRate")));
            pricePrecisionCache.put(key, Integer.parseInt(rs.getString("prciePrecision") == null ? "0" : rs.getString("prciePrecision")));
        }
    }

    private void rewriteEntryWithPrice(Context ctx, IObjectCollection saleOrders, IObjectValue CU) throws BOSException, EASBizException {
        HashMap taxRateCache = new HashMap();
        HashMap pricePrecisionCache = new HashMap();
        try {
            this.initMatPriceCache(ctx, saleOrders, taxRateCache, pricePrecisionCache);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Map currencyPrecisionCache = this.getCurrencyPrecisionCache(ctx, saleOrders);
        Map priceParamCach = this.getPriceParamCach(ctx, saleOrders);
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            saleOrderInfo.setTotalAmount(ZERO);
            saleOrderInfo.setTotalTax(ZERO);
            saleOrderInfo.setTotalTaxAmount(ZERO);
            Integer currencyPrecision = (Integer)currencyPrecisionCache.get(saleOrderInfo.getSaleOrgUnit().getId());
            boolean isContainTax = this.isContainTax(saleOrderInfo.getSaleOrgUnit().getId().toString(), priceParamCach);
            boolean isGetNewPrice = this.isGetNewPrice(ctx, saleOrderInfo.getSaleOrgUnit().getId().toString());
            if (!isGetNewPrice) {
                this.popEntryWithNewPrice(ctx, saleOrderInfo, taxRateCache, pricePrecisionCache, currencyPrecision == null ? 2 : currencyPrecision, isContainTax);
            } else {
                this.popEntryWithPrice(ctx, saleOrderInfo, taxRateCache, pricePrecisionCache, currencyPrecision == null ? 2 : currencyPrecision, isContainTax);
            }
            BigDecimal localTotalAmount = SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)saleOrderInfo.getTotalAmount(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency());
            saleOrderInfo.setLocalTotalAmount(localTotalAmount == null ? ZERO : localTotalAmount);
            BigDecimal localTaxAmount = SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)saleOrderInfo.getTotalTaxAmount(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency());
            saleOrderInfo.setLocalTotalTaxAmount(localTaxAmount == null ? ZERO : localTaxAmount);
        }
    }

    private boolean isContainTax(String orgId, Map priceParamCach) {
        String value = (String)priceParamCach.get(orgId + "PricePa002");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private Map getPriceParamCach(Context ctx, IObjectCollection saleOrders) throws BOSException {
        String orgid;
        String orgsStr = this.getOrgNumberStr(this.getSOUNumbers(saleOrders));
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT pe.forgunitid as forgunitid ,pp.fnumber as fnumber, pe.fvalue_l2 as value FROM T_BAS_PARAM pp ");
        sql.append(" INNER JOIN t_bas_paramitem pe on pe.fkeyid = pp.fid ");
        sql.append(" WHERE pp.fnumber IN ('PricePa002') ");
        sql.append(" AND pe.forgunitid IN (SELECT FID FROM T_ORG_SALE WHERE FNUMBER in (").append(orgsStr).append(") )");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                orgid = rowSet.getString("forgunitid");
                String fnumber = rowSet.getString("fnumber");
                String value = rowSet.getString("value");
                if (value.equals("-1") || value == null) {
                    value = "false";
                }
                map.put(orgid + fnumber, value);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append("SELECT fid from T_ORG_SALE where fnumber in (").append(orgsStr).append(")");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                orgid = rowSet.getString("fid");
                String key = orgid + "PricePa002";
                if (map.containsKey(key)) continue;
                map.put(key, "false");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String[] getSOUNumbers(IObjectCollection saleOrders) {
        HashSet<String> set = new HashSet<String>();
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            String[] numbers = saleOrderInfo.getSaleOrgUnit().getLongNumber().split("!");
            for (int j = 0; j < numbers.length; ++j) {
                set.add(numbers[j]);
            }
        }
        Object[] obj = set.toArray();
        String[] retNumbers = new String[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            retNumbers[i] = (String)obj[i];
        }
        return retNumbers;
    }

    private String getOrgNumberStr(String[] orgNumber) {
        if (orgNumber == null) {
            return null;
        }
        StringBuffer orgNumbers = new StringBuffer("");
        for (int j = 0; j < orgNumber.length; ++j) {
            if (j > 0) {
                orgNumbers.append(",");
            }
            orgNumbers.append("'");
            orgNumbers.append(orgNumber[j]);
            orgNumbers.append("'");
        }
        return orgNumbers.toString();
    }

    private Map getCurrencyPrecisionCache(Context ctx, IObjectCollection saleOrders) throws BOSException {
        HashMap<String, Integer> currencyPrecisionCache = new HashMap<String, Integer>();
        StringBuffer saleOrgIds = new StringBuffer();
        int size = saleOrders.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            saleOrgIds.append(saleOrderInfo.getId().toString()).append(",");
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("saleOrgUnit.id", (Object)saleOrgIds.toString(), CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("saleOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("currency.precision"));
        SaleOrderCollection colls = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderCollection(viewInfo);
        for (int i = 0; i < colls.size(); ++i) {
            currencyPrecisionCache.put(colls.get(i).getSaleOrgUnit().getId().toString(), new Integer(colls.get(i).getCurrency().getPrecision()));
        }
        return currencyPrecisionCache;
    }

    private void popEntryWithNewPrice(Context ctx, SaleOrderInfo saleOrderInfo, Map taxRateCache, Map pricePrecisionCache, int precision, boolean isContainTax) throws EASBizException, BOSException {
        List priceTOs = PriceService.getBatchMatPrices(ctx, this.genPriceCondtions(saleOrderInfo));
        for (int j = 0; j < saleOrderInfo.getEntries().size(); ++j) {
            SaleOrderEntryInfo entry = saleOrderInfo.getEntries().get(j);
            SalePriceTO priceTO = this.findPriceTO(entry, priceTOs, saleOrderInfo.getSaleOrgUnit().getLongNumber());
            BigDecimal taxRate = this.findCurrentRate(entry, taxRateCache);
            entry.setTaxRate(taxRate);
            entry.setDiscountType(DiscountModeEnum.PERCENT);
            int pricePrecision = this.findPricePrecision(entry, pricePrecisionCache);
            if (priceTO != null) {
                this.setEntryPriceWithTax(entry, priceTO.price, taxRate, pricePrecision, isContainTax);
                if (priceTO.discountMode != null && priceTO.discountMode != -1) {
                    entry.setDiscountType(DiscountModeEnum.getEnum((int)priceTO.discountMode));
                }
                if (priceTO.discountCondition != null) {
                    entry.setDiscountCondition(DiscountConditionEnum.getEnum((int)priceTO.discountCondition));
                }
                entry.setDiscount(priceTO.discountValue == null ? ZERO : priceTO.discountValue);
            }
            this.setAmountWithDiscount(entry, precision);
            this.setAmountWithTax(entry, precision, saleOrderInfo.isIsInTax());
            this.setActualPrice(entry, pricePrecision);
            saleOrderInfo.setTotalAmount(saleOrderInfo.getTotalAmount().add(entry.getAmount()));
            saleOrderInfo.setTotalTax(saleOrderInfo.getTotalTax().add(entry.getTax()));
            saleOrderInfo.setTotalTaxAmount(saleOrderInfo.getTotalTaxAmount().add(entry.getTaxAmount()));
            entry.setLocalAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entry.getAmount(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency()));
            entry.setLocalTax(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entry.getTax(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency()));
            entry.setLocalTaxAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entry.getTaxAmount(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency()));
        }
    }

    private void popEntryWithPrice(Context ctx, SaleOrderInfo saleOrderInfo, Map taxRateCache, Map pricePrecisionCache, int precision, boolean isContainTax) throws EASBizException, BOSException {
        for (int j = 0; j < saleOrderInfo.getEntries().size(); ++j) {
            SaleOrderEntryInfo entry = saleOrderInfo.getEntries().get(j);
            BigDecimal taxRate = this.findCurrentRate(entry, taxRateCache);
            int pricePrecision = this.findPricePrecision(entry, pricePrecisionCache);
            this.setEntryPriceWithTax(entry, entry.getPrice(), taxRate, pricePrecision, isContainTax);
            this.setAmountWithDiscount(entry, precision);
            this.setAmountWithTax(entry, precision, saleOrderInfo.isIsInTax());
            this.setActualPrice(entry, pricePrecision);
            saleOrderInfo.setTotalAmount(saleOrderInfo.getTotalAmount().add(entry.getAmount()));
            saleOrderInfo.setTotalTax(saleOrderInfo.getTotalTax().add(entry.getTax()));
            saleOrderInfo.setTotalTaxAmount(saleOrderInfo.getTotalTaxAmount().add(entry.getTaxAmount()));
            entry.setLocalAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entry.getAmount(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency()));
            entry.setLocalTax(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entry.getTax(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency()));
            entry.setLocalTaxAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entry.getTaxAmount(), (CompanyOrgUnitInfo)saleOrderInfo.getCompanyOrgUnit(), (CurrencyInfo)saleOrderInfo.getCurrency()));
        }
    }

    private SalePriceTO findPriceTO(SaleOrderEntryInfo entry, List priceTOs, String orgLongNumber) {
        for (int i = 0; i < priceTOs.size(); ++i) {
            SalePriceTO priceTO = PriceService.findPriceDTO((SalePriceTO)priceTOs.get(i), entry.getMaterial().getId().toString(), orgLongNumber, entry.getSaleOrgUnit());
            if (priceTO == null) continue;
            return priceTO;
        }
        return null;
    }

    private BigDecimal findCurrentRate(SaleOrderEntryInfo SOEntryInfo, Map taxRateCache) {
        BigDecimal taxRate = (BigDecimal)taxRateCache.get(SOEntryInfo.getMaterial().getId().toString() + SOEntryInfo.getSaleOrgUnit());
        if (taxRate == null) {
            taxRate = new BigDecimal(17);
        }
        if (taxRate.compareTo(ZERO) == 0) {
            taxRate = new BigDecimal(17);
        }
        return taxRate;
    }

    private int findPricePrecision(SaleOrderEntryInfo SOEntryInfo, Map pricePrecisionCache) {
        Integer pricePrecision = (Integer)pricePrecisionCache.get(SOEntryInfo.getMaterial().getId().toString() + SOEntryInfo.getSaleOrgUnit());
        if (pricePrecision == null) {
            pricePrecision = 0;
        }
        return pricePrecision;
    }

    private void setEntryPriceWithTax(SaleOrderEntryInfo SOEntryInfo, BigDecimal price, BigDecimal taxRate, int pricePrecision, boolean isContainTax) {
        BigDecimal taxPrice;
        BigDecimal bigDecimal = price = price == null ? ZERO : price;
        if (isContainTax) {
            taxPrice = price;
            price = taxPrice.divide(taxRate.divide(Hundred, 10, 6).add(ONE), 10, 6);
        } else {
            taxPrice = price.multiply(taxRate.divide(Hundred, 10, 6).add(ONE));
        }
        price.setScale(pricePrecision, 4);
        taxPrice.setScale(pricePrecision, 4);
        SOEntryInfo.setPrice(price);
        SOEntryInfo.setTaxPrice(taxPrice);
    }

    private void setAmountWithDiscount(SaleOrderEntryInfo entry, int precision) {
        BigDecimal qty;
        BigDecimal discountAmount = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        DiscountModeEnum mode = entry.getDiscountType();
        BigDecimal taxPrice = entry.getTaxPrice();
        BigDecimal discount = entry.getDiscount() == null ? ZERO : entry.getDiscount();
        BigDecimal bigDecimal = qty = entry.getQty() == null ? ZERO : entry.getQty();
        if (mode == null) {
            totalTaxAmount = qty.multiply(taxPrice);
        } else if (mode.equals((Object)DiscountModeEnum.PERCENT)) {
            discountAmount = taxPrice.multiply(discount).multiply(qty).divide(Hundred, 2, 6);
            totalTaxAmount = qty.multiply(taxPrice.multiply(ONE.subtract(discount.divide(Hundred, 10, 6))));
        } else {
            discountAmount = qty.multiply(discount);
            totalTaxAmount = qty.multiply(taxPrice.subtract(discount));
        }
        entry.setTaxAmount(totalTaxAmount.setScale(precision, 4));
        entry.setDiscountAmount(discountAmount.setScale(precision, 4));
    }

    private void setAmountWithTax(SaleOrderEntryInfo entry, int precision, boolean isInTax) {
        BigDecimal tax = ZERO;
        BigDecimal amount = ZERO;
        BigDecimal totalTaxAmount = entry.getTaxAmount() == null ? ONE : entry.getTaxAmount();
        BigDecimal taxRate = entry.getTaxRate() == null ? ZERO : entry.getTaxRate();
        BigDecimal taxRatePercent = taxRate.divide(Hundred, 10, 6);
        if (isInTax) {
            tax = totalTaxAmount.divide(taxRatePercent.add(ONE), 10, 6).multiply(taxRatePercent);
            amount = totalTaxAmount.subtract(tax);
        }
        entry.setTax(tax.setScale(precision, 4));
        entry.setAmount(amount.setScale(precision, 4));
    }

    private void setActualPrice(SaleOrderEntryInfo entry, int pricePrecisionCache) {
        BigDecimal totalTaxAmount = entry.getTaxAmount();
        BigDecimal amount = entry.getAmount();
        BigDecimal actualPrice = ZERO;
        BigDecimal actualTaxPrice = ZERO;
        BigDecimal qty = entry.getQty();
        actualTaxPrice = totalTaxAmount.divide(qty, pricePrecisionCache, 6);
        actualPrice = amount.divide(qty, pricePrecisionCache, 6);
        entry.setActualTaxPrice(actualTaxPrice);
        entry.setActualPrice(actualPrice);
    }

    private Map getCompanyOrgUnitCache(Context ctx, IObjectCollection saleOrders) throws BOSException {
        HashSet<String> fromUnitIDs = new HashSet<String>();
        for (int i = 0; i < saleOrders.size(); ++i) {
            for (int j = 0; j < ((SaleOrderInfo)saleOrders.getObject(i)).getEntries().size(); ++j) {
                fromUnitIDs.add(((SaleOrderInfo)saleOrders.getObject(i)).getEntries().get(j).getStorageOrgUnit().getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        view.getSelector().add(new SelectorItemInfo("fromUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", fromUnitIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(4), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        OrgUnitRelationCollection relCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        HashMap<String, CompanyOrgUnitInfo> companyOrgUnitCache = new HashMap<String, CompanyOrgUnitInfo>();
        for (int i = 0; i < relCol.size(); ++i) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(relCol.get(i).getToUnit().getId());
            companyOrgUnitCache.put(relCol.get(i).getFromUnit().getId().toString(), company);
        }
        return companyOrgUnitCache;
    }

    private void updateSaleOrders(Context ctx, IObjectCollection saleOrders) throws EASBizException, BOSException {
        CoreBaseCollection colBaseColl = new CoreBaseCollection();
        SaleOrderInfo saleOrderInfo = null;
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < saleOrders.size(); ++i) {
            saleOrderInfo = (SaleOrderInfo)saleOrders.getObject(i);
            iSaleOrder.submit((CoreBaseInfo)saleOrderInfo);
        }
    }

    private void synchronizeNetOrderBillMap(Map netOrderBillMap, Map netOrderBillEntryMap) {
        NetOrderBillInfo netOrderBillInfo2 = null;
        NetOrderBillEntryInfo netOrderBillEntryInfo = null;
        NetOrderBillEntryCollection netOrderBillEntryCollection = null;
        for (NetOrderBillInfo netOrderBillInfo2 : netOrderBillMap.values()) {
            netOrderBillEntryCollection = netOrderBillInfo2.getEntries();
            int length = netOrderBillEntryCollection.size();
            for (int index = 0; index < length; ++index) {
                netOrderBillEntryInfo = netOrderBillEntryCollection.get(index);
                if (!netOrderBillEntryMap.containsKey(netOrderBillEntryInfo.getId().toString())) continue;
                netOrderBillEntryInfo = (NetOrderBillEntryInfo)netOrderBillEntryMap.get(netOrderBillEntryInfo.getId().toString());
                netOrderBillEntryCollection.setObject(index, (IObjectValue)netOrderBillEntryInfo);
            }
        }
    }

    private void releaseLockInv(Context ctx, String entryIds, String saleOrgId) throws EASBizException, BOSException {
        IObjectPK[] entryObjectPK = new IObjectPK[]{new ObjectUuidPK(entryIds)};
        NetOrderFacadeFactory.getLocalInstance(ctx).unLockInventory(entryObjectPK, saleOrgId);
    }

    protected IObjectCollection getBillList(Context ctx, List bills, List entriesKey, String srcBillType, SelectorItemCollection botpSelectors) throws BOSException, RemoteException {
        NetOrderBillCollection collection = new NetOrderBillCollection();
        Iterator it = bills.iterator();
        while (it.hasNext()) {
            collection.add((NetOrderBillInfo)it.next());
        }
        if (entriesKey.size() > 0) {
            this.removeUnSelect(entriesKey, collection);
        }
        CoreBillBaseCollection sourceBillCollection = null;
        if (collection != null) {
            sourceBillCollection = new CoreBillBaseCollection();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                NetOrderBillInfo object = collection.get(i);
                sourceBillCollection.addObject((IObjectValue)object);
            }
        }
        return sourceBillCollection;
    }

    private void removeUnSelect(List entriesKey, NetOrderBillCollection sourceBillCollection) {
        int count = sourceBillCollection.size();
        for (int i = 0; i < count; ++i) {
            NetOrderBillInfo bills = sourceBillCollection.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get("entries");
            if (entries == null) {
                return;
            }
            Iterator iters = entries.iterator();
            while (iters.hasNext()) {
                CoreBaseInfo cInfo = (CoreBaseInfo)iters.next();
                if (entriesKey.contains(cInfo.get("id").toString()) && cInfo.getBigDecimal("approveQty") != null && cInfo.getBigDecimal("approveQty").compareTo(ZERO) >= 1) continue;
                iters.remove();
            }
            if (entries.size() != 0) continue;
            sourceBillCollection.remove(bills);
            count = sourceBillCollection.size();
            --i;
        }
    }

    private Map calDiscountAmount(DiscountModeEnum mode, BigDecimal taxPrice, BigDecimal discount, BigDecimal qty, boolean isInTax, BigDecimal taxRate, int precision, int materialPrecision) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> calAmount = new HashMap<String, BigDecimal>();
        BigDecimal discountAmount = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal tax = ZERO;
        BigDecimal amount = ZERO;
        BigDecimal actualPrice = ZERO;
        BigDecimal actualTaxPrice = ZERO;
        taxRate = taxRate.divide(Hundred, 10, 6);
        if (mode == null) {
            totalTaxAmount = qty.multiply(taxPrice);
        } else if (mode.equals((Object)DiscountModeEnum.PERCENT)) {
            discountAmount = taxPrice.multiply(discount).multiply(qty).divide(Hundred, 2, 6);
            totalTaxAmount = qty.multiply(taxPrice.multiply(ONE.subtract(discount.divide(Hundred, 10, 6))));
        } else {
            discountAmount = qty.multiply(discount);
            totalTaxAmount = qty.multiply(taxPrice.subtract(discount));
        }
        if (isInTax) {
            tax = totalTaxAmount.divide(ONE.add(taxRate), 10, 6).multiply(taxRate);
            amount = totalTaxAmount.subtract(tax);
        }
        actualTaxPrice = totalTaxAmount.divide(qty, materialPrecision, 6);
        actualPrice = amount.divide(qty, materialPrecision, 6);
        calAmount.put("discountAmount", discountAmount.setScale(precision, 4));
        calAmount.put("totalTaxAmount", totalTaxAmount.setScale(precision, 4));
        calAmount.put("tax", tax.setScale(precision, 4));
        calAmount.put("amount", amount.setScale(precision, 4));
        calAmount.put("actualTaxPrice", actualTaxPrice);
        calAmount.put("actualPrice", actualPrice);
        return calAmount;
    }

    public Date changeDate(Date date, int day) {
        Date needDate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, day);
        needDate = calendar.getTime();
        return needDate;
    }

    @Override
    protected IRowSet _getInventoryDetail(Context ctx, List materialIds, String queryType) throws BOSException {
        if (materialIds == null || materialIds.size() < 1) {
            return null;
        }
        StringBuffer materialIdSet = new StringBuffer();
        Iterator it = materialIds.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            Object id = it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                materialIdSet.append(",");
            }
            materialIdSet.append("'").append(id.toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        String warehouse = "null as warehouse,";
        String location = "null as location,";
        String lot = "null as lot,";
        String groupBy = " ";
        String orderBy = " ";
        String permStorageIds = null;
        try {
            permStorageIds = this.getPermissionStorage(ctx);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (queryType != null) {
            if (queryType.indexOf("a") != -1) {
                warehouse = "warehouse.fname_" + ctx.getLocale().getLanguage() + " as warehouse,";
                groupBy = groupBy + "warehouse.fname_" + ctx.getLocale().getLanguage() + ",";
                orderBy = orderBy + "warehouse.fname_" + ctx.getLocale().getLanguage() + ",";
            }
            if (queryType.indexOf("b") != -1) {
                location = "location.fname_" + ctx.getLocale().getLanguage() + " as location,";
                groupBy = groupBy + "location.fname_" + ctx.getLocale().getLanguage() + ",";
                orderBy = orderBy + "location.fname_" + ctx.getLocale().getLanguage() + ",";
            }
            if (queryType.indexOf("c") != -1) {
                lot = "case when inv.flot = 'YNi0IQEOEADgBT3mfwAAAcznrtQ=' then null else inv.flot end as lot,";
                groupBy = groupBy + "inv.flot,";
                orderBy = orderBy + "inv.flot,";
            }
        }
        if (orderBy != " ") {
            orderBy = orderBy.substring(1, orderBy.length() - 1);
        }
        sql.append(" select material.fid as materialId, material.fnumber as materialNumber,  material.fname_" + ctx.getLocale().getLanguage() + " as materialName, material.FModel as materialModel,storage.fname_" + ctx.getLocale().getLanguage() + " as storageOrg,").append(warehouse).append(location).append(lot).append("sum(inv.fbaseqty) as qty,measureunit.fname_" + ctx.getLocale().getLanguage() + "  as unit,measureunit.fid as unitId from t_im_inventory inv").append(" inner join t_bd_material material on inv.fmaterialid=material.fid ").append(" left outer join t_org_storage storage on inv.fstorageorgunitid=storage.fid").append(" left outer join  t_db_warehouse warehouse on inv.fwarehouseid=warehouse.fid ").append(" left outer join t_db_location location on inv.flocationid=location.fid ").append(" left outer join t_bd_measureunit measureunit on inv.fbaseunitid=measureunit.fid").append(" left outer join T_IM_STORESTATE storeState on inv.FStoreStatusID=storeState.fid").append(" left outer join T_IM_STORETYPE storeType on inv.fStoreTypeId=storeType.fid ").append(" where inv.fbaseqty<>0 and storeType.fnumber='G' and  material.fid in (").append(materialIdSet).append(") and storeState.fnumber='1' ");
        if (permStorageIds != null) {
            sql.append(" and storage.fid in  ");
            sql.append(permStorageIds);
        } else {
            sql.append(" and 1=2 ");
        }
        sql.append(" group by material.fid,material.fnumber,material.fname_" + ctx.getLocale().getLanguage() + ",material.FModel,storage.fname_" + ctx.getLocale().getLanguage() + ",").append(groupBy).append("measureunit.fname_" + ctx.getLocale().getLanguage() + ",measureunit.fid");
        if (orderBy != " ") {
            sql.append(" order by " + orderBy);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected Map _getInventoryQtyBase(Context ctx, List materialIds) throws BOSException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (materialIds == null || materialIds.size() < 1) {
            return null;
        }
        StringBuffer materialIdSet = new StringBuffer();
        Iterator it = materialIds.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            Object id = it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                materialIdSet.append(",");
            }
            materialIdSet.append("'").append(id.toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        String warehouse = "null as warehouse,";
        String location = "null as location,";
        String lot = "null as lot,";
        String groupBy = " ";
        String permStorageIds = null;
        try {
            permStorageIds = this.getPermissionStorage(ctx);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        sql.append(" select inv.fstorageorgunitid as fstorageorgunitid,measureunit.fid as funitid,material.fid as materialId, material.fnumber as materialNumber,").append("material.fname_" + ctx.getLocale().getLanguage() + " as materialName, material.FModel as materialModel,storage.fname_" + ctx.getLocale().getLanguage() + " as storageOrg,").append("null as warehouse,").append("null as location,").append("null as lot,").append("sum(inv.fbaseqty) as qty,measureunit.fname_" + ctx.getLocale().getLanguage() + "  as unit from t_im_inventory inv").append(" inner join t_bd_material material on inv.fmaterialid=material.fid ").append(" left outer join t_org_storage storage on inv.fstorageorgunitid=storage.fid").append(" left outer join  t_db_warehouse warehouse on inv.fwarehouseid=warehouse.fid ").append(" left outer join t_db_location location on inv.flocationid=location.fid ").append(" left outer join t_bd_measureunit measureunit on inv.fbaseunitid=measureunit.fid").append(" left outer join T_IM_STORESTATE storeState on inv.FStoreStatusID=storeState.fid").append(" left outer join T_IM_STORETYPE storeType on inv.fStoreTypeId=storeType.fid ").append(" where inv.fbaseqty<>0 and storeType.fnumber='G' and  material.fid in (").append(materialIdSet).append(") and storeState.fnumber='1' ");
        if (permStorageIds != null) {
            sql.append(" and storage.fid in  ");
            sql.append(permStorageIds);
        }
        sql.append(" group by material.fid,material.fnumber,material.fname_" + ctx.getLocale().getLanguage() + ",material.FModel,storage.fname_" + ctx.getLocale().getLanguage() + ",");
        sql.append(groupBy);
        sql.append("measureunit.fname_" + ctx.getLocale().getLanguage() + ",inv.fstorageorgunitid,measureunit.fid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() < 1) {
            return result;
        }
        try {
            while (rs.next()) {
                String storageID = rs.getString("fstorageorgunitid");
                String materialId = rs.getString("materialId");
                BigDecimal qty = rs.getBigDecimal("qty");
                result.put(storageID + materialId, qty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _assignInventory(Context ctx, Map assignMap) throws BOSException {
        if (assignMap == null || assignMap.size() < 1) {
            return;
        }
        Set keySet = assignMap.keySet();
        Iterator it = keySet.iterator();
        StringBuffer updateSql = new StringBuffer();
        while (it.hasNext()) {
            String entryId = it.next().toString();
            BigDecimal approveQty = (BigDecimal)assignMap.get(entryId);
            updateSql = new StringBuffer();
            updateSql = updateSql.append("update T_CHA_NetOrderBillEntry set FApproveQty = ?, FEntryStatus = 8 where fid = ?");
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{approveQty.toString(), entryId});
        }
    }

    @Override
    protected void _assignInventory(Context ctx, IObjectCollection entryCollection) throws BOSException {
        Object[] pks;
        if (entryCollection == null || entryCollection.size() < 1) {
            return;
        }
        StringBuffer billIdSet = new StringBuffer();
        boolean isFirst = true;
        StringBuffer updateSql = new StringBuffer("update T_CHA_NetOrderBillEntry set FApproveQty = ?, FApprovePrice = FPrice, FStorageOrgUnit = ?, FEntryStatus = ?,FWarehouseID = ?, FAskArriveDate = ?, FApproveAmount = ? where fid = ?");
        StringBuffer updateSqlNoWH = new StringBuffer("update T_CHA_NetOrderBillEntry set FApproveQty = ?, FApprovePrice = FPrice, FStorageOrgUnit = ?, FEntryStatus = ?,FWarehouseID = null, FAskArriveDate = ?, FApproveAmount = ? where fid = ?");
        INetOrderBill iNetOrderBill = NetOrderBillFactory.getLocalInstance(ctx);
        INetOrderBillEntry iNetOrderBillEntry = NetOrderBillEntryFactory.getLocalInstance(ctx);
        ArrayList<String> idList = new ArrayList<String>();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            if (entryCollection.getObject(i) == null || !(entryCollection.getObject(i) instanceof NetOrderBillEntryInfo) || ((NetOrderBillEntryInfo)entryCollection.getObject(i)).getId() == null) continue;
            idList.add(((NetOrderBillEntryInfo)entryCollection.getObject(i)).getId().toString());
        }
        pks = idList.size() > 0 ? (pks = idList.toArray()) : null;
        IRowSet rs = null;
        try {
            rs = CreditUpdateHelper.getPreUpdateData((Context)ctx, (Object[])pks);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        int size2 = entryCollection.size();
        for (int i = 0; i < size2; ++i) {
            NetOrderBillEntryInfo entry = (NetOrderBillEntryInfo)entryCollection.getObject(i);
            if (entry.getWarehouse() != null) {
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{entry.getApproveQty(), entry.getStorageOrgUnit().getId().toString(), new Integer(entry.getEntryStatus().getValue()), entry.getWarehouse().getId().toString(), entry.getAskArriveDate(), entry.getApproveAmount(), entry.getId().toString()});
            } else {
                DbUtil.execute((Context)ctx, (String)updateSqlNoWH.toString(), (Object[])new Object[]{entry.getApproveQty(), entry.getStorageOrgUnit() == null ? "" : entry.getStorageOrgUnit().getId().toString(), new Integer(entry.getEntryStatus().getValue()), entry.getAskArriveDate(), entry.getApproveAmount(), entry.getId().toString()});
            }
            if (isFirst) {
                isFirst = false;
            } else {
                billIdSet.append(",");
            }
            billIdSet.append("'").append(entry.getParent().getId().toString()).append("'");
        }
        if (pks != null && pks.length > 0) {
            try {
                CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(pks, rs, CreditOperationEnum.ALTER);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        updateSql.setLength(0);
        updateSql.append("update T_CHA_NetOrderBill set FBillStatus = 8 where fid in(").append(billIdSet).append(") and exists(select * from T_CHA_NetOrderBillEntry entry where entry.FParentID = T_CHA_NetOrderBill.fid and entry.FEntryStatus = 8)");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    @Override
    protected void _batchModify(Context ctx, Set entryIds, NetOrderBatchModifyFieldEnum fieldType, String data) throws BOSException {
        if (entryIds == null || entryIds.size() < 1) {
            return;
        }
        StringBuffer entryIdSet = new StringBuffer();
        boolean isFirst = true;
        Iterator it = entryIds.iterator();
        while (it.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                entryIdSet.append(",");
            }
            entryIdSet.append("'").append(it.next().toString()).append("'");
        }
        StringBuffer updateSql = new StringBuffer(" update T_CHA_NetOrderBillEntry ");
        if (NetOrderBatchModifyFieldEnum.STORAGEORG.equals((Object)fieldType)) {
            if (data != null && data.trim().length() > 0) {
                updateSql.append(" set FStorageOrgUnit = '" + data + "'");
            } else {
                updateSql.append(" set FStorageOrgUnit = null");
            }
        } else if (data != null && data.trim().length() > 0) {
            updateSql.append(" set FWarehouseID = '" + data + "'");
        } else {
            updateSql.append(" set FWarehouseID = null");
        }
        updateSql.append(" where fid in(").append(entryIdSet).append(") ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    @Override
    protected int _getTransadvday(Context ctx, String channelID, String saleOrgUnitId) throws BOSException, EASBizException {
        int transadvDay = 0;
        StringBuffer sql = new StringBuffer();
        Object[] params = new Object[2];
        sql.append(" SELECT FTRANSADVDAY  ");
        sql.append(" FROM T_BD_CustomerSaleInfo customerSaleInfo ");
        sql.append(" INNER JOIN T_BD_Customer customer ON customerSaleInfo.FCUSTOMERID = customer.FID ");
        sql.append(" INNER JOIN T_BD_ChannelBase channelBase ON customer.FID = channelBase.FCUSTOMERID");
        sql.append(" where channelBase.FID = ? and customerSaleInfo.FSaleOrgID = ? ");
        params[0] = channelID;
        params[1] = saleOrgUnitId;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        BigDecimal tempTransadvDay = SysConstant.BIGZERO;
        try {
            while (rowSet.next()) {
                tempTransadvDay = rowSet.getBigDecimal("FTRANSADVDAY");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (null != tempTransadvDay) {
            transadvDay = tempTransadvDay.intValue();
        }
        return transadvDay;
    }
}

