/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.scm.sd.channel.util.NullObjectUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.channel.ShoppingCartRecordCollection;
import com.kingdee.eas.scm.sd.channel.ShoppingCartRecordFactory;
import com.kingdee.eas.scm.sd.channel.app.AbstractNetOrderFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetOrderFacadeControllerBean
extends AbstractNetOrderFacadeControllerBean {
    private static final long serialVersionUID = 76266949629896109L;
    public static final String RES_NETORDERBILL_CLASS = "com.kingdee.eas.scm.sd.channel.NetOrderBillResource";
    private String sp = "\r\n";
    public static final String BILLID = "FBillID";
    public static final String BILLENTRYID = "FBillEntryID";
    public static final String INVENTORYID = "FInventoryID";
    public static final String BILLNUMBER = "FBillNumber";
    public static final String BILLTYPEID = "FBillTypeID";
    public static final String WAREHOUSEID = "FWarehouseID";
    public static final String LOCATIONID = "FLocationID";
    public static final String LOT = "Flot";
    public static final String STORETYPEID = "FStoreTypeID";
    public static final String STORESTATEID = "FStoreStateID";
    public static final String LOCKQTY = "FLockQty";
    public static final String LOCKBASEQTY = "FLockBaseQty";
    public static final String LOCKASSISTQTY = "FLockAssistQty";
    public static final String UNLOCKDATE = "FUnLockDate";

    @Override
    public void _lockInventory(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        NetOrderBillInfo billInfo = NetOrderBillFactory.getLocalInstance(ctx).getNetOrderBillInfo(pk);
        NetOrderBillEntryCollection entryInfoCollection = billInfo.getEntries();
        ArrayList maps = new ArrayList();
        for (int i = 0; i < entryInfoCollection.size(); ++i) {
            maps.addAll(this.getParamsMap(ctx, billInfo, entryInfoCollection.get(i)));
        }
        int size = maps.size();
        if (size < 1) {
            return;
        }
        HashMap[] hms = new HashMap[size];
        for (int i = 0; i < size; ++i) {
            hms[i] = (HashMap)maps.get(i);
        }
        IInventory ii = InventoryFactory.getLocalInstance((Context)ctx);
        ii.lockInventory(hms);
    }

    private final List getParamsMap(Context ctx, NetOrderBillInfo billInfo, NetOrderBillEntryInfo entryInfo) throws SQLDataException {
        BigDecimal orderBaseQty = entryInfo.getBaseQty();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT inv.FID as FID, inv.FWarehouseID as FWarehouseID, inv.FLocationID as FLocationID,").append(" inv.FLot as FLot, inv.FBaseQty as FBaseQty, inv.FUnitID as FUnitID, munit.FBaseConvsrate as FBaseConvsrate, munit.FQtyPrecision as FQtyPrecision ").append(this.sp).append(" FROM T_IM_Inventory as inv,T_BD_MultiMeasureUnit as munit ").append(this.sp).append(" where inv.FMaterialID = ? and inv.FStorageOrgUnitID = ? ").append(" and inv.FStoreTypeID= ? and inv.FStoreStatusID= ? and FBaseQty > 0 and inv.FUnitID = munit.FMeasureUnitID").append(" and inv.FMaterialID = munit.FmaterialID order by FLot asc,FBaseQty desc").append(this.sp);
        Connection con = this.getConnection(ctx);
        RptRowSet rs = null;
        SqlParams params = new SqlParams();
        params.addString(entryInfo.getMaterial().getId().toString());
        params.addString(entryInfo.getStorageOrgUnit().getId().toString());
        params.addString("181875d5-0105-1000-e000-0111c0a812fd97D461A6");
        params.addString("181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
        try {
            rs = DBUtil.executeQuery((String)sql.toString(), (SqlParams)params, (Connection)con);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(null, null, (Connection)con);
        }
        ArrayList maps = new ArrayList();
        while (rs.next()) {
            BigDecimal invQty = rs.getBigDecimal("FBaseQty");
            BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsrate");
            int qtyPrecision = rs.getInt("FQtyPrecision");
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put(BILLID, billInfo.getId().toString());
            hm.put(BILLNUMBER, billInfo.getNumber());
            hm.put(BILLTYPEID, "PQmB0qv6S02gx+xypWAQo8LWunc=");
            hm.put(STORETYPEID, "181875d5-0105-1000-e000-0111c0a812fd97D461A6");
            hm.put(STORESTATEID, "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
            hm.put(BILLENTRYID, entryInfo.getId().toString());
            hm.put(UNLOCKDATE, null);
            hm.put(INVENTORYID, rs.getString("FID"));
            hm.put(WAREHOUSEID, rs.getString(WAREHOUSEID));
            hm.put(LOCATIONID, rs.getString(LOCATIONID));
            hm.put(LOT, rs.getString("FLot"));
            if (orderBaseQty.compareTo(invQty) == 1 && invQty.compareTo(SysConstant.BIGZERO) == 1) {
                if (baseConvsRate.compareTo(new BigDecimal("1.0")) != 0) {
                    hm.put(LOCKQTY, invQty.divide(baseConvsRate, qtyPrecision, 6));
                } else {
                    hm.put(LOCKQTY, invQty);
                }
                hm.put(LOCKBASEQTY, invQty);
                orderBaseQty = orderBaseQty.subtract(invQty);
                hm.put(LOCKASSISTQTY, new BigDecimal("0.0"));
                maps.add(hm);
                continue;
            }
            if (baseConvsRate.compareTo(new BigDecimal("1.0")) != 0) {
                hm.put(LOCKQTY, orderBaseQty.divide(baseConvsRate, qtyPrecision, 6));
            } else {
                hm.put(LOCKQTY, orderBaseQty);
            }
            hm.put(LOCKBASEQTY, orderBaseQty);
            hm.put(LOCKASSISTQTY, new BigDecimal("0.0"));
            maps.add(hm);
            break;
        }
        return maps;
    }

    @Override
    protected void _unLockInventory(Context ctx, IObjectPK[] entryPks, String saleOrgId) throws BOSException, EASBizException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(saleOrgId), (String)"NETORDERLOCKEDINV");
        if (Boolean.valueOf(paramValue).booleanValue()) {
            this.query(ctx, entryPks, saleOrgId);
        }
    }

    private void query(Context ctx, IObjectPK[] entryPks, String saleOrgId) throws BOSException, EASBizException {
        String entryIDs = this.makeEntryIDsBy(entryPks);
        String sql = "select fbillentryid, FInventoryID, FLockQty, FLockBaseQty, FLockAssistQty from T_IM_LockInventory where fbillentryid in(" + entryIDs + ")";
        JdbcRowSet rs = (JdbcRowSet)DbUtil.executeQuery((Context)ctx, (String)sql);
        int size = rs.size();
        if (size > 0) {
            HashMap[] params = new HashMap[size];
            int i = 0;
            try {
                while (rs.next()) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put(BILLENTRYID, rs.getString("fbillentryid"));
                    param.put(INVENTORYID, rs.getString(INVENTORYID));
                    param.put(LOCKQTY, rs.getBigDecimal(LOCKQTY));
                    param.put(LOCKBASEQTY, rs.getBigDecimal(LOCKBASEQTY));
                    param.put(LOCKASSISTQTY, rs.getBigDecimal(LOCKASSISTQTY));
                    params[i] = param;
                    ++i;
                }
            }
            catch (SQLException e) {
                e.setNextException(new SQLException("SQL: " + sql));
                throw new SQLDataException(e);
            }
            this._unLockInventory(ctx, params, saleOrgId);
        }
    }

    private String makeEntryIDsBy(IObjectPK[] entryPks) {
        StringBuffer entryIDs = new StringBuffer();
        for (int i = 0; i < entryPks.length; ++i) {
            if (i == 0) {
                entryIDs.append("'").append(entryPks[i].toString()).append("'");
                continue;
            }
            entryIDs.append(",").append("'").append(entryPks[i].toString()).append("'");
        }
        return entryIDs.toString();
    }

    @Override
    protected void _unLockInventory(Context ctx, HashMap[] params, String saleOrgId) throws BOSException, EASBizException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(saleOrgId), (String)"NETORDERLOCKEDINV");
        if (!Boolean.valueOf(paramValue).booleanValue()) {
            return;
        }
        if (params == null || params.length <= 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement psDelete = null;
        PreparedStatement psUpdate = null;
        int recs = params.length;
        if (recs > 0) {
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(" DELETE T_IM_LockInventory WHERE FBillEntryID = ? AND FInventoryID = ?;");
                psDelete = conn.prepareStatement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                stringBuffer.append(" UPDATE T_IM_Inventory SET");
                stringBuffer.append(" FCurStoreQty = FCurStoreQty + ?,");
                stringBuffer.append(" FBaseQty = FBaseQty + ?,");
                stringBuffer.append(" FCurStoreAssistQty = FCurStoreAssistQty + ?,");
                stringBuffer.append(" FLockQTy = FLockQTy - ?,");
                stringBuffer.append(" FLockBaseQty = FLockBaseQty - ?,");
                stringBuffer.append(" FLockAssistQty = FLockAssistQty - ?");
                stringBuffer.append(" WHERE FID = ?;");
                psUpdate = conn.prepareStatement(stringBuffer.toString());
                BigDecimal assistQty = SysConstant.BIGZERO;
                for (int i = 0; i < recs; ++i) {
                    if (params[i].get(LOCKASSISTQTY) != null) {
                        assistQty = (BigDecimal)params[i].get(LOCKASSISTQTY);
                    }
                    psDelete.setString(1, params[i].get(BILLENTRYID).toString());
                    psDelete.setString(2, params[i].get(INVENTORYID).toString());
                    psUpdate.setBigDecimal(1, (BigDecimal)params[i].get(LOCKQTY));
                    psUpdate.setBigDecimal(2, (BigDecimal)params[i].get(LOCKBASEQTY));
                    psUpdate.setBigDecimal(3, assistQty);
                    psUpdate.setBigDecimal(4, (BigDecimal)params[i].get(LOCKQTY));
                    psUpdate.setBigDecimal(5, (BigDecimal)params[i].get(LOCKBASEQTY));
                    psUpdate.setBigDecimal(6, assistQty);
                    psUpdate.setString(7, params[i].get(INVENTORYID).toString());
                    psDelete.addBatch();
                    psUpdate.addBatch();
                }
                psDelete.executeBatch();
                psUpdate.executeBatch();
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(psUpdate);
                    SQLUtils.cleanup(psDelete, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)psUpdate);
            SQLUtils.cleanup((Statement)psDelete, (Connection)conn);
        }
    }

    @Override
    protected BigDecimal _getInvQty(Context ctx, IObjectValue entryInfo) throws BOSException, EASBizException {
        NetOrderBillEntryInfo info = (NetOrderBillEntryInfo)entryInfo;
        return this.getInvQty(ctx, info.getMaterial().getId().toString(), info.getStorageOrgUnit().getId().toString());
    }

    @Override
    protected BigDecimal _getInvQty(Context ctx, String materialID, String storageOrgId) throws BOSException, EASBizException {
        IRowSet rs = this.getInvQtySet(ctx, materialID, storageOrgId);
        BigDecimal invQty = SysConstant.BIGZERO;
        try {
            while (rs.next()) {
                invQty = rs.getBigDecimal("FBaseQty");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return invQty;
    }

    @Override
    protected IRowSet _getInvQtySet(Context ctx, String materialIds, String storageOrgId) throws BOSException, EASBizException {
        String[] idArray = null;
        if (materialIds == null) {
            return null;
        }
        idArray = materialIds.split(",");
        if (idArray == null) {
            return null;
        }
        int length = idArray.length;
        StringBuffer sql = new StringBuffer();
        Object[] params = new Object[length + 3];
        sql.append(" SELECT sum(FBaseQty) as FBaseQty,FMaterialID FROM T_IM_Inventory ").append(this.sp).append(" where FMaterialID in (");
        for (int i = 0; i < length; ++i) {
            params[i] = idArray[i];
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") and FStorageOrgUnitID = ? ").append(this.sp).append(" and FStoreTypeID= ? and FStoreStatusID= ? group by FMaterialID,FStorageOrgUnitID").append(this.sp);
        params[length] = storageOrgId;
        params[length + 1] = "181875d5-0105-1000-e000-0111c0a812fd97D461A6";
        params[length + 2] = "181875d5-0105-1000-e000-012ec0a812fd62A73FA5";
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    @Override
    protected Set _getSaleOrgIdsInShoppingCart(Context ctx, String channelId) throws BOSException {
        HashSet<String> saleOrgIds = null;
        if (!StringUtil.isEmpty((String)channelId)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add(new SelectorItemInfo("saleOrgUnit.id"));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("channel.id", (Object)channelId));
            ShoppingCartRecordCollection col = ShoppingCartRecordFactory.getLocalInstance(ctx).getShoppingCartRecordCollection(view);
            saleOrgIds = new HashSet<String>(col.size());
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                saleOrgIds.add(col.get(i).getSaleOrgUnit().getId().toString());
            }
        }
        return NullObjectUtil.getNoNullSet(saleOrgIds);
    }

    @Override
    protected Map _getTransadvday(Context ctx, String customerId) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> tempMap = new HashMap<String, BigDecimal>(10);
        StringBuffer sql = new StringBuffer();
        Object[] params = new Object[1];
        sql.append(" select FSALEORGID ,FTRANSADVDAY from T_BD_CustomerSaleInfo");
        sql.append(" where fcustomerid = ? ");
        params[0] = customerId;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        String tempSaleOrgId = null;
        BigDecimal tempTransadvDay = SysConstant.BIGZERO;
        try {
            while (rowSet.next()) {
                tempSaleOrgId = rowSet.getString("FSALEORGID");
                tempTransadvDay = rowSet.getBigDecimal("FTRANSADVDAY");
                if (null == tempSaleOrgId || null == tempTransadvDay) continue;
                tempMap.put(tempSaleOrgId, tempTransadvDay);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return tempMap;
    }
}

