/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class NetOrderStalkDetailImport
extends AbstractDataTransmission {
    NetOrderBillInfo netOrderBillInfo = null;
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    Locale local = new Locale("l2");
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntries_qty", "FEntries_price", "FEntries_amount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"qty", "price", "amount"};

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return NetOrderBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    private NetOrderBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        return null;
    }

    private void handleEntry(NetOrderBillEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FAuditTime", rs.getString("auditTime"));
            this.putTable(result, "FMaterial_number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_name", rs.getString("material.name"));
            this.putTable(result, "FMaterial_model", rs.getString("material.model"));
            String qtyPrecision = rs.getString("multiMeasureUnit.qtyPrecision");
            int _qtyPrecision = qtyPrecision != null ? Integer.parseInt(qtyPrecision) : 2;
            int currencyPrecision = 2;
            try {
                currencyPrecision = Integer.parseInt(rs.getString("currency.precision"));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            int pricePrecision = 2;
            try {
                pricePrecision = Integer.parseInt(rs.getString("entries.pricePrecision"));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            this.putTable(result, "FStorageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FWarehouse_name", rs.getString("Warehouse.name"));
            this.putTable(result, "FSaleOrderEntry_totalIssueQty", this.dealPrecisioin(rs.getBigDecimal("saleOrderEntry.totalIssueQty"), _qtyPrecision));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FEntries_qty", this.dealPrecisioin(rs.getBigDecimal("entries.qty"), _qtyPrecision));
            this.putTable(result, "FEntries_seq", rs.getString("entries.seq"));
            this.putTable(result, "FSaleOrderEntry_taxAmount", rs.getString("saleOrderEntry.taxAmount"));
            this.putTable(result, "FSaleOrderEntry_actualTaxPrice", this.dealPrecisioin(rs.getBigDecimal("saleOrderEntry.actualTaxPrice"), pricePrecision));
            this.putTable(result, "FSaleEntry_totalShippingQty", this.dealPrecisioin(rs.getBigDecimal("saleEntry.totalShippingQty"), _qtyPrecision));
            this.putTable(result, "FUnit_name", rs.getString("unit.name"));
            this.putTable(result, "FSaleOrderEntry_qty", this.dealPrecisioin(rs.getBigDecimal("saleOrderEntry.qty"), _qtyPrecision));
            BigDecimal confirmQty = rs.getBigDecimal("saleIssueEntry.confirmQty");
            String postRequisition = rs.getString("postRequisitionEntry.baseStatus");
            String saleIssueStatus = rs.getString("saleIssueBill.baseStatus");
            String netOrderBillEntryStatus = rs.getString("entries.entryStatus");
            String saleOrderEntryStatus = rs.getString("SaleOrderEntry.baseStatus");
            String baseStatus = null;
            if (confirmQty != null) {
                if (confirmQty.compareTo(new BigDecimal("0.00")) > 0) {
                    baseStatus = this.getChannelImportResource("CONFIRM");
                }
            } else {
                baseStatus = saleIssueStatus != null && "4".equals(saleIssueStatus) ? this.getChannelImportResource("HASCONSIGNMENT") : (saleIssueStatus != null && Integer.parseInt(saleIssueStatus) < 4 ? this.getChannelImportResource("CONSIGNMENTING") : (postRequisition != null && "4".equals(postRequisition) ? this.getChannelImportResource("CONSIGNMENTING") : (saleOrderEntryStatus != null && "4".equals(saleOrderEntryStatus) ? this.getChannelImportResource("CONSIGNMENTING") : (saleIssueStatus != null && Integer.parseInt(saleIssueStatus) < 4 ? this.getChannelImportResource("CONSIGNMENTING") : ("9".equals(netOrderBillEntryStatus) && saleOrderEntryStatus == null && saleIssueStatus == null || "9".equals(netOrderBillEntryStatus) && (saleOrderEntryStatus == null || "7".equals(saleOrderEntryStatus)) || "9".equals(netOrderBillEntryStatus) && saleOrderEntryStatus != null && "4".equals(saleOrderEntryStatus) && (saleIssueStatus == null || "7".equals(saleIssueStatus)) ? this.getChannelImportResource("HASCANCEL") : ("4".equals(netOrderBillEntryStatus) ? this.getChannelImportResource("HASSUBMIT") : this.getChannelImportResource("BILLDEALING")))))));
            }
            this.putTable(result, "FEntries_entryStatus", baseStatus);
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private String dealPrecisioin(BigDecimal number, int precision) {
        if (number != null && number.toString().indexOf("0E") != -1) {
            number = ZERO.setScale(precision);
        } else if (number != null) {
            number = number.setScale(precision, 4);
        }
        return number != null ? number.toString() : null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.NetOrderStalkQuery";
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }
}

