/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.UpdataStorageEnum;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelBillProperyInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class ReportBaseStrategy {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ReportBaseStrategy");
    protected IObjectValue channelBillInfo;
    protected SaleChannelBillProperyInfo channelInventoryInfo;
    protected BizActionEnum actionEnum;
    private static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal("0");
    protected Context ctx;
    protected Map updateMaterialQty = null;
    protected Map updateMaterialBaseQty = null;
    protected Map updateMaterialAssistQty = null;
    protected Map updateMaterialUnit = null;
    protected Map updateMaterialAssistUnit = null;
    protected Map updateMaterialBaseUnit = null;
    protected Map updateMaterial = null;
    protected Map updateExpiryDate = null;
    protected Map updateProduceDate = null;
    protected Map updateSaleOrgUnit = null;
    protected Map updateSaleOrgUnitByEntryId = null;
    protected Map params = null;

    public void updateInventory() throws Exception {
        this.initMaterialQty();
        if (BizActionEnum.AUDIT.equals((Object)this.actionEnum)) {
            this.updateInventoryByAudit();
            this.insertHistoryUpdate();
        }
        if (BizActionEnum.UNAUDIT.equals((Object)this.actionEnum)) {
            this.updateInventoryByUnAudit();
            this.deleteHistoryUpdate();
        }
    }

    private void initMaterialQty() throws Exception {
        ChannelBaseInfo channelBaseInfo = (ChannelBaseInfo)this.params.get(this.channelInventoryInfo.getChannelProperty());
        boolean isUpdateStorageByAssistPorperty = false;
        if (channelBaseInfo.getIsUpdataStorage().equals((Object)UpdataStorageEnum.YES)) {
            isUpdateStorageByAssistPorperty = true;
        }
        this.updateMaterialBaseQty = new HashMap();
        this.updateMaterialQty = new HashMap();
        this.updateMaterialAssistQty = new HashMap();
        this.updateMaterialUnit = new HashMap();
        this.updateMaterialAssistUnit = new HashMap();
        this.updateMaterialBaseUnit = new HashMap();
        this.updateMaterial = new HashMap();
        this.updateExpiryDate = new HashMap();
        this.updateProduceDate = new HashMap();
        this.updateSaleOrgUnit = new HashMap();
        this.updateSaleOrgUnitByEntryId = new HashMap();
        String billId = this.channelBillInfo.get("id").toString();
        AbstractObjectCollection entryCollection = (AbstractObjectCollection)this.channelBillInfo.get(this.channelInventoryInfo.getEntrysProperty());
        BigDecimal baseQty = null;
        BigDecimal assistQty = null;
        String materialId = null;
        StringBuffer entriesId = new StringBuffer();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                entriesId.append(",");
            }
            entriesId.append("'").append(entryCollection.getObject(i).get("id").toString()).append("'");
        }
        Map mapBillId = this.getHistoryUpdateInventroy(this.ctx, billId);
        int c = entryCollection.size();
        for (int i = 0; i < c; ++i) {
            String billEntryId = entryCollection.getObject(i).get("id").toString();
            baseQty = (BigDecimal)entryCollection.getObject(i).get(this.channelInventoryInfo.getBaseQtyProperty());
            assistQty = (BigDecimal)entryCollection.getObject(i).get(this.channelInventoryInfo.getAssistQtyProperty());
            String baseUnitId = ((MeasureUnitInfo)entryCollection.getObject(i).get(this.channelInventoryInfo.getBaseUnitProperty())).getId().toString();
            String assistUnitId = null;
            if (entryCollection.getObject(i).get(this.channelInventoryInfo.getAssistUnitProperty()) instanceof MeasureUnitInfo) {
                assistUnitId = ((MeasureUnitInfo)entryCollection.getObject(i).get(this.channelInventoryInfo.getAssistUnitProperty())).getId().toString();
            }
            Date expiryDate = (Date)entryCollection.getObject(i).get(this.channelInventoryInfo.getExpiryDateProperty());
            Date produceDate = (Date)entryCollection.getObject(i).get(this.channelInventoryInfo.getProduceDateProperty());
            String key = null;
            String lot = "";
            if (entryCollection.getObject(i).get(this.channelInventoryInfo.getLotProperty()) != null) {
                lot = entryCollection.getObject(i).get(this.channelInventoryInfo.getLotProperty()).toString();
            }
            key = isUpdateStorageByAssistPorperty ? (entryCollection.getObject(i).get(this.channelInventoryInfo.getAssistProperty()) instanceof AsstAttrValueInfo ? ((MaterialInfo)entryCollection.getObject(i).get(this.channelInventoryInfo.getMaterialProperty())).getId().toString() + "#" + ((AsstAttrValueInfo)entryCollection.getObject(i).get(this.channelInventoryInfo.getAssistProperty())).getId().toString() + "#" + lot : ((MaterialInfo)entryCollection.getObject(i).get(this.channelInventoryInfo.getMaterialProperty())).getId().toString() + "#" + null + "#" + lot) : ((MaterialInfo)entryCollection.getObject(i).get(this.channelInventoryInfo.getMaterialProperty())).getId().toString();
            materialId = ((MaterialInfo)entryCollection.getObject(i).get(this.channelInventoryInfo.getMaterialProperty())).getId().toString();
            if (this.updateMaterialBaseQty.containsKey(key)) {
                baseQty = baseQty.add((BigDecimal)this.updateMaterialBaseQty.get(key));
                if (assistQty == null) {
                    if (this.updateMaterialAssistQty.get(key) != null) {
                        assistQty = (BigDecimal)this.updateMaterialAssistQty.get(key);
                    }
                } else if (this.updateMaterialAssistQty.get(key) != null) {
                    assistQty = assistQty.add((BigDecimal)this.updateMaterialAssistQty.get(key));
                }
                this.updateMaterialBaseQty.put(key, baseQty);
                this.updateMaterialAssistQty.put(key, assistQty);
            } else {
                this.updateMaterialBaseQty.put(key, baseQty);
                this.updateMaterialAssistQty.put(key, assistQty);
                this.updateMaterialBaseUnit.put(key, baseUnitId);
                this.updateMaterialAssistUnit.put(key, assistUnitId);
                this.updateExpiryDate.put(key, expiryDate);
                this.updateProduceDate.put(key, produceDate);
                this.updateMaterial.put(key, materialId);
            }
            String saleOrgUnitId = null;
            saleOrgUnitId = this.channelInventoryInfo.getBosType().equals("E79987D5") ? (entryCollection.getObject(i).get("fromSaleOrgUnit") != null ? ((SaleOrgUnitInfo)entryCollection.getObject(i).get("fromSaleOrgUnit")).getId().toString() : (mapBillId.get(billEntryId) != null ? (String)mapBillId.get(billEntryId) : ((SaleOrgUnitInfo)this.channelBillInfo.get(this.channelInventoryInfo.getSaleOrgProperty())).getId().toString())) : ((SaleOrgUnitInfo)this.channelBillInfo.get(this.channelInventoryInfo.getSaleOrgProperty())).getId().toString();
            this.updateSaleOrgUnit.put(materialId, saleOrgUnitId);
            this.updateSaleOrgUnitByEntryId.put(billEntryId, saleOrgUnitId);
        }
        Object[] baseQtyKey = this.updateMaterialBaseQty.keySet().toArray();
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        int c2 = baseQtyKey.length;
        for (int i = 0; i < c2; ++i) {
            this.updateMaterialQty.put(baseQtyKey[i].toString(), (BigDecimal)this.updateMaterialBaseQty.get(baseQtyKey[i].toString()));
            this.updateMaterialUnit.put(baseQtyKey[i].toString(), this.updateMaterialBaseUnit.get(baseQtyKey[i].toString()).toString());
        }
        if (this.channelInventoryInfo.getBosType().equals("E79987D5")) {
            BigDecimal minus = new BigDecimal("-1");
            Object[] key = this.updateMaterialBaseQty.keySet().toArray();
            int c3 = key.length;
            for (int i = 0; i < c3; ++i) {
                this.updateMaterialBaseQty.put(key[i], ((BigDecimal)this.updateMaterialBaseQty.get(key[i])).multiply(minus));
                this.updateMaterialQty.put(key[i], ((BigDecimal)this.updateMaterialQty.get(key[i])).multiply(minus));
                if (this.updateMaterialAssistQty.get(key[i]) == null) continue;
                this.updateMaterialAssistQty.put(key[i], ((BigDecimal)this.updateMaterialAssistQty.get(key[i])).multiply(minus));
            }
        }
    }

    private Map getHistoryUpdateInventroy(Context ctx, String billId) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.channelInventoryInfo.getBosType().equals("E79987D5")) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FSALEORGUNITID, FSALECHANNELID, FBILLID, FBILLENTRYID from T_SD_HisChannelInventory WHERE FBILLID = ?");
            try {
                IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId});
                if (rowSet != null) {
                    while (rowSet.next()) {
                        String saleOrgUnitId = rowSet.getString("FSALEORGUNITID");
                        String billEntryId = rowSet.getString("FBILLENTRYID");
                        map.put(billEntryId, saleOrgUnitId);
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return map;
    }

    private void insertHistoryUpdate() throws Exception {
        if (!this.channelInventoryInfo.getBosType().equals("E79987D5")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        String billId = this.channelBillInfo.get("id").toString();
        String channelId = ((ChannelBaseInfo)this.channelBillInfo.get(this.channelInventoryInfo.getChannelProperty())).getId().toString();
        AbstractObjectCollection entryCollection = (AbstractObjectCollection)this.channelBillInfo.get(this.channelInventoryInfo.getEntrysProperty());
        ArrayList<String> sqls = new ArrayList<String>();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            String billEntryId = entryCollection.getObject(i).get("id").toString();
            String saleOrgUnitId = (String)this.updateSaleOrgUnitByEntryId.get(billEntryId);
            sql = new StringBuffer();
            sql.append("INSERT INTO T_SD_HisChannelInventory(FSALEORGUNITID, FSALECHANNELID, FBILLID, FBILLENTRYID) VALUES(");
            sql.append(" '").append(saleOrgUnitId).append("'").append(",");
            sql.append(" '").append(channelId).append("'").append(",");
            sql.append(" '").append(billId).append("'").append(",");
            sql.append(" '").append(billEntryId).append("'");
            sql.append(")");
            sqls.add(sql.toString());
        }
        if (sqls.size() > 0) {
            DBUtil.executeBatch((Context)this.ctx, (String[])sqls.toArray(new String[sqls.size()]));
        }
    }

    private void deleteHistoryUpdate() throws Exception {
        if (!this.channelInventoryInfo.getBosType().equals("E79987D5")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        String billId = this.channelBillInfo.get("id").toString();
        sql.append("DELETE FROM T_SD_HisChannelInventory WHERE FBILLID = '").append(billId).append("'");
        DBUtil.executeUpdate((Context)this.ctx, (String)sql.toString(), null);
    }

    protected abstract void updateInventoryByUnAudit() throws Exception;

    protected abstract void updateInventoryByAudit() throws Exception;

    private BigDecimal caculateQty(String materialId, String unitId, String otherUnitId, BigDecimal qty) throws Exception {
        BigDecimal targetQty = null;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialId, unitId);
        MultiMeasureUnitInfo otherMultiUnifInfo = multiUnit.getMultiUnit(materialId, otherUnitId);
        if (multiUnifInfo != null && otherMultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = otherMultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            targetQty = baseQty.divide(baseExchangeRate2, otherMultiUnifInfo.getQtyPrecision(), 4);
        }
        return targetQty;
    }

    protected String getCheckUpdateStorageSql(boolean isUpdateStorageByAssistPorperty, boolean isvalidateQty) {
        int i;
        StringBuffer buffer = new StringBuffer();
        Object[] materialKey = this.updateMaterial.keySet().toArray();
        Object[] saleOrgUnitIds = this.updateSaleOrgUnit.values().toArray();
        StringBuffer materialParams = new StringBuffer();
        StringBuffer assitPropertyParams = new StringBuffer();
        StringBuffer lotParams = new StringBuffer();
        StringBuffer saleOrgUnitParams = new StringBuffer();
        int c = materialKey.length;
        for (i = 0; i < c; ++i) {
            if (materialParams.length() > 1) {
                materialParams.append(",");
            }
            if (assitPropertyParams.length() > 1) {
                assitPropertyParams.append(",");
            }
            String[] keyvalues = materialKey[i].toString().split("#");
            materialParams.append("'").append(keyvalues[0]).append("'");
            if (keyvalues.length > 1 && keyvalues[1] != null) {
                assitPropertyParams.append("'").append(keyvalues[1]).append("'");
            }
            if (keyvalues.length <= 2 || keyvalues[2] == null) continue;
            if (lotParams.length() > 1) {
                lotParams.append(",");
            }
            lotParams.append("'").append(keyvalues[2]).append("'");
        }
        int length = saleOrgUnitIds.length;
        for (i = 0; i < length; ++i) {
            if (i > 0) {
                saleOrgUnitParams.append(",");
            }
            saleOrgUnitParams.append("'").append(saleOrgUnitIds[i]).append("'");
        }
        String channelId = ((ChannelBaseInfo)this.channelBillInfo.get(this.channelInventoryInfo.getChannelProperty())).getId().toString();
        if (isvalidateQty) {
            buffer.append(" select channelInv.fid,material.FName_").append(this.ctx.getLocale().toString()).append(" materialname ").append(" from T_SD_ChannelInventory channelInv").append(" inner join T_BD_Material material on material.fid = channelInv.FMaterialID ").append(" where channelInv.FSaleOrgUnitID in (").append(saleOrgUnitParams.toString()).append(") ").append(" and channelInv.FSaleChannelID = '").append(channelId).append("'").append(" and channelInv.FMaterialID in(").append(materialParams.toString()).append(")");
            if (isUpdateStorageByAssistPorperty) {
                if (assitPropertyParams.length() == 0 && lotParams.length() == 0) {
                    buffer.append(" and channelInv.FAssistPropertyID is null and channelInv.FLot is null ");
                } else if (assitPropertyParams.length() > 0 && lotParams.length() == 0) {
                    buffer.append(" and (channelInv.FAssistPropertyID in(").append(assitPropertyParams.toString()).append(")").append(" or channelInv.FAssistPropertyID is null) and channelInv.FLot is null ");
                } else if (assitPropertyParams.length() == 0 && lotParams.length() > 0) {
                    buffer.append(" and channelInv.FAssistPropertyID is null and (channelInv.FLot in(").append(lotParams.toString()).append(")").append(" or channelInv.FLot is null)");
                } else {
                    buffer.append(" and (channelInv.FAssistPropertyID in(").append(assitPropertyParams.toString()).append(") or channelInv.FAssistPropertyID is null) and (channelInv.FLot in(").append(lotParams.toString()).append(") or channelInv.FLot is null)");
                }
            }
            buffer.append(" and (channelInv.FQty <0 or channelInv.FBaseQty <0)");
        } else {
            buffer.append(" select fid,FMaterialID,FAssistPropertyID,FLot,FStorageDate ").append(" from ").append(" T_SD_ChannelInventory ").append(" where FSaleOrgUnitID in (").append(saleOrgUnitParams.toString()).append(")").append(" and ").append("  FSaleChannelID = '").append(channelId).append("'").append("  and FMaterialID in(").append(materialParams.toString()).append(")");
            if (isUpdateStorageByAssistPorperty) {
                if (assitPropertyParams.length() == 0 && lotParams.length() == 0) {
                    buffer.append(" and FAssistPropertyID is null and FLot is null ");
                } else if (assitPropertyParams.length() > 0 && lotParams.length() == 0) {
                    buffer.append(" and (FAssistPropertyID in(").append(assitPropertyParams.toString()).append(")").append(" or FAssistPropertyID is null) and FLot is null ");
                } else if (assitPropertyParams.length() == 0 && lotParams.length() > 0) {
                    buffer.append(" and FAssistPropertyID is null and (FLot in(").append(lotParams.toString()).append(") or FLot is null)");
                } else {
                    buffer.append(" and (FAssistPropertyID in(").append(assitPropertyParams.toString()).append(")").append(" or FAssistPropertyID is null) and (FLot in(").append(lotParams.toString()).append(") or FLot is null)");
                }
            }
        }
        return buffer.toString();
    }

    protected String getDeleteStorageSql(boolean isUpdateStorageByAssistPorperty, Set deleteMaterial) {
        StringBuffer buffer = new StringBuffer();
        Object[] materialKey = deleteMaterial.toArray();
        StringBuffer materialParams = new StringBuffer();
        StringBuffer assitPropertyParams = new StringBuffer();
        StringBuffer lotParams = new StringBuffer();
        int c = materialKey.length;
        for (int i = 0; i < c; ++i) {
            if (materialParams.length() > 1) {
                materialParams.append(",");
            }
            if (assitPropertyParams.length() > 1) {
                assitPropertyParams.append(",");
            }
            String[] keyvalues = materialKey[i].toString().split("#");
            materialParams.append("'").append(keyvalues[0]).append("'");
            if (keyvalues.length > 1 && keyvalues[1] != null) {
                assitPropertyParams.append("'").append(keyvalues[1]).append("'");
            }
            if (keyvalues.length <= 2 || keyvalues[2] == null) continue;
            if (lotParams.length() > 1) {
                lotParams.append(",");
            }
            lotParams.append("'").append(keyvalues[2]).append("'");
        }
        String saleOrgId = ((SaleOrgUnitInfo)this.channelBillInfo.get(this.channelInventoryInfo.getSaleOrgProperty())).getId().toString();
        String channelId = ((ChannelBaseInfo)this.channelBillInfo.get(this.channelInventoryInfo.getChannelProperty())).getId().toString();
        buffer.append(" delete T_SD_ChannelInventory ").append(" where FSaleOrgUnitID= '").append(saleOrgId).append("' and ").append("  FSaleChannelID = '").append(channelId).append("'").append("  and FMaterialID in(").append(materialParams.toString()).append(")");
        if (isUpdateStorageByAssistPorperty) {
            if (assitPropertyParams.length() == 0 && lotParams.length() == 0) {
                buffer.append(" and FAssistPropertyID is null and FLot is null ");
            } else if (assitPropertyParams.length() > 0 && lotParams.length() == 0) {
                buffer.append(" and (FAssistPropertyID in(").append(assitPropertyParams.toString()).append(") or FAssistPropertyID is null) and FLot is null ");
            } else if (assitPropertyParams.length() == 0 && lotParams.length() > 0) {
                buffer.append(" and FAssistPropertyID is null and (FLot in(").append(lotParams.toString()).append(") or FLot is null)");
            } else {
                buffer.append(" and (FAssistPropertyID in(").append(assitPropertyParams.toString()).append(") or FAssistPropertyID is null) and (FLot in(").append(lotParams.toString()).append(") or FLot is null)");
            }
        }
        return buffer.toString();
    }

    protected AbstractObjectCollection getLastBillInfoWithInfoByInventoryDate(boolean isUpdateStorageByAssistPorperty, Set material) throws Exception {
        Object[] materialKey = material.toArray();
        StringBuffer materialParams = new StringBuffer();
        StringBuffer assitPropertyParams = new StringBuffer();
        StringBuffer lotParams = new StringBuffer();
        int c = materialKey.length;
        for (int i = 0; i < c; ++i) {
            if (materialParams.length() > 1) {
                materialParams.append(",");
            }
            if (assitPropertyParams.length() > 1) {
                assitPropertyParams.append(",");
            }
            if (lotParams.length() > 1) {
                lotParams.append(",");
            }
            String[] keyvalues = materialKey[i].toString().split("#");
            materialParams.append(keyvalues[0]);
            if (keyvalues.length > 1 && keyvalues[1] != null) {
                assitPropertyParams.append(keyvalues[1]);
            }
            if (keyvalues.length > 2 && keyvalues[2] != null) {
                lotParams.append(keyvalues[2]);
                continue;
            }
            lotParams.append(" ");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(BillBaseStatusEnum.AUDITED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(this.channelInventoryInfo.getSaleOrgProperty(), (Object)((SaleOrgUnitInfo)this.channelBillInfo.get(this.channelInventoryInfo.getSaleOrgProperty())).getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(this.channelInventoryInfo.getChannelProperty(), (Object)((ChannelBaseInfo)this.channelBillInfo.get(this.channelInventoryInfo.getChannelProperty())).getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(this.channelInventoryInfo.getBizDateProperty(), (Object)((Date)this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty())), CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(this.channelInventoryInfo.getBizDateProperty(), (Object)((Date)this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty())), CompareType.GREATER));
        filterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        viewInfo.setFilter(filterInfo);
        SorterItemInfo sort = new SorterItemInfo(this.channelInventoryInfo.getBizDateProperty());
        sort.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sort);
        viewInfo.setSelector(this.getSelector());
        ICoreBase icoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)BOSObjectType.create((String)this.channelInventoryInfo.getBosType()));
        CoreBaseCollection tempCollection = icoreBase.getCollection(viewInfo);
        AbstractObjectCollection collection = (AbstractObjectCollection)tempCollection.clone();
        collection.clear();
        StringBuffer replaceMaterialID = new StringBuffer();
        StringBuffer replaceLot = new StringBuffer();
        StringBuffer replaceAssistID = new StringBuffer();
        boolean isExistCollection = true;
        int c2 = tempCollection.size();
        for (int i = 0; i < c2; ++i) {
            int strIndex;
            int m;
            int n;
            Date bizdate = (Date)tempCollection.getObject(i).get(this.channelInventoryInfo.getBizDateProperty());
            if (bizdate.after((Date)this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty()))) {
                isExistCollection = false;
                break;
            }
            AbstractObjectCollection entryCollection = (AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty());
            AbstractObjectCollection tempEntryCollection = (AbstractObjectCollection)entryCollection.clone();
            int count = 0;
            if (replaceMaterialID.length() > 0) {
                String[] mateiralids = replaceMaterialID.toString().split(",");
                n = mateiralids.length;
                for (m = 0; m < n; ++m) {
                    strIndex = materialParams.indexOf(mateiralids[m]);
                    if (strIndex == -1) continue;
                    if (strIndex == 0) {
                        materialParams.delete(strIndex, strIndex + mateiralids[m].length() + 1);
                        continue;
                    }
                    materialParams.delete(strIndex - 1, strIndex + mateiralids[m].length());
                }
            }
            replaceMaterialID.delete(0, replaceMaterialID.length());
            if (replaceLot.length() > 0) {
                String[] lots = replaceLot.toString().split(",");
                n = lots.length;
                for (m = 0; m < n; ++m) {
                    strIndex = lotParams.indexOf(lots[m]);
                    if (strIndex == -1) continue;
                    if (strIndex == 0) {
                        lotParams.delete(strIndex, strIndex + lots[m].length() + 1);
                        continue;
                    }
                    lotParams.delete(strIndex - 1, strIndex + lots[m].length());
                }
            }
            replaceLot.delete(0, replaceLot.length());
            if (replaceAssistID.length() > 0) {
                String[] assitPropertyids = replaceLot.toString().split(",");
                n = assitPropertyids.length;
                for (m = 0; m < n; ++m) {
                    strIndex = assitPropertyParams.indexOf(assitPropertyids[m]);
                    if (strIndex == -1) continue;
                    if (strIndex == 0) {
                        assitPropertyParams.delete(strIndex, strIndex + assitPropertyids[m].length() + 1);
                        continue;
                    }
                    assitPropertyParams.delete(strIndex - 1, strIndex + assitPropertyids[m].length());
                }
            }
            replaceAssistID.delete(0, replaceAssistID.length());
            int entrysize = tempEntryCollection.size();
            for (int j = 0; j < entrysize; ++j) {
                MaterialInfo tempMaterialInfo = (MaterialInfo)tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getMaterialProperty());
                if (isUpdateStorageByAssistPorperty) {
                    AsstAttrValueInfo tempAttrValueInfo;
                    if (assitPropertyParams.length() == 0 && lotParams.length() == 0) {
                        if (materialParams.toString().indexOf(tempMaterialInfo.getId().toString()) != -1 && tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getAssistProperty()) == null && (tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()) == null || tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()).toString().trim().length() == 0)) {
                            if (replaceMaterialID.length() > 0) {
                                replaceMaterialID.append(",");
                            }
                            replaceMaterialID.append(tempMaterialInfo.getId().toString());
                            continue;
                        }
                        ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                        ++count;
                        continue;
                    }
                    if (assitPropertyParams.length() > 0 && lotParams.length() == 0) {
                        if (tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getAssistProperty()) instanceof AsstAttrValueInfo) {
                            tempAttrValueInfo = (AsstAttrValueInfo)tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getAssistProperty());
                            if (materialParams.toString().indexOf(tempMaterialInfo.getId().toString()) != -1 && assitPropertyParams.toString().indexOf(tempAttrValueInfo.getId().toString()) != -1 && (tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()) == null || tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()).toString().trim().length() == 0)) {
                                if (replaceMaterialID.length() > 0) {
                                    replaceMaterialID.append(",");
                                }
                                replaceMaterialID.append(tempMaterialInfo.getId().toString());
                                if (replaceAssistID.length() > 0) {
                                    replaceAssistID.append(",");
                                }
                                replaceAssistID.append(tempAttrValueInfo.getId().toString());
                                continue;
                            }
                            ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                            ++count;
                            continue;
                        }
                        ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                        ++count;
                        continue;
                    }
                    if (assitPropertyParams.length() == 0 && lotParams.length() > 0) {
                        if (materialParams.toString().indexOf(tempMaterialInfo.getId().toString()) != -1 && tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getAssistProperty()) == null && tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()) != null && lotParams.indexOf(tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()).toString()) != -1) {
                            if (replaceMaterialID.length() > 0) {
                                replaceMaterialID.append(",");
                            }
                            replaceMaterialID.append(tempMaterialInfo.getId().toString());
                            if (replaceLot.length() > 0) {
                                replaceLot.append(",");
                            }
                            replaceLot.append(tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()).toString());
                            continue;
                        }
                        ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                        ++count;
                        continue;
                    }
                    if (tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getAssistProperty()) instanceof AsstAttrValueInfo) {
                        tempAttrValueInfo = (AsstAttrValueInfo)tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getAssistProperty());
                        if (tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()) == null) {
                            ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                            ++count;
                            continue;
                        }
                        String lot = tempEntryCollection.getObject(j).get(this.channelInventoryInfo.getLotProperty()).toString();
                        if (lot.trim().length() == 0) {
                            lot = " ";
                        }
                        if (materialParams.toString().indexOf(tempMaterialInfo.getId().toString()) != -1 && assitPropertyParams.toString().indexOf(tempAttrValueInfo.getId().toString()) != -1 && lotParams.toString().indexOf(lot) != -1) {
                            if (replaceMaterialID.length() > 0) {
                                replaceMaterialID.append(",");
                            }
                            replaceMaterialID.append(tempMaterialInfo.getId().toString());
                            if (replaceAssistID.length() > 0) {
                                replaceAssistID.append(",");
                            }
                            replaceAssistID.append(tempAttrValueInfo.getId().toString());
                            if (replaceLot.length() > 0) {
                                replaceLot.append(",");
                            }
                            replaceLot.append(lot);
                            continue;
                        }
                        ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                        ++count;
                        continue;
                    }
                    ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                    ++count;
                    continue;
                }
                if (materialParams.toString().indexOf(tempMaterialInfo.getId().toString()) == -1) {
                    ((AbstractObjectCollection)tempCollection.getObject(i).get(this.channelInventoryInfo.getEntrysProperty())).removeObject(tempEntryCollection.getObject(j));
                    ++count;
                    continue;
                }
                if (replaceMaterialID.length() > 0) {
                    replaceMaterialID.append(",");
                }
                replaceMaterialID.append(tempMaterialInfo.getId().toString());
            }
            if (count == entryCollection.size() || entryCollection.size() <= 0) continue;
            collection.addObject(tempCollection.getObject(i));
        }
        if (!isExistCollection) {
            return null;
        }
        return collection;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo(this.channelInventoryInfo.getChannelProperty() + ".*"));
        selector.add(new SelectorItemInfo(this.channelInventoryInfo.getEntrysProperty() + ".*"));
        return selector;
    }
}

