/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.UpdataStorageEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.app.ReportBaseStrategy;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelBillProperyInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReportInventoryStrategy
extends ReportBaseStrategy {
    public ReportInventoryStrategy(Context ctx, IObjectValue model, BizActionEnum actionEnum, SaleChannelBillProperyInfo channelInventoryInfo, Map params) {
        this.ctx = ctx;
        this.channelBillInfo = model;
        this.actionEnum = actionEnum;
        this.channelInventoryInfo = channelInventoryInfo;
        this.params = params;
    }

    @Override
    protected void updateInventoryByAudit() throws Exception {
        ChannelBaseInfo channelBaseInfo = (ChannelBaseInfo)this.params.get(this.channelInventoryInfo.getChannelProperty());
        boolean isUpdateStorageByAssistPorperty = false;
        if (channelBaseInfo.getIsUpdataStorage().equals((Object)UpdataStorageEnum.YES)) {
            isUpdateStorageByAssistPorperty = true;
        }
        Set materialKey = this.updateMaterial.keySet();
        Connection con = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            Object[] insertMaterials;
            con = EJBFactory.getConnection((Context)this.ctx);
            statement = con.createStatement();
            resultset = statement.executeQuery(this.getCheckUpdateStorageSql(isUpdateStorageByAssistPorperty, false));
            PreparedStatement updateStatement = con.prepareStatement(this.getUpdateInventorySql());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            boolean isNeedUpdateInventory = false;
            HashMap tempMaterialKey = new HashMap();
            tempMaterialKey.putAll(this.updateMaterial);
            while (resultset.next()) {
                String key = null;
                if (isUpdateStorageByAssistPorperty) {
                    key = resultset.getString("FLot") == null ? resultset.getString("FMaterialID") + "#" + resultset.getString("FAssistPropertyID") + "#" : resultset.getString("FMaterialID") + "#" + resultset.getString("FAssistPropertyID") + "#" + resultset.getString("FLot");
                    Logger.info((String)("isUpdateStorageByAssistPorperty materialKey is " + key));
                } else {
                    key = resultset.getString("FMaterialID");
                    Logger.info((String)("Not isUpdateStorageByAssistPorperty materialKey is " + key));
                }
                if (!materialKey.contains(key)) continue;
                materialKey.remove(key);
                Date bizDate = Date.valueOf(this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty()).toString());
                if (resultset.getDate("FStorageDate").compareTo(bizDate) > 0) continue;
                updateStatement.setBigDecimal(1, (BigDecimal)this.updateMaterialQty.get(key));
                if (this.updateMaterialAssistQty != null) {
                    updateStatement.setBigDecimal(2, (BigDecimal)this.updateMaterialAssistQty.get(key));
                } else {
                    updateStatement.setBigDecimal(2, null);
                }
                updateStatement.setBigDecimal(3, (BigDecimal)this.updateMaterialBaseQty.get(key));
                Date bd = Date.valueOf(df.format(this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty())).toString());
                updateStatement.setDate(4, bd);
                if (this.updateExpiryDate.get(key) != null) {
                    Date expiryDate = Date.valueOf(df.format(this.updateExpiryDate.get(key)));
                    updateStatement.setDate(5, expiryDate);
                } else {
                    updateStatement.setNull(5, 91);
                }
                if (this.updateProduceDate.get(key) != null) {
                    Date produceDate = Date.valueOf(df.format(this.updateProduceDate.get(key)));
                    updateStatement.setDate(6, produceDate);
                } else {
                    updateStatement.setNull(6, 91);
                }
                updateStatement.setString(7, resultset.getString("fid"));
                updateStatement.addBatch();
                isNeedUpdateInventory = true;
            }
            if (isNeedUpdateInventory) {
                updateStatement.executeBatch();
            }
            if ((insertMaterials = materialKey.toArray()).length > 0) {
                PreparedStatement insertStatement = con.prepareStatement(this.getInsertInventorySql());
                int c = insertMaterials.length;
                for (int i = 0; i < c; ++i) {
                    insertStatement.setString(1, BOSUuid.create((String)"7811B21F").toString());
                    insertStatement.setString(2, ((SaleOrgUnitInfo)this.channelBillInfo.get(this.channelInventoryInfo.getSaleOrgProperty())).getId().toString());
                    insertStatement.setString(3, ((ChannelBaseInfo)this.channelBillInfo.get(this.channelInventoryInfo.getChannelProperty())).getId().toString());
                    String[] keyparams = insertMaterials[i].toString().split("#");
                    Logger.info((String)("keyparams length is : " + keyparams.length));
                    insertStatement.setString(4, keyparams[0]);
                    if (isUpdateStorageByAssistPorperty) {
                        Logger.info((String)"keyparams length much be gt zero ! ");
                        if (keyparams.length > 1 && keyparams[1] != null && !keyparams[1].equalsIgnoreCase("null")) {
                            insertStatement.setString(5, keyparams[1]);
                        } else {
                            insertStatement.setString(5, null);
                        }
                        if (keyparams.length > 2 && keyparams[2] != null && !keyparams[2].equalsIgnoreCase("null")) {
                            insertStatement.setString(6, keyparams[2]);
                        } else {
                            insertStatement.setString(6, null);
                        }
                    } else {
                        insertStatement.setString(5, null);
                        insertStatement.setString(6, null);
                    }
                    insertStatement.setString(7, this.updateMaterialUnit.get(insertMaterials[i]).toString());
                    insertStatement.setBigDecimal(8, (BigDecimal)this.updateMaterialQty.get(insertMaterials[i]));
                    if (this.updateMaterialAssistUnit != null && this.updateMaterialAssistUnit.get(insertMaterials[i]) != null) {
                        insertStatement.setString(9, this.updateMaterialAssistUnit.get(insertMaterials[i]).toString());
                    } else {
                        insertStatement.setString(9, null);
                    }
                    if (this.updateMaterialAssistQty != null) {
                        insertStatement.setBigDecimal(10, (BigDecimal)this.updateMaterialAssistQty.get(insertMaterials[i]));
                    } else {
                        insertStatement.setBigDecimal(10, null);
                    }
                    insertStatement.setString(11, this.updateMaterialBaseUnit.get(insertMaterials[i]).toString());
                    insertStatement.setBigDecimal(12, (BigDecimal)this.updateMaterialBaseQty.get(insertMaterials[i]));
                    Date bd = Date.valueOf(df.format(this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty())).toString());
                    insertStatement.setDate(13, bd);
                    if (this.updateExpiryDate.get(insertMaterials[i]) != null) {
                        Date expiryDate = Date.valueOf(df.format(this.updateExpiryDate.get(insertMaterials[i])));
                        insertStatement.setDate(14, expiryDate);
                    } else {
                        insertStatement.setNull(14, 91);
                    }
                    if (this.updateProduceDate.get(insertMaterials[i]) != null) {
                        Date produceDate = Date.valueOf(df.format(this.updateProduceDate.get(insertMaterials[i])));
                        insertStatement.setDate(15, produceDate);
                    } else {
                        insertStatement.setNull(15, 91);
                    }
                    insertStatement.addBatch();
                }
                insertStatement.executeBatch();
            }
            this.updateMaterial.putAll(tempMaterialKey);
            resultset = statement.executeQuery(this.getCheckUpdateStorageSql(isUpdateStorageByAssistPorperty, true));
            if (resultset.next()) {
                throw new ChannelBillException(ChannelBillException.MINUSINVENTORY);
            }
        }
        catch (Exception e) {
            try {
                Logger.error((Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultset, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultset, (Statement)statement, (Connection)con);
    }

    @Override
    protected void updateInventoryByUnAudit() throws Exception {
        ChannelBaseInfo channelBaseInfo = (ChannelBaseInfo)this.params.get(this.channelInventoryInfo.getChannelProperty());
        boolean isUpdateStorageByAssistPorperty = false;
        if (channelBaseInfo.getIsUpdataStorage().equals((Object)UpdataStorageEnum.YES)) {
            isUpdateStorageByAssistPorperty = true;
        }
        Set materialKey = this.updateMaterial.keySet();
        Connection con = null;
        Statement statement = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            statement = con.createStatement();
            AbstractObjectCollection collection = this.getLastBillInfoWithInfoByInventoryDate(isUpdateStorageByAssistPorperty, materialKey);
            if (collection != null) {
                if (!materialKey.isEmpty()) {
                    statement.execute(this.getDeleteStorageSql(isUpdateStorageByAssistPorperty, materialKey));
                }
                int c = collection.size();
                for (int i = 0; i < c; ++i) {
                    this.channelBillInfo = collection.getObject(i);
                    this.params.put(this.channelInventoryInfo.getChannelProperty(), this.channelBillInfo.get(this.channelInventoryInfo.getChannelProperty()));
                    this.actionEnum = BizActionEnum.AUDIT;
                    this.updateInventory();
                }
            }
        }
        catch (Exception e) {
            try {
                Logger.error((Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private String getUpdateInventorySql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SD_ChannelInventory ").append(" set FQty= ?,FAssistQty=?,FBaseQty=?,FStorageDate = ?,FExpiryDate = ?,FProduceDate = ? ").append(" where fid = ? ");
        return sql.toString();
    }

    private String getInsertInventorySql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert T_SD_ChannelInventory(FID,FSaleOrgUnitID,FSaleChannelID,FMaterialID,FAssistPropertyID,FLot,FUnitID,FQty,FAssistUnitID,FAssistQty,FBaseUnitID,FBaseQty,FStorageDate,FExpiryDate,FProduceDate) ").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
        return sql.toString();
    }
}

