/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.UpdataStorageEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.app.ReportBaseStrategy;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelBillProperyInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportInvoiceStrategy
extends ReportBaseStrategy {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ReportInvoiceStrategy");

    public ReportInvoiceStrategy(Context ctx, IObjectValue model, BizActionEnum actionEnum, SaleChannelBillProperyInfo channelInventoryInfo, Map params) {
        this.ctx = ctx;
        this.channelBillInfo = model;
        this.actionEnum = actionEnum;
        this.channelInventoryInfo = channelInventoryInfo;
        this.params = params;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void updateInventoryByUnAudit() throws Exception {
        ChannelBaseInfo channelBaseInfo = (ChannelBaseInfo)this.params.get(this.channelInventoryInfo.getChannelProperty());
        boolean isUpdateStorageByAssistPorperty = false;
        if (channelBaseInfo.getIsUpdataStorage().equals((Object)UpdataStorageEnum.YES)) {
            isUpdateStorageByAssistPorperty = true;
        }
        Connection con = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            statement = con.createStatement();
            resultset = statement.executeQuery(this.getCheckUpdateStorageSql(isUpdateStorageByAssistPorperty, false));
            PreparedStatement updateStatement1 = con.prepareStatement(this.getInitDataSql());
            PreparedStatement updateStatement = con.prepareStatement(this.getUpdateInventorySqlByUnAudit());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            HashMap tempMaterialKey = new HashMap();
            tempMaterialKey.putAll(this.updateMaterial);
            while (resultset.next()) {
                String key = null;
                if (isUpdateStorageByAssistPorperty) {
                    String lot = resultset.getString("FLot");
                    if (lot == null) {
                        lot = "";
                    }
                    key = resultset.getString("FMaterialID") + "#" + resultset.getString("FAssistPropertyID") + "#" + lot;
                } else {
                    key = resultset.getString("FMaterialID");
                }
                updateStatement.setBigDecimal(1, (BigDecimal)this.updateMaterialQty.get(key));
                if (this.updateMaterialAssistQty != null) {
                    updateStatement.setBigDecimal(2, (BigDecimal)this.updateMaterialAssistQty.get(key));
                } else {
                    updateStatement.setBigDecimal(2, null);
                }
                updateStatement.setBigDecimal(3, (BigDecimal)this.updateMaterialBaseQty.get(key));
                Date bd = Date.valueOf(df.format(this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty())).toString());
                updateStatement.setDate(4, bd);
                if (this.updateExpiryDate.get(key) != null) {
                    Date expiryDate = Date.valueOf(df.format(this.updateExpiryDate.get(key)));
                    updateStatement.setDate(5, expiryDate);
                } else {
                    updateStatement.setNull(5, 91);
                }
                if (this.updateProduceDate.get(key) != null) {
                    Date produceDate = Date.valueOf(df.format(this.updateProduceDate.get(key)));
                    updateStatement.setDate(6, produceDate);
                } else {
                    updateStatement.setNull(6, 91);
                }
                updateStatement.setString(7, resultset.getString("fid"));
                updateStatement1.setString(1, resultset.getString("fid"));
                updateStatement1.addBatch();
                updateStatement.addBatch();
            }
            updateStatement1.executeBatch();
            updateStatement.executeBatch();
            this.updateMaterial.putAll(tempMaterialKey);
            resultset = statement.executeQuery(this.getCheckUpdateStorageSql(isUpdateStorageByAssistPorperty, true));
            if (resultset.next()) {
                throw new ChannelBillException(ChannelBillException.MINUSINVENTORY);
            }
        }
        catch (EASBizException e) {
            try {
                logger.error((Object)e);
                throw e;
                catch (Exception e2) {
                    logger.error((Object)e2);
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultset, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultset, (Statement)statement, (Connection)con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void updateInventoryByAudit() throws Exception {
        ChannelBaseInfo channelBaseInfo = (ChannelBaseInfo)this.params.get(this.channelInventoryInfo.getChannelProperty());
        boolean isUpdateStorageByAssistPorperty = false;
        if (channelBaseInfo.getIsUpdataStorage().equals((Object)UpdataStorageEnum.YES)) {
            isUpdateStorageByAssistPorperty = true;
        }
        HashMap tempMaterialKey = new HashMap();
        tempMaterialKey.putAll(this.updateMaterial);
        Set materialKey = this.updateMaterial.keySet();
        Connection con = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            statement = con.createStatement();
            resultset = statement.executeQuery(this.getCheckUpdateStorageSql(isUpdateStorageByAssistPorperty, false));
            PreparedStatement updateStatement1 = con.prepareStatement(this.getInitDataSql());
            PreparedStatement updateStatement = con.prepareStatement(this.getUpdateInventorySqlByAudit());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String key = null;
            while (resultset.next()) {
                if (isUpdateStorageByAssistPorperty) {
                    String lot = resultset.getString("FLot");
                    if (lot == null) {
                        lot = "";
                    }
                    key = resultset.getString("FMaterialID") + "#" + resultset.getString("FAssistPropertyID") + "#" + lot;
                } else {
                    key = resultset.getString("FMaterialID");
                }
                if (!materialKey.contains(key)) continue;
                materialKey.remove(key);
                updateStatement.setBigDecimal(1, (BigDecimal)this.updateMaterialQty.get(key));
                if (this.updateMaterialAssistQty != null) {
                    updateStatement.setBigDecimal(2, (BigDecimal)this.updateMaterialAssistQty.get(key));
                } else {
                    updateStatement.setBigDecimal(2, null);
                }
                updateStatement.setBigDecimal(3, (BigDecimal)this.updateMaterialBaseQty.get(key));
                Date bd = Date.valueOf(df.format(this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty())).toString());
                updateStatement.setDate(4, bd);
                if (this.updateExpiryDate.get(key) != null) {
                    Date expiryDate = Date.valueOf(df.format(this.updateExpiryDate.get(key)));
                    updateStatement.setDate(5, expiryDate);
                } else {
                    updateStatement.setNull(5, 91);
                }
                if (this.updateProduceDate.get(key) != null) {
                    Date produceDate = Date.valueOf(df.format(this.updateProduceDate.get(key)));
                    updateStatement.setDate(6, produceDate);
                } else {
                    updateStatement.setNull(6, 91);
                }
                updateStatement.setString(7, resultset.getString("fid"));
                updateStatement1.setString(1, resultset.getString("fid"));
                updateStatement1.addBatch();
                updateStatement.addBatch();
            }
            updateStatement1.executeBatch();
            updateStatement.executeBatch();
            Object[] insertMaterials = materialKey.toArray();
            PreparedStatement insertStatement = null;
            if (insertMaterials.length > 0) {
                insertStatement = con.prepareStatement(this.getInsertInventorySql());
                int c = insertMaterials.length;
                for (int i = 0; i < c; ++i) {
                    String[] keyparams = insertMaterials[i].toString().split("#");
                    insertStatement.setString(1, BOSUuid.create((String)"7811B21F").toString());
                    insertStatement.setString(2, (String)this.updateSaleOrgUnit.get(keyparams[0]));
                    insertStatement.setString(3, ((ChannelBaseInfo)this.channelBillInfo.get(this.channelInventoryInfo.getChannelProperty())).getId().toString());
                    insertStatement.setString(4, keyparams[0]);
                    logger.info((Object)("keyparams length is : " + keyparams.length));
                    if (isUpdateStorageByAssistPorperty) {
                        logger.info((Object)"keyparams length much be gt zero ! ");
                        if (keyparams.length > 1 && keyparams[1] != null && !keyparams[1].equalsIgnoreCase("null")) {
                            insertStatement.setString(5, keyparams[1]);
                        } else {
                            insertStatement.setString(5, null);
                        }
                        if (keyparams.length > 2 && keyparams[2] != null && !keyparams[2].equalsIgnoreCase("null")) {
                            insertStatement.setString(6, keyparams[2]);
                        } else {
                            insertStatement.setString(6, null);
                        }
                    } else {
                        insertStatement.setString(5, null);
                        insertStatement.setString(6, null);
                    }
                    insertStatement.setString(7, this.updateMaterialUnit.get(insertMaterials[i]).toString());
                    insertStatement.setBigDecimal(8, (BigDecimal)this.updateMaterialQty.get(insertMaterials[i]));
                    if (this.updateMaterialAssistUnit != null && this.updateMaterialAssistUnit.get(insertMaterials[i]) != null) {
                        insertStatement.setString(9, this.updateMaterialAssistUnit.get(insertMaterials[i]).toString());
                    } else {
                        insertStatement.setString(9, null);
                    }
                    if (this.updateMaterialAssistQty != null) {
                        insertStatement.setBigDecimal(10, (BigDecimal)this.updateMaterialAssistQty.get(insertMaterials[i]));
                    } else {
                        insertStatement.setBigDecimal(10, null);
                    }
                    insertStatement.setString(11, this.updateMaterialBaseUnit.get(insertMaterials[i]).toString());
                    insertStatement.setBigDecimal(12, (BigDecimal)this.updateMaterialBaseQty.get(insertMaterials[i]));
                    Date bd = Date.valueOf(df.format(this.channelBillInfo.get(this.channelInventoryInfo.getBizDateProperty())).toString());
                    insertStatement.setDate(13, bd);
                    if (this.updateExpiryDate.get(insertMaterials[i]) != null) {
                        Date expiryDate = Date.valueOf(df.format(this.updateExpiryDate.get(insertMaterials[i])));
                        insertStatement.setDate(14, expiryDate);
                    } else {
                        insertStatement.setNull(14, 91);
                    }
                    if (this.updateProduceDate.get(insertMaterials[i]) != null) {
                        Date produceDate = Date.valueOf(df.format(this.updateProduceDate.get(insertMaterials[i])));
                        insertStatement.setDate(15, produceDate);
                    } else {
                        insertStatement.setNull(15, 91);
                    }
                    insertStatement.addBatch();
                }
                insertStatement.executeBatch();
            }
            this.updateMaterial.putAll(tempMaterialKey);
            resultset = statement.executeQuery(this.getCheckUpdateStorageSql(isUpdateStorageByAssistPorperty, true));
            if (resultset.next()) {
                throw new ChannelBillException(ChannelBillException.MINUSINVENTORY);
            }
        }
        catch (EASBizException e) {
            try {
                logger.error((Object)e);
                throw e;
                catch (Exception e2) {
                    logger.error((Object)e2);
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultset, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultset, (Statement)statement, (Connection)con);
    }

    private String getUpdateInventorySqlByAudit() {
        StringBuffer sql = new StringBuffer();
        if (this.updateMaterialAssistQty != null) {
            sql.append(" update T_SD_ChannelInventory ").append(" set FQty= FQty+?,FAssistQty=FAssistQty+?,FBaseQty=FBaseQty+?,FStorageDate = ?,FExpiryDate = ?, FProduceDate = ? ").append(" where fid = ? ");
        } else {
            sql.append(" update T_SD_ChannelInventory ").append(" set FQty= FQty+?,FAssistQty=?,FBaseQty=FBaseQty+?,FStorageDate = ?,FExpiryDate = ?, FProduceDate = ? ").append(" where fid = ? ");
        }
        return sql.toString();
    }

    private String getUpdateInventorySqlByUnAudit() {
        StringBuffer sql = new StringBuffer();
        if (this.updateMaterialAssistQty != null) {
            sql.append(" update T_SD_ChannelInventory ").append(" set FQty= FQty-?,FAssistQty=FAssistQty-?,FBaseQty=FBaseQty-?,FStorageDate = ?,FExpiryDate = ?, FProduceDate = ? ").append(" where fid = ?");
        } else {
            sql.append(" update T_SD_ChannelInventory ").append(" set FQty= FQty-?,FAssistQty=?,FBaseQty=FBaseQty-?,FStorageDate = ?,FExpiryDate = ?, FProduceDate = ? ").append(" where fid = ?");
        }
        return sql.toString();
    }

    private String getInsertInventorySql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert T_SD_ChannelInventory(FID,FSaleOrgUnitID,FSaleChannelID,FMaterialID,FAssistPropertyID,FLot,FUnitID,FQty,FAssistUnitID,FAssistQty,FBaseUnitID,FBaseQty,FStorageDate,FExpiryDate,FProduceDate) ").append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sql.toString();
    }

    private String getInitDataSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SD_ChannelInventory ").append(" set FQty= 0,FAssistQty=0,FBaseQty=0").append(" where fid = ? and FQty is null");
        return sql.toString();
    }
}

