/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.RequirementPlanEntryCollection;
import com.kingdee.eas.scm.sd.channel.RequirementPlanEntryFactory;
import com.kingdee.eas.scm.sd.channel.RequirementPlanInfo;
import com.kingdee.eas.scm.sd.channel.app.AbstractRequirementPlanControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;

public class RequirementPlanControllerBean
extends AbstractRequirementPlanControllerBean {
    private static final long serialVersionUID = 1869592321478020798L;

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RequirementPlanInfo billInfo = this.getRequirementPlanInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        if (billInfo.getBaseStatus() != null) {
            RequirementPlanEntryCollection entries = billInfo.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                boolean flag = this.checkPeriod(ctx, billInfo.getId().toString(), billInfo.getSaleOrgUnit().getId().toString(), billInfo.getChannel().getId().toString(), entries.get(i).getMaterial().getId().toString(), billInfo.getRequirementPlanPeriod().getId().toString());
                if (flag) {
                    throw new ChannelBillException(ChannelBillException.CANNOT_AUDIT_REQUIREMENTPLAN, new String[]{billInfo.getNumber()});
                }
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.AUDITED);
            }
        }
        this.update(ctx, pk, billInfo);
        super._audit(ctx, pk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RequirementPlanInfo billInfo = this.getRequirementPlanInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANDELETE, new String[]{""});
        }
        IObjectPK logResult = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)pk, (String)billInfo.getNumber(), (String)"requirementPlan_delete");
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logResult);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementPlanInfo billInfo = (RequirementPlanInfo)model;
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() != 1 && billInfo.getBaseStatus().getValue() != -1) {
            throw new ChannelBillException(ChannelBillException.CANNOT_SAVE);
        }
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("VnuqmgEhEADgAAAMwKgPZ7dsPo0="));
        billInfo.setBillType(billTypeInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (billInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
            this._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
            return pk;
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementPlanInfo billInfo = (RequirementPlanInfo)model;
        ObjectUuidPK pk = null;
        if (!this.isAddNew(ctx, (IObjectValue)billInfo)) {
            pk = new ObjectUuidPK(billInfo.getId());
            if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() >= 4) {
                throw new ChannelBillException(ChannelBillException.CANNOT_SUBMIT);
            }
        }
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("VnuqmgEhEADgAAAMwKgPZ7dsPo0="));
        billInfo.setBillType(billTypeInfo);
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, billInfo, orgUnitID, 2)) {
            billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            pk = super._submit(ctx, model);
            this._audit(ctx, (IObjectPK)pk);
            return pk;
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        pk = super._submit(ctx, model);
        return pk;
    }

    protected boolean checkPeriod(Context ctx, String parentID, String saleOrgID, String channelID, String materialID, String requirementPlanPeriodId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.saleOrgUnit.id", (Object)saleOrgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.channel.id", (Object)channelID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.requirementPlanPeriod.id", (Object)requirementPlanPeriodId, CompareType.EQUALS));
        entityViewInfo.getSelector().add("material.id");
        try {
            CoreBaseCollection collection = RequirementPlanEntryFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
            if (collection != null) {
                int length = collection.size();
                return length >= 1;
            }
            return false;
        }
        catch (BOSException e) {
            return true;
        }
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        super._submit(ctx, id);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RequirementPlanInfo billInfo = this.getRequirementPlanInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYAUDITCANUNAUDIT, new String[]{billInfo.getNumber()});
        }
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (!this.isUnAudit(ctx, billInfo, orgUnitID, 2)) {
            throw new ChannelBillException(ChannelBillException.NOALLOWUNADUIT);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        super._update(ctx, pk, (IObjectValue)billInfo);
        super._unAudit(ctx, pk);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }
}

