/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseCollection;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodFactory;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodInfo;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeCollection;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeFactory;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.RequirementPlanCollection;
import com.kingdee.eas.scm.sd.channel.RequirementPlanEntryCollection;
import com.kingdee.eas.scm.sd.channel.RequirementPlanEntryInfo;
import com.kingdee.eas.scm.sd.channel.RequirementPlanFactory;
import com.kingdee.eas.scm.sd.channel.RequirementPlanInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;

public class RequirementPlanImport
extends AbstractDataTransmission {
    public RequirementPlanInfo requirementPlanInfo;
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    Locale local = new Locale("l2");
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntries_qty", "FEntries_salePromotionQty", "FEntries_totalQty"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"qty", "salePromotionQty", "totalQty"};

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return RequirementPlanFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RequirementPlanInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        Object saleOrgUnitData;
        ChannelBaseCollection collection;
        ChannelBaseInfo channelBaseInfo;
        Object data = ((DataToken)lineData.get((Object)"FNumber")).data;
        if (data == null || data != null && data.toString().trim().length() < 1) {
            data = this.getContextParameter("number");
        }
        ChannelBaseInfo tempChannelBaseInfo = channelBaseInfo = (ChannelBaseInfo)this.getContextParameter("channel");
        this.requirementPlanInfo = null;
        if (data != null && data.toString().trim().length() >= 1) {
            this.requirementPlanInfo = this.getBillFromNumber(data.toString().trim(), ctx);
        }
        SaleOrgUnitInfo saleOrgUnitInfo = null;
        if (tempChannelBaseInfo == null) {
            if (data == null || data.toString().trim().length() < 1) {
                throw new TaskExternalException(this.getChannelImportResource("NUMBER_CANNOT_NULL"));
            }
            Object channelData = ((DataToken)lineData.get((Object)"FChannel_number")).data;
            if (channelData == null) throw new TaskExternalException(this.getChannelImportResource("CHANNEL_CANNOT_NULL"));
            String channelNumber = channelData.toString();
            if (channelNumber == null || channelNumber.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("CHANNEL_CANNOT_NULL"));
            collection = null;
            try {
                collection = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseCollection(this.getFilter(channelNumber.toString().trim()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_CHANNEL"));
            }
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_CHANNEL"));
            channelBaseInfo = collection.get(0);
        } else {
            data = this.getNumber(ctx, data, (SaleOrgUnitInfo)this.getContextParameter("saleOrg"));
        }
        if ((saleOrgUnitData = ((DataToken)lineData.get((Object)"FSaleOrgUnit_number")).data) != null && !StringUtils.isEmpty((String)saleOrgUnitData.toString())) {
            String orgNumber = saleOrgUnitData.toString();
            if (orgNumber != null && orgNumber.trim().length() > 0) {
                collection = null;
                try {
                    collection = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(this.getFilter(orgNumber.toString().trim()));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_SALEORG"));
                }
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_SALEORG"));
                saleOrgUnitInfo = collection.get(0);
                data = this.getNumber(ctx, data, saleOrgUnitInfo);
            }
        } else {
            saleOrgUnitInfo = (SaleOrgUnitInfo)this.getContextParameter("saleOrg");
        }
        if (this.requirementPlanInfo == null) {
            this.requirementPlanInfo = new RequirementPlanInfo();
            this.requirementPlanInfo.setNumber(data.toString().trim());
        } else {
            if (this.requirementPlanInfo.getChannel() != null && channelBaseInfo != null && !this.requirementPlanInfo.getChannel().getId().toString().equals(channelBaseInfo.getId().toString())) {
                throw new TaskExternalException(data.toString() + this.getChannelImportResource("SAME_NUMBER"));
            }
            if (this.requirementPlanInfo.getBaseStatus().getValue() == 4) {
                throw new TaskExternalException(data.toString() + this.getChannelImportResource("HAVE_AUDIT"));
            }
        }
        this.requirementPlanInfo.setChannel(channelBaseInfo);
        this.requirementPlanInfo.setSaleOrgUnit(saleOrgUnitInfo);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object date = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (date == null || date.toString().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("STORAGE_DATE_CANNOT_NULL"));
        try {
            this.requirementPlanInfo.setBizDate(df.parse(date.toString()));
        }
        catch (ParseException e) {
            throw new TaskExternalException(this.getChannelImportResource("DATE_FORMAT_ERROR"));
        }
        Object statusdate = ((DataToken)lineData.get((Object)"FStatus")).data;
        this.requirementPlanInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        if (statusdate != null && statusdate.toString().trim().length() > 0 && BillBaseStatusEnum.TEMPORARILYSAVED.toString().equals(statusdate.toString())) {
            this.requirementPlanInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        this.requirementPlanInfo.setRemark((String)((DataToken)lineData.get((Object)"FRemark")).data);
        try {
            BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("pGlaewEaEADgAAA+wKg9C0Y+1VI="));
            this.requirementPlanInfo.setBillType(billTypeInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"10_RequirementPlanImport", (Locale)ctx.getLocale()));
        }
        data = ((DataToken)lineData.get((Object)"FPeriodType")).data;
        String periodTypeNumber = null;
        if (data == null || data.toString().length() <= 0) throw new TaskExternalException(this.getChannelImportResource(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"12_RequirementPlanImport", (Locale)ctx.getLocale())));
        periodTypeNumber = data.toString();
        PeriodTypeCollection collection2 = null;
        try {
            collection2 = PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeCollection(this.getFilter(data.toString()));
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("DATE_FORMAT_ERROR"));
        }
        if (collection2 == null || collection2.size() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"11_RequirementPlanImport", (Locale)ctx.getLocale()));
        }
        PeriodTypeInfo periodTypeInfo = collection2.get(0);
        this.requirementPlanInfo.setPeriodType(periodTypeInfo);
        data = ((DataToken)lineData.get((Object)"FPeriod")).data;
        if (data == null || data.toString().length() <= 0) throw new TaskExternalException(this.getChannelImportResource(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"14_RequirementPlanImport", (Locale)ctx.getLocale())));
        collection2 = null;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("type.number", (Object)periodTypeNumber, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            collection2 = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("DATE_FORMAT_ERROR"));
        }
        if (collection2 == null || collection2.size() <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"13_RequirementPlanImport", (Locale)ctx.getLocale()));
        }
        PeriodInfo periodInfo = collection2.get(0);
        this.requirementPlanInfo.setRequirementPlanPeriod(periodInfo);
        if (this.requirementPlanInfo.getRequirementPlanPeriod() != null) {
            this.requirementPlanInfo.setStartDate(this.requirementPlanInfo.getRequirementPlanPeriod().getBeginDate());
            this.requirementPlanInfo.setEndDate(this.requirementPlanInfo.getRequirementPlanPeriod().getEndDate());
        }
        RequirementPlanEntryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        data = ((DataToken)lineData.get((Object)"FEntries_seq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            RequirementPlanEntryCollection entryCollection = this.requirementPlanInfo.getEntries();
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                RequirementPlanEntryInfo tempentryInfo = entryCollection.get(i);
                if (tempentryInfo.getSeq() != seq) continue;
                entryInfo = tempentryInfo;
                isUpdateEntry = true;
            }
            if (!isUpdateEntry) {
                entryInfo = new RequirementPlanEntryInfo();
                entryInfo.setParent(this.requirementPlanInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
            }
        } else {
            RequirementPlanEntryCollection entryCollection = this.requirementPlanInfo.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new RequirementPlanEntryInfo();
            entryInfo.setParent(this.requirementPlanInfo);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        this.handleEntry(entryInfo, lineData, ctx);
        return this.requirementPlanInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEntry(RequirementPlanEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object dataObj = ((DataToken)hsData.get((Object)"FEntries_qty")).data;
        if (dataObj == null || dataObj.toString().trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("QTY_CANNOT_NULL"));
        BigDecimal value = new BigDecimal(dataObj.toString());
        if (value == null) {
            throw new TaskExternalException(this.getChannelImportResource("QTY_CANNOT_NULL"));
        }
        entryInfo.setBigDecimal("qty", value);
        dataObj = ((DataToken)hsData.get((Object)"FEntries_salePromotionQty")).data;
        if (dataObj != null && dataObj.toString().trim().length() > 0) {
            value = new BigDecimal(dataObj.toString());
            entryInfo.setBigDecimal("salePromotionQty", value == null ? new BigDecimal("0.00") : value);
        } else {
            entryInfo.setBigDecimal("salePromotionQty", new BigDecimal("0.00"));
        }
        dataObj = ((DataToken)hsData.get((Object)"FEntries_totalQty")).data;
        if (dataObj != null && dataObj.toString().trim().length() > 0) {
            value = new BigDecimal(dataObj.toString());
            entryInfo.setBigDecimal("totalQty", value == null ? new BigDecimal("0.00") : value);
        } else {
            entryInfo.setBigDecimal("totalQty", entryInfo.getQty().add(entryInfo.getSalePromotionQty()));
        }
        String str = null;
        Object material = ((DataToken)hsData.get((Object)"FEntries$material_number")).data;
        String materialNumber = null;
        if (material == null) throw new TaskExternalException(this.getChannelImportResource("MATERIAL_CANNOT_NULL"));
        materialNumber = str = material.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("MATERIAL_CANNOT_NULL"));
        MaterialCollection collection = null;
        try {
            collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(this.getFilter(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        }
        if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        MaterialInfo info = collection.get(0);
        if (info == null) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        }
        entryInfo.setMaterial(info);
        MeasureUnitInfo baseUnitinfo = info.getBaseUnit();
        entryInfo.setBaseUnit(baseUnitinfo);
        Object unit = ((DataToken)hsData.get((Object)"FEntries$unit_number")).data;
        if (unit == null) throw new TaskExternalException(this.getChannelImportResource("UNIT_CANNOT_NULL"));
        str = unit.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("UNIT_CANNOT_NULL"));
        boolean flag = this.isExistMeasureUnit(ctx, materialNumber, str);
        if (!flag) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"15_RequirementPlanImport", (Locale)ctx.getLocale()));
        }
        MeasureUnitCollection collection2 = null;
        try {
            collection2 = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(this.getFilter(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        }
        if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        MeasureUnitInfo info2 = collection2.get(0);
        if (info2 == null) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        }
        entryInfo.setUnit(info2);
        MultiMeasureUnitInfo multiMeasureUnitInfo = null;
        try {
            multiMeasureUnitInfo = this.getMultiMeasureUnit(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (multiMeasureUnitInfo == null) return;
        entryInfo.setQty(entryInfo.getQty().setScale(multiMeasureUnitInfo.getQtyPrecision(), 4));
        entryInfo.setSalePromotionQty(entryInfo.getSalePromotionQty().setScale(multiMeasureUnitInfo.getQtyPrecision(), 4));
        entryInfo.setTotalQty(entryInfo.getTotalQty().setScale(multiMeasureUnitInfo.getQtyPrecision(), 4));
        entryInfo.setBaseUnitQty(entryInfo.getQty().multiply(multiMeasureUnitInfo.getBaseConvsRate()));
        entryInfo.setBaseUnitSalesQty(entryInfo.getSalePromotionQty().multiply(multiMeasureUnitInfo.getBaseConvsRate()));
        entryInfo.setBaseUnitTotalQty(entryInfo.getTotalQty().multiply(multiMeasureUnitInfo.getBaseConvsRate()));
        int baseQtyPrecision = 0;
        if (entryInfo.getBaseUnit() != null) {
            baseQtyPrecision = entryInfo.getBaseUnit().getQtyPrecision();
        }
        BigDecimal baseQty = entryInfo.getBaseUnitQty().setScale(baseQtyPrecision, 4);
        BigDecimal baseUnitSalesQty = entryInfo.getBaseUnitSalesQty().setScale(baseQtyPrecision, 4);
        BigDecimal baseUnitTotalQty = entryInfo.getBaseUnitTotalQty().setScale(baseQtyPrecision, 4);
        entryInfo.setBaseUnitQty(baseQty);
        entryInfo.setBaseUnitSalesQty(baseUnitSalesQty);
        entryInfo.setBaseUnitTotalQty(baseUnitTotalQty);
    }

    private RequirementPlanInfo getBillFromNumber(String number, Context ctx) throws TaskExternalException {
        RequirementPlanCollection collection;
        try {
            collection = RequirementPlanFactory.getLocalInstance(ctx).getRequirementPlanCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FChannel_number", rs.getString("channel.number"));
            this.putTable(result, "FSaleOrgUnit_number", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FStatus", BillBaseStatusEnum.getEnum((int)Integer.parseInt(rs.getString("baseStatus"))));
            this.putTable(result, "FRemark", rs.getString("remark"));
            this.putTable(result, "FPeriod", rs.getString("requirementPlanPeriod.number"));
            this.putTable(result, "FPeriodType", rs.getString("periodType.number"));
            this.putTable(result, "FStartDate", rs.getString("startDate"));
            this.putTable(result, "FEndDate", rs.getString("endDate"));
            this.putTable(result, "FEntries_seq", rs.getString("entries.seq"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries$material_name_l1", rs.getString("material.name"));
            this.putTable(result, "FEntries$material_model", rs.getString("material.model"));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            String qtyPrecisionStr = rs.getString("multiMeasureUnit.qtyPrecision");
            int qtyPrecision = qtyPrecisionStr != null ? Integer.parseInt(qtyPrecisionStr) : 2;
            String qty = rs.getString("entries.qty");
            qty = qty.indexOf("0E") != -1 ? new BigDecimal("0.00").setScale(qtyPrecision, 4).toString() : new BigDecimal(qty).setScale(qtyPrecision, 4).toString();
            String salePromotionQty = rs.getString("entries.salePromotionQty");
            salePromotionQty = salePromotionQty.indexOf("0E") != -1 ? new BigDecimal("0.00").setScale(qtyPrecision, 4).toString() : new BigDecimal(salePromotionQty).setScale(qtyPrecision, 4).toString();
            String totalQty = rs.getString("entries.totalQty");
            totalQty = totalQty.indexOf("0E") != -1 ? new BigDecimal("0.00").setScale(qtyPrecision, 4).toString() : new BigDecimal(totalQty).setScale(qtyPrecision, 4).toString();
            this.putTable(result, "FEntries_qty", qty);
            this.putTable(result, "FEntries_salePromotionQty", salePromotionQty);
            this.putTable(result, "FEntries_totalQty", totalQty);
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.RequirementPlanExportQuery";
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getMultiMeasureUnitEntityViewInfo(String materialId, String unitId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        return entityViewInfo;
    }

    private MultiMeasureUnitInfo getMultiMeasureUnit(Context ctx, String materialId, String unitId) throws BOSException {
        EntityViewInfo entityViewInfo = this.getMultiMeasureUnitEntityViewInfo(materialId, unitId);
        MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }

    private Object getNumber(Context ctx, Object data, SaleOrgUnitInfo saleOrgUnitInfo) throws TaskExternalException {
        data = data != null && data.toString().trim().length() >= 1 ? data : this.getContextParameter("number");
        RequirementPlanInfo caller = new RequirementPlanInfo();
        if (data == null || data.toString().trim().length() < 1) {
            boolean isHasCodingRule = this.hasCodingRule(ctx, (IObjectValue)caller, saleOrgUnitInfo.getId().toString());
            if (isHasCodingRule) {
                try {
                    data = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)caller, saleOrgUnitInfo.getId().toString());
                    this.getContextParameter().put("number", data);
                }
                catch (EASBizException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(this.getChannelImportResource("GETNUMBER_ERROR"));
                }
                catch (BOSException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(this.getChannelImportResource("GETNUMBER_ERROR"));
                }
            } else {
                throw new TaskExternalException(this.getChannelImportResource("CODINGRULE_UNDEFINED"));
            }
        }
        return data;
    }

    private boolean hasCodingRule(Context ctx, IObjectValue caller, String orgId) {
        try {
            if (orgId != null && orgId.trim().length() > 0 && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist(caller, orgId)) {
                return true;
            }
            String companyId = this.getNextCompanyId(ctx);
            return companyId != null && companyId.trim().length() > 0 && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist(caller, companyId);
        }
        catch (Exception err) {
            return false;
        }
    }

    private String getNextCompanyId(Context ctx) throws Exception {
        CompanyOrgUnitInfo comInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4");
        CtrlUnitInfo rootCU = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk);
        if (rootCU.isIsCompanyOrgUnit()) {
            comInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootCU.getId()));
        }
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    private boolean isExistMeasureUnit(Context ctx, String materialNumber, String unitNumber) {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as numbers from T_BD_MultiMeasureUnit t where t.fmaterialid = ");
        sql.append("(select max(fid) from T_BD_Material where fnumber = '").append(materialNumber).append("' group by fnumber) ");
        sql.append(" and t.FMeasureUnitID = ");
        sql.append("(select max(fid) from T_BD_MeasureUnit where fnumber = '").append(unitNumber).append("' group by fnumber)");
        try {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet != null) {
                while (rowSet.next()) {
                    int numbers = rowSet.getInt("numbers");
                    if (numbers <= 0) continue;
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
        return flag;
    }
}

