/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.basedata.scm.sd.channel.IChannelBase;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import com.kingdee.eas.scm.sd.channel.app.ReportBaseStrategy;
import com.kingdee.eas.scm.sd.channel.app.ReportInventoryStrategy;
import com.kingdee.eas.scm.sd.channel.app.ReportInvoiceStrategy;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelBillProperyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class SaleChannelInventoryHelper {
    private static String CONFIG_PATH = "saleChannelBillPropertyConfig.xml";
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.SaleChannelInventoryHelper");

    public void updateInventory(Context ctx, IObjectValue model, BizActionEnum actionEnum) throws Exception {
        ReportBaseStrategy strategy;
        SaleChannelBillProperyInfo channelInventoryInfo = this.getChannelInventoryInfo(model);
        if (channelInventoryInfo == null) {
            throw new Exception("the saleChannelBillPropertyConfig.xml doesn't contains the property of the billInfo,pls check it");
        }
        IChannelBase ichannelBase = ChannelBaseFactory.getLocalInstance((Context)ctx);
        ChannelBaseInfo channelBaseInfo = ichannelBase.getChannelBaseInfo((IObjectPK)new ObjectStringPK(((ChannelBaseInfo)model.get(channelInventoryInfo.getChannelProperty())).getId().toString()));
        HashMap<String, ChannelBaseInfo> params = new HashMap<String, ChannelBaseInfo>();
        params.put(channelInventoryInfo.getChannelProperty(), channelBaseInfo);
        if (channelBaseInfo.getDataCollectionType().equals((Object)DataCollectionTypeEnum.REPORTINSTORAGE) || channelBaseInfo.getDataCollectionType().equals((Object)DataCollectionTypeEnum.REPORTALL)) {
            strategy = new ReportInventoryStrategy(ctx, model, actionEnum, channelInventoryInfo, params);
            strategy.updateInventory();
        }
        if (channelBaseInfo.getDataCollectionType().equals((Object)DataCollectionTypeEnum.REPORTINSALE)) {
            strategy = new ReportInvoiceStrategy(ctx, model, actionEnum, channelInventoryInfo, params);
            strategy.updateInventory();
        }
    }

    private SaleChannelBillProperyInfo getChannelInventoryInfo(IObjectValue model) throws Exception {
        String bosType = BOSUuid.read((String)model.getString("id").toString()).getType().toString();
        XMLProcessor processor = new XMLProcessor();
        return processor.getSaleChannelInventoryInfo(bosType);
    }

    public static void main(String[] args) {
    }

    private ChannelInWarehsBillInfo createNewChannelInWarehsInfo() {
        ChannelInWarehsBillInfo inwares = new ChannelInWarehsBillInfo();
        inwares.setId(BOSUuid.create((String)"05F02018"));
        ChannelInWarehsBillEntryInfo inwarese = new ChannelInWarehsBillEntryInfo();
        inwarese.setId(BOSUuid.create((String)"F818473A"));
        inwarese.setBaseQty(new BigDecimal("100"));
        inwarese.setQty(new BigDecimal("100"));
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)"8PBGygEYEADgATYVwKg9FEQJ5/A="));
        MeasureUnitInfo unitInfo = new MeasureUnitInfo();
        unitInfo.setId(BOSUuid.read((String)"gw5fUwEOEADgAAvDwKgSOFuCXFc="));
        inwarese.setMaterial(materialInfo);
        inwarese.setUnit(unitInfo);
        inwarese.setAssistUnit(unitInfo);
        inwarese.setAssistQty(new BigDecimal("100"));
        inwarese.setBaseUnit(unitInfo);
        ChannelBaseInfo channelInfo = new ChannelBaseInfo();
        channelInfo.setId(BOSUuid.read((String)"lD4d1AEaEADgABFlwKgS4IVD5l4="));
        inwares.setChannel(channelInfo);
        inwares.getEntries().add(inwarese);
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        inwares.setBizDate(curDate);
        SaleOrgUnitInfo org = new SaleOrgUnitInfo();
        org.setId(BOSUuid.read((String)"4X1JYwEYEADgADLUwKg9FMznrtQ="));
        inwares.setSaleOrgUnit(org);
        return inwares;
    }

    class XMLProcessor {
        private Element xmlRoot;
        private String ELEMENT_SALEORGPROPERTY = "SaleOrgProperty";
        private String ELEMENT_CHANNELPROPERTY = "ChannelProperty";
        private String ELEMENT_MATERIALPROPERTY = "MaterialProperty";
        private String ELEMENT_ASSISTPROPERTY = "AssistProperty";
        private String ELEMENT_LOTPROPERTY = "LotProperty";
        private String ELEMENT_BASEQTYPROPERTY = "BaseQtyProperty";
        private String ELEMENT_BASEUNITPROPERTY = "BaseUnitProperty";
        private String ELEMENT_ASSISTQTYPROPERTY = "AssistQtyProperty";
        private String ELEMENT_ASSISTUNITPROPERTY = "AssistUnitProperty";
        private String ELEMENT_ENTRYSPROPERTY = "EntrysProperty";
        private String ELEMENT_BIZDATEPROPERTY = "BizDateProperty";
        private String ELEMENT_EXPIRYDATEPROPERTY = "ExpiryDateProperty";
        private String ELEMENT_PRODUCEDATEPROPERTY = "ProduceDateProperty";

        public Element getSaleChannelBillPropertyConfigInstance() throws Exception {
            if (this.xmlRoot == null) {
                InputStream is = null;
                try {
                    is = ReportBaseStrategy.class.getResourceAsStream(CONFIG_PATH);
                    this.xmlRoot = XMLParser.parseXML((InputStream)is).getRootElement();
                }
                finally {
                    if (is != null) {
                        this.safeClose(is);
                    }
                }
            }
            return this.xmlRoot;
        }

        public void safeClose(InputStream is) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }

        public SaleChannelBillProperyInfo getSaleChannelInventoryInfo(String bosType) throws Exception {
            this.xmlRoot = this.getSaleChannelBillPropertyConfigInstance();
            List childrens = this.xmlRoot.getChildren();
            SaleChannelBillProperyInfo saleChannelInventoryInfo = new SaleChannelBillProperyInfo();
            boolean isHasChannleInventoryInfoInXML = false;
            int size = childrens.size();
            for (int i = 0; i < size; ++i) {
                Element element = (Element)childrens.get(i);
                String xmlBosType = element.getAttributeValue("bosType");
                if (!xmlBosType.equals(bosType)) continue;
                String tableName = element.getAttributeValue("tableName");
                saleChannelInventoryInfo.setTableName(tableName);
                String tableEntryName = element.getAttributeValue("tableEntryName");
                saleChannelInventoryInfo.setTableEntryName(tableEntryName);
                saleChannelInventoryInfo.setBosType(element.getAttributeValue("bosType"));
                saleChannelInventoryInfo.setSaleOrgProperty(element.getChildText(this.ELEMENT_SALEORGPROPERTY));
                saleChannelInventoryInfo.setChannelProperty(element.getChildText(this.ELEMENT_CHANNELPROPERTY));
                saleChannelInventoryInfo.setMaterialProperty(element.getChildText(this.ELEMENT_MATERIALPROPERTY));
                saleChannelInventoryInfo.setAssistProperty(element.getChildText(this.ELEMENT_ASSISTPROPERTY));
                saleChannelInventoryInfo.setLotProperty(element.getChildText(this.ELEMENT_LOTPROPERTY));
                saleChannelInventoryInfo.setBaseQtyProperty(element.getChildText(this.ELEMENT_BASEQTYPROPERTY));
                saleChannelInventoryInfo.setBaseUnitProperty(element.getChildText(this.ELEMENT_BASEUNITPROPERTY));
                saleChannelInventoryInfo.setAssistQtyProperty(element.getChildText(this.ELEMENT_ASSISTQTYPROPERTY));
                saleChannelInventoryInfo.setAssistUnitProperty(element.getChildText(this.ELEMENT_ASSISTUNITPROPERTY));
                saleChannelInventoryInfo.setEntrysProperty(element.getChildText(this.ELEMENT_ENTRYSPROPERTY));
                saleChannelInventoryInfo.setBizDateProperty(element.getChildText(this.ELEMENT_BIZDATEPROPERTY));
                saleChannelInventoryInfo.setExpiryDateProperty(element.getChildText(this.ELEMENT_EXPIRYDATEPROPERTY));
                saleChannelInventoryInfo.setProduceDateProperty(element.getChildText(this.ELEMENT_PRODUCEDATEPROPERTY));
                isHasChannleInventoryInfoInXML = true;
            }
            if (isHasChannleInventoryInfoInXML) {
                return saleChannelInventoryInfo;
            }
            return null;
        }
    }
}

