/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.report.app.AbstractChannelInWarehouseTotalFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ChannelInWarehouseTotalFacadeControllerBean
extends AbstractChannelInWarehouseTotalFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.report.app.ChannelInWarehouseTotalFacadeControllerBean");
    boolean isChannel = true;
    private static final String ResClassName = "com.kingdee.eas.scm.sd.channel.report.ChannelRPTResource";
    private String ORGTEMPTABLE = "OrgTempTable";
    private String LEAFORGUNIT = "LEAFPURCHASEORGUNIT";
    private String MAXLEVEL = "maxLevelStr";
    private int TOTALGROPUBY;
    private String SUBLABEL;
    private String SUMLABEL;
    private String sp = "\r\n";
    private String CHANNEL;
    private String TERMINALCHANNEL;
    private String NEW_BOSID = "88888888";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        this.dropTable(params.getString("OrgTempTable"), ctx);
        String tempTable = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        String orgUnitTempTable = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        String stockTempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"17_ChannelInWarehouseTotalFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        String endStockTempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"18_ChannelInWarehouseTotalFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        if (params.getBoolean("IsOutWarehs")) {
            this.isChannel = false;
        }
        this.TOTALGROPUBY = new Integer(params.getString("kdcTotalGroupBy"));
        this.SUBLABEL = SCMUtils.getResource((String)ResClassName, (String)"SUB_LABEL", (Context)ctx);
        this.SUMLABEL = SCMUtils.getResource((String)ResClassName, (String)"SUM_LABEL", (Context)ctx);
        this.CHANNEL = SCMUtils.getResource((String)ResClassName, (String)"Channel", (Context)ctx);
        this.TERMINALCHANNEL = SCMUtils.getResource((String)ResClassName, (String)"TerminalChannel", (Context)ctx);
        params.setString("tempTable", tempTable);
        params.setString("OrgTempTable", orgUnitTempTable);
        params.setString("StockTempTable", stockTempTable);
        params.setString("ENDStockTempTable", endStockTempTable);
        this.buildSaleOrgTable(ctx, orgUnitTempTable, params);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setSaleOrderRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString(this.ORGTEMPTABLE, orgUnitTempTable);
        return result;
    }

    private void buildSaleOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fnumber varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(ctx.getLocale().getLanguage());
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] org = (Object[])params.getObject("fullOrgUnit");
        String[] sql = new String[org.length];
        int n = org.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)org[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)org[i]).get("level");
            String fnumber = (String)((FullOrgUnitInfo)org[i]).get("number");
            String fname = (String)((FullOrgUnitInfo)org[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)org[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)org[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (isleaf.booleanValue()) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fnumber,fname_");
            sqlbf.append(ctx.getLocale().getLanguage());
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fnumber != null) {
                sqlbf.append("'" + fnumber + "',");
            } else {
                sqlbf.append("null,");
            }
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.LEAFORGUNIT, (Object)v.toArray());
        params.setObject(this.MAXLEVEL, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String createSql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, createSql);
        String stockTempTable = params.getString("StockTempTable");
        String endTempTable = params.getString("ENDStockTempTable");
        String endStockSql = this.getCreateEndStock(endTempTable, params);
        this.executeSQL(ctx, endStockSql);
        String qtyEndStock = this.getEndQtyFromStockBill(endTempTable, params, ctx);
        this.executeUpdate(qtyEndStock, null, ctx);
        String qtyInitStock = this.getInitQtyFromStockBill(endTempTable, params, ctx);
        this.executeUpdate(qtyInitStock, null, ctx);
        String qtyInStock = this.getQtyFromInWarehsBill(endTempTable, params, ctx);
        this.executeUpdate(qtyInStock, null, ctx);
        SqlParams sqlParams = new SqlParams();
        this.setRPTData(sqlParams, params);
        String insertSql = this.getInsertSql(params, tempTable, ctx);
        this.executeUpdate(insertSql, sqlParams, ctx);
        this.insertGroupData(params, tempTable, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer createsql = new StringBuffer();
        createsql.append("Create Table " + tempTable + "(\r\n");
        createsql.append("FID Varchar(44) \r\n");
        createsql.append(",FsaleOrgID Varchar(44) \r\n");
        createsql.append(",FsaleOrgNumber Varchar(80) \r\n");
        createsql.append(",FsaleOrgNumberCopy Varchar(80) \r\n");
        createsql.append(",FsaleOrgNumberSort Varchar(80) \r\n");
        createsql.append(",FsaleOrgName Varchar(80) \r\n");
        createsql.append(",FChaTypeID Varchar(44) \r\n");
        createsql.append(",FChaTypeNumber Varchar(80) \r\n");
        createsql.append(",FChaTypeNumberCopy Varchar(80) \r\n");
        createsql.append(",FChaTypeNumberSort Varchar(80) \r\n");
        createsql.append(",FChaTypeName Varchar(80) \r\n");
        createsql.append(",FchannelBaseID Varchar(44) \r\n");
        createsql.append(",FchannelBaseNumber Varchar(80) \r\n");
        createsql.append(",FchannelBaseNumberCopy Varchar(80) \r\n");
        createsql.append(",FchannelBaseNumberSort Varchar(80) \r\n");
        createsql.append(",FchannelBaseName Varchar(80) \r\n");
        createsql.append(",FMaterialID Varchar(44) \r\n");
        createsql.append(",FMaterialNumber Varchar(80) \r\n");
        createsql.append(",FMaterialNumberCopy Varchar(80) \r\n");
        createsql.append(",FMaterialNumberSort Varchar(80) \r\n");
        createsql.append(",FMaterialName Varchar(80) \r\n");
        createsql.append(",FBaseUnitID Varchar(44) \r\n");
        createsql.append(",FBaseUnitName Varchar(80) \r\n");
        createsql.append(",FBaseSaleQty  Decimal(28,10)\r\n");
        createsql.append(",FUnitID Varchar(44) \r\n");
        createsql.append(",FUnitName Varchar(44) \r\n");
        createsql.append(",FSaleQty  Decimal(28,10)\r\n");
        createsql.append(",FPrice  Decimal(28,10)\r\n");
        createsql.append(",FAmount  Decimal(28,10)\r\n");
        createsql.append(",FCurrencyID  Varchar(80)\r\n");
        createsql.append(",FFLag  Varchar(10)\r\n");
        createsql.append(");\r\n");
        return createsql.toString();
    }

    private String getCreateTempStock(String tempTable, RptParams params) {
        StringBuffer createsql = new StringBuffer();
        createsql.append("Create Table " + tempTable + "(\r\n");
        createsql.append("FID Varchar(44) \r\n");
        createsql.append(",FCurrencyID Varchar(44) \r\n");
        createsql.append(",FsaleOrgID Varchar(44) \r\n");
        createsql.append(",FChaTypeID Varchar(44) \r\n");
        createsql.append(",FchannelBaseID Varchar(44) \r\n");
        createsql.append(",FMaterialID Varchar(44) \r\n");
        createsql.append(",FBaseUnitID Varchar(44) \r\n");
        createsql.append(",FBaseSaleQty  Decimal(28,10)\r\n");
        createsql.append(",FUnitID Varchar(80) \r\n");
        createsql.append(",FSaleQty  Decimal(28,10)\r\n");
        createsql.append(",FAmount  Decimal(28,10)\r\n");
        createsql.append(")");
        return createsql.toString();
    }

    private String getCreateEndStock(String tempTable, RptParams params) {
        StringBuffer createsql = new StringBuffer();
        createsql.append("Create Table " + tempTable + "(\r\n");
        createsql.append("FID Varchar(44) \r\n");
        createsql.append(",FCurrencyID Varchar(44) \r\n");
        createsql.append(",FsaleOrgID Varchar(44) \r\n");
        createsql.append(",FChaTypeID Varchar(44) \r\n");
        createsql.append(",FchannelBaseID Varchar(44) \r\n");
        createsql.append(",FMaterialID Varchar(44) \r\n");
        createsql.append(",FBaseUnitID Varchar(80) \r\n");
        createsql.append(",FInBaseQty  Decimal(28,10)\r\n");
        createsql.append(",FInitBaseQty  Decimal(28,10)\r\n");
        createsql.append(",FEndBaseQty  Decimal(28,10)\r\n");
        createsql.append(")");
        return createsql.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("ChannelFrom") != null) {
            sqlParams.setString(count++, params.getString("ChannelFrom"));
        }
        if (params.getString("ChannelTo") != null) {
            sqlParams.setString(count++, params.getString("ChannelTo"));
        }
        if (params.getString("materialFrom") != null) {
            sqlParams.setString(count++, params.getString("materialFrom"));
        }
        if (params.getString("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
    }

    private String getInsertSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer();
        String qtyFromsaleIssue = this.getQtyFromSaleIssueBill(params, tableName, ctx);
        String qtyFromJXC = this.getQtyFromJXCBill(params, tableName, ctx);
        String qtyFromStock = this.getQtyFromStockTemp(params, tableName, ctx);
        insertSql.append("insert into ");
        insertSql.append(tableName);
        insertSql.append("\n select");
        insertSql.append("\n newbosid('").append(this.NEW_BOSID).append("') FID");
        insertSql.append("\n ,temp.FsaleOrgID FsaleOrgID");
        insertSql.append("\n ,temp.FsaleOrgNumber FsaleOrgNumber");
        insertSql.append("\n ,temp.FsaleOrgNumber FsaleOrgNumberCopy");
        insertSql.append("\n ,'00' FsaleOrgNumberSort");
        insertSql.append("\n ,temp.FSaleOrgName");
        insertSql.append("\n ,temp.FChaTypeID FChaTypeID");
        insertSql.append("\n ,temp.FChaTypeNumber FChaTypeNumber");
        insertSql.append("\n ,temp.FChaTypeNumber FChaTypeNumberCopy");
        insertSql.append("\n ,'00' FChaTypeNumberSort");
        insertSql.append("\n ,temp.FChaTypeName");
        insertSql.append("\n ,temp.FchannelBaseID FchannelBaseID");
        insertSql.append("\n ,temp.FchannelBaseNumber FchannelBaseNumber");
        insertSql.append("\n ,temp.FchannelBaseNumber FchannelBaseNumberCopy");
        insertSql.append("\n ,'00' FchannelBaseNumberSort");
        insertSql.append("\n ,temp.FchannelBaseName");
        insertSql.append("\n ,temp.FMaterialID FMaterialID");
        insertSql.append("\n ,temp.FMaterialNumber FMaterialNumber");
        insertSql.append("\n ,temp.FMaterialNumber FMaterialNumberCopy");
        insertSql.append("\n ,'00' FMaterialNumberSort");
        insertSql.append("\n ,temp.FMaterialName");
        insertSql.append("\n ,temp.FBaseUnitID FBaseUnitID");
        insertSql.append("\n ,Baseunit.FName_").append(ctx.getLocale().getLanguage()).append(" FBaseUnitName");
        insertSql.append("\n ,Sum(temp.FBaseQty) FTotalBaseQty");
        insertSql.append("\r\n ,MatSales.FUnitID FUnitID");
        insertSql.append("\n ,Unit.FName_").append(ctx.getLocale().getLanguage()).append(" FUnitName");
        insertSql.append("\r\n ,sum(TO_DECIMAL(CASE WHEN multiUnit.FBaseConvsRate =0 THEN 0 ");
        insertSql.append(" WHEN multiUnit.FBaseConvsRate =1 THEN temp.FBaseQty ELSE ");
        insertSql.append(" temp.FBaseQty/multiUnit.FBaseConvsRate END,31,7)) FTotalQty ");
        insertSql.append("\n ,AVG(matBasePrice.FPrice) FPrice");
        insertSql.append("\n ,Sum(matBasePrice.FPrice*temp.FBaseQty) FTotalAmount");
        insertSql.append("\r\n ,temp.FCurrencyID FCurrencyID");
        insertSql.append("\n ,'000' FFLag");
        insertSql.append("\n from (");
        insertSql.append("\n " + qtyFromsaleIssue);
        insertSql.append("\n union all ");
        insertSql.append("\n " + qtyFromJXC);
        insertSql.append("\n union all ");
        insertSql.append("\n " + qtyFromStock);
        insertSql.append("\n ) temp");
        insertSql.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        insertSql.append(" ON temp.FsaleOrgID = saleOrg.FID");
        insertSql.append("\n INNER JOIN T_BD_MaterialSales MatSales");
        insertSql.append("\n ON  temp.FMaterialID = matsales.FMaterialID");
        insertSql.append("\n AND temp.FsaleOrgID =  matsales.FOrgUnit");
        insertSql.append("\n INNER JOIN T_BD_MultiMeasureUnit multiUnit");
        insertSql.append("\n ON MatSales.FUnitID = multiUnit.FMeasureUnitID");
        insertSql.append("\n AND temp.FMaterialID = multiUnit.FMaterialID");
        insertSql.append("\r\n  INNER JOIN T_BD_MeasureUnit Baseunit");
        insertSql.append(" ON temp.FBaseUnitID = Baseunit.FID");
        insertSql.append("\r\n  INNER JOIN T_BD_MeasureUnit unit");
        insertSql.append(" ON MatSales.FUnitID = unit.FID");
        insertSql.append("\r\n LEFT OUTER JOIN T_SD_MaterialBasePrice matBasePrice ");
        insertSql.append("\r\n ON temp.FMaterialID = matBasePrice.FMaterialID");
        insertSql.append("\r\n AND temp.FCurrencyID =matBasePrice.FCurrencyID");
        insertSql.append("\r\n AND temp.FChaTypeID = matBasePrice.FChannelTypeID");
        insertSql.append("\r\n AND temp.FBaseUnitID = matBasePrice.FUnitID");
        insertSql.append("\r\n AND saleOrg.FControlUnitID = matBasePrice.FAdminCUID");
        insertSql.append("\n GROUP BY ");
        insertSql.append("\n temp.FCurrencyID");
        insertSql.append("\n ,temp.FsaleOrgID");
        insertSql.append("\n ,temp.FsaleOrgNumber");
        insertSql.append("\n ,temp.FSaleOrgName");
        insertSql.append("\n ,temp.FChaTypeID");
        insertSql.append("\n ,temp.FChaTypeNumber");
        insertSql.append("\n ,temp.FChaTypeName");
        insertSql.append("\n ,temp.FchannelBaseID");
        insertSql.append("\n ,temp.FchannelBaseNumber");
        insertSql.append("\n ,temp.FchannelBaseName");
        insertSql.append("\n ,temp.FMaterialID");
        insertSql.append("\n ,temp.FMaterialNumber");
        insertSql.append("\n ,temp.FMaterialName");
        insertSql.append("\n ,temp.FBaseUnitID");
        insertSql.append("\n ,Baseunit.FName_").append(ctx.getLocale().getLanguage());
        insertSql.append("\n ,MatSales.FUnitID");
        insertSql.append("\n ,Unit.FName_").append(ctx.getLocale().getLanguage());
        return insertSql.toString();
    }

    private String getQtyFromInWarehsBill(String tempTableName, RptParams params, Context ctx) throws BOSException, EASBizException {
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\n newbosid('").append(this.NEW_BOSID).append("') FID");
        selCols.append("\r\n ,bill.FCurrencyID FCurrencyID");
        selCols.append("\r\n ,org.FID FORGID");
        selCols.append(" \r\n ,saleInfo.FChannelTypeID FChaTypeID");
        selCols.append(" \r\n ,chaBase.FID FchaID");
        selCols.append(" \r\n ,Material.FID FMatID");
        selCols.append("\r\n ,ENTRIES.FBaseUnitID FBaseUnitID");
        selCols.append("\r\n ,entries.FBaseQty FInBaseQty ");
        selCols.append("\r\n ,0 FInitBaseQty ");
        selCols.append("\r\n ,0 FEndBaseQty ");
        fromTable.append("\r\n FROM T_CHA_ChannelInWarehsBill AS bill");
        fromTable.append("\r\n  INNER JOIN T_CHA_ChannelInWarehsBillentry AS ENTRIES");
        fromTable.append("\r\n  ON bill.FID = ENTRIES.FParentID");
        fromTable.append("\r\n  INNER JOIN T_BD_Material Material");
        fromTable.append("\r\n  ON ENTRIES.FMaterialID = Material.FID");
        fromTable.append("\r\n  INNER JOIN ");
        fromTable.append(params.getString("OrgTempTable"));
        fromTable.append(" ORG");
        fromTable.append("\r\n   ON bill.FSaleOrgUnitID = ORG.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        fromTable.append("\r\n  ON bill.FChannelID = chaBase.FID");
        fromTable.append("\r\n  AND chaBase.FDataCollectionType = '2'");
        fromTable.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        fromTable.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        fromTable.append("\r\n ON chaBase.FID = saleInfo.FChannelBaseID");
        fromTable.append("\r\n  and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        StringBuffer saleOrderStr = new StringBuffer();
        String begindate = null;
        String enddate = null;
        begindate = params.getString("dateStart");
        enddate = params.getString("dateEnd");
        saleOrderStr.append("\r\n where ");
        saleOrderStr.append("\n bill.Fbasestatus =4 ");
        saleOrderStr.append("\n AND bill.FInWarehsType <> 2 ");
        saleOrderStr.append("\n AND Bill.FBizDate  >= {" + begindate + "} \n AND Bill.FBizDate <= {" + enddate + "}");
        if (params.getString("ChannelFrom") != null) {
            saleOrderStr.append("\n AND chaBase.FNumber >= '");
            saleOrderStr.append(params.getString("ChannelFrom"));
            saleOrderStr.append("'");
        }
        if (params.getString("ChannelTo") != null) {
            saleOrderStr.append("\n AND chaBase.FNumber <= '");
            saleOrderStr.append(params.getString("ChannelTo"));
            saleOrderStr.append("'");
        }
        if (params.getString("materialFrom") != null) {
            saleOrderStr.append("\n AND  material.FNumber >='");
            saleOrderStr.append(params.getString("materialFrom"));
            saleOrderStr.append("'");
        }
        if (params.getString("materialTo") != null) {
            saleOrderStr.append("\n AND  material.FNumber <='");
            saleOrderStr.append(params.getString("materialTo"));
            saleOrderStr.append("'");
        }
        StringBuffer tempSql = new StringBuffer();
        tempSql.append(" INSERT INTO ");
        tempSql.append(tempTableName);
        tempSql.append("\n select ");
        tempSql.append("\n " + selCols);
        tempSql.append(fromTable);
        tempSql.append("\n " + saleOrderStr);
        return tempSql.toString();
    }

    private String getQtyFromSaleIssueBill(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\r\n org.FID FsaleOrgID");
        selCols.append("\n ,ORG.FNumber FsaleOrgNumber");
        selCols.append("\n ,ORG.FName_").append(ctx.getLocale().getLanguage()).append(" FSaleOrgName");
        selCols.append(" \r\n ,ChaType.FID FChaTypeID");
        selCols.append("\n ,ChaType.FNumber FChaTypeNumber");
        selCols.append("\n ,ChaType.FName_").append(ctx.getLocale().getLanguage()).append(" FChaTypeName");
        selCols.append(" \r\n ,chaBase.FID FchannelBaseID");
        selCols.append("\n ,ChaBase.FNumber FchannelBaseNumber");
        selCols.append("\n ,ChaBase.FName_").append(ctx.getLocale().getLanguage()).append(" FchannelBaseName");
        selCols.append(" \r\n ,Material.FID FMaterialID");
        selCols.append("\n ,Material.FNumber FMaterialNumber");
        selCols.append("\n ,Material.FName_").append(ctx.getLocale().getLanguage()).append(" FMaterialName");
        selCols.append("\r\n ,ENTRIES.FBaseUnitID FBaseUnitID");
        selCols.append("\r\n ,entries.FBaseQty FBaseQty ");
        selCols.append("\r\n ,bill.FCurrencyID FCurrencyID");
        fromTable.append("\r\n FROM T_CHA_ChannelSaleIssueBill AS bill");
        fromTable.append("\r\n  INNER JOIN T_CHA_ChannelSaleIssueentry AS ENTRIES");
        fromTable.append(" ON bill.FID = ENTRIES.FParentID");
        fromTable.append("\r\n  INNER JOIN T_BD_Material Material");
        fromTable.append(" ON ENTRIES.FMaterialID = Material.FID");
        fromTable.append("\r\n  INNER JOIN ");
        fromTable.append(params.getString("OrgTempTable"));
        fromTable.append(" ORG");
        fromTable.append("  ON bill.FSaleOrgUnitID = ORG.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        fromTable.append(" ON bill.FChannelID = chaBase.FID");
        fromTable.append(" AND chaBase.FDataCollectionType = '1'");
        fromTable.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        fromTable.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        fromTable.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        fromTable.append(" and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelType ChaType");
        fromTable.append(" ON saleInfo.FChannelTypeID = ChaType.FID");
        String saleOrderStr = this.getQueryStr(params, "bill", ctx);
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n SELECT");
        tempSql.append("\n " + selCols);
        tempSql.append(fromTable);
        tempSql.append("\n " + saleOrderStr);
        tempSql.append("\n AND bill.FSaleIssueType =1 ");
        return tempSql.toString();
    }

    private String getQtyFromJXCBill(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\r\n org.FID FsaleOrgID");
        selCols.append("\n ,ORG.FNumber FsaleOrgNumber");
        selCols.append("\n ,ORG.FName_").append(ctx.getLocale().getLanguage()).append(" FSaleOrgName");
        selCols.append(" \r\n ,ChaType.FID FChaTypeID");
        selCols.append("\n ,ChaType.FNumber FChaTypeNumber");
        selCols.append("\n ,ChaType.FName_").append(ctx.getLocale().getLanguage()).append(" FChaTypeName");
        selCols.append(" \r\n ,chaBase.FID FchannelBaseID");
        selCols.append("\n ,ChaBase.FNumber FchannelBaseNumber");
        selCols.append("\n ,ChaBase.FName_").append(ctx.getLocale().getLanguage()).append(" FchannelBaseName");
        selCols.append(" \r\n ,Material.FID FMaterialID");
        selCols.append("\n ,Material.FNumber FMaterialNumber");
        selCols.append("\n ,Material.FName_").append(ctx.getLocale().getLanguage()).append(" FMaterialName");
        selCols.append("\r\n ,ENTRIES.FBaseUnitID FBaseUnitID");
        selCols.append("\r\n ,entries.FBaseOutQty FBaseQty ");
        selCols.append("\r\n ,bill.FCurrencyID FCurrencyID");
        fromTable.append("\r\n FROM T_CHA_ChannelJXCBill AS bill");
        fromTable.append("\r\n  INNER JOIN T_CHA_ChannelJXCBillentry AS ENTRIES");
        fromTable.append(" ON bill.FID = ENTRIES.FParentID");
        fromTable.append("\r\n  INNER JOIN T_BD_Material Material");
        fromTable.append(" ON ENTRIES.FMaterialID = Material.FID");
        fromTable.append("\r\n  INNER JOIN ");
        fromTable.append(params.getString("OrgTempTable"));
        fromTable.append(" ORG");
        fromTable.append("  ON bill.FSaleOrgUnitID = ORG.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        fromTable.append(" ON bill.FChannelID = chaBase.FID");
        fromTable.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        fromTable.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        fromTable.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        fromTable.append(" and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelType ChaType");
        fromTable.append(" ON saleInfo.FChannelTypeID = ChaType.FID");
        StringBuffer fromChaTable = new StringBuffer();
        fromChaTable.append("\r\n FROM T_CHA_ChannelJXCBill AS bill");
        fromChaTable.append("\r\n  INNER JOIN T_CHA_ChannelJXCBillentry AS ENTRIES");
        fromChaTable.append(" ON bill.FID = ENTRIES.FParentID");
        fromChaTable.append("\r\n  INNER JOIN T_BD_Material Material");
        fromChaTable.append(" ON ENTRIES.FMaterialID = Material.FID");
        fromChaTable.append("\r\n  INNER JOIN ");
        fromChaTable.append(params.getString("OrgTempTable"));
        fromChaTable.append(" ORG");
        fromChaTable.append("  ON bill.FSaleOrgUnitID = ORG.FID");
        fromChaTable.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        fromChaTable.append(" ON bill.FChannelID = chaBase.FID");
        fromChaTable.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        fromChaTable.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        fromChaTable.append("\r\n  INNER JOIN T_BD_TerminalSaleInfo saleInfo");
        fromChaTable.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        fromChaTable.append(" and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        fromChaTable.append("\r\n  INNER JOIN T_BD_ChannelType ChaType");
        fromChaTable.append(" ON saleInfo.FChannelTypeID = ChaType.FID");
        String begindate = params.getString("dateStart");
        String enddate = params.getString("dateEnd");
        StringBuffer dateFilter = new StringBuffer();
        dateFilter.append("\n Where ");
        dateFilter.append("\n ( (bill.FStartDate >={" + begindate + "}");
        dateFilter.append("\n AND bill.FStartDate <={" + enddate + "})");
        dateFilter.append("\n OR ");
        dateFilter.append("\n (bill.FEndDate >={" + begindate + "}");
        dateFilter.append("\n AND bill.FEndDate <={" + enddate + "}) )");
        if (params.getString("ChannelFrom") != null) {
            dateFilter.append("\n AND chaBase.FNumber >= '");
            dateFilter.append(params.getString("ChannelFrom"));
            dateFilter.append("'");
        }
        if (params.getString("ChannelTo") != null) {
            dateFilter.append("\n AND chaBase.FNumber <= '");
            dateFilter.append(params.getString("ChannelTo"));
            dateFilter.append("'");
        }
        if (params.getString("materialFrom") != null) {
            dateFilter.append("\n AND material.FNumber >= '");
            dateFilter.append(params.getString("materialFrom"));
            dateFilter.append("'");
        }
        if (params.getString("materialTo") != null) {
            dateFilter.append("\n AND material.FNumber <= '");
            dateFilter.append(params.getString("materialTo"));
            dateFilter.append("'");
        }
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n SELECT ");
        tempSql.append("\n " + selCols);
        tempSql.append(fromTable);
        tempSql.append("\n " + dateFilter);
        tempSql.append("\n UNION ALL ");
        tempSql.append("\n SELECT ");
        tempSql.append("\n " + selCols);
        tempSql.append(fromChaTable);
        tempSql.append("\n " + dateFilter);
        return tempSql.toString();
    }

    private String getEndQtyFromStockBill(String tempTableName, RptParams params, Context ctx) throws BOSException, EASBizException {
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\n newbosid('").append(this.NEW_BOSID).append("') FID");
        selCols.append("\r\n ,bill.FCurrencyID FCurrencyID");
        selCols.append("\r\n ,org.FID FORGID");
        selCols.append(" \r\n ,saleInfo.FChannelTypeID FChaTypeID");
        selCols.append(" \r\n ,chaBase.FID FchaID");
        selCols.append(" \r\n ,ENTRIES.FMaterialID FMatID");
        selCols.append("\r\n ,ENTRIES.FBaseUnitID FBaseUnitID");
        selCols.append("\r\n ,0 FInBaseQty ");
        selCols.append("\r\n ,0 FInitBaseQty ");
        selCols.append("\r\n ,entries.FBaseQty FEndBaseQty ");
        fromTable.append("\r\n FROM T_CHA_ChannelStockBill AS bill");
        fromTable.append("\r\n  INNER JOIN T_CHA_ChannelStockBillentry AS ENTRIES");
        fromTable.append(" ON bill.FID = ENTRIES.FParentID");
        fromTable.append("\r\n  INNER JOIN ");
        fromTable.append(params.getString("OrgTempTable"));
        fromTable.append(" ORG");
        fromTable.append("  ON bill.FSaleOrgUnitID = ORG.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        fromTable.append(" ON bill.FChannelID = chaBase.FID");
        fromTable.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        fromTable.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        fromTable.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        fromTable.append(" and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        StringBuffer maxDateSQL = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        StringBuffer enddate = new StringBuffer();
        enddate.append(params.getString("dateEnd"));
        enddate.setLength(10);
        enddate.append(" 00:00:00.0");
        filter.append("\r\n where ");
        filter.append("\n bill.Fbasestatus =4 ");
        filter.append("\n AND Bill.FBizDate >= {" + enddate + "}");
        if (params.getString("ChannelFrom") != null) {
            filter.append("\n AND chaBase.FNumber >= '");
            filter.append(params.getString("ChannelFrom"));
            filter.append("'");
        }
        if (params.getString("ChannelTo") != null) {
            filter.append("\n AND chaBase.FNumber <= '");
            filter.append(params.getString("ChannelTo"));
            filter.append("'");
        }
        if (params.getString("materialFrom") != null) {
            filter.append("\n AND material.FNumber >= '");
            filter.append(params.getString("materialFrom"));
            filter.append("'");
        }
        if (params.getString("materialTo") != null) {
            filter.append("\n AND material.FNumber <= '");
            filter.append(params.getString("materialTo"));
            filter.append("'");
        }
        maxDateSQL.append("SELECT ");
        maxDateSQL.append("\n bill.FSaleOrgUnitID ForgID,saleInfo.FChannelTypeID FChaTypeID");
        maxDateSQL.append("\n ,bill.FChannelID FChannelID,ENTRIES.FMaterialID FMaterialID");
        maxDateSQL.append("\n ,ENTRIES.FBaseUnitID FBaseUnitID");
        maxDateSQL.append("\n ,MIN(bill.FBizDate) FMaxBizDate");
        maxDateSQL.append("\r\n FROM T_CHA_ChannelStockBill AS bill");
        maxDateSQL.append("\r\n  INNER JOIN T_CHA_ChannelStockBillentry AS ENTRIES");
        maxDateSQL.append(" ON bill.FID = ENTRIES.FParentID");
        maxDateSQL.append("\r\n  INNER JOIN T_BD_Material Material");
        maxDateSQL.append(" ON ENTRIES.FMaterialID = Material.FID");
        maxDateSQL.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        maxDateSQL.append(" ON bill.FChannelID = chaBase.FID");
        maxDateSQL.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        maxDateSQL.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        maxDateSQL.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        maxDateSQL.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        maxDateSQL.append(" and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        maxDateSQL.append("\n " + filter);
        maxDateSQL.append("\n GROUP BY ");
        maxDateSQL.append("\n bill.FSaleOrgUnitID,saleInfo.FChannelTypeID");
        maxDateSQL.append("\n ,bill.FChannelID,ENTRIES.FMaterialID");
        maxDateSQL.append("\n ,ENTRIES.FBaseUnitID");
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n INSERT INTO ");
        tempSql.append(tempTableName);
        tempSql.append("\n SELECT ");
        tempSql.append("\n " + selCols);
        tempSql.append(fromTable);
        tempSql.append("\n INNER JOIN (");
        tempSql.append("\n " + maxDateSQL);
        tempSql.append("\n ) MaxTemp ");
        tempSql.append("\n ON MaxTemp.ForgID = bill.FSaleOrgUnitID");
        tempSql.append("\n AND MaxTemp.FChaTypeID = saleInfo.FChannelTypeID");
        tempSql.append("\n AND MaxTemp.FChannelID = bill.FChannelID");
        tempSql.append("\n AND MaxTemp.FMaterialID = ENTRIES.FMaterialID");
        tempSql.append("\n AND MaxTemp.FBaseUnitID = ENTRIES.FBaseUnitID");
        tempSql.append("\n AND MaxTemp.FMaxBizDate = bill.FBizDate ");
        return tempSql.toString();
    }

    private String getQtyFromStockTemp(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\r\n org.FID FsaleOrgID");
        selCols.append("\n ,ORG.FNumber FsaleOrgNumber");
        selCols.append("\n ,ORG.FName_").append(ctx.getLocale().getLanguage()).append(" FSaleOrgName");
        selCols.append(" \r\n ,ChaType.FID FChaTypeID");
        selCols.append("\n ,ChaType.FNumber FChaTypeNumber");
        selCols.append("\n ,ChaType.FName_").append(ctx.getLocale().getLanguage()).append(" FChaTypeName");
        selCols.append(" \r\n ,chaBase.FID FchannelBaseID");
        selCols.append("\n ,ChaBase.FNumber FchannelBaseNumber");
        selCols.append("\n ,ChaBase.FName_").append(ctx.getLocale().getLanguage()).append(" FchannelBaseName");
        selCols.append(" \r\n ,Material.FID FMaterialID");
        selCols.append("\n ,Material.FNumber FMaterialNumber");
        selCols.append("\n ,Material.FName_").append(ctx.getLocale().getLanguage()).append(" FMaterialName");
        selCols.append("\r\n ,bill.FBaseUnitID FBaseUnitID");
        selCols.append("\r\n ,sum((bill.FInitBaseQty + bill.FInBaseQty - bill.FEndBaseQty )) FBaseQty ");
        selCols.append("\r\n ,bill.FCurrencyID FCurrencyID");
        fromTable.append("\r\n FROM ");
        fromTable.append(params.getString("ENDStockTempTable") + " bill ");
        fromTable.append("\r\n  INNER JOIN T_BD_Material Material");
        fromTable.append(" ON bill.FMaterialID = Material.FID");
        fromTable.append("\r\n  INNER JOIN ");
        fromTable.append(params.getString("OrgTempTable"));
        fromTable.append(" ORG");
        fromTable.append("  ON bill.FsaleOrgID = ORG.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        fromTable.append(" ON bill.FchannelBaseID = chaBase.FID");
        fromTable.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        fromTable.append(" ON bill.FsaleOrgID = saleOrg.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        fromTable.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        fromTable.append(" and saleInfo.FSaleOrgUnitID = bill.FsaleOrgID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelType ChaType");
        fromTable.append(" ON saleInfo.FChannelTypeID = ChaType.FID");
        StringBuffer groupby = new StringBuffer();
        groupby.append("\r\n bill.FCurrencyID");
        groupby.append("\r\n ,org.FID");
        groupby.append("\n ,ORG.FNumber");
        groupby.append("\n ,ORG.FName_").append(ctx.getLocale().getLanguage());
        groupby.append(" \r\n ,ChaType.FID");
        groupby.append("\n ,ChaType.FNumber");
        groupby.append("\n ,ChaType.FName_").append(ctx.getLocale().getLanguage());
        groupby.append(" \r\n ,chaBase.FID");
        groupby.append("\n ,ChaBase.FNumber");
        groupby.append("\n ,ChaBase.FName_").append(ctx.getLocale().getLanguage());
        groupby.append(" \r\n ,Material.FID");
        groupby.append("\n ,Material.FNumber");
        groupby.append("\n ,Material.FName_").append(ctx.getLocale().getLanguage());
        groupby.append("\r\n ,bill.FBaseUnitID");
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n SELECT");
        tempSql.append("\n " + selCols);
        tempSql.append(fromTable);
        tempSql.append("\n GROUP BY ");
        tempSql.append(groupby);
        return tempSql.toString();
    }

    private String getInitQtyFromStockBill(String tempTableName, RptParams params, Context ctx) throws BOSException, EASBizException {
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\n newbosid('").append(this.NEW_BOSID).append("') FID");
        selCols.append("\r\n ,bill.FCurrencyID FCurrencyID");
        selCols.append("\r\n ,org.FID FORGID");
        selCols.append(" \r\n ,saleInfo.FChannelTypeID FChaTypeID");
        selCols.append(" \r\n ,chaBase.FID FchaID");
        selCols.append(" \r\n ,ENTRIES.FMaterialID FMatID");
        selCols.append("\r\n ,ENTRIES.FBaseUnitID FBaseUnitID");
        selCols.append("\r\n ,0 FInBaseQty ");
        selCols.append("\r\n ,entries.FBaseQty FInitBaseQty ");
        selCols.append("\r\n ,0 FEndBaseQty ");
        fromTable.append("\r\n FROM T_CHA_ChannelStockBill AS bill");
        fromTable.append("\r\n  INNER JOIN T_CHA_ChannelStockBillentry AS ENTRIES");
        fromTable.append(" ON bill.FID = ENTRIES.FParentID");
        fromTable.append("\r\n  INNER JOIN ");
        fromTable.append(params.getString("OrgTempTable"));
        fromTable.append(" ORG");
        fromTable.append("  ON bill.FSaleOrgUnitID = ORG.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        fromTable.append(" ON bill.FChannelID = chaBase.FID");
        fromTable.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        fromTable.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        fromTable.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        fromTable.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        fromTable.append(" and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        StringBuffer maxDateSQL = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        String begindate = params.getString("dateStart");
        filter.append("\r\n where ");
        filter.append("\n bill.Fbasestatus =4 ");
        filter.append("\n AND Bill.FBizDate < {" + begindate + "}");
        if (params.getString("ChannelFrom") != null) {
            filter.append("\n AND chaBase.FNumber >= '");
            filter.append(params.getString("ChannelFrom"));
            filter.append("'");
        }
        if (params.getString("ChannelTo") != null) {
            filter.append("\n AND chaBase.FNumber <= '");
            filter.append(params.getString("ChannelTo"));
            filter.append("'");
        }
        if (params.getString("materialFrom") != null) {
            filter.append("\n AND material.FNumber >= '");
            filter.append(params.getString("materialFrom"));
            filter.append("'");
        }
        if (params.getString("materialTo") != null) {
            filter.append("\n AND material.FNumber <= '");
            filter.append(params.getString("materialTo"));
            filter.append("'");
        }
        maxDateSQL.append("SELECT ");
        maxDateSQL.append("\n bill.FSaleOrgUnitID ForgID,saleInfo.FChannelTypeID FChaTypeID");
        maxDateSQL.append("\n ,bill.FChannelID FChannelID,ENTRIES.FMaterialID FMaterialID");
        maxDateSQL.append("\n ,ENTRIES.FBaseUnitID FBaseUnitID");
        maxDateSQL.append("\n ,Max(bill.FBizDate) FMaxBizDate");
        maxDateSQL.append("\r\n FROM T_CHA_ChannelStockBill AS bill");
        maxDateSQL.append("\r\n  INNER JOIN T_CHA_ChannelStockBillentry AS ENTRIES");
        maxDateSQL.append(" ON bill.FID = ENTRIES.FParentID");
        maxDateSQL.append("\r\n  INNER JOIN T_BD_Material Material");
        maxDateSQL.append(" ON ENTRIES.FMaterialID = Material.FID");
        maxDateSQL.append("\r\n  INNER JOIN T_BD_ChannelBase chaBase");
        maxDateSQL.append(" ON bill.FChannelID = chaBase.FID");
        maxDateSQL.append("\r\n  INNER JOIN T_ORG_sale saleOrg");
        maxDateSQL.append(" ON bill.FSaleOrgUnitID = saleOrg.FID");
        maxDateSQL.append("\r\n  INNER JOIN T_BD_ChannelSaleInfo saleInfo");
        maxDateSQL.append(" ON chaBase.FID = saleInfo.FChannelBaseID");
        maxDateSQL.append(" and saleInfo.FSaleOrgUnitID = bill.FSaleOrgUnitID");
        maxDateSQL.append("\n " + filter);
        maxDateSQL.append("\n GROUP BY ");
        maxDateSQL.append("\n bill.FSaleOrgUnitID,saleInfo.FChannelTypeID");
        maxDateSQL.append("\n ,bill.FChannelID,ENTRIES.FMaterialID");
        maxDateSQL.append("\n ,ENTRIES.FBaseUnitID");
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n INSERT INTO ");
        tempSql.append(tempTableName);
        tempSql.append("\n SELECT ");
        tempSql.append("\n " + selCols);
        tempSql.append(fromTable);
        tempSql.append("\n INNER JOIN (");
        tempSql.append("\n " + maxDateSQL);
        tempSql.append("\n ) MaxTemp ");
        tempSql.append("\n ON MaxTemp.ForgID = bill.FSaleOrgUnitID");
        tempSql.append("\n AND MaxTemp.FChaTypeID = saleInfo.FChannelTypeID");
        tempSql.append("\n AND MaxTemp.FChannelID = bill.FChannelID");
        tempSql.append("\n AND MaxTemp.FMaterialID = ENTRIES.FMaterialID");
        tempSql.append("\n AND MaxTemp.FBaseUnitID = ENTRIES.FBaseUnitID");
        tempSql.append("\n AND MaxTemp.FMaxBizDate = bill.FBizDate ");
        return tempSql.toString();
    }

    private void insertGroupData(RptParams params, String tempTable, Context ctx) throws BOSException, EASBizException {
        StringBuffer insColsa = new StringBuffer();
        StringBuffer insColsb = new StringBuffer();
        StringBuffer insColsc = new StringBuffer();
        StringBuffer selColsa = new StringBuffer();
        StringBuffer selColsb = new StringBuffer();
        StringBuffer selColsc = new StringBuffer();
        StringBuffer grpColsa = new StringBuffer();
        StringBuffer grpColsb = new StringBuffer();
        StringBuffer grpColsc = new StringBuffer();
        switch (this.TOTALGROPUBY) {
            case 10: {
                insColsa.append("FID");
                insColsa.append(",FsaleOrgID");
                insColsa.append(",FsaleOrgNumber");
                insColsa.append(",FsaleOrgNumberCopy");
                insColsa.append(",FsaleOrgNumberSort");
                insColsa.append(",FsaleOrgName");
                insColsa.append(",FChaTypeNumber");
                insColsa.append(",FChaTypeNumberCopy");
                insColsa.append(",FChaTypeNumberSort");
                insColsa.append(",FChaTypeName");
                insColsa.append(",FchannelBaseNumber");
                insColsa.append(",FchannelBaseNumberCopy");
                insColsa.append(",FchannelBaseNumberSort");
                insColsa.append(",FchannelBaseName");
                insColsa.append(",FMaterialNumber");
                insColsa.append(",FFlag");
                insColsa.append(",FBaseSaleQty,FSaleQty,FAmount");
                insColsb.append("FID");
                insColsb.append(",FsaleOrgID");
                insColsb.append(",FsaleOrgNumber");
                insColsb.append(",FsaleOrgNumberCopy");
                insColsb.append(",FsaleOrgNumberSort");
                insColsb.append(",FsaleOrgName");
                insColsb.append(",FChaTypeNumber");
                insColsb.append(",FChaTypeNumberCopy");
                insColsb.append(",FChaTypeNumberSort");
                insColsb.append(",FChaTypeName");
                insColsb.append(",FchannelBaseNumber");
                insColsb.append(",FFlag");
                insColsb.append(",FBaseSaleQty,FSaleQty,FAmount");
                insColsc.append("FID");
                insColsc.append(",FsaleOrgID");
                insColsc.append(",FsaleOrgNumber");
                insColsc.append(",FsaleOrgNumberCopy");
                insColsc.append(",FsaleOrgNumberSort");
                insColsc.append(",FsaleOrgName");
                insColsc.append(",FChaTypeNumber");
                insColsc.append(",FChaTypeName");
                insColsc.append(",FFlag");
                insColsc.append(",FBaseSaleQty,FSaleQty,FAmount");
                selColsa.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsa.append(",FsaleOrgID");
                selColsa.append(",FsaleOrgNumber");
                selColsa.append(",FsaleOrgNumber");
                selColsa.append(",'00'");
                selColsa.append(",FsaleOrgName");
                selColsa.append(",FChaTypeNumber");
                selColsa.append(",FChaTypeNumber");
                selColsa.append(",'00'");
                selColsa.append(",FChaTypeName");
                selColsa.append(",FchannelBaseNumber");
                selColsa.append(",FchannelBaseNumber");
                selColsa.append(",'11'");
                selColsa.append(",FchannelBaseName");
                selColsa.append(",'" + this.SUBLABEL + "' ");
                selColsa.append(",'111'");
                selColsa.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                selColsb.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsb.append(",FsaleOrgID");
                selColsb.append(",FsaleOrgNumber");
                selColsb.append(",FsaleOrgNumber");
                selColsb.append(",'00'");
                selColsb.append(",FsaleOrgName");
                selColsb.append(",FChaTypeNumber");
                selColsb.append(",FChaTypeNumber");
                selColsb.append(",'11'");
                selColsb.append(",FChaTypeName");
                selColsb.append(",'" + this.SUBLABEL + "' ");
                selColsb.append(",'222'");
                selColsb.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                selColsc.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsc.append(",FsaleOrgID");
                selColsc.append(",FsaleOrgNumber");
                selColsc.append(",FsaleOrgNumber");
                selColsc.append(",'11'");
                selColsc.append(",FsaleOrgName");
                selColsc.append(",'" + this.SUMLABEL + "' ");
                selColsc.append(",'" + this.SUMLABEL + "' ");
                selColsc.append(",'333'");
                selColsc.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                grpColsa.append("FsaleOrgID");
                grpColsa.append(",FsaleOrgNumber");
                grpColsa.append(",FsaleOrgName");
                grpColsa.append(",FChaTypeNumber");
                grpColsa.append(",FChaTypeName");
                grpColsa.append(",FchannelBaseNumber");
                grpColsa.append(",FchannelBaseName");
                grpColsb.append("FsaleOrgID");
                grpColsb.append(",FsaleOrgNumber");
                grpColsb.append(",FsaleOrgName");
                grpColsb.append(",FChaTypeNumber");
                grpColsb.append(",FChaTypeName");
                grpColsc.append("FsaleOrgID");
                grpColsc.append(",FsaleOrgNumber");
                grpColsc.append(",FsaleOrgName");
                break;
            }
            case 20: {
                insColsa.append(" FID");
                insColsa.append(",FsaleOrgID");
                insColsa.append(",FsaleOrgNumber");
                insColsa.append(",FsaleOrgNumberCopy");
                insColsa.append(",FsaleOrgNumberSort");
                insColsa.append(",FsaleOrgName");
                insColsa.append(",FMaterialNumber");
                insColsa.append(",FMaterialNumberCopy");
                insColsa.append(",FMaterialNumberSort");
                insColsa.append(",FMaterialName");
                insColsa.append(",FChaTypeNumber");
                insColsa.append(",FChaTypeNumberCopy");
                insColsa.append(",FChaTypeNumberSort");
                insColsa.append(",FChaTypeName");
                insColsa.append(",FchannelBaseNumber");
                insColsa.append(",FFlag");
                insColsa.append(",FBaseSaleQty,FSaleQty,FAmount");
                insColsb.append(" FID");
                insColsb.append(",FsaleOrgID");
                insColsb.append(",FsaleOrgNumber");
                insColsb.append(",FsaleOrgNumberCopy");
                insColsb.append(",FsaleOrgNumberSort");
                insColsb.append(",FsaleOrgName");
                insColsb.append(",FMaterialNumber");
                insColsb.append(",FMaterialNumberCopy");
                insColsb.append(",FMaterialNumberSort");
                insColsb.append(",FMaterialName");
                insColsb.append(",FChaTypeNumber");
                insColsb.append(",FChaTypeName");
                insColsb.append(",FFlag");
                insColsb.append(",FBaseSaleQty,FSaleQty,FAmount");
                insColsc.append(" FID");
                insColsc.append(",FsaleOrgID");
                insColsc.append(",FsaleOrgNumber");
                insColsc.append(",FsaleOrgNumberCopy");
                insColsc.append(",FsaleOrgNumberSort");
                insColsc.append(",FsaleOrgName");
                insColsc.append(",FMaterialNumber");
                insColsc.append(",FFlag");
                insColsc.append(",FBaseSaleQty,FSaleQty,FAmount");
                selColsa.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsa.append(",FsaleOrgID");
                selColsa.append(",FsaleOrgNumber");
                selColsa.append(",FsaleOrgNumber");
                selColsa.append(",'00'");
                selColsa.append(",FsaleOrgName");
                selColsa.append(",FMaterialNumber");
                selColsa.append(",FMaterialNumber");
                selColsa.append(",'00'");
                selColsa.append(",FMaterialName");
                selColsa.append(",FChaTypeNumber");
                selColsa.append(",FChaTypeNumber");
                selColsa.append(",'11'");
                selColsa.append(",FChaTypeName");
                selColsa.append(",'" + this.SUBLABEL + "' ");
                selColsa.append(",'222'");
                selColsa.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                selColsb.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsb.append(",FsaleOrgID");
                selColsb.append(",FsaleOrgNumber");
                selColsb.append(",FsaleOrgNumber");
                selColsb.append(",'00'");
                selColsb.append(",FsaleOrgName");
                selColsb.append(",FMaterialNumber");
                selColsb.append(",FMaterialNumber");
                selColsb.append(",'11'");
                selColsb.append(",FMaterialName");
                selColsb.append(",'" + this.SUBLABEL + "' ");
                selColsb.append(",'" + this.SUBLABEL + "' ");
                selColsb.append(",'222'");
                selColsb.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                selColsc.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsc.append(",FsaleOrgID");
                selColsc.append(",FsaleOrgNumber");
                selColsc.append(",FsaleOrgNumber");
                selColsc.append(",'11'");
                selColsc.append(",FsaleOrgName");
                selColsc.append(",'" + this.SUMLABEL + "' ");
                selColsc.append(",'333'");
                selColsc.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                grpColsa.append("FsaleOrgID");
                grpColsa.append(",FsaleOrgNumber");
                grpColsa.append(",FsaleOrgName");
                grpColsa.append(",FMaterialNumber");
                grpColsa.append(",FMaterialName");
                grpColsa.append(",FChaTypeNumber");
                grpColsa.append(",FChaTypeName");
                grpColsb.append("FsaleOrgID");
                grpColsb.append(",FsaleOrgNumber");
                grpColsb.append(",FsaleOrgName");
                grpColsb.append(",FMaterialNumber");
                grpColsb.append(",FMaterialName");
                grpColsc.append("FsaleOrgID");
                grpColsc.append(",FsaleOrgNumber");
                grpColsc.append(",FsaleOrgName");
                break;
            }
            case 30: {
                insColsa.append(" FID");
                insColsa.append(",FMaterialNumber");
                insColsa.append(",FMaterialNumberCopy");
                insColsa.append(",FMaterialNumberSort");
                insColsa.append(",FMaterialName");
                insColsa.append(",FsaleOrgID");
                insColsa.append(",FsaleOrgNumber");
                insColsa.append(",FsaleOrgNumberCopy");
                insColsa.append(",FsaleOrgNumberSort");
                insColsa.append(",FsaleOrgName");
                insColsa.append(",FChaTypeNumber");
                insColsa.append(",FChaTypeNumberCopy");
                insColsa.append(",FChaTypeNumberSort");
                insColsa.append(",FChaTypeName");
                insColsa.append(",FchannelBaseNumber");
                insColsa.append(",FFlag");
                insColsa.append(",FBaseSaleQty,FSaleQty,FAmount");
                insColsb.append(" FID");
                insColsb.append(",FMaterialNumber");
                insColsb.append(",FMaterialNumberCopy");
                insColsb.append(",FMaterialNumberSort");
                insColsb.append(",FMaterialName");
                insColsb.append(",FsaleOrgID");
                insColsb.append(",FsaleOrgNumber");
                insColsb.append(",FsaleOrgNumberCopy");
                insColsb.append(",FsaleOrgNumberSort");
                insColsb.append(",FsaleOrgName");
                insColsb.append(",FChaTypeNumber");
                insColsb.append(",FChaTypeName");
                insColsb.append(",FFlag");
                insColsb.append(",FBaseSaleQty,FSaleQty,FAmount");
                insColsc.append(" FID");
                insColsc.append(",FMaterialNumber");
                insColsc.append(",FMaterialNumberCopy");
                insColsc.append(",FMaterialNumberSort");
                insColsc.append(",FMaterialName");
                insColsc.append(",FsaleOrgNumber");
                insColsc.append(",FFlag");
                insColsc.append(",FBaseSaleQty,FSaleQty,FAmount");
                selColsa.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsa.append(",FMaterialNumber");
                selColsa.append(",FMaterialNumber");
                selColsa.append(",'00'");
                selColsa.append(",FMaterialName");
                selColsa.append(",FsaleOrgID");
                selColsa.append(",FsaleOrgNumber");
                selColsa.append(",FsaleOrgNumber");
                selColsa.append(",'00'");
                selColsa.append(",FsaleOrgName");
                selColsa.append(",FChaTypeNumber");
                selColsa.append(",FChaTypeNumber");
                selColsa.append(",'11'");
                selColsa.append(",FChaTypeName");
                selColsa.append(",'" + this.SUBLABEL + "' ");
                selColsa.append(",'111'");
                selColsa.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                selColsb.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsb.append(",FMaterialNumber");
                selColsb.append(",FMaterialNumber");
                selColsb.append(",'00'");
                selColsb.append(",FMaterialName");
                selColsb.append(",FsaleOrgID");
                selColsb.append(",FsaleOrgNumber");
                selColsb.append(",FsaleOrgNumber");
                selColsb.append(",'11'");
                selColsb.append(",FsaleOrgName");
                selColsb.append(",'" + this.SUBLABEL + "' ");
                selColsb.append(",'" + this.SUBLABEL + "' ");
                selColsb.append(",'222'");
                selColsb.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                selColsc.append("\n newbosid('").append(this.NEW_BOSID).append("')");
                selColsc.append(",FMaterialNumber");
                selColsc.append(",FMaterialNumber");
                selColsc.append(",'11'");
                selColsc.append(",FMaterialName");
                selColsc.append(",'" + this.SUMLABEL + "' ");
                selColsc.append(",'333'");
                selColsc.append(",sum(FBaseSaleQty),sum(FSaleQty),sum(FAmount)");
                grpColsa.append("FMaterialNumber");
                grpColsa.append(",FMaterialName");
                grpColsa.append(",FsaleOrgID");
                grpColsa.append(",FsaleOrgNumber");
                grpColsa.append(",FsaleOrgName");
                grpColsa.append(",FChaTypeNumber");
                grpColsa.append(",FChaTypeName");
                grpColsb.append("FMaterialNumber");
                grpColsb.append(",FMaterialName");
                grpColsb.append(",FsaleOrgID");
                grpColsb.append(",FsaleOrgNumber");
                grpColsb.append(",FsaleOrgName");
                grpColsc.append("FMaterialNumber");
                grpColsc.append(",FMaterialName");
            }
        }
        StringBuffer totalSqla = new StringBuffer();
        totalSqla.append("insert into ");
        totalSqla.append(tempTable).append(" (");
        totalSqla.append(insColsa);
        totalSqla.append(") ").append(this.sp);
        totalSqla.append(" SELECT ");
        totalSqla.append(selColsa);
        totalSqla.append(this.sp).append(" FROM ");
        totalSqla.append(tempTable).append(this.sp);
        totalSqla.append(" WHERE FFlag='000' ");
        totalSqla.append(" GROUP BY ").append(grpColsa).append(this.sp);
        StringBuffer totalSqlb = new StringBuffer();
        totalSqlb.append("insert into ");
        totalSqlb.append(tempTable).append(" (");
        totalSqlb.append(insColsb);
        totalSqlb.append(") ").append(this.sp);
        totalSqlb.append(" SELECT ");
        totalSqlb.append(selColsb);
        totalSqlb.append(this.sp).append(" FROM ");
        totalSqlb.append(tempTable).append(this.sp);
        totalSqlb.append(" WHERE FFlag='000' ");
        totalSqlb.append(" GROUP BY ").append(grpColsb).append(this.sp);
        StringBuffer totalSqlc = new StringBuffer();
        totalSqlc.append("insert into ");
        totalSqlc.append(tempTable).append(" (");
        totalSqlc.append(insColsc);
        totalSqlc.append(") ").append(this.sp);
        totalSqlc.append(" SELECT ");
        totalSqlc.append(selColsc);
        totalSqlc.append(this.sp).append(" FROM ");
        totalSqlc.append(tempTable).append(this.sp);
        totalSqlc.append(" WHERE FFlag='000' ");
        totalSqlc.append(" GROUP BY ").append(grpColsc).append(this.sp);
        String[] sql = new String[]{totalSqla.toString(), totalSqlb.toString(), totalSqlc.toString()};
        this.executeBatchUpdate(ctx, sql);
    }

    private String getQueryStr(RptParams params, String purName, Context ctx) throws EASBizException, BOSException {
        StringBuffer queryStr = new StringBuffer();
        String begindate = null;
        String enddate = null;
        begindate = params.getString("dateStart");
        enddate = params.getString("dateEnd");
        queryStr.append("\r\n where ");
        queryStr.append("\n bill.Fbasestatus =4 ");
        queryStr.append("\n AND Bill.FBizDate  >= {" + begindate + "} \n AND Bill.FBizDate <= {" + enddate + "}");
        if (params.getString("ChannelFrom") != null) {
            queryStr.append("\n AND chaBase.FNumber >= ? ");
        }
        if (params.getString("ChannelTo") != null) {
            queryStr.append("\n AND chaBase.FNumber <= ? ");
        }
        if (params.getString("materialFrom") != null) {
            queryStr.append("\n AND  material.FNumber >= ? ");
        }
        if (params.getString("materialTo") != null) {
            queryStr.append("\n AND  material.FNumber <= ? ");
        }
        return queryStr.toString();
    }

    private RptTableHeader setSaleOrderRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String orgNum = this.getServerResource("SaleOrgNumber", ctx);
        String saleOrgName = this.getServerResource("SaleOrgName", ctx);
        String channelType = this.getServerResource("ChannelType", ctx);
        String channelNumber = this.getServerResource("ChannelNubmer", ctx);
        String channelName = this.getServerResource("ChannelName", ctx);
        String materialNum = this.getServerResource("MaterialNum", ctx);
        String materialName = this.getServerResource("MaterialNam", ctx);
        String baseUnit = this.getServerResource("BASE_UNIT", ctx);
        String baseqty = this.getServerResource("BASE_QTY", ctx);
        String Unit = this.getServerResource("Unit", ctx);
        String qty = this.getServerResource("Qty", ctx);
        String price = this.getServerResource("Price", ctx);
        String amount = this.getServerResource("Amount", ctx);
        Object[][] labels = new Object[1][16];
        String[] cols = new String[16];
        int groupBy = new Integer(params.getString("kdcTotalGroupBy"));
        switch (groupBy) {
            case 10: {
                cols[0] = "ORG_NUM";
                cols[1] = "ORG_NAME";
                cols[2] = "CHANNEL_TYPE";
                cols[3] = "CHANNEL_NUMBER";
                cols[4] = "CHANNEL_NAME";
                cols[5] = "MATERIAL_NUMBER";
                cols[6] = "MATERIAL_NAME";
                labels[0][0] = orgNum;
                labels[0][1] = saleOrgName;
                labels[0][2] = channelType;
                labels[0][3] = channelNumber;
                labels[0][4] = channelName;
                labels[0][5] = materialNum;
                labels[0][6] = materialName;
                break;
            }
            case 20: {
                cols[0] = "ORG_NUM";
                cols[1] = "ORG_NAME";
                cols[2] = "MATERIAL_NUMBER";
                cols[3] = "MATERIAL_NAME";
                cols[4] = "CHANNEL_TYPE";
                cols[5] = "CHANNEL_NUMBER";
                cols[6] = "CHANNEL_NAME";
                labels[0][0] = orgNum;
                labels[0][1] = saleOrgName;
                labels[0][2] = materialNum;
                labels[0][3] = materialName;
                labels[0][4] = channelType;
                labels[0][5] = channelNumber;
                labels[0][6] = channelName;
                break;
            }
            case 30: {
                cols[0] = "MATERIAL_NUMBER";
                cols[1] = "MATERIAL_NAME";
                cols[2] = "ORG_NUM";
                cols[3] = "ORG_NAME";
                cols[4] = "CHANNEL_TYPE";
                cols[5] = "CHANNEL_NUMBER";
                cols[6] = "CHANNEL_NAME";
                labels[0][0] = materialNum;
                labels[0][1] = materialName;
                labels[0][2] = orgNum;
                labels[0][3] = saleOrgName;
                labels[0][4] = channelType;
                labels[0][5] = channelNumber;
                labels[0][6] = channelName;
            }
        }
        cols[7] = "UNIT_NAME";
        cols[8] = "QTY";
        cols[9] = "BASEUNIT_NAME";
        cols[10] = "BASEQTY";
        cols[11] = "PRICE";
        cols[12] = "AMOUNT";
        cols[13] = "FID";
        cols[14] = "CHA_TYPE";
        cols[15] = "FFLAG";
        labels[0][7] = Unit;
        labels[0][8] = qty;
        labels[0][9] = baseUnit;
        labels[0][10] = baseqty;
        labels[0][11] = price;
        labels[0][12] = amount;
        labels[0][13] = "FID";
        labels[0][14] = "CHA_TYPE";
        labels[0][15] = "FFLAG";
        this.setHeaderColumns(header, cols, params);
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String qtyFormat = RptCellFormatter.getNumberFormat((int)6, (boolean)false);
        RptTableColumn col = null;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(-1);
            if (i == 8 || i == 10 || i == 11 || i == 12) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(qtyFormat);
            }
            if (i == 13 || i == 14 || i == 15) {
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        String displaySql = this.querySql(params, ctx);
        RptRowSet rs = this.executeQuery(displaySql, null, from, len, ctx);
        if (from == 0) {
            String countSql = "select count(*) from " + params.getString("tempTable");
            if (params.getBoolean("onlyViewSumRow")) {
                countSql = countSql + " Where Findex<>0 ";
            }
            RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
            rsCount.next();
            int count = rsCount.getInt(0);
            pp.setInt("totalCount", count);
        }
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer displaysql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String orgUnitTempTable = params.getString("OrgTempTable");
        int groupBy = new Integer(params.getString("kdcTotalGroupBy"));
        StringBuffer selCols = new StringBuffer();
        StringBuffer orderCols = new StringBuffer();
        switch (groupBy) {
            case 10: {
                selCols.append(" temp.FSaleOrgNumber");
                selCols.append(",temp.FSaleOrgName");
                selCols.append(",temp.FChaTypeName");
                selCols.append(",temp.FchannelBaseNumber");
                selCols.append(",temp.FchannelBaseName");
                selCols.append(",temp.FMaterialNumber");
                selCols.append(",temp.FMaterialName");
                orderCols.append(" temp.FSaleOrgNumberCopy");
                orderCols.append(",temp.FSaleOrgNumberSort");
                orderCols.append(",temp.FChaTypeNumberCopy");
                orderCols.append(",temp.FChaTypeNumberSort");
                orderCols.append(",temp.FchannelBaseNumberCopy");
                orderCols.append(",temp.FchannelBaseNumberSort");
                orderCols.append(",temp.FMaterialNumber");
                break;
            }
            case 20: {
                selCols.append(" temp.FSaleOrgNumber");
                selCols.append(",temp.FSaleOrgName");
                selCols.append(",temp.FMaterialNumber");
                selCols.append(",temp.FMaterialName");
                selCols.append(",temp.FChaTypeName");
                selCols.append(",temp.FchannelBaseNumber");
                selCols.append(",temp.FchannelBaseName");
                orderCols.append(" temp.FSaleOrgNumberCopy");
                orderCols.append(",temp.FSaleOrgNumberSort");
                orderCols.append(",temp.FMaterialNumberCopy");
                orderCols.append(",temp.FMaterialNumberSort");
                orderCols.append(",temp.FChaTypeNumberCopy");
                orderCols.append(",temp.FChaTypeNumberSort");
                orderCols.append(",temp.FchannelBaseNumber");
                break;
            }
            case 30: {
                selCols.append(" temp.FMaterialNumber");
                selCols.append(",temp.FMaterialName");
                selCols.append(",temp.FSaleOrgNumber");
                selCols.append(",temp.FSaleOrgName");
                selCols.append(",temp.FChaTypeName");
                selCols.append(",temp.FchannelBaseNumber");
                selCols.append(",temp.FchannelBaseName");
                orderCols.append(" temp.FMaterialNumberCopy");
                orderCols.append(",temp.FMaterialNumberSort");
                orderCols.append(",temp.FsaleOrgNumberCopy");
                orderCols.append(",temp.FsaleOrgNumberSort");
                orderCols.append(",temp.FChaTypeNumberCopy");
                orderCols.append(",temp.FChaTypeNumberSort");
                orderCols.append(",temp.FchannelBaseNumber");
            }
        }
        selCols.append(",temp.FUnitName");
        selCols.append(",temp.FSaleQty");
        selCols.append(",temp.FBaseUnitName");
        selCols.append(",temp.FBaseSaleQty");
        selCols.append(",temp.FPrice");
        selCols.append(",temp.FAmount");
        selCols.append(",temp.FID");
        selCols.append(",temp.FChaTypeNumber");
        selCols.append(",temp.FFlag");
        displaysql.append(" SELECT ");
        displaysql.append("\n ").append(selCols.toString());
        displaysql.append("\n from ").append(tempTable);
        displaysql.append("\n AS temp ");
        displaysql.append("\n order by ");
        displaysql.append(orderCols.toString());
        displaysql.append("\n ASC");
        return displaysql.toString();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        int groupBy = new Integer(param.getString("kdcTotalGroupBy"));
        StringBuffer orderCols = new StringBuffer();
        switch (groupBy) {
            case 10: {
                orderCols.append(" temp.FSaleOrgNumber");
                orderCols.append(",temp.FChaTypeNumber");
                orderCols.append(",temp.FchannelBaseNumber");
                break;
            }
            case 20: {
                orderCols.append(" temp.FSaleOrgNumber");
                orderCols.append(",temp.FMaterialNumber");
                orderCols.append(",temp.FChaTypeNumber");
                break;
            }
            case 30: {
                orderCols.append(" temp.FMaterialNumber");
                orderCols.append(",temp.FSaleOrgNumber");
                orderCols.append(",temp.FChaTypeNumber");
            }
        }
        orderCols.append(",temp.FFlag");
        String rsList = "select  temp.fid from " + param.getString("tempTable") + "\n temp \n order by " + orderCols.toString() + "\n ASC";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        String tempTable = params.getString("tempTable");
        if (first) {
            subWhere = " ";
        } else {
            StringBuffer fid = new StringBuffer("where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        int groupBy = new Integer(params.getString("kdcTotalGroupBy"));
        StringBuffer selCols = new StringBuffer();
        StringBuffer orderCols = new StringBuffer();
        switch (groupBy) {
            case 10: {
                selCols.append(" temp.FSaleOrgNumber");
                selCols.append(",temp.FSaleOrgName");
                selCols.append(",temp.FChaTypeName");
                selCols.append(",temp.FchannelBaseNumber");
                selCols.append(",temp.FchannelBaseName");
                selCols.append(",temp.FMaterialNumber");
                selCols.append(",temp.FMaterialName");
                orderCols.append(" temp.FSaleOrgNumber");
                orderCols.append(",temp.FChaTypeNumber");
                orderCols.append(",temp.FchannelBaseNumber");
                break;
            }
            case 20: {
                selCols.append(" temp.FSaleOrgNumber");
                selCols.append(",temp.FSaleOrgName");
                selCols.append(",temp.FMaterialNumber");
                selCols.append(",temp.FMaterialName");
                selCols.append(",temp.FChaTypeName");
                selCols.append(",temp.FchannelBaseNumber");
                selCols.append(",temp.FchannelBaseName");
                orderCols.append(" temp.FSaleOrgNumber");
                orderCols.append(",temp.FMaterialNumber");
                orderCols.append(",temp.FChaTypeNumber");
                break;
            }
            case 30: {
                selCols.append(" temp.FMaterialNumber");
                selCols.append(",temp.FMaterialName");
                selCols.append(",temp.FSaleOrgNumber");
                selCols.append(",temp.FSaleOrgName");
                selCols.append(",temp.FChaTypeName");
                selCols.append(",temp.FchannelBaseNumber");
                selCols.append(",temp.FchannelBaseName");
                orderCols.append(" temp.FMaterialNumber");
                orderCols.append(",temp.FSaleOrgNumber");
                orderCols.append(",temp.FChaTypeNumber");
            }
        }
        selCols.append(",temp.FUnitName");
        selCols.append(",temp.FSaleQty");
        selCols.append(",temp.FBaseUnitName");
        selCols.append(",temp.FBaseSaleQty");
        selCols.append(",temp.FPrice");
        selCols.append(",temp.FAmount");
        selCols.append(",temp.FID");
        selCols.append(",temp.FChaTypeNumber");
        selCols.append(",temp.FFlag");
        orderCols.append(",temp.FFlag");
        StringBuffer displaysql = new StringBuffer();
        displaysql.append(" SELECT ");
        displaysql.append("\n ").append(selCols.toString());
        displaysql.append("\n from ").append(tempTable);
        displaysql.append("\n AS temp ");
        displaysql.append(subWhere);
        displaysql.append("\n order by ");
        displaysql.append(orderCols.toString());
        displaysql.append("\n ASC");
        RptRowSet rs = this.executeQuery(displaysql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)ResClassName, (String)key, (Context)ctx);
    }

    @Override
    protected int _check_Currency_unique(Context ctx, RptParams params) throws BOSException, EASBizException {
        return 0;
    }
}

