/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.webservice.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.util.BosUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillInfo;
import com.kingdee.eas.scm.sd.channel.IChannelJXCBill;
import com.kingdee.eas.scm.sd.channel.UserChannelRelationFacadeFactory;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelJXCBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelJXCBillInfo;
import com.kingdee.eas.scm.sd.channel.webservice.app.utils.WSDataGetUtil;
import com.kingdee.eas.scm.sd.channel.webservice.app.utils.WsImportChannelInWarehsBillUtils;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WsChannelJXCUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.webservice.app.utils.WsChannelStockUtils");

    public static IObjectCollection import_ChannelJXCBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelJXCBill iChannelJXCBill = ChannelJXCBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelJXCBillInfo tempBillInfo;
            boolean isChannelUser;
            ChannelJXCBillInfo bill = new ChannelJXCBillInfo();
            WsChannelJXCBillInfo channelJXCBillInfo = (WsChannelJXCBillInfo)billCols.getObject(i);
            String number = String.valueOf(channelJXCBillInfo.getNumber());
            channelJXCBillInfo.put("ws_number", number);
            if (number == null) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            if (numberMap.containsKey(number)) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "1001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"24_WsChannelJXCUtils", (Locale)ctx.getLocale()), number));
                continue;
            }
            numberMap.put(number, number);
            bill.setNumber(String.valueOf(channelJXCBillInfo.getNumber()));
            String channelNumber = channelJXCBillInfo.getChannelNumber();
            SaleOrgUnitInfo saleOrgUnitInfo = null;
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
            boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
            if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            ChannelBaseInfo channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber);
            if (channelBaseInfo != null) {
                bill.setChannel(channelBaseInfo);
            } else if (isChannelUser) {
                bill.setChannel(curChannelBaseInfo);
            } else {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String orgUnit = channelJXCBillInfo.getSaleOrgUnit();
            if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, channelJXCBillInfo.getSaleOrgUnit());
            if (saleOrgUnitInfo != null) {
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else if (isChannelUser) {
                saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String salePerson = channelJXCBillInfo.getSalePerson();
            PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
            if (personInfo != null) {
                bill.setSalePerson(personInfo);
            } else if (isChannelUser && saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                bill.setSalePerson(saleOrgUnitInfo.getLeader());
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = WsChannelJXCUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx);
            if (companyOrgUnitInfo != null) {
                CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                bill.setCurrency(baseCurrencyInfo);
            }
            bill.setExchangeRate(new BigDecimal("1.00"));
            Date dateStart = channelJXCBillInfo.getStartDate();
            Date dateEnd = channelJXCBillInfo.getEndDate();
            if (dateStart == null) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"30_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            if (dateEnd == null) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"31_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            bill.setStartDate(channelJXCBillInfo.getStartDate());
            bill.setEndDate(channelJXCBillInfo.getEndDate());
            String baseStatus = channelJXCBillInfo.getBaseStatus();
            if (null == baseStatus || "".equals(baseStatus)) {
                bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            } else {
                BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                if (baseStatusEnum != null) {
                    bill.setBaseStatus(BillBaseStatusEnum.ADD);
                } else {
                    bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                }
            }
            bill.setRemark(channelJXCBillInfo.getRemark());
            if (entries != null && entries.size() > 0) {
                ChannelJXCBillEntryCollection entryCol = bill.getEntries();
                int size = entries.size();
                for (int j = 0; j < size; ++j) {
                    ChannelJXCBillEntryInfo entryInfo = new ChannelJXCBillEntryInfo();
                    WsChannelJXCBillEntryInfo wsChannelJXCBillEntryInfo = (WsChannelJXCBillEntryInfo)entries.getObject(j);
                    if (wsChannelJXCBillEntryInfo.getEntrySeq() != channelJXCBillInfo.getEntrySeq()) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelJXCBillInfo.getNumber().toString()));
                        continue;
                    }
                    entryInfo.setSeq(wsChannelJXCBillEntryInfo.getEntrySeq());
                    String materialNumber = wsChannelJXCBillEntryInfo.getMaterialNumber();
                    if (materialNumber == null) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelJXCBillEntryInfo.getMaterialNumber());
                    if (materialInfo == null) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                        continue;
                    }
                    entryInfo.setMaterial(materialInfo);
                    entryInfo.setInQty(new BigDecimal(wsChannelJXCBillEntryInfo.getInQty()));
                    entryInfo.setOutQty(new BigDecimal(wsChannelJXCBillEntryInfo.getOutQty()));
                    entryInfo.setInvQty(new BigDecimal(wsChannelJXCBillEntryInfo.getInvQty()));
                    String unitNumber = wsChannelJXCBillEntryInfo.getUnitNumber();
                    if (unitNumber == null) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"36_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                    if (measureUnitInfo == null) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    entryInfo.setRemark(wsChannelJXCBillEntryInfo.getRemark());
                    entryCol.add(entryInfo);
                }
            } else if (bill.getEntries() == null || bill.getEntries().size() == 0) {
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelJXCBillInfo.getNumber().toString()));
                continue;
            }
            if ((tempBillInfo = WSDataGetUtil.findChannelJXCBill(ctx, channelNumber, number)) != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                    bill.setId(tempBillInfo.getId());
                    bill.setBaseStatus(tempBillInfo.getBaseStatus());
                    iChannelJXCBill.update((IObjectPK)pk, bill);
                    channelJXCBillInfo.put("ws_SuccessID", number);
                    WsChannelJXCUtils.setMessage(channelJXCBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    continue;
                }
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"39_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String rtnNumber = (String)channelJXCBillInfo.get("ws_returnNumber");
            if (rtnNumber != null || channelJXCBillInfo.get("ws_SuccessID") != null) continue;
            try {
                IObjectPK _pk = iChannelJXCBill.save((CoreBaseInfo)bill);
                channelJXCBillInfo.put("ws_SuccessID", number);
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                WsChannelJXCUtils.dealException(ctx, e, channelJXCBillInfo);
            }
        }
        return billCols;
    }

    public static IObjectCollection update_ChannelBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelJXCBill iChannelJXCBill = ChannelJXCBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelJXCBillInfo bill = new ChannelJXCBillInfo();
            WsChannelJXCBillInfo channelJXCBillInfo = (WsChannelJXCBillInfo)billCols.getObject(i);
            String number = channelJXCBillInfo.getNumber();
            channelJXCBillInfo.put("ws_number", number);
            String channelNumber = channelJXCBillInfo.getChannelNumber();
            ChannelJXCBillInfo tempBillInfo = WSDataGetUtil.findChannelJXCBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    String rtnNumber;
                    boolean isChannelUser;
                    if (number == null) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (numberMap.containsKey(number)) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "1001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"40_WsChannelJXCUtils", (Locale)ctx.getLocale()) + number);
                        continue;
                    }
                    numberMap.put(number, number);
                    bill.setNumber(number);
                    SaleOrgUnitInfo saleOrgUnitInfo = null;
                    UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
                    if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
                    boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
                    if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber);
                    if (channelBaseInfo != null) {
                        bill.setChannel(channelBaseInfo);
                    } else if (isChannelUser) {
                        bill.setChannel(curChannelBaseInfo);
                    } else {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String orgUnit = channelJXCBillInfo.getSaleOrgUnit();
                    if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, channelJXCBillInfo.getSaleOrgUnit());
                    if (saleOrgUnitInfo != null) {
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else if (isChannelUser) {
                        saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String salePerson = channelJXCBillInfo.getSalePerson();
                    PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
                    if (personInfo != null) {
                        bill.setSalePerson(personInfo);
                    } else if (isChannelUser && saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                        bill.setSalePerson(saleOrgUnitInfo.getLeader());
                    }
                    CompanyOrgUnitInfo companyOrgUnitInfo = WsChannelJXCUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx);
                    if (companyOrgUnitInfo != null) {
                        CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                        bill.setCurrency(baseCurrencyInfo);
                    }
                    bill.setExchangeRate(new BigDecimal("1.00"));
                    Date dateStart = channelJXCBillInfo.getStartDate();
                    Date dateEnd = channelJXCBillInfo.getEndDate();
                    if (dateStart == null) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"30_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (dateEnd == null) {
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"31_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String baseStatus = channelJXCBillInfo.getBaseStatus();
                    if (null == baseStatus || "".equals(baseStatus)) {
                        bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                    } else {
                        BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                        if (baseStatusEnum != null) {
                            bill.setBaseStatus(BillBaseStatusEnum.ADD);
                        } else {
                            bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                        }
                    }
                    bill.setRemark(channelJXCBillInfo.getRemark());
                    if (entries != null && entries.size() > 0) {
                        ChannelJXCBillEntryCollection entryCol = bill.getEntries();
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            ChannelJXCBillEntryInfo entryInfo = new ChannelJXCBillEntryInfo();
                            WsChannelJXCBillEntryInfo wsChannelJXCBillEntryInfo = (WsChannelJXCBillEntryInfo)entries.getObject(j);
                            entryInfo.setSeq(wsChannelJXCBillEntryInfo.getEntrySeq());
                            if (wsChannelJXCBillEntryInfo.getEntrySeq() != channelJXCBillInfo.getEntrySeq()) {
                                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelJXCBillInfo.getNumber().toString()));
                                continue;
                            }
                            String materialNumber = wsChannelJXCBillEntryInfo.getMaterialNumber();
                            if (materialNumber == null) {
                                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelJXCBillEntryInfo.getMaterialNumber());
                            if (materialInfo == null) {
                                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                                continue;
                            }
                            entryInfo.setMaterial(materialInfo);
                            entryInfo.setInQty(new BigDecimal(wsChannelJXCBillEntryInfo.getInQty()));
                            entryInfo.setOutQty(new BigDecimal(wsChannelJXCBillEntryInfo.getOutQty()));
                            entryInfo.setInvQty(new BigDecimal(wsChannelJXCBillEntryInfo.getInvQty()));
                            String unitNumber = wsChannelJXCBillEntryInfo.getUnitNumber();
                            if (unitNumber == null) {
                                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"36_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                            if (measureUnitInfo == null) {
                                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            entryInfo.setUnit(measureUnitInfo);
                            entryInfo.setRemark(wsChannelJXCBillEntryInfo.getRemark());
                            entryCol.add(entryInfo);
                        }
                    }
                    if ((rtnNumber = (String)channelJXCBillInfo.get("ws_returnNumber")) != null || channelJXCBillInfo.get("ws_SuccessID") != null) continue;
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelJXCBill.update((IObjectPK)pk, bill);
                        channelJXCBillInfo.put("ws_SuccessID", number);
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"41_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsChannelJXCUtils.dealException(ctx, e, channelJXCBillInfo);
                    }
                    continue;
                }
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"42_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    public static IObjectCollection delete_ChannelBill(Context ctx, IObjectCollection billCols) throws BOSException, EASBizException {
        IChannelJXCBill iChannelJXCBill = ChannelJXCBillFactory.getLocalInstance(ctx);
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelJXCBillInfo bill = new ChannelJXCBillInfo();
            WsChannelJXCBillInfo channelJXCBillInfo = (WsChannelJXCBillInfo)billCols.getObject(i);
            String number = String.valueOf(channelJXCBillInfo.getNumber());
            channelJXCBillInfo.put("ws_number", number);
            String channelNumber = channelJXCBillInfo.getChannelNumber();
            ChannelJXCBillInfo tempBillInfo = WSDataGetUtil.findChannelJXCBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelJXCBill.delete((IObjectPK)pk);
                        channelJXCBillInfo.put("ws_SuccessID", number);
                        WsChannelJXCUtils.setMessage(channelJXCBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"44_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsChannelJXCUtils.dealException(ctx, e, channelJXCBillInfo);
                    }
                    continue;
                }
                WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"45_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsChannelJXCUtils.setMessage(channelJXCBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    private static CompanyOrgUnitInfo getCompanyOrgUnit(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK, Context ctx) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        OrgUnitCollection collection = iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
        if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
            return (CompanyOrgUnitInfo)collection.get(0);
        }
        return null;
    }

    public static final CurrencyInfo getBaseCurrencyInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
    }

    private static void setMessage(AbstractObjectValue billInfo, String returnNumber, String returnValue) {
        logger.info((Object)(returnNumber + ":" + returnValue));
        billInfo.put("ws_returnNumber", (Object)returnNumber);
        billInfo.put("ws_returnValue", (Object)returnValue);
    }

    private static void dealException(Context ctx, Exception e, AbstractObjectValue billInfo) throws BOSException {
        if (e instanceof PermissionException) {
            WsChannelJXCUtils.setMessage(billInfo, "6" + ((PermissionException)e).getSubCode(), e.getMessage());
        }
        if (e instanceof PermissionServiceException) {
            WsChannelJXCUtils.setMessage(billInfo, "7***", e.getMessage());
        } else if (e instanceof EASBizException) {
            WsChannelJXCUtils.setMessage(billInfo, "5" + ((EASBizException)((Object)e)).getSubCode(), e.getMessage());
        } else {
            WsChannelJXCUtils.setMessage(billInfo, "9001", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"46_WsChannelJXCUtils", (Locale)ctx.getLocale()), e.getMessage().toString()));
        }
    }
}

