/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.customize.storeage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.scm.customize.storeage.VResult;
import com.kingdee.eas.scm.customize.storeage.VenturyResults;
import com.kingdee.eas.scm.customize.storeage.app.AbstractWsInventoryFacadeControllerBean;
import com.kingdee.eas.scm.customize.storeage.util.WSUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.log4j.Logger;

public class WsInventoryFacadeControllerBean
extends AbstractWsInventoryFacadeControllerBean {
    private static final long serialVersionUID = -5639010238233029870L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.customize.storeage.app.WsInventoryFacadeControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.scm.customize.storeage.app.WebserviceResource";

    @Override
    protected VenturyResults _getInventoryResult(Context ctx, String[] materNumber, String[] wharehouse, String storageOrgNumber, Date stDate, Date enDate) throws BOSException {
        VenturyResults result = new VenturyResults();
        this.buildResult(ctx, materNumber, storageOrgNumber, stDate, enDate, result);
        return result;
    }

    private void buildResult(Context ctx, String[] materNumber, String storageOrgNumber, Date stDate, Date enDate, VenturyResults result) throws BOSException {
        if (materNumber != null && storageOrgNumber != null) {
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                String strStDate = WSUtil.convertDateToStr((Date)stDate, (String)"yyyy-MM-dd");
                String strenDate = WSUtil.convertDateToStr((Date)enDate, (String)"yyyy-MM-dd");
                String querySql = this.getQuerySql(materNumber, storageOrgNumber, strStDate, strenDate);
                if (conn != null) {
                    this.buildQueryQty(conn, querySql, result);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage());
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    private void buildQueryQty(Connection conn, String querySql, VenturyResults result) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rt = stmt.executeQuery(querySql);
        while (rt.next()) {
            VResult vRet = new VResult();
            vRet.setMaterialNo(rt.getString("MaterialNo"));
            vRet.setBaseUnitNo(rt.getString("baseUnit"));
            if (rt.getBigDecimal("Qty1") == null) {
                vRet.setUnIssueQty(new BigDecimal("0"));
            } else {
                vRet.setUnIssueQty(rt.getBigDecimal("Qty1"));
            }
            if (rt.getBigDecimal("Qty2") == null) {
                vRet.setUnReceiveQty(new BigDecimal("0"));
            } else {
                vRet.setUnReceiveQty(rt.getBigDecimal("Qty2"));
            }
            if (rt.getBigDecimal("Qty3") == null) {
                vRet.setJustQty(new BigDecimal("0"));
            } else {
                vRet.setJustQty(rt.getBigDecimal("Qty3"));
            }
            result.addOutVentoryResults(vRet);
        }
    }

    private String getQuerySql(String[] materialNumber, String storageOrgNumber, String stDate, String enDate) {
        StringBuffer whereMaterial = new StringBuffer();
        StringBuffer whereStorage = new StringBuffer();
        StringBuffer whereBizDate = new StringBuffer();
        whereMaterial.append(" m.fnumber in (");
        for (int i = 0; i < materialNumber.length; ++i) {
            if (i != 0) {
                whereMaterial.append(",");
            }
            whereMaterial.append("'").append(materialNumber[i]).append("'");
        }
        whereMaterial.append(") ");
        whereStorage.append(" s.fnumber = '").append(storageOrgNumber).append("' ");
        whereBizDate.append(" b.fbasestatus = 4 ");
        whereBizDate.append("and  a.fbizdate >= to_date('").append(stDate).append("') ");
        whereBizDate.append("and a.fbizdate <= to_date('").append(enDate).append("')");
        StringBuffer buffer = new StringBuffer();
        buffer.append("select m.fnumber as MaterialNo,T4.FNumber as baseUnit,t1.fbaseqty as Qty1,t2.fbaseqty as Qty2,t3.fbaseqty as Qty3 from  ");
        buffer.append("t_bd_material m left join ");
        buffer.append("(");
        buffer.append(" select sum(a.fbaseqty + a.flockbaseqty) as fbaseqty,a.fmaterialid as fmaterialid,");
        buffer.append("a.fstorageorgunitid  as fstorageorgunitid,s.fnumber as storageOrgNumber from t_im_inventory a");
        buffer.append(" inner join  t_bd_material  m on a.fmaterialid = m.fid ");
        buffer.append(" inner join  t_org_storage s on a.fstorageorgunitid = s.fid");
        buffer.append(" where ").append(whereMaterial).append(" and ").append(whereStorage);
        buffer.append(" group by a.fmaterialid,a.fstorageorgunitid,s.fnumber ");
        buffer.append("   ) t1  on m.fid = t1.fmaterialid ");
        buffer.append("left join ");
        buffer.append(" (select sum(case when (b.fbaseqty - b.FTotalReceiptBaseQty) >= 0 then (b.fbaseqty - b.FTotalReceiptBaseQty) else 0 end) as fbaseqty,");
        buffer.append("b.fmaterialid as fmaterialid,b.fstorageorgunitid  as fstorageorgunitid,s.fnumber as storageOrgNumber ");
        buffer.append("from t_sm_purorder a ");
        buffer.append(" inner join t_sm_purorderentry b on a.fid = b.fparentid ");
        buffer.append(" inner join  t_bd_material  m on b.fmaterialid = m.fid ");
        buffer.append(" inner join  t_org_storage s on b.fstorageorgunitid = s.fid");
        buffer.append(" where ").append(whereMaterial).append(" and ").append(whereStorage).append(" and ").append(whereBizDate);
        buffer.append("   group by b.fmaterialid,b.FStorageOrgUnitID,s.fnumber  ");
        buffer.append("  ) t2  on  t1.fmaterialid = t2.fmaterialid and t1.FStorageOrgUnitID = t2.FStorageOrgUnitID ");
        buffer.append("left join   ");
        buffer.append("(select sum(case when (b.fbaseqty - b.FTotalIssueBaseQty) >=0 then (b.fbaseqty - b.FTotalIssueBaseQty) else 0 end) as fbaseqty,");
        buffer.append("b.fmaterialid as fmaterialid,b.fstorageorgunitid  as fstorageorgunitid,s.fnumber as storageOrgNumber ");
        buffer.append("from  t_sd_saleorder a ");
        buffer.append("inner join t_sd_saleorderentry b on a.fid = b.fparentid ");
        buffer.append("inner join  t_bd_material  m on b.fmaterialid = m.fid ");
        buffer.append(" inner join  t_org_storage s on b.fstorageorgunitid = s.fid ");
        buffer.append(" where ").append(whereMaterial).append(" and ").append(whereStorage).append(" and ").append(whereBizDate);
        buffer.append("  group by b.fmaterialid,b.FStorageOrgUnitID,s.fnumber ");
        buffer.append(") t3  on t1.fmaterialid = t3.fmaterialid and t1.FStorageOrgUnitID = t3.FStorageOrgUnitID ");
        buffer.append(" LEFT JOIN T_BD_MeasureUnit T4 ON T4.FID = M.FBaseUnit ");
        buffer.append("where").append(whereMaterial);
        return buffer.toString();
    }

    private String getSaleOrderQuerySql(String[] materialNumber, String[] wharehouse, String storageOrgNumber, String stDate, String enDate) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT T3.FNumber AS MaterialNo,T6.FNumber AS BaseUnit,SUM(T2.FTotalUnIssueBaseQty) AS Qty");
        buffer.append(" FROM T_SD_SaleOrder T1 INNER JOIN T_SD_SaleOrderEntry T2");
        buffer.append(" ON T1.FID = T2.FPARENTID");
        buffer.append(" LEFT JOIN T_BD_Material T3");
        buffer.append(" ON T2.FMaterialID = T3.FID");
        buffer.append(" LEFT JOIN T_ORG_Storage T4");
        buffer.append(" ON T4.FID = T2.FStorageOrgUnitID");
        buffer.append(" LEFT JOIN T_BD_MeasureUnit T6");
        buffer.append(" ON T6.FID = T2.FBaseUnitID");
        buffer.append(" WHERE T3.FNumber IN (");
        this.buildMaterialFiter(buffer, materialNumber);
        buffer.append(" AND T4.FNumber ='" + storageOrgNumber + "'");
        if (stDate != null && enDate != null) {
            buffer.append(" AND T1.FBizDate BETWEEN TO_DATE('" + stDate + "') AND TO_DATE('" + enDate + "')");
        }
        buffer.append(" AND T2.FBaseStatus = 4 ");
        buffer.append(" GROUP BY T3.FNumber,T6.FNumber");
        buffer.append(" ORDER BY T3.FNumber,T6.FNumber");
        return buffer.toString();
    }

    private String getPurOrderQuerySql(String[] materialNumber, String storageOrgNumber, String stDate, String enDate) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT T3.FNumber AS MaterialNo,T6.FNumber AS BaseUnit,SUM(T2.FTotalUnReceiveBaseQty) Qty");
        buffer.append(" FROM T_SM_PurOrder T1 INNER JOIN T_SM_PurOrderEntry T2");
        buffer.append(" ON T1.FID  =T2.FPARENTID");
        buffer.append(" LEFT JOIN T_BD_Material T3 ");
        buffer.append(" ON T2.FMaterialID = T3.FID ");
        buffer.append(" LEFT JOIN T_ORG_Storage T5 ");
        buffer.append(" ON T5.FID = T2.FStorageOrgUnitID");
        buffer.append(" LEFT JOIN T_BD_MeasureUnit T6");
        buffer.append(" ON T6.FID = T2.FBaseUnitID");
        buffer.append(" WHERE T3.FNumber IN (");
        this.buildMaterialFiter(buffer, materialNumber);
        buffer.append(" AND T5.FNumber ='" + storageOrgNumber + "'");
        if (stDate != null && enDate != null) {
            buffer.append(" AND T1.FBizDate BETWEEN TO_DATE('" + stDate + "') AND TO_DATE('" + enDate + "')");
        }
        buffer.append(" GROUP BY T3.FNumber,T6.FNumber");
        buffer.append(" ORDER BY T3.FNumber,T6.FNumber");
        return buffer.toString();
    }

    private String getVentoryQuerySql(String[] materialNumber, String[] wharehouse, String storageOrgNumber) {
        StringBuffer buffer = new StringBuffer();
        if (wharehouse != null && wharehouse.length > 0) {
            buffer.append("SELECT T2.FNumber AS MaterialNo,T3.FNumber AS WharehouseNo,T6.FNumber AS BaseUnit,SUM(T1.FBaseQty) Qty");
            buffer.append(" FROM T_IM_Inventory T1");
            buffer.append(" LEFT JOIN T_BD_Material T2");
            buffer.append(" ON T1.FMaterialID = T2.FID");
            buffer.append(" LEFT JOIN T_DB_WAREHOUSE T3");
            buffer.append(" ON T1.FWarehouseID = T3.FID");
            buffer.append(" LEFT JOIN T_ORG_Storage T4");
            buffer.append(" ON T4.FID = T1.FStorageOrgUnitID");
            buffer.append(" LEFT JOIN T_BD_MeasureUnit T6");
            buffer.append(" ON T6.FID = T1.FBaseUnitID");
            buffer.append(" WHERE T2.FNumber IN (");
            this.buildMaterialFiter(buffer, materialNumber);
            buffer.append(" AND T3.FNumber IN (");
            this.buildWharehouseFilter(buffer, wharehouse);
            buffer.append(" AND T4.FNumber ='" + storageOrgNumber + "'");
            buffer.append(" GROUP BY T2.FNumber,T3.FNumber,T6.FNumber");
            buffer.append(" ORDER BY T2.FNumber,T3.FNumber,T6.FNumber");
        } else {
            buffer.append("SELECT T2.FNumber AS MaterialNo,T6.FNumber AS BaseUnit,SUM(T1.FBaseQty) Qty");
            buffer.append(" FROM T_IM_Inventory T1");
            buffer.append(" LEFT JOIN T_BD_Material T2");
            buffer.append(" ON T1.FMaterialID = T2.FID");
            buffer.append(" LEFT JOIN T_ORG_Storage T5 ");
            buffer.append(" ON T5.FID = T1.FStorageOrgUnitID");
            buffer.append(" LEFT JOIN T_BD_MeasureUnit T6");
            buffer.append(" ON T6.FID = T1.FBaseUnitID");
            buffer.append(" WHERE T2.FNumber IN (");
            this.buildMaterialFiter(buffer, materialNumber);
            buffer.append(" AND T5.FNumber ='" + storageOrgNumber + "'");
            buffer.append(" GROUP BY T2.FNumber,T6.FNumber");
            buffer.append(" ORDER BY T2.FNumber,T6.FNumber");
        }
        return buffer.toString();
    }

    private void buildMaterialFiter(StringBuffer buffer, String[] materialNos) {
        for (int i = 0; i < materialNos.length; ++i) {
            buffer.append("'" + materialNos[i] + "'");
            if (i >= materialNos.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(") ");
    }

    private void buildWharehouseFilter(StringBuffer buffer, String[] wharehouse) {
        for (int i = 0; wharehouse != null && i < wharehouse.length; ++i) {
            buffer.append("'" + wharehouse[i] + "'");
            if (i >= wharehouse.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(") ");
    }
}

