/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.customize.tools.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.customize.tools.IndexCheckMsgInfo;
import com.kingdee.eas.scm.customize.tools.app.AbstractIndexCheckControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndexCheckControllerBean
extends AbstractIndexCheckControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.customize.tools.app.IndexCheckControllerBean");
    private String res = "com.kingdee.eas.scm.customize.tools.ToolsResource";

    @Override
    protected List _filterTable(Context ctx, List tableNameList) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select Table_name from KSQL_USERTABLES ");
        if (tableNameList != null && tableNameList.size() > 0) {
            sb.append(" where Table_name like '").append(tableNameList.get(0).toString().toUpperCase()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        tableNameList.remove(0);
        try {
            while (rs.next()) {
                tableNameList.add(rs.getString("Table_name"));
            }
        }
        catch (SQLException e) {
            logger.info((Object)e);
            throw new EASBizException(null, (Throwable)e);
        }
        return tableNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _reCreateIndex(Context ctx, List indexMap) throws BOSException, EASBizException {
        ArrayList<IndexCheckMsgInfo> returnResult = new ArrayList<IndexCheckMsgInfo>();
        if (indexMap != null && indexMap.size() > 0) {
            IndexCheckMsgInfo aIndexCheckMsgInfo;
            String treeID = indexMap.get(0).toString();
            indexMap.remove(0);
            HashMap<String, String> indexSqlMap = new HashMap<String, String>();
            HashMap tableSqlMap = new HashMap();
            ArrayList<String> dropSQLList = new ArrayList<String>();
            ArrayList<String> createSQLList = new ArrayList<String>();
            ArrayList<String> tableNameList = new ArrayList<String>();
            for (int i = 0; i < indexMap.size(); ++i) {
                aIndexCheckMsgInfo = (IndexCheckMsgInfo)indexMap.get(i);
                if (tableSqlMap.get(aIndexCheckMsgInfo.getTableName()) == null) {
                    tableNameList.add(aIndexCheckMsgInfo.getTableName());
                }
                if (indexSqlMap.get(aIndexCheckMsgInfo.getExeDropSQL()) == null && aIndexCheckMsgInfo.getExeDropSQL().trim().length() > 0) {
                    dropSQLList.add(" " + aIndexCheckMsgInfo.getExeDropSQL());
                    indexSqlMap.put(aIndexCheckMsgInfo.getExeDropSQL(), "");
                }
                if (indexSqlMap.get(aIndexCheckMsgInfo.getExeCreateSQL()) != null || aIndexCheckMsgInfo.getExeCreateSQL().trim().length() <= 0) continue;
                createSQLList.add(" " + aIndexCheckMsgInfo.getExeCreateSQL());
                indexSqlMap.put(aIndexCheckMsgInfo.getExeCreateSQL(), "");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Create Table tt").append("(");
            stringBuffer.append("FID Varchar(44),");
            stringBuffer.append("FCONTROLUNITID Varchar(44),");
            stringBuffer.append("Ftreeid Varchar(44),");
            stringBuffer.append("FTABLENAME Varchar(200),");
            stringBuffer.append("FINDEXNAME Varchar(200),");
            stringBuffer.append("FINDEXFIELDS Varchar(200),");
            stringBuffer.append("FISCLUINDEX int,");
            stringBuffer.append("FISKEYINDEX int,FCREATETIME DateTime);");
            String tempTable = KsqlUtil.createTempTable((Context)ctx, (String)stringBuffer.toString());
            this.getIndexFromDataBase(ctx, treeID, tableNameList, tempTable, true);
            try {
                int i;
                StringBuffer backupSQL = new StringBuffer();
                backupSQL.append("INSERT INTO T_SCM_IndexBackup(FID,FCONTROLUNITID,FTreeNodeID,FTABLENAME,FINDEXNAME,");
                backupSQL.append("FINDEXFIELDS,FISCLUINDEX,FISKEYINDEX,FBackupTime)");
                backupSQL.append(" SELECT NEWBOSID('2FEED813'),FCONTROLUNITID,");
                backupSQL.append("FTREEID,FTABLENAME,FINDEXNAME,FINDEXFIELDS,FISCLUINDEX,FISKEYINDEX,getDate() FROM ").append(tempTable);
                DbUtil.execute((Context)ctx, (String)backupSQL.toString());
                for (i = 0; i < dropSQLList.size(); ++i) {
                    aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                    try {
                        aIndexCheckMsgInfo = this.executeSql(ctx, dropSQLList.get(i).toString());
                        continue;
                    }
                    finally {
                        returnResult.add(aIndexCheckMsgInfo);
                    }
                }
                for (i = 0; i < createSQLList.size(); ++i) {
                    aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                    try {
                        aIndexCheckMsgInfo = this.executeSql(ctx, createSQLList.get(i).toString());
                        continue;
                    }
                    finally {
                        returnResult.add(aIndexCheckMsgInfo);
                    }
                }
                Connection conn = null;
                for (int i2 = 0; i2 < tableNameList.size(); ++i2) {
                    try {
                        conn = this.getConnection(ctx);
                        TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tableNameList.get(i2).toString());
                        continue;
                    }
                    catch (SQLException e) {
                        throw new EASBizException(null, (Throwable)e);
                    }
                    finally {
                        SQLUtils.cleanup(null, null, (Connection)conn);
                    }
                }
            }
            finally {
                KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
            }
        }
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexCheckMsgInfo executeSql(Context ctx, String sql) throws BOSException, EASBizException {
        if (sql == null || sql.trim().length() == 0) {
            return null;
        }
        IndexCheckMsgInfo aIndexCheckMsgInfo = new IndexCheckMsgInfo();
        Connection conn = null;
        Statement state = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            state = conn.createStatement();
            aIndexCheckMsgInfo.setRepairStrategy(sql);
            aIndexCheckMsgInfo.setResult(ResourceUtils.getMessage((String)this.res, (String)"ExcuteSuccessful"));
            state.execute(sql);
        }
        catch (SQLException e) {
            try {
                aIndexCheckMsgInfo.setResult(ResourceUtils.getMessage((String)this.res, (String)"ExceptionMessage") + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, state, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)state, (Connection)conn);
        }
        SQLUtils.cleanup(rs, (Statement)state, (Connection)conn);
        return aIndexCheckMsgInfo;
    }

    @Override
    protected Map _importIndex(Context ctx, String treeID, List tableNameList) throws BOSException, EASBizException {
        this.getIndexFromDataBase(ctx, treeID, tableNameList, "T_SCM_IndexCheck", false);
        return null;
    }

    private void getIndexFromDataBase(Context ctx, String treeID, List tableNameList, String tableName, boolean isBack) throws BOSException, EASBizException {
        if (tableNameList.size() < 1 || tableName == null || tableName.length() < 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (tableNameList != null && tableNameList.size() > 0) {
            for (int i = 0; i < tableNameList.size(); ++i) {
                stringBuffer.append("upper('").append(tableNameList.get(i)).append("'),");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)("SELECT fid FROM " + tableName + " WHERE FTABLENAME IN (" + stringBuffer + ")"));
        try {
            if (row.next()) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer isKeyIndex = new StringBuffer();
        if (KsqlUtil.isOracle((Context)ctx)) {
            sb.append(" select Index_name,table_name,column_name,descend from user_ind_columns \n");
            sb.append(" where table_name in (").append(stringBuffer.toString());
            sb.append(" ) \n ");
            sb.append(" order by table_name,index_name,COLUMN_POSITION ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            isKeyIndex.append(" select index_name,index_type,uniqueness,table_name from dba_indexes \n");
            isKeyIndex.append(" where table_name in (").append(stringBuffer.toString());
            isKeyIndex.append(" ) \n group by index_name,index_type,uniqueness,table_name \n");
            isKeyIndex.append(" order by table_name,index_name ");
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)isKeyIndex.toString());
            sb.setLength(0);
            sb.append(" SELECT FTABLENAME,FTREEID FROM T_SCM_INDEXCHECK WHERE FTABLENAME IN (").append(stringBuffer).append(")");
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            HashMap<String, Integer> isKeyMap = new HashMap<String, Integer>();
            HashMap<String, Integer> isCluMap = new HashMap<String, Integer>();
            HashMap<String, String> treeNodeMap = new HashMap<String, String>();
            try {
                while (rs2.next()) {
                    if (treeNodeMap.containsKey(rs2.getString("FTABLENAME"))) continue;
                    treeNodeMap.put(rs2.getString("FTABLENAME"), rs2.getString("FTREEID"));
                }
                while (rs1.next()) {
                    if ("UNIQUE".equals(rs1.getString("uniqueness"))) {
                        isKeyMap.put(rs1.getString("table_name") + "','" + rs1.getString("index_name"), new Integer(1));
                    }
                    if (!"cluster".equalsIgnoreCase(rs1.getString("index_type"))) continue;
                    isCluMap.put(rs1.getString("table_name") + "','" + rs1.getString("index_name"), new Integer(1));
                }
            }
            catch (SQLException e1) {
                throw new EASBizException(null, (Throwable)e1);
            }
            try {
                HashMap<String, String> tableMap = new HashMap<String, String>();
                sb.setLength(0);
                String sqlInsert = " insert into " + tableName + " (fid,FCreateTime,FCONTROLUNITID,Ftreeid  " + ",FTABLENAME ,FINDEXNAME ,FINDEXFIELDS ,FISCLUINDEX ,FISKEYINDEX )" + " values (newbosid('2AE77497'),getDate(),'00000000-0000-0000-0000-000000000000CCE7AED4',";
                ArrayList<String> tableAndIndexNameList = new ArrayList<String>();
                ArrayList<String> tablename = new ArrayList<String>();
                String key = null;
                while (rs.next()) {
                    key = rs.getString("table_name") + "','" + rs.getString("index_name");
                    if (tableMap.get(key) == null) {
                        tableMap.put(key, rs.getString("column_name"));
                        tableAndIndexNameList.add(key);
                        tablename.add(rs.getString("table_name"));
                        continue;
                    }
                    tableMap.put(key, tableMap.get(key).toString() + "," + rs.getString("column_name"));
                }
                if (tableMap != null) {
                    for (int i = 0; i < tableAndIndexNameList.size(); ++i) {
                        sb.append(sqlInsert).append("'");
                        if (isBack) {
                            sb.append(treeNodeMap.get(tablename.get(i).toString())).append("','");
                        } else {
                            sb.append(treeID).append("','");
                        }
                        sb.append(tableAndIndexNameList.get(i)).append("','");
                        sb.append(tableMap.get(tableAndIndexNameList.get(i).toString()).toString()).append("',");
                        sb.append(isCluMap.containsKey(tableAndIndexNameList.get(i).toString()) ? 1 : 0).append(",");
                        sb.append(isKeyMap.containsKey(tableAndIndexNameList.get(i).toString()) ? 1 : 0).append(");");
                    }
                }
                if (sb.length() > 0) {
                    KsqlUtil.executeBatch((Context)ctx, (String[])sb.toString().split(";"));
                }
            }
            catch (SQLException e) {
                throw new EASBizException(null, (Throwable)e);
            }
        }
    }

    @Override
    protected List _checkIndex(Context ctx, String treeIDString) throws BOSException, EASBizException {
        if (treeIDString == null || treeIDString.length() <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Create Table tt").append("(");
        stringBuffer.append("FID Varchar(44),");
        stringBuffer.append("FCONTROLUNITID Varchar(44),");
        stringBuffer.append("Ftreeid Varchar(44),");
        stringBuffer.append("FTABLENAME Varchar(200),");
        stringBuffer.append("FINDEXNAME Varchar(200),");
        stringBuffer.append("FINDEXFIELDS Varchar(200),");
        stringBuffer.append("FISCLUINDEX int,");
        stringBuffer.append("FISKEYINDEX int,FCREATETIME DateTime);");
        String tempTable = KsqlUtil.createTempTable((Context)ctx, (String)stringBuffer.toString());
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct FTABLENAME from t_scm_indexcheck where ftreeid in (select fid from t_scm_indexchecktree where fisleaf = 1 and (flongnumber like '%!");
        sb.append(treeIDString.trim());
        sb.append("!%' or flongnumber like '%!");
        sb.append(treeIDString.trim());
        sb.append("' or flongnumber like '");
        sb.append(treeIDString.trim());
        sb.append("!%'))");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<String> tableNameList = new ArrayList<String>();
        ArrayList<IndexCheckMsgInfo> returnList = new ArrayList<IndexCheckMsgInfo>();
        try {
            IndexCheckMsgInfo aIndexCheckMsgInfo;
            while (rs1.next()) {
                tableNameList.add(rs1.getString("FTABLENAME"));
            }
            this.getIndexFromDataBase(ctx, treeIDString, tableNameList, tempTable, true);
            sb.setLength(0);
            sb.append(" select FTABLENAME,FINDEXNAME,FINDEXFIELDS,FISCLUINDEX,FISKEYINDEX from t_scm_indexcheck where ftreeid in (select fid from t_scm_indexchecktree where fisleaf = 1 and (flongnumber like '%!");
            sb.append(treeIDString.trim());
            sb.append("!%' or flongnumber like '%!");
            sb.append(treeIDString.trim());
            sb.append("' or flongnumber like '");
            sb.append(treeIDString.trim());
            sb.append("!%')) order by FTABLENAME,FINDEXNAME,FINDEXFIELDS");
            IRowSet stdRs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" select FTABLENAME,FINDEXNAME,FINDEXFIELDS,FISCLUINDEX,FISKEYINDEX from ");
            sb.append(tempTable);
            sb.append(" order by FTABLENAME,FINDEXNAME,FINDEXFIELDS");
            IRowSet destRs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            boolean isExits = false;
            while (stdRs.next()) {
                String srcIndexNameStr = stdRs.getString("FINDEXNAME");
                while (destRs.next()) {
                    String destIndexNameStr = destRs.getString("FINDEXNAME");
                    if (!srcIndexNameStr.trim().equalsIgnoreCase(destIndexNameStr.trim())) continue;
                    isExits = true;
                    if (!stdRs.getString("FINDEXFIELDS").trim().equalsIgnoreCase(destRs.getString("FINDEXFIELDS").trim()) && stdRs.getString("FTABLENAME").trim().equalsIgnoreCase(destRs.getString("FTABLENAME").trim())) {
                        aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                        aIndexCheckMsgInfo.setIndexName(stdRs.getString("FINDEXNAME"));
                        aIndexCheckMsgInfo.setTableName(stdRs.getString("FTABLENAME"));
                        aIndexCheckMsgInfo.setDiffMsg(ResourceUtils.getMessageInOrder((String)this.res, (String)"stdRsIndexDefferentdestRsIndex", (String[])new String[]{stdRs.getString("FINDEXFIELDS"), destRs.getString("FINDEXFIELDS")}));
                        aIndexCheckMsgInfo.setRepairStrategy(ResourceUtils.getMessageInOrder((String)this.res, (String)"DelIndexAndRebuildstdRsIndex", (String[])new String[]{stdRs.getString("FINDEXNAME"), stdRs.getString("FINDEXNAME")}));
                        this.getSQL(stdRs, destRs, aIndexCheckMsgInfo, true);
                        returnList.add(aIndexCheckMsgInfo);
                    }
                    if (!stdRs.getString("FTABLENAME").trim().equalsIgnoreCase(destRs.getString("FTABLENAME").trim())) {
                        aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                        aIndexCheckMsgInfo.setIndexName(stdRs.getString("FINDEXNAME"));
                        aIndexCheckMsgInfo.setTableName(stdRs.getString("FTABLENAME"));
                        aIndexCheckMsgInfo.setDiffMsg(ResourceUtils.getMessageInOrder((String)this.res, (String)"stdRsTableDefferentdestRsTable", (String[])new String[]{stdRs.getString("FTABLENAME"), destRs.getString("FTABLENAME")}));
                        aIndexCheckMsgInfo.setRepairStrategy(ResourceUtils.getMessageInOrder((String)this.res, (String)"DelTableIndexAndRebuildstdRsIndex", (String[])new String[]{destRs.getString("FTABLENAME"), destRs.getString("FINDEXNAME"), stdRs.getString("FINDEXNAME")}));
                        this.getSQL(stdRs, destRs, aIndexCheckMsgInfo, true);
                        returnList.add(aIndexCheckMsgInfo);
                    }
                    if (stdRs.getInt("FISCLUINDEX") != destRs.getInt("FISCLUINDEX")) {
                        aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                        aIndexCheckMsgInfo.setIndexName(stdRs.getString("FINDEXNAME"));
                        aIndexCheckMsgInfo.setTableName(stdRs.getString("FTABLENAME"));
                        aIndexCheckMsgInfo.setDiffMsg(ResourceUtils.getMessageInOrder((String)this.res, (String)"stdRsIndexcollTagDefferentdestRsIndexcollTag", (String[])new String[]{stdRs.getString("FISCLUINDEX"), destRs.getString("FISCLUINDEX")}));
                        aIndexCheckMsgInfo.setRepairStrategy(ResourceUtils.getMessageInOrder((String)this.res, (String)"DelIndexAndRebuildstdRsIndex", (String[])new String[]{stdRs.getString("FINDEXNAME"), stdRs.getString("FINDEXNAME")}));
                        this.getSQL(stdRs, destRs, aIndexCheckMsgInfo, true);
                        returnList.add(aIndexCheckMsgInfo);
                    }
                    if (stdRs.getInt("FISKEYINDEX") == destRs.getInt("FISKEYINDEX")) continue;
                    aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                    aIndexCheckMsgInfo.setIndexName(stdRs.getString("FINDEXNAME"));
                    aIndexCheckMsgInfo.setTableName(stdRs.getString("FTABLENAME"));
                    aIndexCheckMsgInfo.setDiffMsg(ResourceUtils.getMessageInOrder((String)this.res, (String)"stdRsIndexmainTagDefferentdestRsIndexmainTag", (String[])new String[]{stdRs.getString("FISKEYINDEX"), destRs.getString("FISKEYINDEX")}));
                    aIndexCheckMsgInfo.setRepairStrategy(ResourceUtils.getMessageInOrder((String)this.res, (String)"DelIndexAndRebuildstdRsIndex", (String[])new String[]{stdRs.getString("FINDEXNAME"), stdRs.getString("FINDEXNAME")}));
                    this.getSQL(stdRs, destRs, aIndexCheckMsgInfo, true);
                    returnList.add(aIndexCheckMsgInfo);
                }
                if (!isExits) {
                    aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                    aIndexCheckMsgInfo.setIndexName(stdRs.getString("FINDEXNAME"));
                    aIndexCheckMsgInfo.setTableName(stdRs.getString("FTABLENAME"));
                    aIndexCheckMsgInfo.setDiffMsg(ResourceUtils.getMessageInOrder((String)this.res, (String)"IndexNotExistsdestRS", (String[])new String[]{stdRs.getString("FINDEXNAME")}));
                    aIndexCheckMsgInfo.setRepairStrategy(ResourceUtils.getMessageInOrder((String)this.res, (String)"BuildIndexBystdRs", (String[])new String[]{stdRs.getString("FINDEXNAME")}));
                    this.getSQL(stdRs, destRs, aIndexCheckMsgInfo, false);
                    returnList.add(aIndexCheckMsgInfo);
                    destRs.first();
                    destRs.previous();
                    while (destRs.next()) {
                        if (!stdRs.getString("FTABLENAME").trim().equalsIgnoreCase(destRs.getString("FTABLENAME").trim()) || !stdRs.getString("FINDEXFIELDS").trim().equalsIgnoreCase(destRs.getString("FINDEXFIELDS").trim())) continue;
                        aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                        aIndexCheckMsgInfo.setIndexName(stdRs.getString("FINDEXNAME"));
                        aIndexCheckMsgInfo.setTableName(stdRs.getString("FTABLENAME"));
                        aIndexCheckMsgInfo.setDiffMsg(ResourceUtils.getMessageInOrder((String)this.res, (String)"IndexRepeat", (String[])new String[]{destRs.getString("FINDEXNAME"), stdRs.getString("FINDEXNAME")}));
                        aIndexCheckMsgInfo.setRepairStrategy(ResourceUtils.getMessageInOrder((String)this.res, (String)"DelIndexAndRebuildstdRsIndex", (String[])new String[]{stdRs.getString("FINDEXNAME"), stdRs.getString("FINDEXNAME")}));
                        this.getSQL(stdRs, destRs, aIndexCheckMsgInfo, true);
                        returnList.add(aIndexCheckMsgInfo);
                    }
                }
                destRs.first();
                destRs.previous();
                isExits = false;
            }
            destRs.first();
            destRs.previous();
            stdRs.first();
            stdRs.previous();
            isExits = false;
            while (destRs.next()) {
                while (stdRs.next()) {
                    if (!destRs.getString("FINDEXNAME").trim().equalsIgnoreCase(stdRs.getString("FINDEXNAME").trim())) continue;
                    isExits = true;
                }
                if (!isExits) {
                    aIndexCheckMsgInfo = new IndexCheckMsgInfo();
                    aIndexCheckMsgInfo.setIndexName(destRs.getString("FINDEXNAME"));
                    aIndexCheckMsgInfo.setTableName(destRs.getString("FTABLENAME"));
                    aIndexCheckMsgInfo.setDiffMsg(ResourceUtils.getMessageInOrder((String)this.res, (String)"IndexNotExistsstdRs", (String[])new String[]{destRs.getString("FINDEXNAME"), destRs.getString("FINDEXFIELDS")}));
                    aIndexCheckMsgInfo.setRepairStrategy(ResourceUtils.getMessage((String)this.res, (String)"FeedBack"));
                    aIndexCheckMsgInfo.setExeDropSQL("");
                    aIndexCheckMsgInfo.setExeCreateSQL("");
                    returnList.add(aIndexCheckMsgInfo);
                }
                stdRs.first();
                stdRs.previous();
                isExits = false;
            }
        }
        catch (SQLException e) {
            throw new EASBizException(null, (Throwable)e);
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
        }
        return returnList;
    }

    private void getSQL(IRowSet stdRs, IRowSet destRs, IndexCheckMsgInfo aIndexCheckMsgInfo, boolean isHaveDropSQL) throws SQLException {
        if (isHaveDropSQL) {
            aIndexCheckMsgInfo.setExeDropSQL("DROP INDEX " + stdRs.getString("FTABLENAME") + "." + stdRs.getString("FINDEXNAME") + ";");
        } else {
            aIndexCheckMsgInfo.setExeDropSQL(" ");
        }
        if (isHaveDropSQL && destRs.getBoolean("FISKEYINDEX")) {
            aIndexCheckMsgInfo.setExeDropSQL("ALTER TABLE " + destRs.getString("FTABLENAME") + " DROP CONSTRAINT " + stdRs.getString("FINDEXNAME") + " ;");
        }
        String flag = "";
        if (stdRs.getBoolean("FISCLUINDEX")) {
            flag = "CLUSTERED";
        }
        aIndexCheckMsgInfo.setExeCreateSQL("CREATE " + flag + " INDEX " + stdRs.getString("FINDEXNAME") + " ON " + stdRs.getString("FTABLENAME") + "( " + stdRs.getString("FINDEXFIELDS") + ");");
        if (stdRs.getBoolean("FISKEYINDEX")) {
            aIndexCheckMsgInfo.setExeCreateSQL("ALTER TABLE " + stdRs.getString("FTABLENAME") + " ADD CONSTRAINT " + stdRs.getString("FINDEXNAME") + "   PRIMARY KEY (" + stdRs.getString("FINDEXFIELDS") + ");");
        }
    }
}

