/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.scm.framework.balance.AbstractDataQueryInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.DataTableCollection;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.io.Serializable;

public class DataQueryInfo
extends AbstractDataQueryInfo
implements Serializable {
    public DataQueryInfo() {
    }

    protected DataQueryInfo(String pkField) {
        super(pkField);
    }

    public DataTableInfo getMainTable() {
        DataTableCollection coll = this.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.get(i).isIsMainTable()) continue;
            return coll.get(i);
        }
        return null;
    }

    public DataTableInfo getDataTableByTableAlias(String tableAlias) {
        DataTableCollection coll = this.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            if (!tableAlias.equalsIgnoreCase(coll.get(i).getTableAlias())) continue;
            return coll.get(i);
        }
        return null;
    }

    public String getNoDumplicateTableAlias(String tableAlias) {
        String result = tableAlias;
        int i = 1;
        while (this.isTableAliasDumplicate(null, result)) {
            result = result + i;
            ++i;
        }
        return result;
    }

    public boolean isTableNameDumplicate(BOSUuid id, String tableName) {
        DataTableInfo table = null;
        DataTableCollection coll = this.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.get(i).getName().equalsIgnoreCase(tableName)) continue;
            table = coll.get(i);
            break;
        }
        if (table == null) {
            return false;
        }
        return id == null || !table.getId().equals((Object)id);
    }

    public boolean isTableAliasDumplicate(BOSUuid id, String tableAlias) {
        DataTableInfo table = this.getDataTableByTableAlias(tableAlias);
        if (table == null) {
            return false;
        }
        return id == null || !table.getId().equals((Object)id);
    }

    public FilterInfo getFilterInfo() throws BalanceModelException {
        FilterInfo filter = null;
        if (StringUtil.isEmpty((String)this.getFilterString())) {
            filter = new FilterInfo();
        } else {
            try {
                filter = new FilterInfo(this.getFilterString());
            }
            catch (ParserException e) {
                throw new BalanceModelException(BalanceModelException.DATAQUERYFILTERINVALID, new String[]{this.getName()});
            }
        }
        return filter;
    }

    public String getFromSQL() {
        StringBuffer result = new StringBuffer("FROM ");
        result.append(this.getJoinTableSQL(this.getMainTable()));
        return result.toString();
    }

    private String getJoinTableSQL(DataTableInfo table) {
        StringBuffer result = new StringBuffer();
        if (table == null) {
            return result.toString();
        }
        result.append(table.toSQL()).append("\r\n");
        DataTableCollection coll = table.getChildren(this.getEntry());
        for (int i = 0; i < coll.size(); ++i) {
            result.append(this.getJoinTableSQL(coll.get(i)));
        }
        return result.toString();
    }
}

