/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalancePlugInFactory;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.AbstractBalanceModelControllerBean;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceModelCache;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BalanceModelControllerBean
extends AbstractBalanceModelControllerBean {
    private static final long serialVersionUID = 1L;

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BalanceModelInfo info;
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        if ((info = (BalanceModelInfo)model).getState().getValue() != 1) {
            throw new BalanceModelException(BalanceModelException.CANNOTINACTIVE);
        }
        info.setState(UseStatusEnum.INACTIVE);
        super._cancel(ctx, pk, model);
        BalanceCalculatorFactory.removeCacheBalanceModel(info.getId().toString());
        BalanceModelCache.clearMemory();
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BalanceModelInfo info;
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        if ((info = (BalanceModelInfo)model).getState().getValue() == 1) {
            throw new BalanceModelException(BalanceModelException.CANNOTACTIVE);
        }
        this.checkBalanceValid(info);
        this.updateTableToDB(ctx, info);
        info.setState(UseStatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, model);
        BalanceCalculatorFactory.removeCacheBalanceModel(info.getId().toString());
        BalanceModelCache.clearMemory();
    }

    private void checkBalanceValid(BalanceModelInfo info) throws BalanceModelException {
        if (BalanceTypeEnum.Period.equals((Object)info.getBalanceType())) {
            this.PeriodBalanceCheck(info);
        }
    }

    private void PeriodBalanceCheck(BalanceModelInfo info) throws BalanceModelException {
        if (info.getMainOrgUnitField() == null) {
            throw new BalanceModelException(BalanceModelException.MAINORGFIELDISNULL);
        }
        if (info.getPeriodField() == null && info.getPeriodYearField() == null && info.getPeriodMonthField() == null) {
            throw new BalanceModelException(BalanceModelException.PERIODFIELDISNULL);
        }
        if (info.getPeriodField() != null && (info.getPeriodYearField() != null || info.getPeriodMonthField() != null)) {
            throw new BalanceModelException(BalanceModelException.PERIODFIELDISINVALID);
        }
        if (info.getPeriodField() == null && info.getPeriodYearField() == null && info.getPeriodMonthField() != null) {
            throw new BalanceModelException(BalanceModelException.NOTEXISTPERIODYEARFIELD);
        }
        if (info.getPeriodField() == null && info.getPeriodYearField() != null && info.getPeriodMonthField() == null) {
            throw new BalanceModelException(BalanceModelException.NOTEXISTPERIODMONTHFIELD);
        }
        BalanceFieldModelInfo field = null;
        BalanceFieldModelCollection coll = info.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            field = coll.get(i);
            if (BizDataTypeEnum.BeginData.equals((Object)field.getBizDataType()) && StringUtil.isEmpty((String)field.getCalExpression())) {
                throw new BalanceModelException(BalanceModelException.BEGINDATANOEXPRESSION);
            }
            if (!BizDataTypeEnum.YearTotalData.equals((Object)field.getBizDataType()) || !StringUtil.isEmpty((String)field.getCalExpression())) continue;
            throw new BalanceModelException(BalanceModelException.YEARTOTALDATANOEXPRESSION);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BalanceModelInfo info = (BalanceModelInfo)model;
        this.checkTabNameExists(ctx, info);
        IObjectPK pk = super._submit(ctx, model);
        BalanceCalculatorFactory.removeCacheBalanceModel(info.getId().toString());
        return pk;
    }

    private void checkTabNameExists(Context ctx, BalanceModelInfo info) throws BOSException, BalanceModelException {
        IRowSet rs;
        if (info == null || StringUtil.isEmpty((String)info.getTabName())) {
            return;
        }
        String sql = "select 1 from T_SCM_BalanceModel where FTabName = ?";
        if (info.getId() != null) {
            sql = sql + " and FID <>'" + info.getId().toString() + "'";
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getTabName()})).size() > 0) {
            throw new BalanceModelException(BalanceModelException.TABLEISEXIST);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)pk.toString()));
        BalanceDataModelFactory.getLocalInstance(ctx).delete(filter);
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)pk.toString()));
        BalancePlugInFactory.getLocalInstance(ctx).delete(filter);
        BalanceCalculatorFactory.removeCacheBalanceModel(pk.toString());
    }

    private boolean checkTableIsExist(Context ctx, String tableName) throws BOSException {
        String sSQL = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tableName + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
        try {
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void createNewTable(Context ctx, BalanceModelInfo info) throws BOSException, EASBizException {
        String newLine = "\n\t";
        StringBuffer createSQL = new StringBuffer();
        createSQL.append("Create Table ").append(info.getTabName()).append("(").append(newLine);
        BalanceFieldModelCollection coll = info.getEntry();
        coll.sort("seq");
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            String fieldName = fieldInfo.getFieldName();
            String dataType = BalanceUtil.getDataTypeStr(ctx, fieldInfo);
            String defaultValue = BalanceUtil.getDefaultValueSQL(fieldInfo, true);
            String constraint = !fieldInfo.isIsNullable() ? "Not Null" : "";
            createSQL.append("  ").append(fieldName).append(" ").append(dataType).append(" ").append(defaultValue).append(" ").append(constraint).append(",").append(newLine);
        }
        String pkName = BalanceUtil.getPkName(info.getTabName());
        createSQL.append("CONSTRAINT ").append(pkName).append(" PRIMARY KEY (FID)");
        createSQL.append(")");
        DbUtil.execute((Context)ctx, (String)createSQL.toString());
    }

    private void updateTableToDB(Context ctx, BalanceModelInfo info) throws BOSException, EASBizException {
        int i;
        if (info == null || StringUtil.isEmpty((String)info.getTabName())) {
            return;
        }
        if (!this.checkTableIsExist(ctx, info.getTabName())) {
            this.createNewTable(ctx, info);
            return;
        }
        Map<String, FieldMetaData> dbTable = this.getDBTableFieldMap(ctx, info.getTabName());
        FieldMetaData dbField = null;
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = info.getEntry();
        ArrayList<String> alterSQLList = new ArrayList<String>();
        for (i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.isIsScheduled()) continue;
            dbField = dbTable.get(fieldInfo.getFieldName().toUpperCase());
            if (dbField == null) {
                alterSQLList.add(this.getAddFieldSQL(ctx, info.getTabName(), fieldInfo));
                continue;
            }
            if (KsqlUtil.isSQLServer((Context)ctx)) {
                if ("0".equals(dbField.getDefaultValue()) && !StringUtil.isEmpty((String)fieldInfo.getDefaultValue())) {
                    alterSQLList.add(this.getAddFieldDefaultValueSQL(info.getTabName(), fieldInfo));
                    alterSQLList.add(this.getUpdateDefaultValueSQL(info.getTabName(), fieldInfo));
                } else if (!"0".equals(dbField.getDefaultValue()) && StringUtil.isEmpty((String)fieldInfo.getDefaultValue())) {
                    alterSQLList.add(this.getDropFieldDefaultValueSQL(info.getTabName(), fieldInfo));
                }
            } else if (dbField.getDefaultValue() == null && !StringUtil.isEmpty((String)fieldInfo.getDefaultValue())) {
                alterSQLList.add(this.getAddFieldDefaultValueSQL(info.getTabName(), fieldInfo));
            } else if (dbField.getDefaultValue() != null && StringUtil.isEmpty((String)fieldInfo.getDefaultValue())) {
                alterSQLList.add(this.getDropFieldDefaultValueSQL(info.getTabName(), fieldInfo));
            }
            if (dbField.isNullabled && !fieldInfo.isIsNullable()) {
                alterSQLList.add(this.getAlterFieldNullabledSQL(ctx, info.getTabName(), fieldInfo, false));
                continue;
            }
            if (dbField.isNullabled || !fieldInfo.isIsNullable()) continue;
            alterSQLList.add(this.getAlterFieldNullabledSQL(ctx, info.getTabName(), fieldInfo, true));
        }
        for (i = 0; i < alterSQLList.size(); ++i) {
            String[] sql = ((String)alterSQLList.get(i)).split(";");
            for (int k = 0; k < sql.length; ++k) {
                DbUtil.execute((Context)ctx, (String)sql[k]);
            }
        }
    }

    private Map<String, FieldMetaData> getDBTableFieldMap(Context ctx, String tableName) throws BOSException {
        String sSQL = "select ksql_col_name, ksql_col_type, ksql_col_length, ksql_col_default, ksql_col_nullable from ksql_usercolumns where ksql_col_tabname = '" + tableName + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sSQL);
        FieldMetaData field = null;
        String nullableValue = null;
        HashMap<String, FieldMetaData> dbTable = new HashMap<String, FieldMetaData>();
        try {
            while (rs.next()) {
                field = new FieldMetaData();
                field.setName(rs.getString("ksql_col_name"));
                field.setDataType(rs.getString("ksql_col_type"));
                field.setLength(rs.getInt("ksql_col_length"));
                field.setDefaultValue(rs.getString("ksql_col_default"));
                nullableValue = rs.getString("ksql_col_nullable");
                if ("Y".equalsIgnoreCase(nullableValue) || "1".equals(nullableValue)) {
                    field.setNullabled(true);
                } else {
                    field.setNullabled(false);
                }
                dbTable.put(field.getName().toUpperCase(), field);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return dbTable;
    }

    private String getAddFieldSQL(Context ctx, String tableName, BalanceFieldModelInfo fieldInfo) throws EASBizException {
        StringBuffer sSQL = new StringBuffer();
        String fieldName = fieldInfo.getFieldName();
        String dataType = BalanceUtil.getDataTypeStr(ctx, fieldInfo);
        String defaultValue = BalanceUtil.getDefaultValueSQL(fieldInfo, true);
        String constraint = !fieldInfo.isIsNullable() ? "Not Null" : "";
        sSQL.append("Alter table ").append(tableName).append(" add ");
        sSQL.append(fieldName).append(" ");
        sSQL.append(dataType).append(" ");
        sSQL.append(defaultValue).append(" ").append(constraint);
        if ("T_IM_InventoryBalance".equals(tableName)) {
            sSQL.append(";");
            String tempStr = sSQL.toString();
            tempStr = tempStr.replaceAll("T_IM_InventoryBalance", "T_IM_PreInventoryBalance");
            sSQL.append(tempStr);
        }
        return sSQL.toString();
    }

    private String getAddFieldDefaultValueSQL(String tableName, BalanceFieldModelInfo fieldInfo) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Alter table ").append(tableName).append(" add ");
        sSQL.append(BalanceUtil.getDefaultValueSQL(fieldInfo, true)).append(" for ");
        sSQL.append(fieldInfo.getFieldName());
        return sSQL.toString();
    }

    private String getUpdateDefaultValueSQL(String tableName, BalanceFieldModelInfo fieldInfo) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update ").append(tableName).append(" set ");
        sSQL.append(fieldInfo.getFieldName()).append(" = ");
        sSQL.append(BalanceUtil.getDefaultValueSQL(fieldInfo, false));
        sSQL.append(" where ").append(fieldInfo.getFieldName()).append(" is null ");
        return sSQL.toString();
    }

    private String getDropFieldDefaultValueSQL(String tableName, BalanceFieldModelInfo fieldInfo) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Alter table ").append(tableName).append(" drop default for ");
        sSQL.append(fieldInfo.getFieldName());
        return sSQL.toString();
    }

    private String getAlterFieldNullabledSQL(Context ctx, String tableName, BalanceFieldModelInfo fieldInfo, boolean isNullabled) throws BalanceModelException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Alter table ").append(tableName).append(" alter column ");
        sSQL.append(fieldInfo.getFieldName()).append(" ");
        sSQL.append(BalanceUtil.getDataTypeStr(ctx, fieldInfo));
        if (isNullabled) {
            sSQL.append(" Null");
        } else {
            sSQL.append(" Not Null");
        }
        return sSQL.toString();
    }

    class FieldMetaData {
        String name;
        String dataType;
        int length;
        String defaultValue;
        boolean isNullabled;

        FieldMetaData() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isNullabled() {
            return this.isNullabled;
        }

        public void setNullabled(boolean isNullabled) {
            this.isNullabled = isNullabled;
        }
    }
}

