/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.app.thread.QueryDataSyncLock;
import com.kingdee.eas.scm.framework.app.thread.QueryDataTask;
import com.kingdee.eas.scm.framework.app.thread.ThreadPool;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalancePlugInCollection;
import com.kingdee.eas.scm.framework.balance.BalancePlugInInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceModelCache;
import com.kingdee.eas.scm.framework.balance.app.engine.IBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.log.BalanceLogFactory;
import com.kingdee.eas.scm.framework.balance.app.log.IBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.framework.balance.app.plugin.IBalancePlugInHandler;
import com.kingdee.eas.scm.framework.balance.util.BalanceFormulaPaser;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBalanceCalculator
implements IBalanceCalculator {
    private static final String PROPER_NAME = "seq";
    protected Context ctx;
    protected OperationTypeEnum OPType;
    protected IBalanceLogger logger;
    protected LowTimer timer;
    protected String detailTempTable;
    protected String finalTempTable;
    protected BalanceModelInfo balanceModelInfo;
    protected String balBosType;
    protected BalanceDataModelCollection balanceDataModelColl;
    protected BalanceFormulaPaser parser;
    protected BalancePlugInCollection plugInColl;

    public AbstractBalanceCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.balanceModelInfo = (BalanceModelInfo)balanceModelInfo.clone();
        this.balBosType = BalanceUtil.getBosTypeByModelId(balanceModelInfo.getId().toString());
        this.timer = new LowTimer();
        this.logger = BalanceLogFactory.getLogger(ctx, balanceModelInfo);
    }

    protected void init() throws BOSException, EASBizException {
        this.balanceModelInfo.getEntry().sort(PROPER_NAME);
        this.createTempTable();
        this.afterCreateTempTable();
        this.parser = new BalanceFormulaPaser(this.balanceModelInfo.getEntry());
        this.balanceDataModelColl = this.getBalaceDataModelCollection();
        this.getBalancePlugIn();
    }

    private BalanceDataModelCollection getBalaceDataModelCollection() throws BOSException {
        return BalanceModelCache.getBalanceDataModelCollection(this.ctx, this.getBalanceDataModelView());
    }

    protected EntityViewInfo getBalanceDataModelView() {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.getBalanceDataModelFilter());
        view.setSelector(BalanceEnginUtil.getBalanceDataModelSelector());
        return view;
    }

    protected abstract FilterInfo getBalanceDataModelFilter();

    protected void getBalancePlugIn() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.getPlugInFilter());
        SorterItemCollection sortor = new SorterItemCollection();
        sortor.add(new SorterItemInfo(PROPER_NAME));
        view.setSorter(sortor);
        this.plugInColl = BalanceModelCache.getBalancePlugInCollection(this.ctx, view);
    }

    protected FilterInfo getPlugInFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        return filter;
    }

    protected String createFinalTempTable() throws BOSException, BalanceModelException {
        return null;
    }

    protected void createTempTable() throws BOSException, BalanceModelException {
        this.timer.reset();
        String createSQL = BalanceEnginUtil.getCreateTempTableSQL(this.ctx, this.balanceModelInfo);
        this.logger.debugSQL("\u521b\u5efa\u4e34\u65f6\u8868SQL\u8bed\u53e5\uff1a", createSQL);
        this.detailTempTable = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createSQL);
        this.finalTempTable = this.createFinalTempTable();
        if (StringUtils.isEmpty((String)this.finalTempTable)) {
            this.finalTempTable = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createSQL);
            KsqlUtil.createTempTableIndex((Context)this.ctx, (String)this.finalTempTable, (String)"FID", (boolean)false, (boolean)false);
            KsqlUtil.createTempTableIndex((Context)this.ctx, (String)this.finalTempTable, (String)"FLOT,FMATERIALID,FLOCATIONID", (boolean)false, (boolean)false);
            this.logger.info("\u521b\u5efa\u4e34\u65f6\u8868\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        }
    }

    protected void afterCreateTempTable() throws BOSException {
    }

    public void releaseTempTable() throws BOSException {
        KsqlUtil.releaseTempTable((Context)this.ctx, (String)this.detailTempTable);
        boolean needRelease = false;
        try {
            if (StringUtils.isEmpty((String)this.createFinalTempTable())) {
                needRelease = true;
            }
        }
        catch (BalanceModelException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        if (needRelease) {
            KsqlUtil.releaseTempTable((Context)this.ctx, (String)this.finalTempTable);
        }
    }

    protected String getInsertSQL(String tableName) {
        StringBuffer insertSQL = new StringBuffer(300);
        insertSQL.append("INSERT INTO ").append(tableName).append("(");
        String balanceModelColumns = BalanceEnginUtil.getBalanceModelFieldStr(this.balanceModelInfo, null);
        insertSQL.append(balanceModelColumns);
        insertSQL.append(")");
        return insertSQL.toString();
    }

    protected void groupDetailDataToFinalTable() throws BOSException {
        StringBuffer groupSQL = new StringBuffer();
        groupSQL.append(this.getInsertSQL(this.finalTempTable)).append("\r\n");
        groupSQL.append("SELECT ");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                groupSQL.append(",");
            }
            if (i == 0) {
                groupSQL.append("newbosid('").append(this.balBosType).append("') AS FID");
                continue;
            }
            if (BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.HappenData.equals((Object)fieldInfo.getBizDataType())) {
                groupSQL.append("SUM(").append(fieldInfo.getFieldName()).append(")").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) {
                groupSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.AssistInfo.equals((Object)fieldInfo.getBizDataType())) {
                groupSQL.append("MAX(").append(fieldInfo.getFieldName()).append(")").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            groupSQL.append(fieldInfo.getFieldName());
        }
        groupSQL.append("\r\n");
        groupSQL.append("FROM ").append(this.detailTempTable).append("\r\n");
        groupSQL.append(this.getGroupbySQL());
        this.logger.debugSQL("\u5206\u7ec4\u6c47\u603bSQL\uff1a", groupSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)groupSQL.toString());
    }

    protected String getGroupbySQL() {
        StringBuffer groupSQL = new StringBuffer();
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Year.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Month.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Period.equals((Object)fieldInfo.getBizDataType())) continue;
            if (groupSQL.length() > 0) {
                groupSQL.append(",");
            }
            groupSQL.append(fieldInfo.getFieldName());
        }
        groupSQL.insert(0, "Group by ");
        return groupSQL.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculate(String orgUnitID, PeriodInfo period, OperationTypeEnum OPType, boolean isReCalculate) throws BOSException, EASBizException {
        this.OPType = OPType;
        this.timer.reset();
        this.init();
        this.logger.info("\u4f59\u989d\u8ba1\u7b97\u5668\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
        try {
            this.beforeCalculate();
            this.calculateStep();
            this.afterCalculate();
        }
        finally {
            this.releaseTempTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculate(String bosType, String billID, OperationTypeEnum OPType) throws BOSException, EASBizException {
        this.OPType = OPType;
        this.init();
        this.logger.info("\u4f59\u989d\u8ba1\u7b97\u5668\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
        try {
            this.beforeCalculate();
            this.calculateStep();
            this.afterCalculate();
        }
        finally {
            this.releaseTempTable();
        }
    }

    protected void beforeCalculate() throws BalanceModelException {
    }

    protected void afterCalculate() throws BalanceModelException {
    }

    protected abstract void calculateStep() throws BOSException, EASBizException;

    protected void takeBillData() throws BOSException, BalanceModelException {
        ISQLBuilder sqlBuilder = null;
        List<ISQLBuilder> sqlBuilderList = this.getSQLBuilder();
        Connection conn = null;
        int size = sqlBuilderList.size();
        int initialCapacity = Math.round((float)(15 + size) / 0.75f) + 1;
        QueryDataSyncLock lock = new QueryDataSyncLock(initialCapacity);
        ThreadPool threadPool = ThreadPool.getInstance();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            String insertSQL = this.getInsertSQL(this.detailTempTable);
            StringBuffer sSQL = new StringBuffer(300);
            String[] sqls = this.isUseThreadPool4TakeBill() != false ? null : new String[size];
            for (int i = 0; i < size; ++i) {
                sqlBuilder = sqlBuilderList.get(i);
                String selectSQL = sqlBuilder.getSQL();
                if (StringUtil.isEmpty((String)selectSQL)) continue;
                if (sSQL.length() > 0) {
                    sSQL.setLength(0);
                }
                sSQL.append(insertSQL).append("\r\n").append(selectSQL);
                this.logger.debugSQL("\u53d6\u6570SQL\uff1a", sSQL.toString());
                if (this.isUseThreadPool4TakeBill().booleanValue()) {
                    QueryDataTask thread = new QueryDataTask(lock, sqlBuilder.getExecuteLockName(), conn, sSQL.toString());
                    lock.addLock(sqlBuilder.getExecuteLockName());
                    threadPool.addTask(thread);
                    continue;
                }
                sqls[i] = sSQL.toString();
            }
            if (null != sqls && sqls.length > 0) {
                KsqlUtil.executeBatch((Context)this.ctx, (String[])sqls);
            } else {
                lock.waitFinish();
            }
        }
        catch (BOSException e) {
            this.logger.error("\u591a\u7ebf\u7a0b\u53d6\u6570\u51fa\u9519\uff1a" + (Object)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            this.logger.error("\u591a\u7ebf\u7a0b\u53d6\u6570\u51fa\u9519\uff1a" + e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected List<ISQLBuilder> getSQLBuilder() {
        ISQLBuilder sqlBuilder = null;
        ArrayList<ISQLBuilder> sqlBuilderList = new ArrayList<ISQLBuilder>();
        int size = this.balanceDataModelColl.size();
        for (int i = 0; i < size; ++i) {
            sqlBuilder = this.createSQLBuilder(this.balanceDataModelColl.get(i));
            if (null == sqlBuilder) continue;
            sqlBuilderList.add(sqlBuilder);
        }
        return sqlBuilderList;
    }

    protected abstract ISQLBuilder createSQLBuilder(BalanceDataModelInfo var1);

    protected void invokePlugInHandler(InvokeTime handleTime) throws BOSException, EASBizException {
        BalancePlugInInfo plugIn = null;
        IBalancePlugInHandler handler = null;
        LowTimer timer = new LowTimer();
        HandlerParameter params = this.getHandlerParameter();
        for (int i = 0; i < this.plugInColl.size(); ++i) {
            plugIn = this.plugInColl.get(i);
            handler = this.getPlugInHandler(plugIn);
            if (handler == null) continue;
            try {
                timer.reset();
                if (InvokeTime.AfterDetailData.equals((Object)handleTime)) {
                    handler.handleAfterDetailData(this.ctx, this.detailTempTable, params);
                } else if (InvokeTime.AfterFinalData.equals((Object)handleTime)) {
                    handler.handleAfterFinalReadyData(this.ctx, this.finalTempTable, params);
                } else if (InvokeTime.AfterFinalBeforeLock.equals((Object)handleTime)) {
                    handler.handleAfterFinalDataBeforeLock(this.ctx, this.finalTempTable, params);
                }
                this.logger.info("\u63d2\u4ef6\uff1a" + handler.getClass().getSimpleName() + ",\u5904\u7406\u82b1\u8d39\uff1a" + timer.msValue());
                continue;
            }
            catch (BOSException e1) {
                this.logger.error("\u63d2\u4ef6\uff1a" + handler.getClass().getSimpleName() + "\u6267\u884c\u51fa\u9519\uff1a" + (Object)((Object)e1));
                throw e1;
            }
            catch (EASBizException e2) {
                this.logger.error("\u63d2\u4ef6\uff1a" + handler.getClass().getSimpleName() + "\u6267\u884c\u51fa\u9519\uff1a" + (Object)((Object)e2));
                throw e2;
            }
        }
    }

    protected IBalancePlugInHandler getPlugInHandler(BalancePlugInInfo plugIn) throws BalanceModelException {
        IBalancePlugInHandler handler;
        String className = plugIn.getPlugInClass();
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object tmpHandler = clazz.newInstance();
            if (!(tmpHandler instanceof IBalancePlugInHandler)) {
                throw new BalanceModelException(BalanceModelException.PLUGINNOTIMPLINTERFACE, new String[]{plugIn.getName()});
            }
            handler = (IBalancePlugInHandler)tmpHandler;
        }
        catch (ClassNotFoundException e) {
            throw new BalanceModelException(BalanceModelException.PLUGINCLASSNOTFOUND, new String[]{plugIn.getName(), plugIn.getPlugInClass()});
        }
        catch (InstantiationException e1) {
            throw new BalanceModelException(BalanceModelException.PLUGINNEWINSTANCEERROR, new String[]{plugIn.getName(), e1.getMessage()});
        }
        catch (IllegalAccessException e2) {
            throw new BalanceModelException(BalanceModelException.PLUGINNEWINSTANCEERROR, new String[]{plugIn.getName(), e2.getMessage()});
        }
        return handler;
    }

    protected HandlerParameter getHandlerParameter() {
        HandlerParameter params = new HandlerParameter(this.balanceModelInfo);
        params.setDetailTempTable(this.detailTempTable);
        params.setFinalTempTable(this.finalTempTable);
        params.setOPType(this.OPType);
        params.setLogger(this.logger);
        return params;
    }

    protected Boolean isUseThreadPool4TakeBill() {
        return true;
    }

    public AbstractBalanceCalculator setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public AbstractBalanceCalculator setBalanceModelInfo(BalanceModelInfo balanceModelInfo) {
        this.balanceModelInfo = balanceModelInfo;
        return this;
    }
}

