/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.PlugInApplyRangeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.AbstractBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.ArApBalanceSQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import java.util.Date;
import java.util.List;

public class ArApBalanceCalculator
extends AbstractBalanceCalculator {
    private String companyId;
    private PeriodInfo currPeriod;
    private String tableName;
    private Date beginDate;
    private Date endDate;
    private String currencyId;
    private String asstActTypeId;
    private List<String> asstActIdList;

    public ArApBalanceCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
    }

    public void calculate(String tableName, String orgUnitID, PeriodInfo currPeriod, String currencyId, String asstActTypeId, List<String> asstActIdList, Date beginDate, Date endDate) throws BOSException, EASBizException {
        this.tableName = tableName;
        this.companyId = orgUnitID;
        this.currPeriod = currPeriod;
        this.currencyId = currencyId;
        this.asstActTypeId = asstActTypeId;
        this.asstActIdList = asstActIdList;
        this.beginDate = beginDate;
        this.endDate = endDate;
        super.calculate(orgUnitID, currPeriod, OperationTypeEnum.Positive, false);
    }

    @Override
    protected void calculateStep() throws BOSException, EASBizException {
        this.timer.reset();
        this.takeBillData();
        this.logger.info("\u6839\u636e\u6a21\u578b\u53d6\u6570\u914d\u7f6e\u4fe1\u606f\u53d6\u6570\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e==================");
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.timer.reset();
        this.groupDetailDataToFinalTable();
        this.logger.info("\u5c06\u660e\u7ec6\u6570\u636e\u6309\u7ef4\u5ea6\u6c47\u603b\u5230\u5206\u7ec4\u4e34\u65f6\u8868\u82b1\u8d39\uff1a" + this.timer.msValue());
    }

    @Override
    protected void groupDetailDataToFinalTable() throws BOSException {
        StringBuffer groupSQL = new StringBuffer();
        groupSQL.append(this.getInsertSQL(this.tableName)).append("\r\n");
        groupSQL.append("SELECT ");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                groupSQL.append(",");
            }
            if (i == 0) {
                groupSQL.append("newbosid('").append(this.balBosType).append("') AS FID");
                continue;
            }
            if (BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.HappenData.equals((Object)fieldInfo.getBizDataType())) {
                groupSQL.append("SUM(").append(fieldInfo.getFieldName()).append(")").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) {
                groupSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.AssistInfo.equals((Object)fieldInfo.getBizDataType())) {
                groupSQL.append("MAX(").append(fieldInfo.getFieldName()).append(")").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            groupSQL.append(fieldInfo.getFieldName());
        }
        groupSQL.append("\r\n");
        groupSQL.append("FROM ").append(this.detailTempTable).append("\r\n");
        groupSQL.append(this.getGroupbySQL());
        this.logger.debugSQL("\u5206\u7ec4\u6c47\u603bSQL\uff1a", groupSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)groupSQL.toString());
    }

    @Override
    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new ArApBalanceSQLBuilder(this.balanceModelInfo, dataModelInfo, this.companyId, this.currPeriod, this.beginDate, this.endDate, this.currencyId, this.asstActTypeId, this.asstActIdList);
    }

    @Override
    protected FilterInfo getBalanceDataModelFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)UseStatusEnum.ACTIVE));
        filter.getFilterItems().add(new FilterItemInfo("isInitialize", (Object)Boolean.FALSE));
        return filter;
    }

    @Override
    protected FilterInfo getPlugInFilter() {
        FilterInfo filter = super.getPlugInFilter();
        filter.getFilterItems().add(new FilterItemInfo("applyRange", (Object)PlugInApplyRangeEnum.OnlyForInit, CompareType.NOTEQUALS));
        return filter;
    }

    @Override
    protected HandlerParameter getHandlerParameter() {
        HandlerParameter params = new HandlerParameter(this.balanceModelInfo);
        params.setOrgUnitID(this.companyId);
        params.setCurPeriod(this.currPeriod);
        params.setLogger(this.logger);
        return params;
    }
}

