/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.DateFilterTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceSQLBuilder;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class ArApBalanceSQLBuilder
extends PeriodBalanceSQLBuilder {
    private static final String FIELD_CURRENCY = "Currency";
    private static final String FIELD_ASSTACTTYPE = "AsstActType";
    private static final String FIELD_ASSTACT = "AsstActID";
    private Date beginDate;
    private Date endDate;
    private String currencyId;
    private String asstActTypeId;
    private List<String> asstActIdList;

    public ArApBalanceSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo, String orgUnitID, PeriodInfo period, Date beginDate, Date endDate, String currencyId, String asstActTypeId, List<String> asstActIdList) {
        super(balanceModelInfo, dataModelInfo, orgUnitID, period);
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.currencyId = currencyId;
        this.asstActTypeId = asstActTypeId;
        this.asstActIdList = asstActIdList;
    }

    @Override
    protected FilterInfo getExtendFilter() throws BalanceModelException, BOSException {
        FilterInfo filter = super.getExtendFilter();
        filter.mergeFilter(this.getArApBalanceFilter(), "AND");
        return filter;
    }

    private FilterInfo getArApBalanceFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.currencyId != null && this.currencyId.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(this.getFieldNameByName(FIELD_CURRENCY), (Object)this.currencyId));
        }
        if (this.asstActTypeId != null && this.asstActTypeId.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(this.getFieldNameByName(FIELD_ASSTACTTYPE), (Object)this.asstActTypeId));
        }
        if (this.asstActIdList != null && this.asstActIdList.size() > 0) {
            HashSet<String> idSet = new HashSet<String>(this.asstActIdList);
            filter.getFilterItems().add(new FilterItemInfo(this.getFieldNameByName(FIELD_ASSTACT), idSet, CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    protected FilterInfo getDateFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (DateFilterTypeEnum.BizDate.equals((Object)this.dataModelInfo.getDateFilterType())) {
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getBizDateField(), (Object)this.beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getBizDateField(), (Object)this.endDate, CompareType.LESS));
        }
        return filter;
    }
}

