/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.AbstractBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.ArApBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceModelCache;
import com.kingdee.eas.scm.framework.balance.app.engine.IBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.InvPeriodBalanceInitCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceInitCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.RealTimeBalanceCalculator;
import java.util.HashMap;
import java.util.Map;

public class BalanceCalculatorFactory {
    private static Map<String, BalanceModelInfo> balanceModelCache = new HashMap<String, BalanceModelInfo>();

    private static BalanceModelInfo getBalanceModelInfo(Context ctx, String balanceModelId) throws EASBizException, BOSException {
        return BalanceModelCache.getBalanceModelInfo(ctx, balanceModelId);
    }

    public static void removeCacheBalanceModel(String balanceModelId) {
        balanceModelCache.remove(balanceModelId);
    }

    public static IBalanceCalculator getCalculator(Context ctx, IObjectPK balanceModelId) throws BOSException, EASBizException {
        AbstractBalanceCalculator balanceCalculator = null;
        BalanceModelInfo balanceModelInfo = BalanceCalculatorFactory.getBalanceModelInfo(ctx, balanceModelId.toString());
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        if (BalanceTypeEnum.Period.equals((Object)balanceModelInfo.getBalanceType())) {
            balanceCalculator = new PeriodBalanceCalculator(ctx, balanceModelInfo);
        } else if (BalanceTypeEnum.RealTime.equals((Object)balanceModelInfo.getBalanceType())) {
            balanceCalculator = new RealTimeBalanceCalculator(ctx, balanceModelInfo);
        }
        return balanceCalculator;
    }

    public static IBalanceCalculator getCalculator(Context ctx, String balanceModelNumber) throws BOSException, EASBizException {
        AbstractBalanceCalculator balanceCalculator = null;
        String osql = "Select *, entry.* where number = '" + balanceModelNumber + "'";
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance(ctx).getBalanceModelInfo(osql);
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        if (BalanceTypeEnum.Period.equals((Object)balanceModelInfo.getBalanceType())) {
            balanceCalculator = new PeriodBalanceCalculator(ctx, balanceModelInfo);
        } else if (BalanceTypeEnum.RealTime.equals((Object)balanceModelInfo.getBalanceType())) {
            balanceCalculator = new RealTimeBalanceCalculator(ctx, balanceModelInfo);
        }
        return balanceCalculator;
    }

    public static IBalanceCalculator getInitCalculator(Context ctx, IObjectPK balanceModelId) throws BOSException, EASBizException {
        PeriodBalanceInitCalculator balanceCalculator = null;
        BalanceModelInfo balanceModelInfo = BalanceCalculatorFactory.getBalanceModelInfo(ctx, balanceModelId.toString());
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        balanceCalculator = new PeriodBalanceInitCalculator(ctx, balanceModelInfo);
        return balanceCalculator;
    }

    public static IBalanceCalculator getInitCalculator(Context ctx, String balanceModelNumber) throws BOSException, EASBizException {
        PeriodBalanceInitCalculator balanceCalculator = null;
        String osql = "Select *, entry.* where number = '" + balanceModelNumber + "'";
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance(ctx).getBalanceModelInfo(osql);
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        balanceCalculator = new PeriodBalanceInitCalculator(ctx, balanceModelInfo);
        return balanceCalculator;
    }

    public static IBalanceCalculator getInvInitPeriodBalanceCalculator(Context ctx) throws BOSException, EASBizException {
        InvPeriodBalanceInitCalculator balanceCalculator = null;
        BalanceModelInfo balanceModelInfo = BalanceCalculatorFactory.getBalanceModelInfo(ctx, "seqjlFTGSS+fnntnBdl2kyPUYjI=");
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        balanceCalculator = new InvPeriodBalanceInitCalculator(ctx, balanceModelInfo);
        return balanceCalculator;
    }

    public static ArApBalanceCalculator getArApBalanceCalculator(Context ctx, IObjectPK balanceModelId) throws BOSException, EASBizException {
        BalanceModelInfo balanceModelInfo = BalanceCalculatorFactory.getBalanceModelInfo(ctx, balanceModelId.toString());
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        return new ArApBalanceCalculator(ctx, balanceModelInfo);
    }
}

