/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldDataModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;

public class BalanceDataModelSQLBuilder
implements ISQLBuilder {
    protected BalanceModelInfo balanceModelInfo;
    protected BalanceDataModelInfo dataModelInfo;

    public BalanceDataModelSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo) {
        this.balanceModelInfo = balanceModelInfo;
        this.dataModelInfo = dataModelInfo;
    }

    @Override
    public String getSQL() throws BOSException, BalanceModelException {
        StringBuilder result = new StringBuilder(500);
        result.append(this.getSelectSQL()).append("\r\n");
        result.append(this.getFromSQL());
        FilterInfo filter = this.getFilterInfo();
        if (!StringUtil.isEmpty((String)filter.toString())) {
            result.append("WHERE ").append(filter.toString()).append("\r\n");
        }
        return result.toString().replaceAll("\"", "'");
    }

    @Override
    public String getExecuteLockName() {
        return this.dataModelInfo.getId().toString();
    }

    protected String getSelectSQL() {
        StringBuilder result = new StringBuilder(300).append("SELECT ").append("\r\n");
        BalanceFieldModelInfo fieldModel = null;
        BalanceFieldDataModelInfo fieldDataModel = null;
        BalanceFieldModelCollection fieldColl = this.balanceModelInfo.getEntry();
        for (int i = 0; i < fieldColl.size(); ++i) {
            fieldModel = fieldColl.get(i);
            if (i > 0) {
                result.append(",").append("\r\n");
            }
            if ((fieldDataModel = this.dataModelInfo.getFieldDataModelByFieldID(fieldModel.getId().toString())) == null) {
                result.append(this.getFieldSQL(fieldModel));
                continue;
            }
            result.append(this.getFieldDataModelSQL(fieldModel, fieldDataModel));
        }
        return result.toString();
    }

    protected String getFieldDataModelSQL(BalanceFieldModelInfo fieldModel, BalanceFieldDataModelInfo fieldDataModel) {
        if (fieldDataModel.isConstant()) {
            return fieldDataModel.getConstantValue() + " AS " + fieldModel.getFieldName();
        }
        if (StringUtil.isEmpty((String)fieldModel.getDefaultValue())) {
            return fieldDataModel.getValueExpression() + " AS " + fieldModel.getFieldName();
        }
        String defaultValue = BalanceUtil.getDefaultValueSQL(fieldModel, false);
        return "ISNULL(" + fieldDataModel.getValueExpression() + ", " + defaultValue + ")" + " AS " + fieldModel.getFieldName();
    }

    protected String getFromSQL() {
        DataQueryInfo dataQuery = this.dataModelInfo.getDataQuery();
        return dataQuery.getFromSQL();
    }

    private FilterInfo getFilterInfo() throws BalanceModelException, BOSException {
        FilterInfo filter = this.dataModelInfo.getFilterInfo();
        DataQueryInfo dataQuery = this.dataModelInfo.getDataQuery();
        filter.mergeFilter(dataQuery.getFilterInfo(), "AND");
        filter.mergeFilter(this.getExtendFilter(), "AND");
        return filter;
    }

    protected FilterInfo getExtendFilter() throws BalanceModelException, BOSException {
        return null;
    }

    protected String getFieldSQL(BalanceFieldModelInfo fieldModel) {
        String defaultValue;
        String result = "";
        result = fieldModel.getName().equalsIgnoreCase("ID") ? this.dataModelInfo.getDataQuery().getMainTable().getTableAlias() + ".FID AS FID" : (BizDataTypeEnum.Year.equals((Object)fieldModel.getBizDataType()) ? this.dataModelInfo.getPeriodYear() + " AS " + fieldModel.getFieldName() : (BizDataTypeEnum.Month.equals((Object)fieldModel.getBizDataType()) ? this.dataModelInfo.getPeriodMonth() + " AS " + fieldModel.getFieldName() : (BizDataTypeEnum.Period.equals((Object)fieldModel.getBizDataType()) ? this.dataModelInfo.getPeriodIdField() + " AS " + fieldModel.getFieldName() : (StringUtil.isEmpty((String)(defaultValue = BalanceUtil.getDefaultValueSQL(fieldModel, false))) ? "NULL AS " + fieldModel.getFieldName() : defaultValue + " AS " + fieldModel.getFieldName()))));
        return result;
    }

    protected String getFieldNameById(String fieldId) {
        BalanceFieldDataModelCollection coll = this.dataModelInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            BalanceFieldModelInfo field = coll.get(i).getBalanceField();
            if (!fieldId.equals(field.getId().toString())) continue;
            return coll.get(i).getValueExpression();
        }
        return null;
    }

    protected String getFieldNameByName(String fieldName) {
        BalanceFieldDataModelCollection coll = this.dataModelInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            BalanceFieldModelInfo field = coll.get(i).getBalanceField();
            if (!fieldName.equals(field.getName())) continue;
            return coll.get(i).getValueExpression();
        }
        return null;
    }
}

