/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.log.IBalanceLogger;
import com.kingdee.eas.scm.framework.balance.util.BalanceConst;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InsertNewRecordHelper {
    private IBalanceLogger logger;
    private BalanceModelInfo balanceModelInfo;

    public InsertNewRecordHelper(BalanceModelInfo balanceModelInfo, IBalanceLogger logger) {
        this.logger = logger;
        this.balanceModelInfo = balanceModelInfo;
    }

    public String getSelectNotExistRecordSQL(String tableName) {
        String tmpTablePrefix = "tmp";
        String balTablePrefix = "bal";
        StringBuffer sSQL = new StringBuffer("SELECT ");
        sSQL.append(BalanceEnginUtil.getBalanceModelFieldStr(this.balanceModelInfo, tmpTablePrefix));
        sSQL.append("\r\n");
        sSQL.append("FROM ");
        sSQL.append(tableName).append(" ").append(tmpTablePrefix).append("\r\n");
        sSQL.append(" LEFT JOIN ").append(this.balanceModelInfo.getTabName()).append(" ").append(balTablePrefix);
        sSQL.append(" ON ").append(InsertNewRecordHelper.getMatchCondition(this.balanceModelInfo, tmpTablePrefix, balTablePrefix));
        sSQL.append("\r\n");
        sSQL.append("WHERE ").append("bal.FID IS NULL or bal.FID = ''");
        return sSQL.toString();
    }

    public static String getMatchCondition(BalanceModelInfo balanceModelInfo, String tmpTablePrefix, String balTablePrefix) {
        StringBuffer sSQL = new StringBuffer();
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType())) continue;
            if (sSQL.length() > 0) {
                sSQL.append("\r\n").append(" AND ");
            }
            sSQL.append(InsertNewRecordHelper.getJoinFieldName(fieldInfo, tmpTablePrefix));
            sSQL.append(" = ");
            sSQL.append(InsertNewRecordHelper.getJoinFieldName(fieldInfo, balTablePrefix));
        }
        return sSQL.toString();
    }

    static String getJoinFieldName(BalanceFieldModelInfo fieldInfo, String prefix) {
        StringBuffer fieldStr = new StringBuffer();
        if (fieldInfo.isIsNullable() && StringUtil.isEmpty((String)fieldInfo.getDefaultValue())) {
            fieldStr.append("ISNULL").append("(");
            fieldStr.append(prefix).append(".").append(fieldInfo.getFieldName());
            if (DataTypeEnum.String.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", '").append("$#X@$").append("')");
            } else if (DataTypeEnum.Date.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", ").append("{ts'1900-01-01'}").append(")");
            } else if (DataTypeEnum.Integer.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Boolean.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Amount.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Qty.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Price.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", 0)");
            } else if (DataTypeEnum.Enum.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", -999)");
            }
        } else {
            fieldStr.append(prefix).append(".").append(fieldInfo.getFieldName());
        }
        return fieldStr.toString();
    }

    public void doInsertNewRecord(Context ctx, String sSQL) throws BOSException, NoSuchAlgorithmException {
        IRowSet resultRs;
        block10: {
            resultRs = null;
            resultRs = DbUtil.executeQuery((Context)ctx, (String)sSQL.toString());
            if (resultRs.next()) break block10;
            this.logger.debug("\u6ca1\u6709\u65b0\u8bb0\u5f55\u9700\u8981\u63d2\u5165");
            SQLUtils.cleanup((ResultSet)resultRs);
            return;
        }
        try {
            List insertList = this.assemble2Map((ResultSet)resultRs);
            this.logger.info("\u66f4\u65b0\u524d\u9700\u8981\u63d2\u5165\u8bb0\u5f55\u6761\u6570\uff1a" + insertList.size());
            try {
                long start = System.currentTimeMillis();
                this.batchAddRecordsWithNewTx(ctx, insertList.toArray(new Map[0]));
                this.logger.debug("batch insert data\u4e00\u5171\u82b1\u8d39\u7684\u65f6\u95f4\u4e3a(ms): " + (System.currentTimeMillis() - start));
            }
            catch (Throwable e) {
                this.logger.error("batch insert data\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u96c6\u7fa4\u73af\u5883\u4e2d\u9ad8\u5e76\u53d1\u65f6\u5019\u51fa\u73b0\uff0c\u73b0\u5728\u5faa\u73af\u4fdd\u5b58\u8bb0\u5f55");
                for (int i = 0; i < insertList.size(); ++i) {
                    try {
                        this.addOneRecordWithNewTx(ctx, (Map)insertList.get(i));
                        continue;
                    }
                    catch (Throwable e2) {
                        this.logger.error("add one record\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u96c6\u7fa4\u73af\u5883\u4e2d\u9ad8\u5e76\u53d1\u65f6\u5019\u8fdd\u53cd\u552f\u4e00\u952e\u7ea6\u675f\u800c\u51fa\u73b0");
                        this.logger.error(e2.getLocalizedMessage());
                        this.logger.info("\u8fdd\u53cd\u552f\u4e00\u7ea6\u675f\uff1a" + e2.getMessage());
                    }
                }
                this.logger.debug("loop insert data\u4e00\u5171\u82b1\u8d39\u7684\u65f6\u95f4\u4e3a(ms):" + System.currentTimeMillis());
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultRs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultRs);
    }

    List assemble2Map(ResultSet rs) throws SQLException, NoSuchAlgorithmException {
        ArrayList list = new ArrayList();
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        HashMap keyMap = new HashMap();
        StringBuffer keyBuffer = new StringBuffer();
        int size = coll.size();
        rs.beforeFirst();
        while (rs.next()) {
            keyBuffer.setLength(0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < size; ++i) {
                fieldInfo = coll.get(i);
                if (BizDataTypeEnum.HappenData.equals((Object)fieldInfo.getBizDataType())) {
                    map.put(fieldInfo.getFieldName(), BalanceConst.ZERO);
                } else {
                    map.put(fieldInfo.getFieldName(), rs.getObject(fieldInfo.getFieldName()));
                }
                if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType())) continue;
                keyBuffer.append(rs.getObject(fieldInfo.getFieldName()));
            }
            String key = keyBuffer.toString();
            if (keyMap.containsKey(key)) continue;
            keyMap.put(key, null);
            map.put("FUniqueKey", BalanceUtil.getMd5(key));
            list.add(map);
        }
        return list;
    }

    void batchAddRecordsWithNewTx(Context ctx, Map[] maps) throws Throwable {
        if (maps.length == 0) {
            return;
        }
        Method method = this.getClass().getDeclaredMethod("batchAddRecords", Context.class, maps.getClass());
        method.setAccessible(true);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this);
        txInvoker.invoke(method, new Object[]{ctx, maps}, 3);
    }

    void addOneRecordWithNewTx(Context ctx, Map map) throws Throwable {
        Method method = this.getClass().getDeclaredMethod("addOneRecord", Context.class, Map.class);
        method.setAccessible(true);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this);
        txInvoker.invoke(method, new Object[]{ctx, map}, 3);
    }

    void addOneRecord(Context ctx, Map map) throws BOSException, EASBizException {
        this.batchAddRecords(ctx, new Map[]{map});
    }

    void batchAddRecords(Context ctx, Map[] maps) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            Object value = null;
            Map valueMap2 = null;
            BalanceFieldModelInfo fieldInfo = null;
            BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(this.getInsertBalanceSQL(this.balanceModelInfo));
            for (Map valueMap2 : maps) {
                int size = coll.size();
                for (int k = 0; k < size; ++k) {
                    fieldInfo = coll.get(k);
                    value = valueMap2.get(fieldInfo.getFieldName());
                    if (value == null) {
                        ps.setString(k + 1, value);
                        continue;
                    }
                    ps.setObject(k + 1, value);
                }
                ps.setString(coll.size() + 1, valueMap2.get("FUniqueKey").toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public String getInsertBalanceSQL(BalanceModelInfo balanceModelInfo) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(balanceModelInfo.getTabName()).append("(");
        insertSQL.append(BalanceEnginUtil.getBalanceModelFieldStr(balanceModelInfo, null));
        insertSQL.append(",").append("FUniqueKey");
        insertSQL.append(")").append("\r\n");
        insertSQL.append("VALUES ").append("(");
        int size = balanceModelInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                insertSQL.append(",");
            }
            insertSQL.append("?");
        }
        insertSQL.append(",?");
        insertSQL.append(")");
        return insertSQL.toString();
    }
}

