/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.PlugInApplyRangeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvPeriodBalanceInitSQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceInitCalculator;
import com.kingdee.eas.scm.util.string.StringUtil;

public class InvPeriodBalanceInitCalculator
extends PeriodBalanceInitCalculator {
    private String storageId;
    private String warehouseId;

    public InvPeriodBalanceInitCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
    }

    @Override
    protected FilterInfo getPlugInFilter() {
        FilterInfo filter = super.getPlugInFilter();
        filter.getFilterItems().add(new FilterItemInfo("applyRange", (Object)PlugInApplyRangeEnum.OnlyForCloseAccount, CompareType.NOTEQUALS));
        return filter;
    }

    public void calculate(String orgUnitID, String storageId, String warehouseId, PeriodInfo period, OperationTypeEnum OPType) throws EASBizException, BOSException {
        this.storageId = storageId;
        this.warehouseId = warehouseId;
        super.calculate(orgUnitID, period, OPType, false);
    }

    @Override
    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new InvPeriodBalanceInitSQLBuilder(this.balanceModelInfo, dataModelInfo, this.getCurPeriod(), this.getOrgUnitID(), this.storageId, this.warehouseId);
    }

    @Override
    protected String getBalanceTableFilter(PeriodInfo period) {
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append("WHERE ").append(this.balanceModelInfo.getMainOrgUnitField().getFieldName()).append("='").append(this.getOrgUnitID()).append("'");
        whereSQL.append("\r\n").append("AND ");
        if (this.balanceModelInfo.getPeriodField() == null) {
            whereSQL.append(this.balanceModelInfo.getPeriodYearField().getFieldName()).append("=").append(period.getPeriodYear());
            whereSQL.append(" AND ");
            whereSQL.append(this.balanceModelInfo.getPeriodMonthField().getFieldName()).append("=").append(period.getPeriodNumber());
        } else {
            whereSQL.append(this.balanceModelInfo.getPeriodField().getFieldName()).append("='").append(period.getId().toString()).append("'");
        }
        if (!StringUtil.isEmpty((String)this.storageId)) {
            whereSQL.append("\r\n").append("AND FStorageOrgUnitID = '").append(this.storageId).append("'");
        }
        if (!StringUtil.isEmpty((String)this.warehouseId)) {
            whereSQL.append("\r\n").append("AND FWarehouseID = '").append(this.warehouseId).append("'");
        }
        return whereSQL.toString();
    }
}

