/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.PlugInApplyRangeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceInitSQLBuilder;

public class PeriodBalanceInitCalculator
extends PeriodBalanceCalculator {
    public PeriodBalanceInitCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
    }

    @Override
    protected void beforeCalculate() throws BalanceModelException {
    }

    @Override
    protected FilterInfo getBalanceDataModelFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)UseStatusEnum.ACTIVE));
        filter.getFilterItems().add(new FilterItemInfo("isInitialize", (Object)Boolean.TRUE));
        return filter;
    }

    @Override
    protected FilterInfo getPlugInFilter() {
        FilterInfo filter = super.getPlugInFilter();
        filter.getFilterItems().add(new FilterItemInfo("applyRange", (Object)PlugInApplyRangeEnum.OnlyForCloseAccount, CompareType.NOTEQUALS));
        return filter;
    }

    @Override
    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new PeriodBalanceInitSQLBuilder(this.balanceModelInfo, dataModelInfo, this.getOrgUnitID(), this.getCurPeriod());
    }

    @Override
    protected void calculateStep() throws BOSException, EASBizException {
        if (OperationTypeEnum.Positive.equals((Object)this.OPType)) {
            this.initializeBalance();
        } else {
            this.reverseinitializeBalance();
        }
    }

    private void initializeBalance() throws BOSException, EASBizException {
        this.timer.reset();
        this.takeBillData();
        this.logger.info("\u6839\u636e\u6a21\u578b\u53d6\u6570\u914d\u7f6e\u4fe1\u606f\u53d6\u6570\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e==================");
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.timer.reset();
        this.groupDetailDataToFinalTable();
        this.logger.info("\u5c06\u660e\u7ec6\u6570\u636e\u6309\u7ef4\u5ea6\u6c47\u603b\u5230\u5206\u7ec4\u4e34\u65f6\u8868\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e==================");
        this.invokePlugInHandler(InvokeTime.AfterFinalData);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.timer.reset();
        this.insertReadyDataToBalanceTable();
        this.logger.info("\u63d2\u5165\u672c\u671f\u6700\u7ec8\u6570\u636e\u5230\u4f59\u989d\u8868\u82b1\u8d39\uff1a" + this.timer.msValue());
    }

    private void reverseinitializeBalance() throws BOSException, EASBizException {
        this.deletePeriodBalance(this.getCurPeriod());
    }
}

