/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.log.BalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.log.IBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.log.PeriodBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.log.RealTimeBalanceLogger;
import java.util.HashMap;
import java.util.Map;

public class BalanceLogFactory {
    private static Map<String, IBalanceLogger> LoggerCache = new HashMap<String, IBalanceLogger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBalanceLogger getLogger(Context ctx, BalanceModelInfo balanceModelInfo) throws EASBizException, BOSException {
        if (balanceModelInfo == null) {
            return null;
        }
        IBalanceLogger logger = LoggerCache.get(balanceModelInfo.getId().toString());
        Class<BalanceLogFactory> clazz = BalanceLogFactory.class;
        synchronized (BalanceLogFactory.class) {
            if (logger == null) {
                logger = BalanceLogFactory.createNewLogger(ctx, balanceModelInfo);
                LoggerCache.put(balanceModelInfo.getId().toString(), logger);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return logger;
        }
    }

    private static IBalanceLogger createNewLogger(Context ctx, BalanceModelInfo balanceModelInfo) throws EASBizException, BOSException {
        BalanceLogger logger = null;
        logger = BalanceTypeEnum.Period.equals((Object)balanceModelInfo.getBalanceType()) ? new PeriodBalanceLogger(ctx, balanceModelInfo) : new RealTimeBalanceLogger(ctx, balanceModelInfo);
        return logger;
    }
}

