/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.model;

import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import com.kingdee.eas.scm.framework.balance.model.PropertyMeta;
import com.kingdee.eas.scm.framework.util.SCMMDUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class PropertyMetaUtil {
    private static final String DOT = ".";

    public static PropertyMeta getPropertyMeta(DataQueryInfo dataQuery, String strCondition) {
        if (StringUtil.isEmpty((String)strCondition)) {
            return null;
        }
        String tableAlias = strCondition.substring(0, strCondition.indexOf(DOT));
        String fieldName = strCondition.substring(strCondition.indexOf(DOT) + 1);
        DataTableInfo dataTable = dataQuery.getDataTableByTableAlias(tableAlias);
        if (dataTable == null) {
            return null;
        }
        PropertyInfo property = null;
        List<PropertyInfo> propertyList = SCMMDUtil.getEntityProperty(dataTable.getEntity(), false);
        for (int i = 0; i < propertyList.size(); ++i) {
            property = propertyList.get(i);
            if (!property.getMappingField().getName().equalsIgnoreCase(fieldName)) continue;
            return new PropertyMeta(dataTable, property);
        }
        return null;
    }

    public static PropertyMeta getPropertyMeta(DataTableInfo dataTable, String fieldName) {
        if (dataTable == null || StringUtil.isEmpty((String)fieldName)) {
            return null;
        }
        List<PropertyInfo> propertyList = SCMMDUtil.getEntityProperty(dataTable.getEntity(), false);
        PropertyInfo property = null;
        for (int i = 0; i < propertyList.size(); ++i) {
            property = propertyList.get(i);
            if (!property.getMappingField().getName().equalsIgnoreCase(fieldName)) continue;
            return new PropertyMeta(dataTable, property);
        }
        return null;
    }

    public static List<PropertyMeta> getEntityProperty(DataTableInfo dataTable) {
        List<PropertyInfo> propertyList = SCMMDUtil.getEntityProperty(dataTable.getEntity(), false);
        ArrayList<PropertyMeta> result = new ArrayList<PropertyMeta>(propertyList.size());
        for (int i = 0; i < propertyList.size(); ++i) {
            result.add(new PropertyMeta(dataTable, propertyList.get(i)));
        }
        return result;
    }
}

