/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.bizflow.BizFlowException;
import com.kingdee.eas.scm.framework.bizflow.ProcessCollection;
import com.kingdee.eas.scm.framework.bizflow.ProcessInfo;
import com.kingdee.eas.scm.framework.bizflow.ProcessNodeCollection;
import com.kingdee.eas.scm.framework.bizflow.ProcessNodeInfo;
import com.kingdee.eas.scm.framework.bizflow.SimpleStatusEnum;
import com.kingdee.eas.scm.framework.bizflow.app.AbstractProcessControllerBean;
import com.kingdee.eas.scm.framework.bizflow.util.DataExportUtil;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ProcessControllerBean
extends AbstractProcessControllerBean {
    private static final long serialVersionUID = 1L;

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ProcessInfo info = (ProcessInfo)model;
        if (info.getStatus().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BizProcessResource", (String)"13_CancelCancelCheck", (Locale)ctx.getLocale())));
        }
        info.setStatus(SimpleStatusEnum.INACTIVE);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ProcessInfo info = (ProcessInfo)model;
        if (info.getStatus().getValue() == 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BizProcessResource", (String)"12_CancelCheck", (Locale)ctx.getLocale())));
        }
        info.setStatus(SimpleStatusEnum.ACTIVE);
        ProcessNodeCollection entryCol = info.getEntry();
        ProcessNodeInfo entry = null;
        HashMap tableList = new HashMap();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            entry = entryCol.get(i);
            set.add(entry.getNodeBillBosType());
            set.add(entry.getPreNodeBillBosType());
        }
        for (String bosType : set) {
            if (bosType == null || bosType.length() <= 0) continue;
            tableList = CommonUtils.getEntityAllInfo(bosType);
            this.setBizFlowRelationField(ctx, tableList);
        }
        super._cancelCancel(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProcessInfo info = (ProcessInfo)this._getValue(ctx, pk);
        if (info.getStatus().getValue() == 1 || info.getStatus().getValue() == 2) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BizProcessResource", (String)"14_DeleteCheck", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyForSave(ctx, model);
        ProcessInfo info = (ProcessInfo)model;
        return super._save(ctx, model);
    }

    protected void verifyForSave(Context ctx, IObjectValue model) throws BOSException, BizFlowException {
        ProcessInfo info = (ProcessInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        view.setFilter(filter);
        ProcessCollection coll = this.getProcessCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            throw new BizFlowException(BizFlowException.BIZFLOW_ERROR006);
        }
    }

    @Override
    public void _importImageData(Context ctx, Map bytes, boolean isCover) throws BOSException, EASBizException {
        DataExportUtil.importImageData(ctx, bytes, isCover);
    }

    @Override
    protected IRowSet _exportImageData(Context ctx, Set ids) throws BOSException, EASBizException {
        return DataExportUtil.exportImageData(ctx, ids);
    }

    void setBizFlowRelationField(Context ctx, Map tableList) throws EASBizException, BOSException {
        StringBuffer executeSql = new StringBuffer();
        if (tableList == null || tableList.size() <= 0) {
            return;
        }
        HashMap tableTypeList = (HashMap)tableList.get("type");
        if (tableTypeList == null || tableTypeList.size() <= 0) {
            return;
        }
        executeSql.setLength(0);
        Iterator it = tableTypeList.entrySet().iterator();
        while (it.hasNext()) {
            executeSql.setLength(0);
            Map.Entry entry = it.next();
            EntityObjectInfo objInfo = (EntityObjectInfo)entry.getValue();
            String value = objInfo.getTable().getName();
            executeSql.append("If not exists (select 1 as FID from ksql_usercolumns where ksql_col_tabname='" + value + "' and ksql_col_name='" + "FBizFlowRelation" + "') ");
            executeSql.append(" ALTER TABLE " + value + " ADD " + "FBizFlowRelation" + " CLOB(8000)");
            if (executeSql.length() <= 0) continue;
            DbUtil.execute((Context)ctx, (String)executeSql.toString());
        }
    }
}

