/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.bizflow.SimpleStatusEnum;
import com.kingdee.eas.scm.framework.bizflow.WriteBackModeEnum;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleFactory;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleInfo;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleItemCollection;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleItemInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class WriteBackRuleImport
extends AbstractDataTransmission {
    public static final String RESOURCEPATH = "com.kingdee.eas.scm.framework.bizflow.BizProcessImportResource";
    private Hashtable hsData = null;
    WriteBackRuleInfo info = null;
    private List numberImported = new ArrayList();

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            this.hsData = hsData;
            String number = this.getData("FNumber").toString();
            if (!this.numberImported.contains(number)) {
                this.info = new WriteBackRuleInfo();
                this.checkDuplicate(hsData, this.info, ctx);
                String billName = this.getData("FDestBill").toString();
                String bostype = this.getBOSType(ctx, billName);
                this.info.setDestBillEntityAlias(billName);
                this.info.setDestBillBosType(bostype);
                billName = this.getData("FSrcBill").toString();
                bostype = this.getBOSType(ctx, billName);
                this.info.setSrcBillEntityAlias(billName);
                this.info.setSrcBillBosType(bostype);
                this.info.setDescription(this.getData("FRemark").toString());
                this.info.setStatus(SimpleStatusEnum.SAVED);
                this.info.setIsSystem(false);
                WriteBackRuleItemCollection wbCol = this.info.getEntry();
                wbCol.clear();
                this.numberImported.add(number);
            }
            WriteBackRuleItemInfo entryInfo = new WriteBackRuleItemInfo();
            WriteBackRuleItemCollection wbCol = this.info.getEntry();
            wbCol.add(entryInfo);
            entryInfo.setParent(this.info);
            String str = this.getData("entry_FWriteBackMode").toString();
            Iterator iter = WriteBackModeEnum.iterator();
            while (iter.hasNext()) {
                WriteBackModeEnum val = (WriteBackModeEnum)((Object)iter.next());
                if (!val.getAlias().equals(str)) continue;
                entryInfo.setWriteBackMode(val);
                break;
            }
            str = this.getData("entry_FRemark").toString();
            entryInfo.setDescription(str);
            str = this.getData("entry_FDestPropertyAlias").toString();
            entryInfo.setExpressionAlias(str);
            str = this.getData("entry_FSrcPropertyAlias").toString();
            EntityObjectInfo eoi = this.getEntityObjectInfo(ctx, this.info.getSrcBillEntityAlias());
            Object[] objs = this.getDeepPropertyInfo(ctx, eoi, str);
            PropertyInfo prop = (PropertyInfo)objs[0];
            if (prop != null) {
                eoi = (EntityObjectInfo)objs[1];
                entryInfo.setSrcProperty(prop.getName());
                entryInfo.setSrcPropertyAlias(str);
                if (prop instanceof OwnPropertyInfo) {
                    entryInfo.setSrcPropertyType(((OwnPropertyInfo)prop).getDataType().toString());
                } else {
                    entryInfo.setSrcPropertyType("varchar");
                }
                entryInfo.setSrcTableName(eoi.getTable().getName());
                entryInfo.setSrcPropertyField(prop.getMappingField().getName());
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        return this.info;
    }

    private String getBOSType(Context ctx, String alias) throws TaskExternalException {
        try {
            EntityObjectInfo value = this.getEntityObjectInfo(ctx, alias);
            if (value != null) {
                return value.getType().toString();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
        return null;
    }

    private EntityObjectInfo getEntityObjectInfo(Context ctx, String alias) throws TaskExternalException {
        EntityObjectInfo value = null;
        try {
            String fullName = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select FFullName from T_ISQL_EntityInfoIndex where fAlias = '").append(alias).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                fullName = rs.getString("FFullName");
            }
            if (StringUtil.isEmpty(fullName)) {
                this.fail(ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"86_WriteBackRuleImport", (Locale)ctx.getLocale()));
            }
            if (StringUtil.isEmpty((String)fullName)) {
                return null;
            }
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
            MetaDataPK pk = MetaDataPK.create((String)fullName);
            value = (EntityObjectInfo)loader.get(MetaDataTypeList.ENTITY, (IMetaDataPK)pk, null);
            return value;
        }
        catch (Exception e) {
            this.fail(e);
            return null;
        }
    }

    private Object[] getDeepPropertyInfo(Context ctx, EntityObjectInfo eoi, String propAlias) throws TaskExternalException {
        String leftAlias = null;
        String rightAlias = null;
        if (propAlias.indexOf(".") != -1) {
            leftAlias = propAlias.substring(0, propAlias.indexOf("."));
            rightAlias = propAlias.substring(propAlias.indexOf(".") + 1);
        }
        if (leftAlias != null) {
            LinkPropertyInfo prop = (LinkPropertyInfo)this.getSinglePropertyInfo(ctx, eoi, leftAlias);
            eoi = prop.getRelationship().getSupplierObject();
            return this.getDeepPropertyInfo(ctx, eoi, rightAlias);
        }
        return new Object[]{this.getSinglePropertyInfo(ctx, eoi, propAlias), eoi};
    }

    private PropertyInfo getSinglePropertyInfo(Context ctx, EntityObjectInfo eoi, String propAlias) throws TaskExternalException {
        PropertyInfo prop = null;
        PropertyCollection propCol = eoi.getPropertiesRuntime();
        int size = propCol.size();
        for (int i = 0; i < size; ++i) {
            if (!propAlias.equals(propCol.get(i).getAlias())) continue;
            prop = propCol.get(i);
            break;
        }
        return prop;
    }

    public void checkDuplicate(Hashtable hsData, WriteBackRuleInfo info, Context ctx) throws TaskExternalException {
        String number = this.getData("FNumber").toString();
        if (this.numberImported.contains(number)) {
            return;
        }
        if (StringUtil.isEmpty((String)number)) {
            this.fail(ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"87_WriteBackRuleImport", (Locale)ctx.getLocale()));
        }
        try {
            info.setNumber(number);
            CoreBaseCollection cbc = this.getController(ctx).getCollection("select id, name, status where number = '" + number + "'");
            CoreBaseInfo cbInfo = cbc.size() == 0 ? null : cbc.get(0);
            boolean isNumberExist = cbInfo != null;
            boolean isImportUpdate = this.isSltImportUpdate();
            if (isNumberExist) {
                if (!isImportUpdate) {
                    this.fail(ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"88_WriteBackRuleImport", (Locale)ctx.getLocale()));
                } else {
                    if (0 != Integer.parseInt(cbInfo.get("status").toString())) {
                        this.fail(ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"89_WriteBackRuleImport", (Locale)ctx.getLocale()));
                    }
                    info.setId(cbInfo.getId());
                    info.setName(cbInfo.get("name").toString());
                }
            } else {
                String name = this.getData("FName").toString();
                cbc = this.getController(ctx).getCollection("select id where name = '" + name + "'");
                CoreBaseInfo coreBaseInfo = cbInfo = cbc.size() == 0 ? null : cbc.get(0);
                if (cbInfo != null) {
                    this.fail(ResourceBase.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"90_WriteBackRuleImport", (Locale)ctx.getLocale()));
                }
                info.setName(name);
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return WriteBackRuleFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            this.fail(ex);
        }
    }

    private void fail(Exception ex) throws TaskExternalException {
        throw new TaskExternalException(ex.getMessage(), ex.getCause());
    }

    private void fail(String msg) throws TaskExternalException {
        throw new TaskExternalException(msg);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getObject("number"));
            this.putTable(result, "FName", rs.getObject("name"));
            this.putTable(result, "FDestBill", rs.getObject("destBillEntityAlias"));
            this.putTable(result, "FSrcBill", rs.getObject("srcBillEntityAlias"));
            this.putTable(result, "FRemark", rs.getObject("description"));
            this.putTable(result, "entry_FDestPropertyAlias", rs.getObject("entry.destPropertyAlias"));
            Object obj = rs.getObject("entry.writeBackMode");
            int enumValue = 0;
            if (obj != null) {
                enumValue = Integer.parseInt(obj.toString());
                Iterator iter = WriteBackModeEnum.iterator();
                while (iter.hasNext()) {
                    WriteBackModeEnum wbEnum = (WriteBackModeEnum)((Object)iter.next());
                    if (wbEnum.getValue() != enumValue) continue;
                    obj = wbEnum.getAlias();
                    break;
                }
            }
            this.putTable(result, "entry_FWriteBackMode", obj);
            this.putTable(result, "entry_FSrcPropertyAlias", rs.getObject("entry.srcPropertyAlias"));
            this.putTable(result, "entry_FRemark", rs.getObject("entry.description"));
        }
        catch (Exception e) {
            this.fail(e.getMessage());
        }
        return result;
    }

    private void putTable(Hashtable result, String key, Object value) {
        if (value == null) {
            value = "";
        }
        result.put(key, value);
    }

    private Object getData(String key) {
        return ((DataToken)this.hsData.get((Object)key)).data;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.framework.bizflow.app.WriteBackRuleExportQuery";
    }
}

