/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app.formula.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.scm.framework.bizflow.app.formula.engine.WriteBackInterpreter;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackExceptionMsgLexer;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackFormula;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WriteBackExceptionMsgInterpreter {
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;
    private WriteBackInterpreter interpreter;

    public WriteBackExceptionMsgInterpreter(EntityObjectInfo srcEntity, EntityObjectInfo destEntity, WriteBackInterpreter interpreter) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        this.interpreter = interpreter;
    }

    public String eval(Map ctx, String exceptionMsg) throws BOSException {
        StringBuffer expMessage = new StringBuffer();
        List<Token> tokenList = this.getTokenList(exceptionMsg);
        for (Token token : tokenList) {
            if (token.type == 2) {
                expMessage.append(this.evalExpression(ctx, token.value));
                continue;
            }
            expMessage.append(token.value);
        }
        return expMessage.toString();
    }

    public String evalExpression(Map ctx, String exprAlias) throws BOSException {
        String expr = this.getFormualExprByAlias(exprAlias);
        Object value = this.interpreter.eval(expr, ctx);
        if (value != null) {
            if (value instanceof BigDecimal) {
                return StringUtil.subZeroAndDot((String)((BigDecimal)value).toPlainString());
            }
            return value.toString();
        }
        return "ExpressionError";
    }

    private List<Token> getTokenList(String exceptionMsg) throws ParserException {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        WriteBackExceptionMsgLexer lexer = new WriteBackExceptionMsgLexer(exceptionMsg);
        Token token = lexer.next();
        while (!Token.EOFToken.equals(token)) {
            tokenList.add(token);
            token = lexer.next();
        }
        return tokenList;
    }

    private String getFormualExprByAlias(String formualAlias) throws ParserException {
        WriteBackFormula formula = new WriteBackFormula(this.srcEntity, this.destEntity);
        return formula.getFormualExprByAlias(formualAlias);
    }
}

