/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app.formula.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.scm.framework.bizflow.FilterModeEnum;
import com.kingdee.eas.scm.framework.bizflow.FilterType;
import com.kingdee.eas.scm.framework.bizflow.StatusWriteBackInfo;
import com.kingdee.eas.scm.framework.bizflow.WBFormulaException;
import com.kingdee.eas.scm.framework.bizflow.WriteBFilterType;
import com.kingdee.eas.scm.framework.bizflow.WriteBackFilterConfigCollection;
import com.kingdee.eas.scm.framework.bizflow.WriteBackFilterConfigInfo;
import com.kingdee.eas.scm.framework.bizflow.WriteBackModeEnum;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleInfo;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleItemCollection;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleItemInfo;
import com.kingdee.eas.scm.framework.bizflow.app.formula.engine.WriteBackExceptionMsgInterpreter;
import com.kingdee.eas.scm.framework.bizflow.app.formula.engine.WriteBackInterpreter;
import com.kingdee.eas.scm.framework.bizflow.app.formula.engine.WriteBackQtyResultInfo;
import com.kingdee.eas.scm.framework.bizflow.app.formula.engine.WriteBackResultInfo;
import com.kingdee.eas.scm.framework.bizflow.app.formula.engine.WriteBackStatusResultInfo;
import com.kingdee.eas.scm.framework.bizflow.app.formula.function.CustomerFunctionProvider;
import com.kingdee.eas.scm.framework.bizflow.app.log.IBizFlowLogger;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WriteBackFormulaEngine {
    private static final String ProcessSerialNumber = "bizFlowRelation";
    private IBizFlowLogger logger = null;
    private LowTimer timer = new LowTimer();
    private Context ctx;
    private IObjectValue destObject;
    private IMetaDataLoader loader;
    private WriteBackInterpreter interpreter;
    private WriteBackExceptionMsgInterpreter msgInterpreter;
    private List<String> destEntryNameList = new ArrayList<String>();
    private Map<String, IObjectCollection> destEntryMap = new HashMap<String, IObjectCollection>();
    private Map<String, IObjectCollection> srcEntryMap = new HashMap<String, IObjectCollection>();
    private String currProcessId = null;
    private ExceptionObject MissResourceObject = new ExceptionObject();
    private ExceptionObject EvalExceptionObject = new ExceptionObject();

    public WriteBackFormulaEngine(Context ctx, IObjectValue destObject, IBizFlowLogger logger) throws BOSException {
        this.ctx = ctx;
        this.destObject = destObject;
        this.logger = logger;
        this.loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        this.destEntryNameList = this.getEntityEntryNames("_Dest", destObject);
        this.initInterpreter();
    }

    private List<String> getEntityEntryNames(String prefix, IObjectValue object) {
        EntityObjectInfo entity = this.loader.getEntity(object.getBOSType());
        EntityEntryStructure entryStructure = new EntityEntryStructure(1, entity);
        Map<String, Object> srcEntryStructureMap = entryStructure.buildHorizontalStructure(prefix);
        ArrayList<String> result = new ArrayList<String>();
        for (String entryName : srcEntryStructureMap.keySet()) {
            result.add(entryName);
        }
        return result;
    }

    public boolean calculateAutoCreateCondition(String filter) throws BOSException, WBFormulaException {
        if (StringUtil.isEmpty((String)filter)) {
            return true;
        }
        boolean result = false;
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__bosContext", this.ctx);
        localCtx.put("_Dest", this.destObject);
        List<String> entryNameList = this.getEntryNameInExpr(filter, this.destEntryNameList);
        if (entryNameList.size() > 0) {
            String entryName = entryNameList.get(0);
            IObjectCollection entryCollection = this.getEntryCollection(this.destObject, "_Dest", entryName);
            if (entryCollection == null || entryCollection.size() == 0) {
                return true;
            }
            IObjectValue entryObj2 = null;
            for (IObjectValue entryObj2 : entryCollection) {
                localCtx.put(entryName, entryObj2);
                Object value = this.interpreter.eval(filter, localCtx);
                if (value == null || !(value instanceof Boolean)) {
                    throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
                }
                if (((Boolean)value).booleanValue()) continue;
                return false;
            }
            result = true;
        } else {
            Object value = this.interpreter.eval(filter, localCtx);
            if (value == null || !(value instanceof Boolean)) {
                throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
            }
            result = (Boolean)value;
        }
        return result;
    }

    public WriteBackResultInfo calculateWBValue(String processId, IObjectCollection srcObjectColl, WriteBackRuleInfo wbRuleInfo) throws BOSException, WBFormulaException {
        WriteBackResultInfo result = new WriteBackResultInfo();
        if (StringUtil.isEmpty((String)processId)) {
            return result;
        }
        if (srcObjectColl == null || srcObjectColl.size() == 0) {
            return result;
        }
        if (wbRuleInfo == null || wbRuleInfo.getEntry().size() == 0 && wbRuleInfo.getStatusWriteBack().size() == 0) {
            return result;
        }
        this.srcEntryMap.clear();
        this.currProcessId = processId;
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__bosContext", this.ctx);
        localCtx.put("_Dest", this.destObject);
        List<String> srcEntryNameList = this.getEntityEntryNames("_Src", srcObjectColl.getObject(0));
        this.timer.reset();
        if (!this.checkConditions(localCtx, wbRuleInfo.getFilterConfig(), srcObjectColl, srcEntryNameList)) {
            this.logger.info("\u53cd\u5199\u6761\u4ef6\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
            return result;
        }
        this.logger.info("\u53cd\u5199\u6761\u4ef6\u6821\u9a8c\u901a\u8fc7\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
        WriteBackRuleItemCollection coll = wbRuleInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            this.timer.reset();
            localCtx.clear();
            localCtx.put("__bosContext", this.ctx);
            localCtx.put("_Dest", this.destObject);
            this.calculateSingleWBRuleItem(localCtx, coll.get(i), srcObjectColl, srcEntryNameList, result);
            this.logger.info("\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5c5e\u6027\uff1a" + coll.get(i).getSrcPropertyAlias() + ",\u8fd0\u7b97\u8017\u65f6\uff1a" + this.timer.msValue());
        }
        StatusWriteBackInfo statusConfig = wbRuleInfo.getEntryStatusWriteBackInfo();
        if (statusConfig != null) {
            this.timer.reset();
            this.calculateEntryStatusWBValue(localCtx, statusConfig, srcObjectColl, srcEntryNameList, result);
            this.logger.info("\u8ba1\u7b97\u5206\u5f55\u72b6\u6001\u53cd\u5199\u503c\u8017\u65f6\uff1a" + this.timer.msValue());
        }
        if ((statusConfig = wbRuleInfo.getHeadStatusWriteBackInfo()) != null) {
            this.timer.reset();
            this.calculateHeadStatusWBValue(localCtx, statusConfig, srcObjectColl, srcEntryNameList, result);
            this.logger.info("\u8ba1\u7b97\u5355\u5934\u72b6\u6001\u53cd\u5199\u503c\u8017\u65f6\uff1a" + this.timer.msValue());
        }
        return result;
    }

    protected boolean checkConditions(Map<String, Object> localCtx, WriteBackFilterConfigCollection conditionColl, IObjectCollection srcObjectColl, List<String> srcEntryNameList) throws BOSException, WBFormulaException {
        if (conditionColl == null || conditionColl.size() == 0) {
            return true;
        }
        boolean result = true;
        WriteBackFilterConfigInfo condition = null;
        this.msgInterpreter = this.getExceptionMsgInterpreter(srcObjectColl.getObject(0).getBOSType());
        StringBuffer errorMessage = new StringBuffer();
        for (int i = 0; i < conditionColl.size(); ++i) {
            condition = conditionColl.get(i);
            boolean b = this.checkSingleCondition(localCtx, condition, srcObjectColl, srcEntryNameList, errorMessage);
            if (b) continue;
            if (FilterModeEnum.NORMAL.equals((Object)condition.getWriteFilterMode())) {
                return false;
            }
            result = false;
            if (errorMessage.length() == 0) break;
        }
        if (!result) {
            if (errorMessage.length() == 0) {
                throw new WBFormulaException(WBFormulaException.WBFILTERFAIL);
            }
            throw new WBFormulaException(WBFormulaException.WBEXCEPTIONMSG, new String[]{errorMessage.toString()});
        }
        return result;
    }

    private WriteBackExceptionMsgInterpreter getExceptionMsgInterpreter(BOSObjectType srcBosType) {
        EntityObjectInfo srcEntity = this.loader.getEntity(srcBosType);
        EntityObjectInfo destEntity = this.loader.getEntity(this.destObject.getBOSType());
        return new WriteBackExceptionMsgInterpreter(srcEntity, destEntity, this.interpreter);
    }

    protected boolean checkSingleCondition(Map<String, Object> localCtx, WriteBackFilterConfigInfo condition, IObjectCollection srcObjectColl, List<String> srcEntryNameList, StringBuffer errorMessage) throws BOSException, WBFormulaException {
        String filter = condition.getWriteBackFilter();
        if (StringUtil.isEmpty((String)filter)) {
            return true;
        }
        boolean result = true;
        List<String> destEntryNameInExprList = this.getEntryNameInExpr(filter, this.destEntryNameList);
        List<String> srcEntryNameInExprList = this.getEntryNameInExpr(filter, srcEntryNameList);
        for (IObjectValue srcObject : srcObjectColl) {
            localCtx.put("_Src", srcObject);
            if (this.checkSingleSrcObjectCondition(localCtx, condition, srcObject, destEntryNameInExprList, srcEntryNameInExprList, errorMessage)) continue;
            if (errorMessage.length() == 0) {
                return false;
            }
            result = false;
        }
        return result;
    }

    private boolean checkSingleSrcObjectCondition(Map<String, Object> localCtx, WriteBackFilterConfigInfo condition, IObjectValue srcObject, List<String> destEntryNameInExprList, List<String> srcEntryNameInExprList, StringBuffer errorMessage) throws BOSException, WBFormulaException {
        boolean result = true;
        String filter = condition.getWriteBackFilter();
        String filterAlias = condition.getWriteBackFilterAlias();
        IObjectCollection entryCollection = null;
        if (srcEntryNameInExprList.size() == 0) {
            if (destEntryNameInExprList.size() > 0) {
                String entryName = destEntryNameInExprList.get(0);
                entryCollection = this.getEntryCollection(this.destObject, "_Dest", entryName);
                if (entryCollection == null || entryCollection.size() == 0) {
                    return true;
                }
                IObjectValue entryObj = entryCollection.getObject(0);
                localCtx.put(entryName, entryObj);
                Object value = null;
                try {
                    value = this.interpreter.eval(filter, localCtx);
                }
                catch (BOSException e) {
                    StringBuffer errorMsg = new StringBuffer("\n");
                    errorMsg.append("FilterExpression: \n").append(filterAlias).append("\n");
                    errorMsg.append("ExceptionMessage: \n").append(e.getMessage());
                    throw new WBFormulaException(WBFormulaException.WBFILTEREVALERROR, new String[]{filterAlias});
                }
                if (value == null || !(value instanceof Boolean)) {
                    throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
                }
                return (Boolean)value;
            }
            Object value = this.interpreter.eval(filter, localCtx);
            if (value == null || !(value instanceof Boolean)) {
                throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
            }
            return (Boolean)value;
        }
        String entryName = srcEntryNameInExprList.get(0);
        entryCollection = this.getEntryCollection(srcObject, "_Src", entryName);
        if (entryCollection == null) {
            return true;
        }
        for (IObjectValue entryObj : entryCollection) {
            if (!this.isMatchProcessId(entryObj.getString(ProcessSerialNumber))) continue;
            localCtx.put(entryName, entryObj);
            Object value = this.calculateEntryWBValue(localCtx, filter, entryObj, destEntryNameInExprList);
            if (value == this.MissResourceObject) continue;
            if (value == this.EvalExceptionObject) {
                StringBuffer errorMsg = new StringBuffer("\n");
                errorMsg.append("FilterExpression: \n").append(filterAlias).append("\n");
                errorMsg.append("ExceptionMessage: \n").append(value.toString());
                throw new WBFormulaException(WBFormulaException.WBFILTEREVALERROR, new String[]{errorMsg.toString()});
            }
            if (!(value instanceof Boolean)) {
                throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
            }
            boolean b = (Boolean)value;
            if (b) continue;
            if (FilterModeEnum.NORMAL.equals((Object)condition.getWriteFilterMode())) {
                return false;
            }
            if (StringUtil.isEmpty((String)condition.getMessage())) {
                return false;
            }
            errorMessage.append("\n").append(this.msgInterpreter.eval(localCtx, condition.getMessage()));
            result = false;
        }
        return result;
    }

    private boolean checkSingleSrcObjectCondition(Map<String, Object> localCtx, StatusWriteBackInfo statusConfig, IObjectValue srcObject, List<String> destEntryNameInExprList, List<String> srcEntryNameInExprList) throws BOSException, WBFormulaException {
        boolean result = true;
        IObjectCollection entryCollection = null;
        String filter = statusConfig.getWriteBackFilter();
        String filterAlias = statusConfig.getWriteBackFilterAlais();
        if (srcEntryNameInExprList.size() == 0) {
            if (destEntryNameInExprList.size() > 0) {
                String entryName = destEntryNameInExprList.get(0);
                entryCollection = this.getEntryCollection(this.destObject, "_Dest", entryName);
                if (entryCollection == null || entryCollection.size() == 0) {
                    return true;
                }
                IObjectValue entryObj = entryCollection.getObject(0);
                localCtx.put(entryName, entryObj);
                Object value = null;
                try {
                    value = this.interpreter.eval(filter, localCtx);
                }
                catch (BOSException e) {
                    StringBuffer errorMsg = new StringBuffer("\n");
                    errorMsg.append("FilterExpression: \n").append(filterAlias).append("\n");
                    errorMsg.append("ExceptionMessage: \n").append(e.getMessage());
                    throw new WBFormulaException(WBFormulaException.WBFILTEREVALERROR, new String[]{filterAlias});
                }
                if (value == null || !(value instanceof Boolean)) {
                    throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
                }
                return (Boolean)value;
            }
            Object value = this.interpreter.eval(filter, localCtx);
            if (value == null || !(value instanceof Boolean)) {
                throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
            }
            return (Boolean)value;
        }
        String entryName = srcEntryNameInExprList.get(0);
        entryCollection = this.getEntryCollection(srcObject, "_Src", entryName);
        if (entryCollection == null) {
            return true;
        }
        for (IObjectValue entryObj : entryCollection) {
            if (!this.isMatchProcessId(entryObj.getString(ProcessSerialNumber))) continue;
            localCtx.put(entryName, entryObj);
            Object value = this.calculateEntryWBValue(localCtx, filter, entryObj, destEntryNameInExprList);
            if (value == this.MissResourceObject) continue;
            if (value == this.EvalExceptionObject) {
                StringBuffer errorMsg = new StringBuffer("\n");
                errorMsg.append("FilterExpression: \n").append(filterAlias).append("\n");
                errorMsg.append("ExceptionMessage: \n").append(value.toString());
                throw new WBFormulaException(WBFormulaException.WBFILTEREVALERROR, new String[]{errorMsg.toString()});
            }
            if (!(value instanceof Boolean)) {
                throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
            }
            result = (Boolean)value;
            if (result) continue;
            return result;
        }
        return result;
    }

    private void calculateEntryStatusWBValue(Map<String, Object> localCtx, StatusWriteBackInfo statusConfig, IObjectCollection srcObjectColl, List<String> srcEntryNameList, WriteBackResultInfo result) throws BOSException, WBFormulaException {
        IObjectCollection entryCollection = null;
        String property = statusConfig.getSrcProperty();
        if (property == null || property.length() == 0) {
            return;
        }
        List<String> srcEntryNameInExprList = this.getEntryNameInExpr(property, srcEntryNameList);
        if (srcEntryNameInExprList.size() == 0) {
            return;
        }
        String srcEntryName = srcEntryNameInExprList.get(0);
        int lastDotIndex = property.lastIndexOf(46);
        String srcPropertyName = property.substring(lastDotIndex + 1);
        String filter = statusConfig.getWriteBackFilter();
        List<String> destEntryNameInExprList = this.getEntryNameInExpr(filter, this.destEntryNameList);
        for (IObjectValue srcObject : srcObjectColl) {
            localCtx.put("_Src", srcObject);
            entryCollection = this.getEntryCollection(srcObject, "_Src", srcEntryName);
            if (entryCollection == null) continue;
            for (IObjectValue entryObj : entryCollection) {
                if (!this.isMatchProcessId(entryObj.getString(ProcessSerialNumber))) continue;
                if (filter == null || filter.length() == 0) {
                    result.addStatusResultInfo(this.createStatusResult(entryObj, statusConfig));
                    entryObj.put(srcPropertyName, (Object)statusConfig.getPropertyValue());
                    continue;
                }
                localCtx.put(srcEntryName, entryObj);
                Object value = this.calculateEntryWBValue(localCtx, filter, entryObj, destEntryNameInExprList);
                if (value == this.MissResourceObject) continue;
                if (value == this.EvalExceptionObject) {
                    StringBuffer errorMsg = new StringBuffer("\n");
                    errorMsg.append("StatusExpression: \n").append(statusConfig.getWriteBackFilterAlais()).append("\n");
                    errorMsg.append("ExceptionMessage: \n").append(value.toString());
                    throw new WBFormulaException(WBFormulaException.WBSTATUSFILTEREVALERROR, new String[]{errorMsg.toString()});
                }
                if (!(value instanceof Boolean)) {
                    throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
                }
                boolean b = (Boolean)value;
                if (!b) continue;
                result.addStatusResultInfo(this.createStatusResult(entryObj, statusConfig));
                entryObj.put(srcPropertyName, (Object)statusConfig.getPropertyValue());
            }
        }
    }

    private void calculateHeadStatusWBValue(Map<String, Object> localCtx, StatusWriteBackInfo statusConfig, IObjectCollection srcObjectColl, List<String> srcEntryNameList, WriteBackResultInfo result) throws BOSException, WBFormulaException {
        if (WriteBFilterType.CUSTOMER.equals((Object)statusConfig.getWriteBFilterType())) {
            this.calculateNormalFilterStatueValue(localCtx, statusConfig, srcObjectColl, srcEntryNameList, result);
        } else {
            this.calculateSpeciaFilterStatusValue(localCtx, statusConfig, srcObjectColl, srcEntryNameList, result);
        }
    }

    private void calculateSpeciaFilterStatusValue(Map<String, Object> localCtx, StatusWriteBackInfo statusConfig, IObjectCollection srcObjectColl, List<String> srcEntryNameList, WriteBackResultInfo result) throws KScriptException, BOSException {
        String property = statusConfig.getEntryProperty();
        if (property == null || property.length() == 0) {
            return;
        }
        List<String> srcEntryNameInExprList = this.getEntryNameInExpr(property, srcEntryNameList);
        if (srcEntryNameInExprList.size() == 0) {
            return;
        }
        String srcEntryName = srcEntryNameInExprList.get(0);
        int lastDotIndex = property.lastIndexOf(46);
        String entryPropName = property.substring(lastDotIndex + 1);
        IObjectCollection entryCollection = null;
        for (IObjectValue srcObject : srcObjectColl) {
            localCtx.put("_Src", srcObject);
            entryCollection = this.getEntryCollection(srcObject, "_Src", srcEntryName);
            if (entryCollection == null) continue;
            boolean isNeedWriteBack = false;
            for (IObjectValue entryObj : entryCollection) {
                Integer value = (Integer)entryObj.get(entryPropName);
                if (statusConfig.getFilterType().equals((Object)FilterType.SOME) && statusConfig.getEntryPropertyValue() == value.intValue()) {
                    isNeedWriteBack = true;
                    break;
                }
                if (statusConfig.getFilterType().equals((Object)FilterType.ALL) && statusConfig.getEntryPropertyValue() != value.intValue()) {
                    isNeedWriteBack = false;
                    break;
                }
                if (!statusConfig.getFilterType().equals((Object)FilterType.ALL)) continue;
                isNeedWriteBack = true;
            }
            if (!isNeedWriteBack) continue;
            result.addStatusResultInfo(this.createStatusResult(srcObject, statusConfig));
        }
    }

    private void calculateNormalFilterStatueValue(Map<String, Object> localCtx, StatusWriteBackInfo statusConfig, IObjectCollection srcObjectColl, List<String> srcEntryNameList, WriteBackResultInfo result) throws KScriptException, BOSException, WBFormulaException {
        String filter = statusConfig.getWriteBackFilter();
        List<String> destEntryNameInExprList = this.getEntryNameInExpr(filter, this.destEntryNameList);
        List<String> srcEntryNameInExprList = this.getEntryNameInExpr(filter, srcEntryNameList);
        for (IObjectValue srcObject : srcObjectColl) {
            localCtx.put("_Src", srcObject);
            if (filter == null || filter.length() == 0) {
                result.addStatusResultInfo(this.createStatusResult(srcObject, statusConfig));
                continue;
            }
            if (!this.checkSingleSrcObjectCondition(localCtx, statusConfig, srcObject, destEntryNameInExprList, srcEntryNameInExprList)) continue;
            result.addStatusResultInfo(this.createStatusResult(srcObject, statusConfig));
        }
    }

    private void calculateSingleWBRuleItem(Map<String, Object> localCtx, WriteBackRuleItemInfo wbRuleItem, IObjectCollection srcObjectColl, List<String> srcEntryNameList, WriteBackResultInfo result) throws BOSException, WBFormulaException {
        if (wbRuleItem == null) {
            return;
        }
        List<String> destEntryNameInExprList = null;
        List<String> srcEntryNameInExprList = null;
        IObjectCollection entryCollection = null;
        String destExpr = wbRuleItem.getDestProperty();
        if (destExpr == null || destExpr.length() == 0) {
            destExpr = wbRuleItem.getExpression();
        } else if (!destExpr.startsWith("_Dest")) {
            destExpr = "_Dest." + destExpr;
        }
        destEntryNameInExprList = this.getEntryNameInExpr(destExpr, this.destEntryNameList);
        String srcProperty = wbRuleItem.getSrcProperty();
        if (!srcProperty.startsWith("_Src")) {
            srcProperty = "_Src." + srcProperty;
        }
        int lastDotIndex = srcProperty.lastIndexOf(46);
        String srcPropertyName = srcProperty.substring(lastDotIndex + 1);
        srcEntryNameInExprList = this.getEntryNameInExpr(srcProperty, srcEntryNameList);
        for (IObjectValue srcObject : srcObjectColl) {
            localCtx.put("_Src", srcObject);
            if (srcEntryNameInExprList.size() == 0) {
                Object value = this.calculateHeadWBValue(localCtx, destExpr, destEntryNameInExprList);
                if (value == this.MissResourceObject) continue;
                if (value == this.EvalExceptionObject) {
                    StringBuffer errorMsg = new StringBuffer("\n");
                    errorMsg.append("WriteBackExpression: \n").append(wbRuleItem.getExpressionAlias()).append("\n");
                    errorMsg.append("ExceptionMessage: \n").append(value.toString());
                    throw new WBFormulaException(WBFormulaException.WBFORMULAEVALERROR, new String[]{errorMsg.toString()});
                }
                result.addQtyResultInfo(this.createWBResult(srcObject, wbRuleItem, srcPropertyName, value));
                continue;
            }
            String entryName = srcEntryNameInExprList.get(0);
            entryCollection = this.getEntryCollection(srcObject, "_Src", entryName);
            if (entryCollection == null) continue;
            for (IObjectValue entryObj : entryCollection) {
                if (!this.isMatchProcessId(entryObj.getString(ProcessSerialNumber))) continue;
                localCtx.put(entryName, entryObj);
                Object value = this.calculateEntryWBValue(localCtx, destExpr, entryObj, destEntryNameInExprList);
                if (value == this.MissResourceObject) continue;
                if (value == this.EvalExceptionObject) {
                    StringBuffer errorMsg = new StringBuffer("\n");
                    errorMsg.append("WriteBackExpression: \n").append(wbRuleItem.getExpressionAlias()).append("\n");
                    errorMsg.append("ExceptionMessage: \n").append(value.toString());
                    throw new WBFormulaException(WBFormulaException.WBFORMULAEVALERROR, new String[]{errorMsg.toString()});
                }
                result.addQtyResultInfo(this.createWBResult(entryObj, wbRuleItem, srcPropertyName, value));
            }
        }
    }

    private Object calculateHeadWBValue(Map<String, Object> localCtx, String destExpr, List<String> destEntryNameInExprList) throws BOSException {
        IObjectValue destObjectEntry = null;
        boolean isException = false;
        for (int j = 0; j < destEntryNameInExprList.size(); ++j) {
            IObjectCollection entryColl = this.getEntryCollection(this.destObject, "_Dest", destEntryNameInExprList.get(j));
            if (entryColl == null || entryColl.size() == 0) {
                isException = true;
                break;
            }
            destObjectEntry = entryColl.getObject(0);
            localCtx.put(destEntryNameInExprList.get(j), destObjectEntry);
        }
        if (isException) {
            return this.MissResourceObject;
        }
        Object result = null;
        try {
            result = this.interpreter.eval(destExpr, localCtx);
        }
        catch (BOSException e) {
            this.EvalExceptionObject.setException((Exception)((Object)e));
            return this.EvalExceptionObject;
        }
        return result;
    }

    private Object calculateEntryWBValue(Map<String, Object> localCtx, String destExpr, IObjectValue entryObj, List<String> destEntryNameInExprList) throws BOSException {
        String processSerialNumber = entryObj.getString(ProcessSerialNumber);
        if (processSerialNumber == null || processSerialNumber.length() == 0) {
            return this.MissResourceObject;
        }
        for (int i = 0; i < destEntryNameInExprList.size(); ++i) {
            List<IObjectValue> entryList = this.findDestObjectEntry(destEntryNameInExprList.get(i), processSerialNumber);
            if (entryList.size() == 0) {
                return this.MissResourceObject;
            }
            localCtx.put(destEntryNameInExprList.get(0), entryList);
        }
        Object result = null;
        try {
            result = this.interpreter.eval(destExpr, localCtx);
        }
        catch (BOSException e) {
            this.EvalExceptionObject.setException((Exception)((Object)e));
            return this.EvalExceptionObject;
        }
        return result;
    }

    private WriteBackQtyResultInfo createWBResult(IObjectValue destObject, WriteBackRuleItemInfo wbRuleItem, String srcPropertyName, Object value) {
        Object lastValue = value;
        if (destObject.get(srcPropertyName) instanceof BigDecimal) {
            BigDecimal destValue = destObject.getBigDecimal(srcPropertyName);
            if (destValue == null) {
                destValue = new BigDecimal("0");
            }
            if (WriteBackModeEnum.PLUS.equals((Object)wbRuleItem.getWriteBackMode())) {
                lastValue = destValue.add(TypeConversionUtils.objToBigDecimal((Object)value));
            } else if (WriteBackModeEnum.MINUS.equals((Object)wbRuleItem.getWriteBackMode())) {
                lastValue = destValue.subtract(TypeConversionUtils.objToBigDecimal((Object)value));
            }
            if (lastValue instanceof BigDecimal) {
                lastValue = PrecisionUtil.subNoNeedZero((BigDecimal)((BigDecimal)lastValue));
            }
        } else if (value instanceof IObjectValue) {
            lastValue = ((IObjectValue)value).get("id");
        } else if (value instanceof String) {
            lastValue = "" + value;
        }
        destObject.put(srcPropertyName, lastValue);
        WriteBackQtyResultInfo result = new WriteBackQtyResultInfo(destObject.get("id").toString());
        result.setValue(lastValue);
        result.setWBRuleItem(wbRuleItem);
        return result;
    }

    private WriteBackStatusResultInfo createStatusResult(IObjectValue destObject, StatusWriteBackInfo statusConfig) {
        WriteBackStatusResultInfo result = new WriteBackStatusResultInfo(destObject.get("id").toString());
        result.setValue(statusConfig.getPropertyValue());
        result.setStatusConfig(statusConfig);
        return result;
    }

    private List<String> getEntryNameInExpr(String expr, List<String> allEntryNameList) throws KScriptException {
        ArrayList<String> idenList = new ArrayList<String>();
        BotUtil.computeIdent((String)expr, idenList);
        return this.getEntryNameInRuleList(idenList, allEntryNameList);
    }

    private IObjectCollection getEntryCollection(IObjectValue object, String prefix, String entryName) throws BOSException {
        String key;
        IObjectCollection result = null;
        Map<String, IObjectCollection> cacheMap = null;
        cacheMap = prefix.equals("_Dest") ? this.destEntryMap : this.srcEntryMap;
        if (cacheMap.containsKey(key = object.get("id").toString() + "_" + entryName)) {
            return cacheMap.get(key);
        }
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put(prefix, object);
        localCtx.putAll(cacheMap);
        result = (IObjectCollection)this.iteratorGetEntryCollection(object, entryName, localCtx);
        cacheMap.put(key, result);
        return result;
    }

    private boolean isMatchProcessId(String processSerialNumber) {
        if (StringUtil.isEmpty((String)processSerialNumber)) {
            return false;
        }
        return processSerialNumber.indexOf(this.currProcessId) > -1;
    }

    private List<String> getEntryNameInRuleList(List<String> srcIdentList, List<String> allEntryNameList) {
        ArrayList<String> result = new ArrayList<String>();
        int count = srcIdentList.size();
        for (int i = 0; i < count; ++i) {
            String ident = srcIdentList.get(i);
            int lastDotIndex = ident.lastIndexOf(46);
            if (lastDotIndex > -1) {
                ident = ident.substring(0, lastDotIndex);
            }
            if (allEntryNameList.contains(ident) && !result.contains(ident)) {
                result.add(ident);
            }
            if (result.size() == allEntryNameList.size()) break;
        }
        Collections.sort(result);
        return result;
    }

    private List<IObjectValue> findDestObjectEntry(String destEntryName, String processSerialNumber) throws BOSException {
        ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
        IObjectCollection entryColl = this.getEntryCollection(this.destObject, "_Dest", destEntryName);
        IObjectValue entry = null;
        for (int i = 0; entryColl != null && i < entryColl.size(); ++i) {
            entry = entryColl.getObject(i);
            if (entry.getString(ProcessSerialNumber) == null || entry.getString(ProcessSerialNumber).indexOf(processSerialNumber) <= -1) continue;
            result.add(entry);
        }
        return result;
    }

    private Object iteratorGetEntryCollection(IObjectValue object, String entryName, Map<String, Object> localCtx) throws BOSException {
        if (localCtx.containsKey(entryName)) {
            return localCtx.get(entryName);
        }
        int lastDotIndex = entryName.lastIndexOf(46);
        WriteBackInterpreter interpreter = new WriteBackInterpreter(this.ctx);
        if (lastDotIndex > -1) {
            String parent = entryName.substring(0, lastDotIndex);
            Object ownerValue = this.iteratorGetEntryCollection(object, parent, localCtx);
            if (ownerValue instanceof IObjectCollection) {
                IObjectCollection result = null;
                for (Object entryObj : (IObjectCollection)ownerValue) {
                    localCtx.put(parent, entryObj);
                    Object retVal = interpreter.eval(entryName, localCtx);
                    if (result == null) {
                        result = (IObjectCollection)retVal;
                        continue;
                    }
                    result.addObjectCollection((IObjectCollection)retVal);
                }
                return result;
            }
            localCtx.put(parent, ownerValue);
            return interpreter.eval(entryName, localCtx);
        }
        return object;
    }

    private void initInterpreter() throws BOSException {
        if (this.interpreter == null) {
            this.interpreter = new WriteBackInterpreter(this.ctx);
            CustomerFunctionProvider cusProvider = new CustomerFunctionProvider(this.ctx);
            this.interpreter.addFunctionProvider(cusProvider);
            this.interpreter.setProperyExprOwnerNullIgore(true);
        }
    }

    public boolean autoCreateConditionCheck(String filter) throws BOSException, WBFormulaException {
        if (StringUtil.isEmpty((String)filter)) {
            return true;
        }
        boolean result = false;
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__bosContext", this.ctx);
        localCtx.put("_Src", this.destObject);
        List<String> srcEntryNameList = this.getEntityEntryNames("_Src", this.destObject);
        List<String> entryNameList = this.getEntryNameInExpr(filter, srcEntryNameList);
        if (entryNameList.size() > 0) {
            String entryName = entryNameList.get(0);
            IObjectCollection entryCollection = this.getEntryCollection(this.destObject, "_Src", entryName);
            if (entryCollection == null || entryCollection.size() == 0) {
                return true;
            }
            IObjectValue entryObj2 = null;
            for (IObjectValue entryObj2 : entryCollection) {
                localCtx.put(entryName, entryObj2);
                Object value = this.interpreter.eval(filter, localCtx);
                if (value == null || !(value instanceof Boolean)) {
                    throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
                }
                if (((Boolean)value).booleanValue()) continue;
                return false;
            }
            result = true;
        } else {
            Object value = this.interpreter.eval(filter, localCtx);
            if (value == null || !(value instanceof Boolean)) {
                throw new WBFormulaException(WBFormulaException.WBFILTERINVALID);
            }
            result = (Boolean)value;
        }
        return result;
    }

    class ExceptionObject {
        Exception e;

        ExceptionObject() {
            this(null);
        }

        ExceptionObject(Exception e) {
            this.e = e;
        }

        public void setException(Exception e) {
            this.e = e;
        }

        public String toString() {
            if (this.e == null) {
                return "MissResource";
            }
            return this.e.getMessage();
        }
    }

    private class EntityEntryStructure {
        private static final String ISENTRIES = "isEntries";
        private int level;
        private Map<String, Object> entryVerticalMap;
        private EntityObjectInfo entryEntity;

        public EntityEntryStructure(int level, EntityObjectInfo entity) {
            this.level = level;
            this.entryEntity = entity;
            this.buildVerticalStructure();
        }

        public Map<String, Object> buildHorizontalStructure(String prefix) {
            HashMap<String, Object> entryHorizontalMap = new HashMap<String, Object>();
            this.transformVerticalToHorizonStructure(prefix, this.entryVerticalMap, entryHorizontalMap);
            return entryHorizontalMap;
        }

        private void transformVerticalToHorizonStructure(String prefix, Map<String, Object> entryVerticalMap, Map<String, Object> entryHorizontalMap) {
            Set<String> key = entryVerticalMap.keySet();
            for (String propName : key) {
                EntityEntryStructure entry = (EntityEntryStructure)entryVerticalMap.get(propName);
                String entryPrefix = prefix == null ? propName : prefix + "." + propName;
                entryHorizontalMap.put(entryPrefix, entry);
                this.transformVerticalToHorizonStructure(entryPrefix, entry.entryVerticalMap, entryHorizontalMap);
            }
        }

        private void buildVerticalStructure() {
            this.entryVerticalMap = new HashMap<String, Object>();
            PropertyCollection props = this.entryEntity.getInheritedNoDuplicatedProperties();
            for (PropertyInfo propInfo : props) {
                RelationshipInfo relation;
                if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty(ISENTRIES))) continue;
                EntityObjectInfo relateEntity = null;
                if (relation.getClientObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getSupplierObject();
                } else if (relation.getSupplierObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getClientObject();
                }
                if (relateEntity == null) continue;
                EntityEntryStructure entryInfo = new EntityEntryStructure(this.level + 1, relateEntity);
                this.entryVerticalMap.put(propInfo.getName(), entryInfo);
            }
        }
    }
}

