/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.bizflow.app.log.IBizFlowLogger;
import com.kingdee.eas.scm.util.app.log.Log4j2Util;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;

public class BizFlowLogger
implements IBizFlowLogger {
    private static final String PARAM_LEVEL_NAME = "BizFlowLogLevel";
    private static final String LOGGER_NAME = "com.kingdee.eas.scm.framework.bizflow";
    private static final int INFO = 1;
    private static final int DEBUG = 2;
    protected Context ctx;
    protected Logger logger;
    protected int level;

    public BizFlowLogger(Context ctx) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.initLogger();
        this.initParam();
    }

    @Override
    public void error(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLogHeadInfo()).append(message);
        this.logger.info((Object)buffer.toString());
    }

    @Override
    public void info(String message) {
        if (this.level < 1) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLogHeadInfo()).append(message);
        this.logger.info((Object)buffer.toString());
    }

    @Override
    public void debug(String message) {
        if (this.level < 2) {
            return;
        }
        this.error(message);
    }

    @Override
    public void debugSQL(String message, String sSQL) {
        if (this.level < 2) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLogHeadInfo()).append(message).append(sSQL);
        this.logger.info((Object)buffer.toString());
    }

    protected String getLogHeadInfo() {
        String clientIP = this.ctx.getClientHostIP();
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u5ba2\u6237\u7aefIP\uff1a").append(clientIP);
        return buffer.toString();
    }

    private void initLogger() {
        if (this.logger == null) {
            String fileName = "BizFlow.log";
            Log4j2Util.addRollFileLogConfig((String)"bizflow", (String)LOGGER_NAME, (String)fileName, (Level)Level.INFO, (String)"50MB", (String)"10");
            this.logger = Logger.getLogger((String)LOGGER_NAME);
        }
    }

    private Properties getLogProperties() {
        Properties properties = new Properties();
        String appendFullName = "log4j.appender.bizflow";
        String fileName = "${EAS_INSTANCE_HOME}/logs/BizFlow.log";
        properties.put("log4j.logger.com.kingdee.eas.scm.framework.bizflow", "info, bizflow");
        properties.put("log4j.additivity.com.kingdee.eas.scm.framework.bizflow", (Object)false);
        properties.put(appendFullName, "org.apache.log4j.RollingFileAppender");
        properties.put(appendFullName + ".MaxBackupIndex", (Object)10);
        properties.put(appendFullName + ".MaxFileSize", "10MB");
        properties.put(appendFullName + ".layout", "org.apache.log4j.PatternLayout");
        properties.put(appendFullName + ".layout.ConversionPattern", "[%d{yyyy-MM-dd HH:mm:ss.SSS} %-6p] %m %n");
        properties.put(appendFullName + ".encoding", "UTF-8");
        properties.put(appendFullName + ".File", fileName);
        return properties;
    }

    private void initParam() throws EASBizException, BOSException {
        String sql = "SELECT FValue From T_DT_DTTempParam WHERE FKey = 'BizFlowLogLevel'";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            this.level = rs.next() ? rs.getInt("FValue") : 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

