/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.expression;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.scm.framework.bizflow.expression.EvaluationExpressions;
import com.kingdee.eas.scm.framework.bizflow.expression.IExprValue;
import com.kingdee.eas.scm.framework.bizflow.expression.ValueType;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class ComparisonExpressions {
    private String expression;
    private boolean value;
    private CompareTypeEnum compareTypeEnum;
    private EvaluationExpressions evalExpr1;
    private EvaluationExpressions evalExpr2;
    public static final String RESOURCEPATH = "com.kingdee.eas.scm.framework.bizflow.BizProcessResource";

    public ComparisonExpressions(String expression) throws BOSException {
        this.expression = expression;
        this.setValue(false);
        this.parse();
    }

    public ComparisonExpressions(boolean value) throws BOSException {
        this.setValue(value);
        this.parse();
    }

    private void setValue(boolean value) {
        this.value = value;
    }

    public boolean getValue(IObjectValue info) throws BOSException {
        return this.execute(info);
    }

    private void parse() throws BOSException {
        if (StringUtils.isEmpty((String)this.expression)) {
            return;
        }
        char[] charArray = this.expression.trim().toCharArray();
        boolean isInCharArray = false;
        int len = charArray.length;
        block5: for (int i = 0; i < len; ++i) {
            char c = charArray[i];
            switch (c) {
                case '<': 
                case '>': {
                    if (isInCharArray) continue block5;
                    if (i >= len - 1) {
                        throw new BOSException(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
                    }
                    if (charArray[i + 1] == '=') {
                        this.compareTypeEnum = CompareTypeEnum.getCompareType(c + "=");
                        this.evalExpr1 = new EvaluationExpressions(this.expression.substring(0, i));
                        this.evalExpr2 = new EvaluationExpressions(this.expression.substring(i + 2));
                    } else {
                        this.compareTypeEnum = CompareTypeEnum.getCompareType(String.valueOf(c));
                        this.evalExpr1 = new EvaluationExpressions(this.expression.substring(0, i));
                        this.evalExpr2 = new EvaluationExpressions(this.expression.substring(i + 1));
                    }
                    return;
                }
                case '!': 
                case '=': {
                    if (isInCharArray) continue block5;
                    if (i >= len - 1) {
                        throw new BOSException(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
                    }
                    if (charArray[i + 1] != '=') {
                        throw new BOSException(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
                    }
                    this.compareTypeEnum = CompareTypeEnum.getCompareType(c + "=");
                    this.evalExpr1 = new EvaluationExpressions(this.expression.substring(0, i));
                    this.evalExpr2 = new EvaluationExpressions(this.expression.substring(i + 2));
                    return;
                }
                case '\'': {
                    if (i > 0 && charArray[i - 1] == '\\') continue block5;
                    isInCharArray = !isInCharArray;
                }
            }
        }
    }

    private boolean execute(IObjectValue info) throws BOSException {
        if (null == this.compareTypeEnum || this.evalExpr1 == null || this.evalExpr2 == null) {
            return this.value;
        }
        IExprValue objVal1 = this.evalExpr1.getValue(info);
        if (null == objVal1) {
            return false;
        }
        IExprValue objVal2 = this.evalExpr2.getValue(info);
        if (null == objVal2) {
            return false;
        }
        if (CompareTypeEnum.EQUALS.equals((Object)this.compareTypeEnum)) {
            this.value = this.equals(objVal1, objVal2);
        } else if (CompareTypeEnum.NOTEQUALS.equals((Object)this.compareTypeEnum)) {
            this.value = this.notEquals(objVal1, objVal2);
        } else if (CompareTypeEnum.GREATER.equals((Object)this.compareTypeEnum)) {
            this.value = this.greater(objVal1, objVal2);
        } else if (CompareTypeEnum.GREATER_EQUALS.equals((Object)this.compareTypeEnum)) {
            this.value = this.greaterEquals(objVal1, objVal2);
        } else if (CompareTypeEnum.LESS.equals((Object)this.compareTypeEnum)) {
            this.value = this.less(objVal1, objVal2);
        } else if (CompareTypeEnum.LESS_EQUALS.equals((Object)this.compareTypeEnum)) {
            this.value = this.lessEquals(objVal1, objVal2);
        } else {
            throw new RuntimeException(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
        }
        return this.value;
    }

    private boolean equals(IExprValue objVal1, IExprValue objVal2) {
        if (ValueType.NULL.equals((Object)objVal1.getType()) || ValueType.NULL.equals((Object)objVal2.getType())) {
            return objVal1.getValue() == null && objVal2.getValue() == null;
        }
        if (!objVal1.getType().equals((Object)objVal2.getType())) {
            return false;
        }
        Object v1 = objVal1.getValue();
        Object v2 = objVal2.getValue();
        if (v1 == null || v2 == null) {
            return v1 == v2;
        }
        if (ValueType.NUMBER.equals((Object)objVal1.getType())) {
            BigDecimal b1 = (BigDecimal)v1;
            BigDecimal b2 = (BigDecimal)v2;
            return b1.compareTo(b2) == 0;
        }
        if (ValueType.BOOLEAN.equals((Object)objVal1.getType())) {
            return v1.equals(v2);
        }
        if (ValueType.STRING.equals((Object)objVal1.getType())) {
            return v1.equals(v2);
        }
        if (ValueType.COREBASEINFO.equals((Object)objVal1.getType())) {
            IObjectValue c1 = (IObjectValue)v1;
            IObjectValue c2 = (IObjectValue)v2;
            return c1.get("id") == null && c2.get("id") == null && c1.getClass().equals(c2.getClass()) || c1.get("id") != null && c2.get("id") != null && c1.get("id").toString().equals(c2.get("id").toString());
        }
        return v1.equals(v2);
    }

    private boolean notEquals(IExprValue objVal1, IExprValue objVal2) {
        return !this.equals(objVal1, objVal2);
    }

    private boolean greater(IExprValue objVal1, IExprValue objVal2) {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return b1 != null && b2 != null && b1.compareTo(b2) > 0;
        }
        return false;
    }

    private boolean greaterEquals(IExprValue objVal1, IExprValue objVal2) {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return b1 != null && b2 != null && b1.compareTo(b2) >= 0;
        }
        return false;
    }

    private boolean less(IExprValue objVal1, IExprValue objVal2) {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return b1 != null && b2 != null && b1.compareTo(b2) < 0;
        }
        return false;
    }

    private boolean lessEquals(IExprValue objVal1, IExprValue objVal2) {
        if (ValueType.NUMBER.equals((Object)objVal1.getType()) && ValueType.NUMBER.equals((Object)objVal2.getType())) {
            BigDecimal b1 = (BigDecimal)objVal1.getValue();
            BigDecimal b2 = (BigDecimal)objVal2.getValue();
            return b1 != null && b2 != null && b1.compareTo(b2) <= 0;
        }
        return false;
    }

    public String toString() {
        return "expression:" + this.expression + ";value:" + this.value;
    }

    static enum CompareTypeEnum {
        EQUALS("=="),
        NOTEQUALS("!="),
        GREATER(">"),
        GREATER_EQUALS(">="),
        LESS("<"),
        LESS_EQUALS("<=");


        private CompareTypeEnum(String sign) {
        }

        static CompareTypeEnum getCompareType(String sign) {
            if (null == sign || "".equals(sign.trim())) {
                return null;
            }
            if ("==".equals(sign = sign.trim())) {
                return EQUALS;
            }
            if ("!=".equals(sign)) {
                return NOTEQUALS;
            }
            if (">".equals(sign)) {
                return GREATER;
            }
            if (">=".equals(sign)) {
                return GREATER_EQUALS;
            }
            if ("<".equals(sign)) {
                return LESS;
            }
            if ("<=".equals(sign)) {
                return LESS_EQUALS;
            }
            throw new IllegalArgumentException(EASResource.getString((String)ComparisonExpressions.RESOURCEPATH, (String)"54_ExpressionError"));
        }
    }
}

