/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.formula;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackExceptionMsgLexer;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackFormualVerifier;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackFormula;
import java.util.ArrayList;
import java.util.List;

public class WriteBackExceptionMsgVerifier {
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;

    public WriteBackExceptionMsgVerifier(EntityObjectInfo srcEntity, EntityObjectInfo destEntity) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
    }

    public boolean isValid(String exceptionMsg) throws ParserException {
        List<Token> tokenList = this.getTokenList(exceptionMsg);
        WriteBackFormualVerifier verifier = new WriteBackFormualVerifier();
        for (Token token : tokenList) {
            if (token.type != 2 || verifier.isCompatibleWithBOSFormula(this.getFormualExprByAlias(token.value))) continue;
            return false;
        }
        return true;
    }

    public String transformer(String exceptionMsg) throws ParserException {
        StringBuffer expMessage = new StringBuffer();
        List<Token> tokenList = this.getTokenList(exceptionMsg);
        for (Token token : tokenList) {
            if (token.type == 2) {
                expMessage.append("{").append(this.getFormualExprByAlias(token.value)).append("}");
                continue;
            }
            expMessage.append(token.value);
        }
        return expMessage.toString();
    }

    private List<Token> getTokenList(String exceptionMsg) throws ParserException {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        WriteBackExceptionMsgLexer lexer = new WriteBackExceptionMsgLexer(exceptionMsg);
        Token token = lexer.next();
        while (!Token.EOFToken.equals(token)) {
            tokenList.add(token);
            token = lexer.next();
        }
        return tokenList;
    }

    private String getFormualExprByAlias(String formualAlias) throws ParserException {
        WriteBackFormula formula = new WriteBackFormula(this.srcEntity, this.destEntity);
        return formula.getFormualExprByAlias(formualAlias);
    }
}

