/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.secure.util.CloseHelper;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DataExportUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportData(IRowSet rs, String path) throws BOSException {
        BufferedOutputStream out = null;
        InputStream in = null;
        String fnumber = null;
        try {
            while (rs.next()) {
                try {
                    in = rs.getBlob("FProcessImage").getBinaryStream();
                    fnumber = rs.getString("FNumber");
                    File file = new File(DataExportUtil.getFileName(path, fnumber));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buff = new byte[1024];
                    int i = 0;
                    while ((i = in.read(buff)) > 0) {
                        out.write(buff, 0, i);
                    }
                    out.flush();
                }
                catch (Exception e) {
                    try {
                        throw new BOSException("export processimage exception : " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        CloseHelper.safeClose(in);
                        CloseHelper.safeClose(out);
                        throw throwable;
                        return;
                    }
                }
                CloseHelper.safeClose(in);
                CloseHelper.safeClose(out);
            }
        }
        catch (Exception e) {
            throw new BOSException("export processimage exception : " + e.getMessage());
        }
    }

    public static IRowSet exportImageData(Context ctx, Set ids) throws BOSException {
        String idStr = SCMServerUtils.getInStringFromSet((Set)ids);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FNumber, FProcessImage from T_BPM_Process where FProcessImage is not null ");
        sqlBuffer.append(" and fid in ").append(idStr);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        return rs;
    }

    public static void importImageData(Context ctx, Map<String, byte[]> map, boolean isCover) throws BOSException {
        File tempFile = null;
        FileOutputStream fos = null;
        String tempFilePath = "." + File.separator;
        byte[] data = null;
        Iterator<String> itor = map.keySet().iterator();
        String key = null;
        while (itor.hasNext()) {
            key = itor.next();
            data = map.get(key);
            try {
                fos = new FileOutputStream(tempFilePath + key + ".jpg");
                fos.write(data);
                fos.flush();
                tempFile = new File(tempFilePath + key + ".jpg");
                DataExportUtil.importImageData(ctx, new File[]{tempFile}, isCover);
                tempFile.delete();
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseHelper.safeClose(fos);
                    throw throwable;
                }
            }
            CloseHelper.safeClose(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importImageData(Context ctx, File[] files, boolean isCover) throws BOSException {
        if (files == null || files.length == 0) {
            return;
        }
        File file2 = null;
        String updateSQL = "update T_BPM_Process set FProcessImage = ? where FNumber = ? ";
        String selectSQL = "select 1 from T_BPM_Process where FProcessImage is not null and FNumber = ? ";
        String fnumber = null;
        PreparedStatement psSelect = null;
        PreparedStatement psUpdate = null;
        Connection conn = null;
        BufferedInputStream in = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psSelect = conn.prepareStatement(selectSQL);
            psUpdate = conn.prepareStatement(updateSQL);
            for (File file2 : files) {
                if (file2 == null || StringUtil.isEmpty((String)file2.getName()) || file2.getName().lastIndexOf(".") == -1) continue;
                fnumber = file2.getName().substring(0, file2.getName().lastIndexOf("."));
                if (!isCover) {
                    psSelect.setString(1, fnumber);
                    ResultSet rs = psSelect.executeQuery();
                    if (rs.next()) continue;
                }
                try {
                    in = new BufferedInputStream(new FileInputStream(file2));
                    psUpdate.setBinaryStream(1, (InputStream)in, (int)file2.length());
                    psUpdate.setString(2, fnumber);
                    psUpdate.executeUpdate();
                }
                catch (Throwable throwable) {
                    CloseHelper.safeClose(in);
                    throw throwable;
                }
                CloseHelper.safeClose(in);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psSelect, (Connection)conn);
                SQLUtils.cleanup(psUpdate, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psSelect, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdate, (Connection)conn);
    }

    public static Map<String, byte[]> outFile2Map(File[] files) throws BOSException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        if (files == null || files.length == 0) {
            return map;
        }
        byte[] buffer = null;
        File tempFile2 = null;
        String key = null;
        FileInputStream fis = null;
        try {
            for (File tempFile2 : files) {
                int n;
                fis = new FileInputStream(tempFile2);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
                byte[] b = new byte[1000];
                while ((n = fis.read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                buffer = bos.toByteArray();
                fis.close();
                bos.close();
                key = tempFile2.getName().substring(0, tempFile2.getName().lastIndexOf("."));
                map.put(key, buffer);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return map;
    }

    private static String getFileName(String path, String fnumber) {
        StringBuilder realFileName = new StringBuilder(path);
        realFileName.append("/").append(fnumber).append(".jpg");
        return realFileName.toString();
    }
}

