/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.condition.app.AbstractConditionRecordFacadeControllerBean;
import com.kingdee.eas.scm.framework.condition.model.QueryParamInfo;
import com.kingdee.eas.scm.framework.condition.model.SaveParamInfo;
import com.kingdee.eas.scm.framework.util.ObjectTypeUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConditionRecordFacadeControllerBean
extends AbstractConditionRecordFacadeControllerBean {
    private static final String FID = "FID";
    private static final long serialVersionUID = -3386844343957276538L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.condition.app.ConditionRecordFacadeControllerBean");

    @Override
    protected IRowSet _query(Context ctx, QueryParamInfo queryParamInfo) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder();
        List<QueryParamInfo.QuerySelectorItemInfo> selectors = queryParamInfo.getSelectors();
        sb.append("SELECT ");
        if (null == selectors || selectors.size() == 0) {
            sb.append(" * ");
        } else {
            for (QueryParamInfo.QuerySelectorItemInfo selector : selectors) {
                if (!StringUtils.isEmpty((String)selector.getTabAlias())) {
                    sb.append("\"").append(selector.getTabAlias()).append("\".");
                }
                sb.append(selector.getFieldName()).append(" AS \"").append(selector.getFieldAlias()).append("\",");
            }
            sb.setLength(sb.length() - 1);
        }
        List<QueryParamInfo.QueryJoinItemInfo> tabNameList = queryParamInfo.getTables();
        int size = tabNameList.size();
        for (int i = 0; i < size; ++i) {
            QueryParamInfo.QueryJoinItemInfo joinItem = tabNameList.get(i);
            if (i == 0) {
                sb.append(" FROM ").append(joinItem.getTabName()).append(" AS \"").append(joinItem.getTabAlias()).append("\" ");
                continue;
            }
            sb.append(" INNER JOIN ").append(joinItem.getTabName()).append(" AS \"").append(joinItem.getTabAlias()).append("\" ").append(" ON \"").append(joinItem.getJoinTabAlias()).append("\".").append(joinItem.getJoinTabField()).append(" = \"").append(joinItem.getTabAlias()).append("\".").append(joinItem.getJoinField()).append(" ");
        }
        sb.append(" WHERE 1=1 ");
        List<QueryParamInfo.QueryFilterItemInfo> queryParamItemList = queryParamInfo.getFilters();
        ArrayList<Object> params = new ArrayList<Object>();
        for (QueryParamInfo.QueryFilterItemInfo item : queryParamItemList) {
            sb.append(" AND \"").append(item.getTabAlias()).append("\".").append(item.getFieldName()).append(this.getCompareTypeStr(item.getCompareType())).append(" ? ");
            params.add(item.getFieldValue());
        }
        Object[] finalParams = params.toArray();
        ObjectTypeUtil.translateObjectType(finalParams);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])finalParams);
    }

    private String getCompareTypeStr(CompareType compareType) throws BOSException {
        if (null == compareType) {
            return " = ";
        }
        if (CompareType.EQUALS.equals((Object)compareType) || CompareType.GREATER.equals((Object)compareType) || CompareType.GREATER_EQUALS.equals((Object)compareType) || CompareType.LESS.equals((Object)compareType) || CompareType.LESS_EQUALS.equals((Object)compareType)) {
            return compareType.getName();
        }
        BOSException e = new BOSException("Not supported (CompareType: " + compareType.getAlias() + ")");
        logger.error((Object)("Not supported (CompareType: " + compareType.getAlias() + ")"), (Throwable)e);
        throw e;
    }

    @Override
    protected void _save(Context ctx, SaveParamInfo paramInfo) throws BOSException, EASBizException {
        String tabName = paramInfo.getTabName();
        this.del(ctx, tabName, paramInfo.getDelIdList());
        this.update(ctx, tabName, paramInfo.getEntryFieldKeys(), paramInfo.getUpdateEntryFieldList());
        this.addnew(ctx, tabName, paramInfo.getHeadFieldKeys(), paramInfo.getHeadFieldValues(), paramInfo.getEntryFieldKeys(), paramInfo.getNewEntryFieldList());
    }

    private void addnew(Context ctx, String tabName, String[] headFieldKeys, Object[] headFieldValues, String[] entryFieldKeys, List<Object[]> entryFieldValues) throws BOSException {
        if (null == entryFieldKeys || entryFieldKeys.length == 0 || null == entryFieldValues || entryFieldValues.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tabName).append(" (");
        for (String key : headFieldKeys) {
            sql.append(key).append(",");
        }
        int idPosition = 0;
        int len = entryFieldKeys.length;
        for (int i = 0; i < len; ++i) {
            String key;
            key = entryFieldKeys[i];
            if (FID.equalsIgnoreCase(key)) {
                idPosition = i;
            }
            sql.append(key).append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(") VALUES ( ");
        int paramColCount = headFieldKeys.length + entryFieldKeys.length;
        for (int i = 0; i < paramColCount; ++i) {
            sql.append("?,");
        }
        sql.setLength(sql.length() - 1);
        sql.append(")");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Object[] objs : entryFieldValues) {
            Object[] param = new Object[paramColCount];
            objs[idPosition] = BOSUuid.create((String)"SCMCONTC").toString();
            System.arraycopy(headFieldValues, 0, param, 0, headFieldValues.length);
            System.arraycopy(objs, 0, param, headFieldValues.length, objs.length);
            params.add(param);
        }
        ObjectTypeUtil.translateObjectType(params);
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
    }

    private void update(Context ctx, String tabName, String[] fieldKeys, List<Object[]> updateEntryFieldList) throws BOSException {
        List<Object[]> params;
        if (null == fieldKeys || fieldKeys.length == 0 || null == updateEntryFieldList || updateEntryFieldList.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tabName).append(" SET ");
        int idIndex = 0;
        int len = fieldKeys.length;
        for (int i = 0; i < len; ++i) {
            String key = fieldKeys[i];
            if (FID.equalsIgnoreCase(key)) {
                idIndex = i;
                continue;
            }
            sql.append(key).append(" = ?,");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" WHERE FID = ? ");
        if (idIndex != fieldKeys.length - 1) {
            params = new ArrayList<Object[]>();
            for (Object[] objs : updateEntryFieldList) {
                Object[] values = new Object[objs.length];
                System.arraycopy(objs, 0, values, 0, idIndex);
                System.arraycopy(objs, idIndex + 1, values, idIndex, objs.length - idIndex - 1);
                System.arraycopy(objs, idIndex, values, objs.length - 1, 1);
                params.add(values);
            }
        } else {
            params = updateEntryFieldList;
        }
        ObjectTypeUtil.translateObjectType(params);
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
    }

    private void del(Context ctx, String tabName, List<String> idList) throws BOSException {
        if (null == idList || idList.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("delete from ");
        sql.append(tabName).append(" where FID in (");
        for (String id : idList) {
            sql.append("'").append(id).append("',");
        }
        sql.setLength(sql.length() - 1);
        sql.append(") ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

