/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.condition.ConditionException;
import com.kingdee.eas.scm.framework.condition.ConditionTypeCollection;
import com.kingdee.eas.scm.framework.condition.ConditionTypeInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureItemCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureItemFactory;
import com.kingdee.eas.scm.framework.condition.app.AbstractConditionTypeControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ConditionTypeControllerBean
extends AbstractConditionTypeControllerBean {
    private static final long serialVersionUID = -8633796650343046100L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.condition.app.ConditionTypeControllerBean");

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ConditionTypeInfo info = (ConditionTypeInfo)model;
        if (info != null && !UseStatusEnum.ACTIVE.equals((Object)info.getStatus())) {
            throw new EASBizException(ConditionException.CONDITIONTYPE_ISINACTIVED, new Object[]{info.getNumber()});
        }
        String sql = "update T_CT_CONDITIONTYPE SET FSTATUS = ? where FID = ? ";
        Object[] params = new Object[]{2, pk.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ConditionTypeInfo info = (ConditionTypeInfo)model;
        if (info != null && UseStatusEnum.ACTIVE.equals((Object)info.getStatus())) {
            throw new EASBizException(ConditionException.CONDITIONTYPE_ISACTIVED, new Object[]{info.getNumber()});
        }
        String sql = "update T_CT_CONDITIONTYPE SET FSTATUS = ? where FID = ? ";
        Object[] params = new Object[]{1, pk.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected List _setState(Context ctx, List pkList, UseStatusEnum status) throws BOSException, EASBizException {
        ArrayList<ConditionException> list = new ArrayList<ConditionException>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pkList);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ConditionTypeCollection col = this.getConditionTypeCollection(ctx, view);
        if (col == null || col.size() == 0) {
            return list;
        }
        ArrayList<String> allowList = new ArrayList<String>();
        StringBuffer errors = new StringBuffer(20);
        ConditionTypeInfo conditionType = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            conditionType = col.get(i);
            if (2 == status.getValue() && 2 == conditionType.getStatus().getValue()) {
                errors.append("," + conditionType.getNumber());
                list.add(new ConditionException(ConditionException.CONDITIONTYPE_ISINACTIVED, new Object[]{conditionType.getNumber()}));
                continue;
            }
            if (1 == status.getValue() && 1 == conditionType.getStatus().getValue()) {
                errors.append("," + conditionType.getNumber());
                list.add(new ConditionException(ConditionException.CONDITIONTYPE_ISACTIVED, new Object[]{conditionType.getNumber()}));
                continue;
            }
            allowList.add(conditionType.getId().toString());
            conditionType.setStatus(status);
        }
        if (allowList.size() > 0) {
            String sql = "update T_CT_ConditionType set fstatus=" + status.getValue() + " where fid in(" + CollectionUtil.convertList2String(allowList) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return list;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ConditionTypeInfo cTypeInfo = (ConditionTypeInfo)this._getValue(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("conditionType.id", (Object)cTypeInfo.getId().toString()));
        view.setFilter(filterInfo);
        ProcedureItemCollection proCollection = ProcedureItemFactory.getLocalInstance(ctx).getProcedureItemCollection(view);
        if (proCollection != null && !proCollection.isEmpty()) {
            throw new ConditionException(ConditionException.PRODUCE_NOT_DELETE, new Object[]{cTypeInfo.getNumber()});
        }
        super._delete(ctx, pk);
    }
}

