/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app;

import com.kingdee.eas.scm.framework.condition.DebugMsgInfo;
import java.util.HashMap;
import java.util.Map;

public final class MessageHolder {
    private static final String MSG = "msg";
    private static final String SQL = "sql";
    private static final ThreadLocal<Map<String, DebugMsgInfo>> contextThreadLocal = new ThreadLocal();

    private static void setDebugMessage(Map<String, DebugMsgInfo> map) {
        assert (map != null);
        contextThreadLocal.set(map);
    }

    public static Map<String, DebugMsgInfo> getDebugMessageMap() {
        Map<String, DebugMsgInfo> map = contextThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, DebugMsgInfo>(3);
            MessageHolder.setDebugMessage(map);
        }
        return map;
    }

    public static void clearMessage() {
        contextThreadLocal.remove();
    }

    private static DebugMsgInfo getDebugMsg() {
        DebugMsgInfo msg = MessageHolder.getDebugMessageMap().get(MSG);
        if (null == msg) {
            msg = new DebugMsgInfo();
            MessageHolder.getDebugMessageMap().put(MSG, msg);
        }
        return msg;
    }

    private static DebugMsgInfo getDebugSql() {
        DebugMsgInfo sql = MessageHolder.getDebugMessageMap().get(SQL);
        if (null == sql) {
            sql = new DebugMsgInfo();
            MessageHolder.getDebugMessageMap().put(SQL, sql);
        }
        return sql;
    }

    public static void appendMessage(String message) {
        MessageHolder.getDebugMsg().append(message);
    }

    public static void appendMessage(String title, String message) {
        MessageHolder.getDebugMsg().append(title, message);
    }

    public static String getMessage() {
        return MessageHolder.getDebugMsg().getText();
    }

    public static void appendSql(String sql) {
        MessageHolder.getDebugSql().append(sql);
    }

    public static void appendSql(String title, String sql) {
        MessageHolder.getDebugSql().append(title, sql);
    }

    public static String getSql() {
        return MessageHolder.getDebugSql().getText();
    }
}

