/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.condition.ConditionException;
import com.kingdee.eas.scm.framework.condition.DetermanitionDataInfo;
import com.kingdee.eas.scm.framework.condition.ProDeterminationMappingCollection;
import com.kingdee.eas.scm.framework.condition.ProDeterminationMappingFactory;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationInfo;
import com.kingdee.eas.scm.framework.condition.app.AbstractProcedureDeterminationControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcedureDeterminationControllerBean
extends AbstractProcedureDeterminationControllerBean {
    private static final long serialVersionUID = -7599114354088441934L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.condition.app.ProcedureDeterminationControllerBean");

    @Override
    protected void _saveDetermanitionData(Context ctx, DetermanitionDataInfo dataInfo) throws BOSException, EASBizException {
        if (null == dataInfo) {
            return;
        }
        String sql = "DELETE FROM T_CT_DETERDATA WHERE FPROCEDUREID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{dataInfo.getProcedureID()});
        if (null == dataInfo || dataInfo.getFieldValueList() == null || dataInfo.getFieldValueList().size() == 0) {
            return;
        }
        sql = "INSERT INTO T_CT_DETERDATA (FENTRYID,FPROCEDUREID,FKEY,FVALUE) VALUES(?,?,?,?);";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        List<String[]> fieldValues = dataInfo.getFieldValueList();
        String[] fieldNames = dataInfo.getFieldNames();
        for (String[] fieldVal : fieldValues) {
            String entryId = BOSUuid.create((String)"PRODETER").toString();
            int len = fieldVal.length;
            for (int i = 0; i < len; ++i) {
                if ("fentryid".equalsIgnoreCase(fieldNames[i])) {
                    fieldVal[i] = entryId;
                    continue;
                }
                Object[] params = new Object[]{entryId, dataInfo.getProcedureID(), fieldNames[i], fieldVal[i]};
                paramsList.add(params);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    @Override
    protected List _setState(Context ctx, List pkList, UseStatusEnum status) throws BOSException, EASBizException {
        ArrayList<ConditionException> list = new ArrayList<ConditionException>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pkList);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ProcedureDeterminationCollection col = this.getProcedureDeterminationCollection(ctx, view);
        if (col == null || col.size() == 0) {
            return list;
        }
        ArrayList<String> allowList = new ArrayList<String>();
        StringBuffer errors = new StringBuffer(20);
        ProcedureDeterminationInfo procedureDetermination = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            procedureDetermination = col.get(i);
            if (2 == status.getValue() && 2 == procedureDetermination.getStatus().getValue()) {
                errors.append("," + procedureDetermination.getNumber());
                list.add(new ConditionException(ConditionException.PROCEDUREDETERM_ISINACTIVED, new Object[]{procedureDetermination.getNumber()}));
                continue;
            }
            if (1 == status.getValue() && 1 == procedureDetermination.getStatus().getValue()) {
                errors.append("," + procedureDetermination.getNumber());
                list.add(new ConditionException(ConditionException.PROCEDUREDETERM_ISACTIVED, new Object[]{procedureDetermination.getNumber()}));
                continue;
            }
            allowList.add(procedureDetermination.getId().toString());
            procedureDetermination.setStatus(status);
        }
        if (allowList.size() > 0) {
            String sql = "update T_CT_ProcedureDetermination set fstatus=" + status.getValue() + " where fid in(" + CollectionUtil.convertList2String(allowList) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return list;
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProcedureDeterminationInfo pdMInfo = (ProcedureDeterminationInfo)this._getValue(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("proDetermination.id", (Object)pdMInfo.getId().toString()));
        view.setFilter(filterInfo);
        ProDeterminationMappingCollection proDeMCollection = ProDeterminationMappingFactory.getLocalInstance(ctx).getProDeterminationMappingCollection(view);
        if (proDeMCollection != null && !proDeMCollection.isEmpty()) {
            throw new ConditionException(ConditionException.PROCEDURECONFIM_NOT_DELETE, new Object[]{pdMInfo.getNumber()});
        }
        super.delete(ctx, pk);
    }
}

