/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app.formula.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.condition.ConditionFieldCollection;
import com.kingdee.eas.scm.framework.condition.ConditionFormulaException;
import com.kingdee.eas.scm.framework.condition.IProcedureTypeMapping;
import com.kingdee.eas.scm.framework.condition.ProcedureInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureItemCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureItemInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeFactory;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingFactory;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingItemCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingItemInfo;
import com.kingdee.eas.scm.framework.condition.SelectedFieldInfo;
import com.kingdee.eas.scm.framework.condition.SourceTypeEnum;
import com.kingdee.eas.scm.framework.condition.app.formula.engine.ConditionBigDecimalResultInfo;
import com.kingdee.eas.scm.framework.condition.app.formula.engine.ConditionBooleanResultInfo;
import com.kingdee.eas.scm.framework.condition.app.formula.engine.ConditionExceptionMsgInterpreter;
import com.kingdee.eas.scm.framework.condition.app.formula.engine.ConditionFormulaResultInfo;
import com.kingdee.eas.scm.framework.condition.app.formula.engine.ConditionInterpreter;
import com.kingdee.eas.scm.framework.condition.app.formula.function.CustomerFunctionProvider;
import com.kingdee.eas.scm.framework.condition.app.log.IConditionLogger;
import com.kingdee.eas.scm.framework.condition.util.ConditionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.LowTimer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class ConditionFormulaEngine {
    private static final String ProcessSerialNumber = "bizFlowRelation";
    private IConditionLogger logger = null;
    private LowTimer timer = new LowTimer();
    private Context ctx;
    private IObjectValue destObject;
    private IObjectValue destEntryObject;
    private IMetaDataLoader loader;
    private ConditionInterpreter interpreter;
    private ConditionExceptionMsgInterpreter msgInterpreter;
    private List<String> destEntryNameList = new ArrayList<String>();
    private Map<String, IObjectCollection> destEntryMap = new HashMap<String, IObjectCollection>();
    private Map<String, IObjectCollection> srcEntryMap = new HashMap<String, IObjectCollection>();
    private String currProcessId = null;
    private ExceptionObject MissResourceObject = new ExceptionObject();
    private ExceptionObject EvalExceptionObject = new ExceptionObject();

    public ConditionFormulaEngine(Context ctx, IObjectValue destObject, IConditionLogger logger) throws BOSException {
        this.ctx = ctx;
        this.destObject = destObject;
        this.logger = logger;
        this.loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        this.destEntryNameList = this.getEntityEntryNames("_Dest", destObject);
        this.initInterpreter();
    }

    public ConditionFormulaEngine(Context ctx, IObjectValue destObject, IObjectValue destEntryObject, IConditionLogger logger) throws BOSException {
        this.ctx = ctx;
        this.destObject = destObject;
        this.destEntryObject = destEntryObject;
        this.logger = logger;
        this.loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        this.destEntryNameList = this.getEntityEntryNames("_Dest", destObject);
        this.initInterpreter();
    }

    private List<String> getEntityEntryNames(String prefix, IObjectValue object) {
        EntityObjectInfo entity = this.loader.getEntity(object.getBOSType());
        EntityEntryStructure entryStructure = new EntityEntryStructure(1, entity);
        Map<String, Object> srcEntryStructureMap = entryStructure.buildHorizontalStructure(prefix);
        ArrayList<String> result = new ArrayList<String>();
        for (String entryName : srcEntryStructureMap.keySet()) {
            result.add(entryName);
        }
        return result;
    }

    public boolean calculateAutoCreateCondition(String filter) throws BOSException, ConditionFormulaException {
        if (StringUtil.isEmpty((String)filter)) {
            return true;
        }
        boolean result = false;
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__bosContext", this.ctx);
        localCtx.put("_Dest", this.destObject);
        List<String> entryNameList = this.getEntryNameInExpr(filter, this.destEntryNameList);
        if (entryNameList.size() > 0) {
            String entryName = entryNameList.get(0);
            IObjectCollection entryCollection = this.getEntryCollection(this.destObject, "_Dest", entryName);
            if (entryCollection == null || entryCollection.size() == 0) {
                return true;
            }
            IObjectValue entryObj2 = null;
            for (IObjectValue entryObj2 : entryCollection) {
                localCtx.put(entryName, entryObj2);
                Object value = this.interpreter.eval(filter, localCtx);
                if (value == null || !(value instanceof Boolean)) {
                    throw new ConditionFormulaException(ConditionFormulaException.CFFILTERINVALID);
                }
                if (((Boolean)value).booleanValue()) continue;
                return false;
            }
            result = true;
        } else {
            Object value = this.interpreter.eval(filter, localCtx);
            if (value == null || !(value instanceof Boolean)) {
                throw new ConditionFormulaException(ConditionFormulaException.CFFILTERINVALID);
            }
            result = (Boolean)value;
        }
        return result;
    }

    private ConditionExceptionMsgInterpreter getExceptionMsgInterpreter(BOSObjectType srcBosType) {
        EntityObjectInfo srcEntity = this.loader.getEntity(srcBosType);
        EntityObjectInfo destEntity = this.loader.getEntity(this.destObject.getBOSType());
        return new ConditionExceptionMsgInterpreter(srcEntity, destEntity, this.interpreter);
    }

    private Object calculateHeadWBValue(Map<String, Object> localCtx, String destExpr, List<String> destEntryNameInExprList) throws BOSException {
        IObjectValue destObjectEntry = null;
        boolean isException = false;
        for (int j = 0; j < destEntryNameInExprList.size(); ++j) {
            IObjectCollection entryColl = this.getEntryCollection(this.destObject, "_Dest", destEntryNameInExprList.get(j));
            if (entryColl == null || entryColl.size() == 0) {
                isException = true;
                break;
            }
            destObjectEntry = entryColl.getObject(0);
            localCtx.put(destEntryNameInExprList.get(j), destObjectEntry);
        }
        if (isException) {
            return this.MissResourceObject;
        }
        Object result = null;
        try {
            result = this.interpreter.eval(destExpr, localCtx);
        }
        catch (BOSException e) {
            this.EvalExceptionObject.setException((Exception)((Object)e));
            return this.EvalExceptionObject;
        }
        return result;
    }

    private Object calculateEntryWBValue(Map<String, Object> localCtx, String destExpr, IObjectValue entryObj, List<String> destEntryNameInExprList) throws BOSException {
        String processSerialNumber = entryObj.getString(ProcessSerialNumber);
        if (processSerialNumber == null || processSerialNumber.length() == 0) {
            return this.MissResourceObject;
        }
        for (int i = 0; i < destEntryNameInExprList.size(); ++i) {
            List<IObjectValue> entryList = this.findDestObjectEntry(destEntryNameInExprList.get(i), processSerialNumber);
            if (entryList.size() == 0) {
                return this.MissResourceObject;
            }
            localCtx.put(destEntryNameInExprList.get(0), entryList);
        }
        Object result = null;
        try {
            result = this.interpreter.eval(destExpr, localCtx);
        }
        catch (BOSException e) {
            this.EvalExceptionObject.setException((Exception)((Object)e));
            return this.EvalExceptionObject;
        }
        return result;
    }

    private List<String> getEntryNameInExpr(String expr, List<String> allEntryNameList) throws KScriptException {
        ArrayList<String> idenList = new ArrayList<String>();
        BotUtil.computeIdent((String)expr, idenList);
        return this.getEntryNameInRuleList(idenList, allEntryNameList);
    }

    private IObjectCollection getEntryCollection(IObjectValue object, String prefix, String entryName) throws BOSException {
        String key;
        IObjectCollection result = null;
        Map<String, IObjectCollection> cacheMap = null;
        cacheMap = prefix.equals("_Dest") ? this.destEntryMap : this.srcEntryMap;
        if (cacheMap.containsKey(key = (object.get("id") == null ? "" : object.get("id").toString()) + "_" + entryName)) {
            return cacheMap.get(key);
        }
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put(prefix, object);
        localCtx.putAll(cacheMap);
        result = (IObjectCollection)this.iteratorGetEntryCollection(object, entryName, localCtx);
        cacheMap.put(key, result);
        return result;
    }

    private boolean isMatchProcessId(String processSerialNumber) {
        if (StringUtil.isEmpty((String)processSerialNumber)) {
            return false;
        }
        return processSerialNumber.indexOf(this.currProcessId) > -1;
    }

    private List<String> getEntryNameInRuleList(List<String> srcIdentList, List<String> allEntryNameList) {
        ArrayList<String> result = new ArrayList<String>();
        int count = srcIdentList.size();
        for (int i = 0; i < count; ++i) {
            String ident = srcIdentList.get(i);
            int lastDotIndex = ident.lastIndexOf(46);
            if (lastDotIndex > -1) {
                ident = ident.substring(0, lastDotIndex);
            }
            if (allEntryNameList.contains(ident) && !result.contains(ident)) {
                result.add(ident);
            }
            if (result.size() == allEntryNameList.size()) break;
        }
        Collections.sort(result);
        return result;
    }

    private List<IObjectValue> findDestObjectEntry(String destEntryName, String processSerialNumber) throws BOSException {
        ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
        IObjectCollection entryColl = this.getEntryCollection(this.destObject, "_Dest", destEntryName);
        IObjectValue entry = null;
        for (int i = 0; entryColl != null && i < entryColl.size(); ++i) {
            entry = entryColl.getObject(i);
            if (entry.getString(ProcessSerialNumber) == null || entry.getString(ProcessSerialNumber).indexOf(processSerialNumber) <= -1) continue;
            result.add(entry);
        }
        return result;
    }

    private Object iteratorGetEntryCollection(IObjectValue object, String entryName, Map<String, Object> localCtx) throws BOSException {
        if (localCtx.containsKey(entryName)) {
            return localCtx.get(entryName);
        }
        int lastDotIndex = entryName.lastIndexOf(46);
        ConditionInterpreter interpreter = new ConditionInterpreter(this.ctx);
        if (lastDotIndex > -1) {
            String parent = entryName.substring(0, lastDotIndex);
            Object ownerValue = this.iteratorGetEntryCollection(object, parent, localCtx);
            if (ownerValue instanceof IObjectCollection) {
                IObjectCollection result = null;
                for (Object entryObj : (IObjectCollection)ownerValue) {
                    localCtx.put(parent, entryObj);
                    Object retVal = interpreter.eval(entryName, localCtx);
                    if (result == null) {
                        result = (IObjectCollection)retVal;
                        continue;
                    }
                    result.addObjectCollection((IObjectCollection)retVal);
                }
                return result;
            }
            localCtx.put(parent, ownerValue);
            return interpreter.eval(entryName, localCtx);
        }
        return object;
    }

    private void initInterpreter() throws BOSException {
        if (this.interpreter == null) {
            this.interpreter = new ConditionInterpreter(this.ctx);
            CustomerFunctionProvider cusProvider = new CustomerFunctionProvider(this.ctx);
            this.interpreter.addFunctionProvider(cusProvider);
            this.interpreter.setProperyExprOwnerNullIgore(true);
        }
    }

    public ProcedureTypeMappingInfo getProcedureTypeMappingByBill(Context ctx, String procedureTypeID, String billType) throws BOSException {
        ProcedureTypeMappingInfo mappingInfo = null;
        IProcedureTypeMapping mappingFactory = ctx == null ? ProcedureTypeMappingFactory.getRemoteInstance() : ProcedureTypeMappingFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("procedureType.id", (Object)procedureTypeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)billType, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("procedureType.*"));
        sic.add(new SelectorItemInfo("items.id"));
        sic.add(new SelectorItemInfo("items.fieldExpr"));
        sic.add(new SelectorItemInfo("items.fieldAlias"));
        sic.add(new SelectorItemInfo("items.mappingType"));
        sic.add(new SelectorItemInfo("items.replace"));
        sic.add(new SelectorItemInfo("items.required"));
        sic.add(new SelectorItemInfo("items.conditionField.id"));
        sic.add(new SelectorItemInfo("items.conditionField.name"));
        sic.add(new SelectorItemInfo("items.conditionField.number"));
        sic.add(new SelectorItemInfo("items.conditionField.type"));
        sic.add(new SelectorItemInfo("items.conditionField.metaData"));
        sic.add(new SelectorItemInfo("items.conditionField.precision"));
        sic.add(new SelectorItemInfo("items.conditionField.fraction"));
        sic.add(new SelectorItemInfo("items.conditionField.seq"));
        sic.add(new SelectorItemInfo("items.conditionField.sysDef"));
        sic.add(new SelectorItemInfo("items.conditionField.ioType"));
        sic.add(new SelectorItemInfo("items.conditionField.ctrlLocation"));
        sic.add(new SelectorItemInfo("items.conditionField.rangeMatch"));
        sic.add(new SelectorItemInfo("items.conditionField.defaultF7Query"));
        view.setSelector(sic);
        ProcedureTypeMappingCollection col = mappingFactory.getProcedureTypeMappingCollection(view);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return col.get(0);
        }
        return mappingInfo;
    }

    public String matchBillRequireFormula(Context ctx, String exper, ProcedureTypeMappingInfo procedureTypeMappingInfo) throws EASBizException, BOSException {
        if (procedureTypeMappingInfo == null) {
            return exper;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fields.id"));
        sic.add(new SelectorItemInfo("fields.name"));
        sic.add(new SelectorItemInfo("fields.number"));
        sic.add(new SelectorItemInfo("fields.type"));
        sic.add(new SelectorItemInfo("fields.metaData"));
        sic.add(new SelectorItemInfo("fields.precision"));
        sic.add(new SelectorItemInfo("fields.fraction"));
        sic.add(new SelectorItemInfo("fields.seq"));
        sic.add(new SelectorItemInfo("fields.sysDef"));
        sic.add(new SelectorItemInfo("fields.ioType"));
        sic.add(new SelectorItemInfo("fields.ctrlLocation"));
        sic.add(new SelectorItemInfo("fields.rangeMatch"));
        sic.add(new SelectorItemInfo("fields.defaultF7Query"));
        ProcedureTypeInfo procedureType = ProcedureTypeFactory.getLocalInstance(ctx).getProcedureTypeInfo((IObjectPK)new ObjectUuidPK(procedureTypeMappingInfo.getProcedureType().getId()), sic);
        ConditionFieldCollection conditionCol = procedureType.getFields();
        Object fieldInfo = null;
        String fieldNumber = "";
        HashMap map = new HashMap();
        int size = conditionCol.size();
        for (int i = 0; i < size; ++i) {
            fieldNumber = conditionCol.get(i).getNumber();
            if ("FBillType".equals(fieldNumber) || exper.indexOf(fieldNumber) < 0) continue;
            map.put(fieldNumber, null);
        }
        String retValue = exper;
        ProcedureTypeMappingItemCollection mappingItems = procedureTypeMappingInfo.getItems();
        ProcedureTypeMappingItemInfo mappingItem = null;
        StringBuilder sb = new StringBuilder();
        String bosType = "";
        int size2 = mappingItems.size();
        for (int i = 0; i < size2; ++i) {
            mappingItem = mappingItems.get(i);
            String conditionFieldName = mappingItem.getConditionField().getNumber();
            if ("FBillType".equals(conditionFieldName)) {
                bosType = mappingItem.getFieldExpr();
                continue;
            }
            String billPropertyName = mappingItem.getFieldExpr();
            if (retValue.indexOf(conditionFieldName) < 0) continue;
            retValue = SourceTypeEnum.MAPPING.equals((Object)mappingItem.getMappingType()) ? retValue.replaceAll(conditionFieldName, "_Dest." + billPropertyName) : retValue.replaceAll(conditionFieldName, "_Dest." + conditionFieldName);
        }
        if (retValue.indexOf("PROCEDURE_FORMULA_STEP") >= 0) {
            retValue = retValue.replaceAll("PROCEDURE_FORMULA_STEP", "_Dest.PROCEDURE_FORMULA_STEP");
        }
        if (map.size() == mappingItems.size() - 1) {
            return retValue;
        }
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            String key = (String)entry.getKey();
            if (retValue.indexOf(key) < 0) continue;
            sb.append(key).append(",");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
            EntityObjectInfo entityObjectInfo = ConditionUtil.getEntityObjectInfo(ctx, bosType);
        }
        return retValue;
    }

    public String matchProcedureFormula(Context ctx, String exper, ProcedureTypeMappingInfo procedureTypeMappingInfo) throws EASBizException, BOSException {
        if (procedureTypeMappingInfo == null) {
            return exper;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fields.id"));
        sic.add(new SelectorItemInfo("fields.name"));
        sic.add(new SelectorItemInfo("fields.number"));
        sic.add(new SelectorItemInfo("fields.type"));
        sic.add(new SelectorItemInfo("fields.metaData"));
        sic.add(new SelectorItemInfo("fields.precision"));
        sic.add(new SelectorItemInfo("fields.fraction"));
        sic.add(new SelectorItemInfo("fields.seq"));
        sic.add(new SelectorItemInfo("fields.sysDef"));
        sic.add(new SelectorItemInfo("fields.ioType"));
        sic.add(new SelectorItemInfo("fields.ctrlLocation"));
        sic.add(new SelectorItemInfo("fields.rangeMatch"));
        sic.add(new SelectorItemInfo("fields.defaultF7Query"));
        ProcedureTypeInfo procedureType = ProcedureTypeFactory.getLocalInstance(ctx).getProcedureTypeInfo((IObjectPK)new ObjectUuidPK(procedureTypeMappingInfo.getProcedureType().getId()), sic);
        ConditionFieldCollection conditionCol = procedureType.getFields();
        Object fieldInfo = null;
        String fieldNumber = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        int size = conditionCol.size();
        for (int i = 0; i < size; ++i) {
            fieldNumber = conditionCol.get(i).getNumber();
            if ("FBillType".equals(fieldNumber) || exper.indexOf(fieldNumber) < 0) continue;
            map.put(fieldNumber, null);
        }
        String retValue = exper;
        ProcedureTypeMappingItemCollection mappingItems = procedureTypeMappingInfo.getItems();
        ProcedureTypeMappingItemInfo mappingItem = null;
        String bosType = "";
        int size2 = mappingItems.size();
        for (int i = 0; i < size2; ++i) {
            mappingItem = mappingItems.get(i);
            String conditionFieldName = mappingItem.getConditionField().getNumber();
            if ("FBillType".equals(conditionFieldName)) {
                bosType = mappingItem.getFieldExpr();
                continue;
            }
            String billPropertyName = mappingItem.getFieldExpr();
            if (retValue.indexOf(conditionFieldName) < 0) continue;
            retValue = SourceTypeEnum.MAPPING.equals((Object)mappingItem.getMappingType()) ? retValue.replaceAll(conditionFieldName, "_Dest." + billPropertyName) : retValue.replaceAll(conditionFieldName, "_Dest." + conditionFieldName);
        }
        if (retValue.indexOf("PROCEDURE_FORMULA_STEP") >= 0) {
            retValue = retValue.replaceAll("PROCEDURE_FORMULA_STEP", "_Dest.PROCEDURE_FORMULA_STEP");
        }
        return retValue;
    }

    public ConditionFormulaResultInfo calculateConditionFormulaValue(Context ctx, ProcedureInfo procedureInfo, IObjectValue model) throws EASBizException, BOSException {
        ConditionFormulaResultInfo result = new ConditionFormulaResultInfo();
        if (procedureInfo == null || model == null) {
            return result;
        }
        ProcedureItemCollection col = procedureInfo.getItems();
        ProcedureItemInfo item = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            item = col.get(i);
            this.calculateConditionFormulaValue(ctx, item, model, result);
        }
        return result;
    }

    public void calculateConditionFormulaValue(Context ctx, ProcedureItemInfo item, IObjectValue model, ConditionFormulaResultInfo result) throws EASBizException, BOSException {
        if (item == null || StringUtil.isEmpty((String)item.getRequirementExper()) || model == null) {
            return;
        }
        String procedureTypeID = item.getProcedure().getProcedureType().getId().toString();
        ProcedureTypeMappingInfo mappingInfo = this.getProcedureTypeMappingByBill(ctx, procedureTypeID, model.getBOSType().toString());
        String exper = item.getRequirementExper();
        String desExper = this.matchBillRequireFormula(ctx, exper, mappingInfo);
        this.calculateConditionFormulaValue(desExper, item, model, result);
    }

    public void calculateConditionFormulaValue(Context ctx, SelectedFieldInfo selectedField, IObjectValue model, ConditionFormulaResultInfo result) throws EASBizException, BOSException {
        if (selectedField == null || StringUtil.isEmpty((String)selectedField.getFormulaExper()) || model == null) {
            return;
        }
        String procedureTypeID = selectedField.getConditionTable().getProcedureType().getId().toString();
        ProcedureTypeMappingInfo mappingInfo = this.getProcedureTypeMappingByBill(ctx, procedureTypeID, model.getBOSType().toString());
        String exper = selectedField.getFormulaExper();
        String desExper = this.matchBillRequireFormula(ctx, exper, mappingInfo);
        this.calculateConditionFormulaValue(desExper, null, model, result);
    }

    public void calculateConditionFormulaValue(Context ctx, ProcedureTypeMappingItemInfo mappingItem, IObjectValue model, ConditionFormulaResultInfo result) throws EASBizException, BOSException {
        if (mappingItem == null || StringUtil.isEmpty((String)mappingItem.getFormula()) || model == null) {
            return;
        }
        String procedureTypeID = mappingItem.getParent().getProcedureType().getId().toString();
        ProcedureTypeMappingInfo mappingInfo = this.getProcedureTypeMappingByBill(ctx, procedureTypeID, model.getBOSType().toString());
        String exper = mappingItem.getFormula();
        String desExper = this.matchBillRequireFormula(ctx, exper, mappingInfo);
        this.calculateConditionFormulaValue(desExper, null, model, result);
    }

    public void calculateProcedureFormulaValue(Context ctx, ProcedureItemInfo item, IObjectValue model, ConditionFormulaResultInfo result) throws EASBizException, BOSException {
        if (item == null || StringUtil.isEmpty((String)item.getFormulaExper()) || model == null) {
            return;
        }
        String exper = item.getFormulaExper();
        String procedureTypeID = item.getProcedure().getProcedureType().getId().toString();
        ProcedureTypeMappingInfo mappingInfo = this.getProcedureTypeMappingByBill(ctx, procedureTypeID, model.getBOSType().toString());
        String desExper = this.matchProcedureFormula(ctx, exper, mappingInfo);
        this.calculateConditionFormulaValue(desExper, item, model, result);
    }

    public ConditionFormulaResultInfo calculateConditionFormulaValue(String exper, ProcedureItemInfo item, IObjectValue model, ConditionFormulaResultInfo result) throws BOSException, ConditionFormulaException {
        if (StringUtil.isEmpty((String)exper) || model == null) {
            return result;
        }
        this.srcEntryMap.clear();
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__bosContext", this.ctx);
        localCtx.put("_Dest", this.destObject);
        this.timer.reset();
        this.logger.info("\u53cd\u5199\u6761\u4ef6\u6821\u9a8c\u901a\u8fc7\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
        this.calculateSingleWBRuleItem(localCtx, exper, item, result);
        return result;
    }

    public ConditionFormulaResultInfo calculateConditionFormulaValue(String exper, ProcedureItemInfo item, IObjectValue model) throws BOSException, ConditionFormulaException {
        ConditionFormulaResultInfo result = new ConditionFormulaResultInfo();
        if (StringUtil.isEmpty((String)exper) || model == null) {
            return result;
        }
        this.srcEntryMap.clear();
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__bosContext", this.ctx);
        localCtx.put("_Dest", this.destObject);
        this.timer.reset();
        this.logger.info("\u53cd\u5199\u6761\u4ef6\u6821\u9a8c\u901a\u8fc7\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
        this.calculateSingleWBRuleItem(localCtx, exper, item, result);
        return result;
    }

    private void calculateSingleWBRuleItem(Map<String, Object> localCtx, String destExpr, ProcedureItemInfo item, ConditionFormulaResultInfo result) throws BOSException, ConditionFormulaException {
        List<String> destEntryNameInExprList = null;
        Object srcEntryNameInExprList = null;
        destEntryNameInExprList = this.getEntryNameInExpr(destExpr, this.destEntryNameList);
        if (CollectionUtil.isEmpty(destEntryNameInExprList)) {
            try {
                Object object = this.interpreter.eval(destExpr, localCtx);
                String id = this.destObject.get("id") == null ? "" : this.destObject.get("id").toString();
                ConditionBooleanResultInfo v = new ConditionBooleanResultInfo(id, object, item);
                result.addBooleanResultInfo(v);
                if (object instanceof BigDecimal) {
                    ConditionBigDecimalResultInfo b = new ConditionBigDecimalResultInfo(id, object, item);
                    result.addBigDecimalResultInfo(b);
                }
            }
            catch (Exception object) {}
        } else {
            String entryName = destEntryNameInExprList.get(0);
            IObjectCollection destEntryCollection = this.getEntryCollection(this.destObject, "_Dest", entryName);
            Iterator destEntryObjItr = destEntryCollection.iterator();
            localCtx.put("_Dest", this.destObject);
            if (this.destEntryObject != null) {
                localCtx.put(entryName, this.destEntryObject);
                Object value = this.calculateEntryConditionValue(localCtx, destExpr, destEntryNameInExprList);
                String id = this.destEntryObject == null ? null : (this.destEntryObject.get("id") == null ? null : this.destEntryObject.get("id").toString());
                ConditionBooleanResultInfo v = new ConditionBooleanResultInfo(id, value, item);
                result.addBooleanResultInfo(v);
                if (value instanceof BigDecimal) {
                    ConditionBigDecimalResultInfo b = new ConditionBigDecimalResultInfo(id, value, item);
                    result.addBigDecimalResultInfo(b);
                }
                return;
            }
            while (destEntryObjItr.hasNext()) {
                IObjectValue desEntryObject = (IObjectValue)destEntryObjItr.next();
                localCtx.put(entryName, desEntryObject);
                Object value = this.calculateEntryConditionValue(localCtx, destExpr, destEntryNameInExprList);
                String id = this.destEntryObject == null ? null : (this.destEntryObject.get("id") == null ? null : this.destEntryObject.get("id").toString());
                ConditionBooleanResultInfo v = new ConditionBooleanResultInfo(id, value, item);
                result.addBooleanResultInfo(v);
                if (!(value instanceof BigDecimal)) continue;
                ConditionBigDecimalResultInfo b = new ConditionBigDecimalResultInfo(id, value, item);
                result.addBigDecimalResultInfo(b);
            }
        }
    }

    private List<IObjectValue> findDestObjectEntry(String destEntryName) throws BOSException {
        ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
        IObjectCollection entryColl = this.getEntryCollection(this.destObject, "_Dest", destEntryName);
        IObjectValue entry = null;
        for (int i = 0; entryColl != null && i < entryColl.size(); ++i) {
            entry = entryColl.getObject(i);
            result.add(entry);
        }
        return result;
    }

    private Object calculateEntryConditionValue(Map<String, Object> localCtx, String destExpr, List<String> destEntryNameInExprList) throws BOSException {
        for (int i = 0; i < destEntryNameInExprList.size(); ++i) {
            String key = destEntryNameInExprList.get(i);
            List<IObjectValue> entryList = this.findDestObjectEntry(key);
            if (entryList.size() == 0) {
                return this.MissResourceObject;
            }
            if (localCtx.containsKey(key) && localCtx.get(key) != null) continue;
            localCtx.put(key, entryList);
        }
        Object result = null;
        try {
            result = this.interpreter.eval(destExpr, localCtx);
        }
        catch (BOSException e) {
            this.EvalExceptionObject.setException((Exception)((Object)e));
            return this.EvalExceptionObject;
        }
        return result;
    }

    private Object calculateEntryConditionValue(Map<String, Object> localCtx, String destExpr, IObjectValue destObject, List<String> destEntryNameInExprList) throws BOSException {
        for (int i = 0; i < destEntryNameInExprList.size(); ++i) {
            List<IObjectValue> entryList = this.findDestObjectEntry(destObject, destEntryNameInExprList.get(i));
            if (entryList.size() == 0) {
                return this.MissResourceObject;
            }
            localCtx.put(destEntryNameInExprList.get(0), entryList);
        }
        Object result = null;
        try {
            result = this.interpreter.eval(destExpr, localCtx);
        }
        catch (BOSException e) {
            this.EvalExceptionObject.setException((Exception)((Object)e));
            return this.EvalExceptionObject;
        }
        return result;
    }

    private List<IObjectValue> findDestObjectEntry(IObjectValue destObject, String destEntryName) throws BOSException {
        ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
        IObjectCollection entryColl = this.getEntryCollection(destObject, "_Dest", destEntryName);
        IObjectValue entry = null;
        for (int i = 0; entryColl != null && i < entryColl.size(); ++i) {
            entry = entryColl.getObject(i);
            result.add(entry);
        }
        return result;
    }

    private void initEntryCtx(Map<String, Object> localCtx, String exper, IObjectValue destEntryObject, String destEntryName) throws BOSException {
        List<String> destEntryNameInExprList = this.getEntryNameInExpr(exper, this.destEntryNameList);
        if (destEntryNameInExprList.size() <= 1) {
            return;
        }
        IObjectValue nextDestEntryObject = null;
        List<IObjectValue> list = null;
        int size = destEntryNameInExprList.size();
        for (int i = 1; i < size; ++i) {
            destEntryName = destEntryNameInExprList.get(i - 1);
            String nextDestEntryName = destEntryNameInExprList.get(i);
            if (nextDestEntryName.indexOf(destEntryName) < 0) continue;
            if (i == 1) {
                list = this.findDestObjectEntry(destEntryObject, nextDestEntryName);
                localCtx.put(nextDestEntryName, list);
            } else if (!CollectionUtils.isEmpty(list)) {
                nextDestEntryObject = list.get(0);
                list = this.findDestObjectEntry(nextDestEntryObject, nextDestEntryName);
                localCtx.put(nextDestEntryName, list);
            }
            if (!CollectionUtils.isEmpty(list)) continue;
            return;
        }
    }

    class ExceptionObject {
        Exception e;

        ExceptionObject() {
            this(null);
        }

        ExceptionObject(Exception e) {
            this.e = e;
        }

        public void setException(Exception e) {
            this.e = e;
        }

        public String toString() {
            if (this.e == null) {
                return "MissResource";
            }
            return this.e.getMessage();
        }
    }

    private class EntityEntryStructure {
        private static final String ISENTRIES = "isEntries";
        private int level;
        private Map<String, Object> entryVerticalMap;
        private EntityObjectInfo entryEntity;

        public EntityEntryStructure(int level, EntityObjectInfo entity) {
            this.level = level;
            this.entryEntity = entity;
            this.buildVerticalStructure();
        }

        public Map<String, Object> buildHorizontalStructure(String prefix) {
            HashMap<String, Object> entryHorizontalMap = new HashMap<String, Object>();
            this.transformVerticalToHorizonStructure(prefix, this.entryVerticalMap, entryHorizontalMap);
            return entryHorizontalMap;
        }

        private void transformVerticalToHorizonStructure(String prefix, Map<String, Object> entryVerticalMap, Map<String, Object> entryHorizontalMap) {
            Set<String> key = entryVerticalMap.keySet();
            for (String propName : key) {
                EntityEntryStructure entry = (EntityEntryStructure)entryVerticalMap.get(propName);
                String entryPrefix = prefix == null ? propName : prefix + "." + propName;
                entryHorizontalMap.put(entryPrefix, entry);
                this.transformVerticalToHorizonStructure(entryPrefix, entry.entryVerticalMap, entryHorizontalMap);
            }
        }

        private void buildVerticalStructure() {
            this.entryVerticalMap = new HashMap<String, Object>();
            PropertyCollection props = this.entryEntity.getInheritedNoDuplicatedProperties();
            for (PropertyInfo propInfo : props) {
                RelationshipInfo relation;
                if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty(ISENTRIES))) continue;
                EntityObjectInfo relateEntity = null;
                if (relation.getClientObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getSupplierObject();
                } else if (relation.getSupplierObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getClientObject();
                }
                if (relateEntity == null) continue;
                EntityEntryStructure entryInfo = new EntityEntryStructure(this.level + 1, relateEntity);
                this.entryVerticalMap.put(propInfo.getName(), entryInfo);
            }
        }
    }
}

