/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app.formula.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.condition.ConditionFunctionException;
import com.kingdee.eas.scm.framework.condition.app.formula.function.ICustomerFunction;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetCurrencyConvertValue
implements ICustomerFunction {
    private Map<String, BigDecimal> convertRateCache = new HashMap<String, BigDecimal>();
    private Map<String, Integer> curPrecisionCache = new HashMap<String, Integer>();

    @Override
    public Object execFunction(Context ctx, List paramList) throws EASBizException, BOSException {
        Integer precision;
        if (paramList.size() != 4) {
            throw new ConditionFunctionException(ConditionFunctionException.FUNCTIONPARAMERROR, new String[]{"_WBGetCurrencyConvertValue"});
        }
        String companyPk = paramList.get(0).toString();
        BigDecimal srcCurrencyAmount = (BigDecimal)paramList.get(1);
        String srcCurrencyPk = paramList.get(2).toString();
        String destCurrencyPk = paramList.get(3).toString();
        String key = companyPk + srcCurrencyPk + destCurrencyPk;
        BigDecimal convertValue = this.convertRateCache.get(key);
        if (convertValue == null) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseExchangeTable where id = '" + companyPk + "'");
            ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
            ObjectUuidPK excTablepk = null;
            if (exchangeTableInfo == null) {
                return null;
            }
            excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
            convertValue = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertValue((IObjectPK)excTablepk, (IObjectPK)new ObjectUuidPK(srcCurrencyPk), (IObjectPK)new ObjectUuidPK(destCurrencyPk), new Date());
            this.convertRateCache.put(key, convertValue);
        }
        if ((precision = this.curPrecisionCache.get(destCurrencyPk)) == null) {
            CurrencyInfo currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue("SELECT id, precision WHERE id = '" + destCurrencyPk + "'");
            precision = currency.getPrecision();
            this.curPrecisionCache.put(destCurrencyPk, precision);
        }
        return srcCurrencyAmount.multiply(convertValue).setScale((int)precision, RoundingMode.HALF_UP);
    }
}

