/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.formula;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.api.BuilderResourceUtil;
import com.kingdee.eas.scm.framework.condition.ConditionFieldCollection;
import com.kingdee.eas.scm.framework.condition.ConditionFieldInfo;
import com.kingdee.eas.scm.framework.condition.FieldTypeEnum;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeInfo;
import com.kingdee.eas.scm.framework.condition.util.ConditionConstant;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcedureTypeTransformerHelper {
    private TokenList tokenlist;
    ProcedureTypeInfo procedureTypeInfo;
    boolean isProcedureFormula = false;
    Map<String, ConditionFieldInfo> conditionFieldMap = new HashMap<String, ConditionFieldInfo>();
    Map<String, ConditionFieldInfo> conditionFieldMap2 = new HashMap<String, ConditionFieldInfo>();
    List<Token> tokenArr = new ArrayList<Token>();
    private static String[] chineseKeywords = new String[]{BuilderResourceUtil.getString((String)"GetStringUnicode_Shi"), BuilderResourceUtil.getString((String)"GetStringUnicode_RuGuo"), BuilderResourceUtil.getString((String)"GetStringUnicode_FouZe"), BuilderResourceUtil.getString((String)"GetStringUnicode_FouZeRuGuo"), BuilderResourceUtil.getString((String)"GetStringUnicode_Qie"), BuilderResourceUtil.getString((String)"GetStringUnicode_Huo"), BuilderResourceUtil.getString((String)"GetStringUnicode_BuShi"), BuilderResourceUtil.getString((String)"GetStringUnicode_DaYu"), BuilderResourceUtil.getString((String)"GetStringUnicode_DaYuDengYu"), BuilderResourceUtil.getString((String)"GetStringUnicode_DengYu"), BuilderResourceUtil.getString((String)"GetStringUnicode_XiaoYu"), BuilderResourceUtil.getString((String)"GetStringUnicode_XiaoYuDengYu"), BuilderResourceUtil.getString((String)"GetStringUnicode_BuDengYu")};

    public boolean isProcedureFormula() {
        return this.isProcedureFormula;
    }

    public void setProcedureFormula(boolean isProcedureFormula) {
        this.isProcedureFormula = isProcedureFormula;
    }

    public ProcedureTypeTransformerHelper(ProcedureTypeInfo procedureTypeInfo, TokenList tokenlist) {
        this.procedureTypeInfo = procedureTypeInfo;
        this.tokenlist = tokenlist;
        this.init();
    }

    private void init() {
        if (this.procedureTypeInfo == null) {
            return;
        }
        ConditionFieldCollection col = this.procedureTypeInfo.getFields();
        ConditionFieldInfo field = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            field = col.get(i);
            this.conditionFieldMap.put(field.getName(), field);
            this.conditionFieldMap2.put(field.getNumber(), field);
        }
    }

    public boolean isConditionField(Token token) {
        return this.conditionFieldMap != null && token != null && this.conditionFieldMap.containsKey(token.value);
    }

    public boolean isConditionValue(Token token) {
        return this.conditionFieldMap2 != null && token != null && this.conditionFieldMap2.containsKey(token.value);
    }

    private boolean isOperator(Token token) {
        return 4 == token.type;
    }

    public boolean isConditionFieldValue(Token token, int index) {
        if (5 == token.type && Token.OpenBraceToken.equals(token)) {
            return false;
        }
        if (5 == token.type && Token.CloseBraceToken.equals(token)) {
            return false;
        }
        if (8 == token.type) {
            return false;
        }
        if (this.tokenArr.size() < 3) {
            return false;
        }
        Token token1 = this.tokenArr.get(index - 1);
        Token token2 = this.tokenArr.get(index - 2);
        return this.isOperator(token1) && this.isConditionField(token2);
    }

    public boolean isConditionFieldValue2(Token token, int index) {
        if (5 == token.type && Token.OpenBraceToken.equals(token)) {
            return false;
        }
        if (5 == token.type && Token.CloseBraceToken.equals(token)) {
            return false;
        }
        if (8 == token.type) {
            return false;
        }
        if (this.tokenArr.size() < 3) {
            return false;
        }
        Token token1 = this.tokenArr.get(index - 1);
        Token token2 = this.tokenArr.get(index - 2);
        return this.isOperator(token1) && this.isConditionValue(token2);
    }

    public String transferConditionFieldValue(Token token, int index) {
        if (this.tokenArr.size() < 3) {
            return token.value;
        }
        Token token1 = this.tokenArr.get(index - 1);
        Token token2 = this.tokenArr.get(index - 2);
        if (this.isOperator(token1) && this.isConditionField(token2) && this.conditionFieldMap.containsKey(token2.value)) {
            ConditionFieldInfo field = this.conditionFieldMap.get(token2.value);
            String meta = field.getMetaData();
            if (FieldTypeEnum.ENTITY == field.getType()) {
                MetaDataPK metaDataPK = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                metaDataPK = new MetaDataPK(meta);
                EntityObjectInfo entity = loader.getEntity((IMetaDataPK)metaDataPK);
                IDynamicObject iDynamicObject = null;
                try {
                    iDynamicObject = DynamicObjectFactory.getRemoteInstance();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)token.value, CompareType.EQUALS));
                    view.setFilter(filter);
                    IObjectCollection col = iDynamicObject.getCollection(entity.getType(), view);
                    if (!CollectionUtil.isEmpty((IObjectCollection)col)) {
                        return col.getObject(0).get("id").toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return token.value;
    }

    public String transferConditionFieldValue2(Token token, int index) {
        if (this.tokenArr.size() < 3) {
            return token.value;
        }
        Token token1 = this.tokenArr.get(index - 1);
        Token token2 = this.tokenArr.get(index - 2);
        if (this.isOperator(token1) && this.isConditionValue(token2) && this.conditionFieldMap2.containsKey(token2.value)) {
            ConditionFieldInfo field = this.conditionFieldMap2.get(token2.value);
            String meta = field.getMetaData();
            if (FieldTypeEnum.ENTITY == field.getType()) {
                MetaDataPK metaDataPK = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                metaDataPK = new MetaDataPK(meta);
                EntityObjectInfo entity = loader.getEntity((IMetaDataPK)metaDataPK);
                IDynamicObject iDynamicObject = null;
                try {
                    iDynamicObject = DynamicObjectFactory.getRemoteInstance();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)token.value, CompareType.EQUALS));
                    view.setFilter(filter);
                    IObjectCollection col = iDynamicObject.getCollection(entity.getType(), view);
                    if (!CollectionUtil.isEmpty((IObjectCollection)col)) {
                        return col.getObject(0).get("name").toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return token.value;
    }

    private boolean isProcedureStepAlias(int index) throws ParserException {
        Token token = this.tokenlist.lookup(index);
        return token.value.indexOf(ConditionConstant.PROCEDURE_FORMULA_STEP_ALIAS) >= 0 && this.isProcedureFormula;
    }

    private boolean isProcedureStepExper(int index) throws ParserException {
        Token token = this.tokenlist.lookup(index);
        return token.value.indexOf("PROCEDURE_FORMULA_STEP") >= 0 && this.isProcedureFormula;
    }

    public TokenList getScriptTokenList() throws ParserException {
        StringBuffer scriptsb = new StringBuffer();
        int index = 0;
        this.tokenArr = new ArrayList<Token>();
        while (true) {
            Token token = this.tokenlist.lookup(index);
            this.tokenArr.add(index, token);
            if (token == null || token.type == 12) break;
            if (this.isConditionField(token)) {
                scriptsb.append(this.conditionFieldMap.get(token.value).getNumber());
            } else if (this.isConditionFieldValue(token, index)) {
                scriptsb.append("\"");
                scriptsb.append(this.transferConditionFieldValue(token, index));
                scriptsb.append("\"");
            } else if (this.isConstant(index)) {
                scriptsb.append("\"");
                scriptsb.append(token.value);
                scriptsb.append("\"");
            } else if (this.isProcedureStepAlias(index)) {
                String value = token.value;
                value = value.replaceAll(ConditionConstant.PROCEDURE_FORMULA_STEP_ALIAS, "PROCEDURE_FORMULA_STEP");
                scriptsb.append(value);
            } else {
                if (6 == token.type) {
                    scriptsb.append("\"").append(token.value).append("\"");
                } else {
                    scriptsb.append(token.value);
                }
                if (token.value.equals("if") || token.value.equals("else")) {
                    scriptsb.append(" ");
                }
            }
            ++index;
        }
        Lexer _lexer = new Lexer(scriptsb.toString());
        TokenList _tokenList = new TokenList(_lexer);
        return _tokenList;
    }

    private boolean isConstant(int index) throws ParserException {
        if (index < 1) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 6 == token.type;
    }

    public TokenList getAliasTokenList() throws ParserException {
        StringBuffer aliassb = new StringBuffer();
        int index = 0;
        while (true) {
            Token token = this.tokenlist.lookup(index);
            this.tokenArr.add(index, token);
            if (token == null || token.type == 12) break;
            if (this.isConditionValue(token)) {
                aliassb.append(this.conditionFieldMap2.get(token.value).getName());
            } else if (this.isConditionFieldValue2(token, index)) {
                aliassb.append("\"");
                aliassb.append(this.transferConditionFieldValue2(token, index));
                aliassb.append("\"");
            } else if (this.isConstant(index)) {
                aliassb.append("\"");
                aliassb.append(token.value);
                aliassb.append("\"");
            } else if (this.isProcedureStepExper(index)) {
                String value = token.value;
                value = value.replaceAll("PROCEDURE_FORMULA_STEP", ConditionConstant.PROCEDURE_FORMULA_STEP_ALIAS);
                aliassb.append(value);
            } else {
                boolean flag = false;
                for (int i = 0; i < chineseKeywords.length; ++i) {
                    if (!chineseKeywords[i].equals(token.value)) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    aliassb.append(" ");
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else if (token.value.equals("if") || token.value.equals("else")) {
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else {
                    aliassb.append(token.value);
                }
            }
            ++index;
        }
        Lexer _lexer = new Lexer(aliassb.toString());
        TokenList _tokenList = new TokenList(_lexer);
        return _tokenList;
    }
}

