/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.formula;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.service.formula.builder.FormulaUtils;
import com.kingdee.bos.service.formula.engine.BOSObjectTransformer;
import com.kingdee.bos.service.formula.engine.IfThenTransformer;
import com.kingdee.bos.service.formula.engine.KeyWordTransformer;
import com.kingdee.bos.service.formula.engine.ValidateResult;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackKeyWordTransformer;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeInfo;
import com.kingdee.eas.scm.framework.condition.formula.ProcedureTypeTransformer;
import java.util.Locale;
import java.util.Vector;

public class RequirementFormulaTransformer {
    WriteBackKeyWordTransformer keyWordTransformer = new WriteBackKeyWordTransformer();
    IfThenTransformer ifThenTransformer = new IfThenTransformer();
    BOSObjectTransformer bosObjectTransformer;
    ProcedureTypeTransformer procedureTypeTransformer;

    public RequirementFormulaTransformer(ProcedureTypeInfo procedureTypeInfo) {
        this.procedureTypeTransformer = new ProcedureTypeTransformer(procedureTypeInfo);
    }

    public void setLocale(String locale) {
        this.setLocale(new Locale(locale));
    }

    public void setLocale(Locale locale) {
        KeyWordTransformer.setLocale((Locale)locale);
    }

    public RequirementFormulaTransformer() {
        this(null);
    }

    public void addBOSObjects(BusinessObjectInfo[] bosobjs) {
        this.bosObjectTransformer.addBOSObjects(bosobjs);
    }

    public void addBOSObjects(Vector bosobjs) {
        this.bosObjectTransformer.addBOSObjects(bosobjs);
    }

    public TokenList transformeToken(String formulaString) throws ParserException {
        Lexer lexer = new Lexer(formulaString);
        TokenList _tokenList = new TokenList(lexer);
        _tokenList = this.keyWordTransformer.transform(_tokenList);
        _tokenList = this.ifThenTransformer.transform(_tokenList);
        _tokenList = this.procedureTypeTransformer.transform(_tokenList);
        return _tokenList;
    }

    public TokenList transformeToken(String formulaString, boolean isProcedureFormula) throws ParserException {
        Lexer lexer = new Lexer(formulaString);
        TokenList _tokenList = new TokenList(lexer);
        _tokenList = this.keyWordTransformer.transform(_tokenList);
        _tokenList = this.ifThenTransformer.transform(_tokenList);
        _tokenList = this.procedureTypeTransformer.transform(_tokenList, isProcedureFormula);
        return _tokenList;
    }

    public String reverseTransform(String script) throws ParserException {
        Lexer lexer = new Lexer(script);
        TokenList _tokenList = new TokenList(lexer);
        this.fixSpace(_tokenList);
        _tokenList = this.procedureTypeTransformer.reverseTransform(_tokenList);
        this.fixSpace(_tokenList);
        _tokenList = this.keyWordTransformer.reverseTransform(_tokenList);
        this.fixSpace(_tokenList);
        return FormulaUtils.printTokenList((TokenList)_tokenList);
    }

    public String reverseTransform(String script, boolean isProcedureFormula) throws ParserException {
        Lexer lexer = new Lexer(script);
        TokenList _tokenList = new TokenList(lexer);
        this.fixSpace(_tokenList);
        _tokenList = this.procedureTypeTransformer.reverseTransform(_tokenList, isProcedureFormula);
        this.fixSpace(_tokenList);
        _tokenList = this.keyWordTransformer.reverseTransform(_tokenList);
        this.fixSpace(_tokenList);
        return FormulaUtils.printTokenList((TokenList)_tokenList);
    }

    public TokenList fixSpace(TokenList tokenList) throws ParserException {
        Token k;
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            if (k.type == 4) {
                Token next = tokenList.lookup(index + 1);
                if (k.space.length() == 0) {
                    k.space = " ";
                }
                if (next != null && next.space.length() == 0) {
                    next.space = " ";
                }
            }
            ++index;
        }
        return tokenList;
    }

    public String transforme(String formulaString) throws ParserException {
        return FormulaUtils.printTokenList((TokenList)this.transformeToken(formulaString));
    }

    public String transforme(String formulaString, boolean isProcedureFormula) throws ParserException {
        return FormulaUtils.printTokenList((TokenList)this.transformeToken(formulaString, isProcedureFormula));
    }

    public ValidateResult validate(String formulaString) {
        ValidateResult re = new ValidateResult();
        try {
            String script = this.transforme(formulaString);
            KScriptParser parser = new KScriptParser(script);
            parser.parse();
            return re;
        }
        catch (ParserException e) {
            re.success = false;
            re.errorMsg = e.getMessage();
            return re;
        }
    }

    public boolean scriptIsFormula(String script, String formulaString) throws ParserException {
        Lexer lexer = new Lexer(script);
        TokenList _scriptTokenList = new TokenList(lexer);
        TokenList _scriptTokenList1 = this.transformeToken(formulaString);
        return FormulaUtils.tokenListEquals((TokenList)_scriptTokenList, (TokenList)_scriptTokenList1);
    }
}

