/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.rpc.io.loadbalance.JobManager;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.KsqlUtil;
import com.kingdee.eas.scm.framework.log.ClearCacheTaskConf;
import com.kingdee.eas.scm.framework.log.IClearCacheTask;
import com.kingdee.eas.scm.framework.log.LogConfigCollection;
import com.kingdee.eas.scm.framework.log.LogConfigEntryCollection;
import com.kingdee.eas.scm.framework.log.LogConfigEntryInfo;
import com.kingdee.eas.scm.framework.log.LogConfigFactory;
import com.kingdee.eas.scm.framework.log.LogConfigInfo;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogAdapter;
import com.kingdee.eas.scm.framework.log.model.SCMBizLogBillConfigInfo;
import com.kingdee.eas.scm.framework.log.util.SCMBizLogUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SCMBizLogCache {
    private static Map<String, SCMBizLogBillConfigInfo> SCMBizLogBillConfig = new HashMap<String, SCMBizLogBillConfigInfo>();
    private static Map<String, Map<String, List<LogConfigEntryInfo>>> logConfig = new HashMap<String, Map<String, List<LogConfigEntryInfo>>>();
    private static Map<String, Set<String>> checkConfig = new HashMap<String, Set<String>>();
    private static Map<String, Boolean> booleanBackgroundParam = new HashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean getBooleanBackgroundParam(Context ctx, String key) throws BOSException {
        if (StringUtils.isEmpty((String)key)) {
            return false;
        }
        if (!booleanBackgroundParam.containsKey(key)) {
            Map<String, Boolean> map = booleanBackgroundParam;
            synchronized (map) {
                String sql = "select fvalue from t_dt_dttempparam where fkey = ? ";
                Object[] params = new String[]{key};
                IRowSet rs = KsqlUtil.executeQuery(ctx, sql, params);
                String value = "";
                try {
                    while (rs.next()) {
                        value = rs.getString("fvalue");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                Boolean result = "1".equalsIgnoreCase(value) || Boolean.valueOf(value) != false;
                booleanBackgroundParam.put(key, result);
            }
        }
        return booleanBackgroundParam.get(key);
    }

    public static SCMBizLogBillConfigInfo getSCMBizLogBillConfigInfo(Context ctx, String bosType) throws BOSException {
        SCMBizLogBillConfigInfo slbci;
        if (SCMBizLogBillConfig.isEmpty()) {
            SCMBizLogCache.initData(ctx);
        }
        if ((slbci = SCMBizLogBillConfig.get(bosType)) == null) {
            slbci = SCMBizLogCache.createDeafultSCMBizLogBillConfigInfo(bosType);
        }
        return slbci;
    }

    private static SCMBizLogBillConfigInfo createDeafultSCMBizLogBillConfigInfo(String bosType) {
        SCMBizLogBillConfigInfo slbci = new SCMBizLogBillConfigInfo();
        slbci.setBosType(bosType);
        slbci.setEntryField("entry");
        slbci.setCoreBillField("coreBillId");
        slbci.setSourceBillField("sourceBillId");
        slbci.setNumberField("number");
        return slbci;
    }

    public static Map<String, List<LogConfigEntryInfo>> getLogConfigMap(Context ctx, IObjectPK mainBizOrgPk) throws BOSException, EASBizException {
        if (logConfig.isEmpty()) {
            SCMBizLogCache.initData(ctx);
        }
        Map<String, List<LogConfigEntryInfo>> logConfigMap = null;
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("CU.longNumber");
        FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(mainBizOrgPk, select);
        if (orgUnit != null) {
            String longNumber = orgUnit.getCU().getLongNumber();
            String[] longNumberArr = longNumber.split("!");
            HashSet set = new HashSet();
            Collections.addAll(set, longNumberArr);
            if (!set.isEmpty()) {
                String kSql = "select id where number in " + SCMBizLogUtils.transList2String(set) + " order by level desc";
                CtrlUnitCollection coll = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(kSql);
                for (int i = 0; i < coll.size(); ++i) {
                    CtrlUnitInfo info = coll.get(i);
                    logConfigMap = logConfig.get(info.getId().toString());
                    if (logConfigMap == null) continue;
                    return logConfigMap;
                }
            }
        }
        return logConfigMap;
    }

    public static Set<String> getMethodCheckConfig(Context ctx) throws BOSException {
        return SCMBizLogCache.getCheckConfig(ctx, "method");
    }

    public static Set<String> getPackageCheckConfig(Context ctx) throws BOSException {
        return SCMBizLogCache.getCheckConfig(ctx, "package");
    }

    private static Set<String> getCheckConfig(Context ctx, String key) throws BOSException {
        if (checkConfig.isEmpty()) {
            SCMBizLogCache.initData(ctx);
        }
        return checkConfig.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initData(Context ctx) throws BOSException {
        IRowSet rs;
        String sql;
        Map<String, Object> map = SCMBizLogBillConfig;
        synchronized (map) {
            if (SCMBizLogBillConfig.isEmpty()) {
                sql = "select * from T_SCM_BIZLOGBILLCONFIG";
                rs = KsqlUtil.executeQuery(ctx, sql);
                try {
                    while (rs.next()) {
                        SCMBizLogBillConfigInfo slbci = new SCMBizLogBillConfigInfo();
                        slbci.setBosType(rs.getString("FBosType"));
                        slbci.setEntryField(rs.getString("FEntryField"));
                        slbci.setCoreBillField(rs.getString("FCoreBillField"));
                        slbci.setSourceBillField(rs.getString("FSourceBillField"));
                        slbci.setNumberField(rs.getString("FNumberField"));
                        SCMBizLogBillConfig.put(slbci.getBosType(), slbci);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (SCMBizLogBillConfig.isEmpty()) {
                    SCMBizLogBillConfig.put("NONE", new SCMBizLogBillConfigInfo());
                }
            }
        }
        map = logConfig;
        synchronized (map) {
            if (logConfig.isEmpty()) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("logType", (Object)1, CompareType.EQUALS));
                ev.setFilter(filter);
                SelectorItemCollection select = new SelectorItemCollection();
                select.add("CU.id");
                select.add("entry.field");
                select.add("entry.fieldName");
                select.add("entry.billBosType");
                select.add("entry.billName");
                select.add("entry.isRelationField");
                ev.setSelector(select);
                ServiceStateManager.getInstance().disableNextCallService(new SCMBizLogAdapter().getName());
                LogConfigCollection coll = LogConfigFactory.getLocalInstance(ctx).getLogConfigCollection(ev);
                for (int i = 0; i < coll.size(); ++i) {
                    LogConfigInfo info = coll.get(i);
                    String cuId = info.getCU().getId().toString();
                    HashMap fieldsMap = new HashMap();
                    logConfig.put(cuId, fieldsMap);
                    LogConfigEntryCollection entryColl = info.getEntry();
                    for (int j = 0; j < entryColl.size(); ++j) {
                        LogConfigEntryInfo entryInfo = entryColl.get(j);
                        String bosType = entryInfo.getBillBosType();
                        if (fieldsMap.containsKey(bosType)) {
                            ((List)fieldsMap.get(bosType)).add(entryInfo);
                            continue;
                        }
                        ArrayList<LogConfigEntryInfo> entryInfoList = new ArrayList<LogConfigEntryInfo>();
                        entryInfoList.add(entryInfo);
                        fieldsMap.put(bosType, entryInfoList);
                    }
                }
                if (logConfig.isEmpty()) {
                    logConfig.put("NONE", new HashMap());
                }
            }
        }
        map = checkConfig;
        synchronized (map) {
            if (checkConfig.isEmpty()) {
                sql = "select * from T_SCM_BIZLOGCHECKCONFI";
                rs = KsqlUtil.executeQuery(ctx, sql);
                try {
                    while (rs.next()) {
                        String key = rs.getString("FKEYSTR");
                        String value = rs.getString("FVALUESTR");
                        if (StringUtils.isEmpty((String)key)) continue;
                        if (checkConfig.containsKey(key)) {
                            checkConfig.get(key).add(value);
                            continue;
                        }
                        HashSet<String> set = new HashSet<String>();
                        set.add(value);
                        checkConfig.put(key, set);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (checkConfig.isEmpty()) {
                    checkConfig.put("NONE", new HashSet());
                }
            }
        }
    }

    public static void clearBooleanBackgroundParam() throws BOSException {
        SCMBizLogCache.innerClearBooleanBackgroundParam();
        ClearCacheTaskConf task = new ClearCacheTaskConf(){

            public JobManager.Task<IClearCacheTask> getTask() {
                return new JobManager.Task<IClearCacheTask>(){

                    public void run(IClearCacheTask model) throws BOSException {
                        model.clearBooleanBackgroundParam();
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void innerClearBooleanBackgroundParam() {
        Map<String, Boolean> map = booleanBackgroundParam;
        synchronized (map) {
            booleanBackgroundParam.clear();
        }
    }

    public static void clearSCMBizLogBillConfig() throws BOSException {
        SCMBizLogCache.innerClearSCMBizLogBillConfig();
        ClearCacheTaskConf task = new ClearCacheTaskConf(){

            public JobManager.Task<IClearCacheTask> getTask() {
                return new JobManager.Task<IClearCacheTask>(){

                    public void run(IClearCacheTask model) throws BOSException {
                        model.clearSCMBizLogBillConfig();
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void innerClearSCMBizLogBillConfig() {
        Map<String, SCMBizLogBillConfigInfo> map = SCMBizLogBillConfig;
        synchronized (map) {
            SCMBizLogBillConfig.clear();
        }
    }

    public static void clearLogConfig() throws BOSException {
        SCMBizLogCache.innerClearLogConfig();
        ClearCacheTaskConf task = new ClearCacheTaskConf(){

            public JobManager.Task<IClearCacheTask> getTask() {
                return new JobManager.Task<IClearCacheTask>(){

                    public void run(IClearCacheTask model) throws BOSException {
                        model.clearLogConfig();
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void innerClearLogConfig() {
        Map<String, Map<String, List<LogConfigEntryInfo>>> map = logConfig;
        synchronized (map) {
            logConfig.clear();
        }
    }

    public static void clearCheckConfig() throws BOSException {
        SCMBizLogCache.innerClearCheckConfig();
        ClearCacheTaskConf task = new ClearCacheTaskConf(){

            public JobManager.Task<IClearCacheTask> getTask() {
                return new JobManager.Task<IClearCacheTask>(){

                    public void run(IClearCacheTask model) throws BOSException {
                        model.clearCheckConfig();
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void innerClearCheckConfig() {
        Map<String, Map<String, List<LogConfigEntryInfo>>> map = logConfig;
        synchronized (map) {
            checkConfig.clear();
        }
    }

    public static void clearAll() throws BOSException {
        SCMBizLogCache.innerClearAll();
        ClearCacheTaskConf task = new ClearCacheTaskConf(){

            public JobManager.Task<IClearCacheTask> getTask() {
                return new JobManager.Task<IClearCacheTask>(){

                    public void run(IClearCacheTask model) throws BOSException {
                        model.clearAllConfig();
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    public static void innerClearAll() throws BOSException {
        SCMBizLogCache.innerClearSCMBizLogBillConfig();
        SCMBizLogCache.innerClearLogConfig();
        SCMBizLogCache.innerClearCheckConfig();
        SCMBizLogCache.innerClearBooleanBackgroundParam();
    }
}

