/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.model;

import com.kingdee.eas.scm.framework.model.JoinCondition;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class JoinConditionCollection {
    private static final String JOIN_AND = " AND ";
    private static final String JOIN_OR = " OR ";
    private static final String POUND = "#";
    private String maskString;
    private List<String> logicList = new ArrayList<String>();
    private List<JoinCondition> joinConditionlist = new ArrayList<JoinCondition>();

    public JoinConditionCollection(String joinString) {
        this.parse(joinString);
    }

    private void parse(String joinString) {
        if (StringUtil.isEmpty((String)joinString)) {
            return;
        }
        int count = 0;
        JoinCondition joinCond = null;
        StringBuffer maskStr = new StringBuffer();
        String[] andJoinCondition = joinString.split(JOIN_AND);
        for (int i = 0; i < andJoinCondition.length; ++i) {
            String partCondition = andJoinCondition[i];
            String[] orJoinCondition = partCondition.split(JOIN_OR);
            if (count > 0) {
                maskStr.append(JOIN_AND);
            }
            for (int j = 0; j < orJoinCondition.length; ++j) {
                joinCond = new JoinCondition(orJoinCondition[j]);
                this.joinConditionlist.add(joinCond);
                if (j > 0) {
                    maskStr.append(JOIN_OR);
                }
                maskStr.append(POUND).append(count++);
                if (j < orJoinCondition.length - 1) {
                    joinCond.setLogicSign(JOIN_OR.trim());
                    continue;
                }
                if (i >= andJoinCondition.length - 1) continue;
                joinCond.setLogicSign(JOIN_AND.trim());
            }
        }
        this.maskString = maskStr.toString();
    }

    public String toString() {
        String result = this.maskString;
        JoinCondition joinCond = null;
        for (int i = 0; i < this.joinConditionlist.size(); ++i) {
            joinCond = this.joinConditionlist.get(i);
            result = result.replace(POUND + i, joinCond.toString());
        }
        return result;
    }

    public int getConditionCount() {
        return this.joinConditionlist.size();
    }

    public JoinCondition getJoinConditionAt(int index) {
        if (index < 0 || index >= this.joinConditionlist.size()) {
            return null;
        }
        return this.joinConditionlist.get(index);
    }

    public String getLogicSign(int index) {
        if (index < 0 || index >= this.logicList.size()) {
            return "";
        }
        return this.logicList.get(index);
    }

    public String getMaskString() {
        return this.maskString;
    }

    public void setMaskString(String maskString) {
        this.maskString = maskString;
    }

    public List<JoinCondition> getJoinConditionlist() {
        return this.joinConditionlist;
    }

    public void setJoinConditionlist(List<JoinCondition> joinConditionlist) {
        this.joinConditionlist = joinConditionlist;
    }
}

