/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.plugin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.framework.bizflow.AutoCreatePlugInCollection;
import com.kingdee.eas.scm.framework.bizflow.AutoCreatePlugInFactory;
import com.kingdee.eas.scm.framework.bizflow.AutoCreatePlugInInfo;
import com.kingdee.eas.scm.framework.bizflow.BizFlowException;
import com.kingdee.eas.scm.framework.bizflow.ProcessNodeInfo;
import com.kingdee.eas.scm.framework.bizflow.app.BizFlowServerHelper;
import com.kingdee.eas.scm.framework.bizflow.app.log.BizFlowLogger;
import com.kingdee.eas.scm.framework.bizflow.app.log.IBizFlowLogger;
import com.kingdee.eas.scm.framework.bizflow.app.plugin.IAutoCreatePlugInHandler;
import com.kingdee.eas.scm.framework.bizflow.util.Constant;
import com.kingdee.eas.scm.framework.plugin.PlugInException;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutoGenerateBillProcessor {
    private static String COREBILL_ENTRY_ID = "id";
    private static String COREBILL_ENTRY_ID_KEY = "FID";
    private IBizFlowLogger logger = null;
    protected LowTimer timer = null;

    public void doProcessing(Context ctx, IObjectValue model, BatchActionEnum action, ProcessNodeInfo nodeInfo, boolean isPreNode) throws BOSException, EASBizException {
        if (nodeInfo == null || nodeInfo.getBotpRule() == null) {
            return;
        }
        String botpNumber = nodeInfo.getBotpRule().getName();
        if (this.logger == null) {
            this.logger = new BizFlowLogger(ctx);
        }
        if (model.get("number") != null) {
            if (isPreNode) {
                this.logger.info("\u81ea\u52a8\u751f\u6210\u524d\u8282\u70b9\uff0c\u6e90\u5355\u7f16\u7801\uff1a" + model.get("number").toString());
            } else {
                this.logger.info("\u81ea\u52a8\u751f\u6210\u540e\u8282\u70b9\uff0c\u6e90\u5355\u7f16\u7801\uff1a" + model.get("number").toString());
            }
        }
        this.logger.info("botp\u7f16\u7801\uff1a" + botpNumber + "\uff0cbotp\u540d\u79f0\uff1a" + nodeInfo.getBotpRule().getAlias());
        if (nodeInfo.isIsCenterBalance()) {
            this.invokeInnerPlugInHandler(ctx, model, nodeInfo.getNodeBillBosType(), botpNumber);
        } else {
            IObjectCollection objColl = this.autoGenerateBill(ctx, model, botpNumber, isPreNode);
            BOTMappingInfo mappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("select id,defineSys where name='" + botpNumber + "'");
            if (mappingInfo.getDefineSys() == DefineSysEnum.DAP) {
                return;
            }
            this.afterAutoGenerate(ctx, model, objColl, nodeInfo, isPreNode);
        }
    }

    protected IObjectCollection autoGenerateBill(Context ctx, IObjectValue model, String botpNumber, boolean isPreNode) throws BOSException, EASBizException {
        IObjectCollection objColl;
        block12: {
            BTPTransformResult transformResult;
            BOTMappingInfo botMappingInfo;
            block13: {
                objColl = null;
                botMappingInfo = null;
                if (this.logger == null) {
                    this.logger = new BizFlowLogger(ctx);
                }
                if (this.timer == null) {
                    this.timer = new LowTimer();
                }
                if (model == null) {
                    return objColl;
                }
                try {
                    this.timer.reset();
                    botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='" + botpNumber + "'");
                    this.logger.info("\u81ea\u52a8\u751f\u6210\u8282\u70b9\u6839\u636ebotp\u7f16\u7801\u53d6botp\u8017\u65f6\uff1a" + this.timer.msValue());
                }
                catch (Exception e) {
                    throw new PlugInException(PlugInException.BOTPERROR, new String[]{botpNumber});
                }
                if (!botMappingInfo.getExtRule().isIsEffected()) {
                    throw new PlugInException(PlugInException.BOTPERROR, new String[]{botpNumber});
                }
                if (!(model instanceof CoreBillBaseInfo)) break block12;
                this.timer.reset();
                if (botMappingInfo.getDefineSys() == DefineSysEnum.DAP) {
                    SelectorItemCollection botpSelectors = null;
                    try {
                        botpSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfo);
                    }
                    catch (Exception e) {
                        throw new BOSException(e.getMessage());
                    }
                    ICoreBillBase coreBillBase = (ICoreBillBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)model.getBOSType());
                    DAPTransformResult result = coreBillBase.generateVoucher((IObjectPK[])new ObjectUuidPK[]{new ObjectUuidPK(((CoreBillBaseInfo)model).getId())}, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId()), botpSelectors);
                    this.logger.info("dap\u8f6c\u6362\u8017\u65f6\uff1a" + this.timer.msValue());
                    return result.getVoucherCollection();
                }
                transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform((CoreBillBaseInfo)model, botMappingInfo);
                this.logger.info("botp\u8f6c\u6362\u8017\u65f6\uff1a" + this.timer.msValue());
                objColl = transformResult.getBills();
                if (!isPreNode) break block13;
                this.processDefaultValue(ctx, model, objColl);
                HashSet<String> idSet = new HashSet<String>();
                ICoreBillBase iCoreBillBase = (ICoreBillBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)objColl.getObject(0).getBOSType());
                int size = objColl.size();
                for (int i = 0; i < size; ++i) {
                    IObjectPK pk = iCoreBillBase.save((CoreBaseInfo)objColl.getObject(i));
                    idSet.add(pk.toString());
                }
                if (idSet.size() <= 0) break block12;
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                ev.setFilter(filter);
                objColl = iCoreBillBase.getCollection(ev);
                int size2 = objColl.size();
                for (int i = 0; i < size2; ++i) {
                    BizFlowServerHelper.bizProcessParamBuilder(ctx, objColl.getObject(i), (IObjectCollection)transformResult.getBOTRelationCollection(), BatchActionEnum.SAVE);
                }
                break block12;
            }
            int size = objColl.size();
            for (int i = 0; i < size; ++i) {
                objColl.getObject(i).put("mappingId", (Object)botMappingInfo.getId().toString());
                BizFlowServerHelper.bizProcessParamBuilder(ctx, objColl.getObject(i), (IObjectCollection)transformResult.getBOTRelationCollection(), BatchActionEnum.SAVE);
            }
        }
        return objColl;
    }

    protected void afterAutoGenerate(Context ctx, IObjectValue model, IObjectCollection objColl, ProcessNodeInfo nodeInfo, boolean isPreNode) throws BOSException, EASBizException {
        if (objColl == null || objColl.size() == 0) {
            return;
        }
        if (this.logger == null) {
            this.logger = new BizFlowLogger(ctx);
        }
        if (this.timer == null) {
            this.timer = new LowTimer();
        }
        if (isPreNode) {
            this.writeBizFlowRelation(ctx, model, objColl);
            this.otherBizProcess(ctx, model, objColl);
        } else if (nodeInfo != null && nodeInfo.getPlugin() != null && nodeInfo.getPlugin().size() > 0) {
            this.invokePlugInHandler(ctx, model, objColl, nodeInfo.getPlugin());
        } else if (101 == nodeInfo.getDestBillStatus() || 103 == nodeInfo.getDestBillStatus() || 102 == nodeInfo.getDestBillStatus()) {
            int i;
            IBizCtrl iBizCtrl = BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)objColl.getObject(0).getBOSType());
            ICoreBillBase iCoreBillBase = (ICoreBillBase)iBizCtrl;
            this.timer.reset();
            ServiceStateManager.getInstance().enableNextCallServices();
            iCoreBillBase.handleAfterTransform("SAVE", objColl);
            this.logger.info("\u81ea\u52a8\u751f\u6210\u8282\u70b9\u8c03\u4e1a\u52a1\u5355\u636e\u7684botp\u8f6c\u6362\u63a5\u53e3handleAfterTransform\u8017\u65f6\uff1a" + this.timer.msValue());
            ArrayList<String> idList = new ArrayList<String>();
            int size = objColl.size();
            for (i = 0; i < size; ++i) {
                if (objColl.getObject(i) == null || !(objColl.getObject(i) instanceof CoreBaseInfo)) continue;
                this.timer.reset();
                ServiceStateManager.getInstance().enableNextCallServices();
                iCoreBillBase.save((CoreBaseInfo)objColl.getObject(i));
                if (model.get("number") != null && objColl.getObject(i).get("number") != null) {
                    this.logger.debug("\u6e90\u5355\u7f16\u7801\u4e3a\uff1a" + model.get("number").toString() + "\u81ea\u52a8\u751f\u6210\u8282\u70b9\u751f\u6210\u7684\u5355\u636eID\u4e3a\uff1a" + objColl.getObject(i).get("id").toString() + "\uff0c\u5355\u636e\u7f16\u7801\u4e3a\uff1a" + objColl.getObject(i).get("number").toString());
                }
                this.logger.info("\u81ea\u52a8\u751f\u6210\u8282\u70b9\u8c03\u4e1a\u52a1\u5355\u636e\u7684\u4fdd\u5b58\u65b9\u6cd5\u8017\u65f6\uff1a" + this.timer.msValue());
                idList.add(objColl.getObject(i).get("id").toString());
            }
            this.timer.reset();
            this.setFlagByAutoCreate(ctx, idList);
            this.logger.info("\u81ea\u52a8\u751f\u6210\u540e\u5bf9\u5355\u636e\u52a8\u6001\u6dfb\u52a0\u6807\u8bc6\u5b57\u6bb5\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
            if (102 == nodeInfo.getDestBillStatus()) {
                size = objColl.size();
                for (i = 0; i < size; ++i) {
                    if (objColl.getObject(i) == null || !(objColl.getObject(i) instanceof CoreBillBaseInfo)) continue;
                    this.timer.reset();
                    ServiceStateManager.getInstance().enableNextCallServices();
                    WfEventListenerStateManager.getInstance().enableEventListener();
                    iCoreBillBase.submit((CoreBaseInfo)objColl.getObject(i));
                    if (objColl.getObject(i).get("number") == null) continue;
                    this.logger.info("\u5f53\u81ea\u52a8\u751f\u6210\u8282\u70b9\u76ee\u6807\u5355\u72b6\u6001\u4e3a\u63d0\u4ea4\u65f6\uff0c\u8c03\u7528\u4e1a\u52a1\u63d0\u4ea4\u65b9\u6cd5\uff0c\u5355\u636e\u7f16\u7801\u4e3a\uff1a" + objColl.getObject(i).get("number").toString() + "\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
                }
            }
            if (103 == nodeInfo.getDestBillStatus()) {
                size = objColl.size();
                for (i = 0; i < size; ++i) {
                    if (objColl.getObject(i) == null || !(objColl.getObject(i) instanceof CoreBillBaseInfo)) continue;
                    this.timer.reset();
                    ServiceStateManager.getInstance().enableNextCallServices();
                    iCoreBillBase.submit((CoreBaseInfo)objColl.getObject(i));
                    if (objColl.getObject(i).get("number") == null) continue;
                    this.logger.info("\u5f53\u81ea\u52a8\u751f\u6210\u8282\u70b9\u76ee\u6807\u5355\u72b6\u6001\u4e3a\u5ba1\u6838\u65f6\uff0c\u8c03\u7528\u4e1a\u52a1\u63d0\u4ea4\u65b9\u6cd5\uff0c\u5355\u636e\u7f16\u7801\u4e3a\uff1a" + objColl.getObject(i).get("number").toString() + "\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
                }
                Set<String> autoIdSet = this.getAutoAuditBillIds(iCoreBillBase, objColl);
                int size2 = objColl.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    if (objColl.getObject(i2) == null || !(objColl.getObject(i2) instanceof CoreBillBaseInfo)) continue;
                    try {
                        if (autoIdSet != null && autoIdSet.size() > 0 && autoIdSet.contains(objColl.getObject(i2).get("id").toString())) continue;
                        Object[] obj = new Object[]{new ObjectUuidPK(objColl.getObject(i2).get("id").toString())};
                        Class[] clz = new Class[]{IObjectPK.class};
                        this.timer.reset();
                        Method method = iBizCtrl.getClass().getMethod("audit", clz);
                        if (objColl.getObject(i2).get("number") != null) {
                            this.logger.info("\u5f53\u81ea\u52a8\u751f\u6210\u8282\u70b9\u76ee\u6807\u5355\u72b6\u6001\u4e3a\u5ba1\u6838\u65f6\uff0c\u9700\u8981\u8c03\u7528\u4e1a\u52a1\u5355\u636e\u7684\u5ba1\u6838\u65b9\u6cd5\uff0c\u5355\u636e\u7f16\u7801\u4e3a\uff1a" + objColl.getObject(i2).get("number").toString() + "\uff0c\u8017\u65f6\uff1a" + this.timer.msValue());
                        }
                        BusinessProcessUtil.invokeBizMethod((IBizCtrl)iBizCtrl, (Method)method, (Object[])obj);
                        continue;
                    }
                    catch (SecurityException e) {
                        throw new BOSException((Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new BizFlowException(BizFlowException.BIZFLOW_ERROR007, new String[]{iBizCtrl.getName() + ".audit(com.kingdee.bos.dao.IObjectPK)"});
                    }
                }
            }
            this.traceUpAndDown(ctx, model, objColl);
        }
    }

    private OrgType getMainOrgType(SCMBillBaseInfo info) {
        return info == null ? null : info.getMainOrgType();
    }

    private Set<String> getAutoAuditBillIds(ICoreBillBase iCoreBillBase, IObjectCollection objCollection) throws BOSException, EASBizException {
        if (null == objCollection || objCollection.size() == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        int size = objCollection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue value = objCollection.getObject(i);
            idSet.add(String.valueOf(value.get("id")));
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorColl = view.getSelector();
        selectorColl.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("auditor", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        CoreBaseCollection collection = iCoreBillBase.getCollection(view);
        idSet.clear();
        int size2 = collection.size();
        for (int i = 0; i < size2; ++i) {
            idSet.add(String.valueOf(collection.get(i).get("id")));
        }
        return idSet;
    }

    private void setFlagByAutoCreate(Context ctx, List<String> idList) throws EASBizException, BOSException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        String bosType = BOSUuid.read((String)idList.get(0).toString()).getType().toString();
        StringBuilder ids = new StringBuilder();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            ids.append("'").append(idList.get(i).toString()).append("'");
            if (i >= size - 1) continue;
            ids.append(",");
        }
        EntityObjectInfo entityInfo = CommonUtils.getEntityByBosType(ctx, bosType);
        if (entityInfo != null && entityInfo.getTable() != null && !StringUtils.isEmpty((String)entityInfo.getTable().getName())) {
            String tableName = entityInfo.getTable().getName();
            StringBuilder executeSql = new StringBuilder();
            executeSql.append("If not exists (select 1 from ksql_usercolumns where ksql_col_tabname='" + tableName + "' and ksql_col_name='" + "FBizFlowFlag" + "') ");
            executeSql.append(" ALTER TABLE " + tableName + " ADD " + "FBizFlowFlag" + " int default(0);");
            DbUtil.execute((Context)ctx, (String)executeSql.toString());
            executeSql.setLength(0);
            executeSql.append("update ").append(tableName).append(" set ").append("FBizFlowFlag").append(" = 1 where fid in (");
            executeSql.append((CharSequence)ids).append(") ");
            DbUtil.execute((Context)ctx, (String)executeSql.toString());
        }
    }

    public void traceUpAndDown(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException {
        String bosType = "";
        String destBillId = "";
        IObjectValue objValue = null;
        if (model == null || objColl == null || objColl.size() == 0) {
            return;
        }
        String srcBillId = model.get("id").toString();
        String srcBosType = model.getBOSType().toString();
        StringBuilder sql = new StringBuilder();
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            sql.append("INSERT INTO t_bot_relation (FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FisEffected,FType) ");
            sql.append(" VALUES ( ");
            objValue = objColl.getObject(i);
            destBillId = objValue.get("id").toString();
            bosType = objValue.getBOSType().toString();
            sql.append("'").append(BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"59302EC6")).toString()).append("',");
            sql.append("'").append(srcBosType).append("',");
            sql.append("'").append(bosType).append("',");
            sql.append("'").append(srcBillId).append("',");
            sql.append("'").append(destBillId).append("',");
            sql.append("'unknown',");
            sql.append("1,");
            sql.append("0) \r\n");
        }
        if (sql.length() > 0) {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void writeBizFlowRelation(Context ctx, IObjectValue model, IObjectCollection objColl) throws EASBizException, BOSException {
        this.writePreBizFlowRelation(ctx, model, objColl);
    }

    private void writePreBizFlowRelation(Context ctx, IObjectValue model, IObjectCollection objColl) throws EASBizException, BOSException {
        String bizFlowNumber = "";
        if (this.logger == null) {
            this.logger = new BizFlowLogger(ctx);
        }
        HashMap<String, String> bizFlowMap = new HashMap<String, String>();
        if (objColl == null || objColl.size() == 0 || model == null || model.get("BizFlowRowSet") == null) {
            return;
        }
        IRowSet rowSet = (IRowSet)model.get("BizFlowRowSet");
        if (rowSet == null || rowSet.size() == 0) {
            return;
        }
        try {
            rowSet.first();
            rowSet.previous();
            while (rowSet.next()) {
                bizFlowNumber = rowSet.getString("FBizFlowRelation");
                if (StringUtils.isEmpty((String)bizFlowNumber)) continue;
                bizFlowNumber = bizFlowNumber.substring(0, bizFlowNumber.lastIndexOf("#"));
                bizFlowMap.put(rowSet.getString(COREBILL_ENTRY_ID_KEY), bizFlowNumber);
            }
            HashMap tableSrcList = CommonUtils.getEntityAllInfo(model.getBOSType().toString());
            HashMap tableList = CommonUtils.getEntityAllInfo(objColl.getObject(0).getBOSType().toString());
            if (tableSrcList == null || tableSrcList.size() <= 0 || tableList == null || tableList.size() <= 0) {
                return;
            }
            if (!this.setBizFlowRelationField(ctx, tableList)) {
                return;
            }
            StringBuilder updateSql = new StringBuilder();
            HashMap<String, IObjectValue> billInfoMap = new HashMap<String, IObjectValue>();
            IObjectCollection relationColl = (IObjectCollection)objColl.getObject(0).get("relationColl");
            if (relationColl != null && relationColl.size() > 0 && bizFlowMap != null && bizFlowMap.size() > 0) {
                int i;
                IObjectValue entryValue = null;
                BOTRelationEntryCollection btpRelationEntryColl = new BOTRelationEntryCollection();
                int size = relationColl.size();
                for (i = 0; i < size; ++i) {
                    BOTRelationInfo btpRelationInfo = ((BOTRelationCollection)relationColl).get(i);
                    btpRelationEntryColl.addCollection(btpRelationInfo.getRelationEntries());
                }
                for (i = 0; i < btpRelationEntryColl.size(); ++i) {
                    entryValue = btpRelationEntryColl.getObject(i);
                    if (entryValue == null || !bizFlowMap.containsKey(entryValue.get("srcentryid").toString())) continue;
                    bizFlowNumber = (String)bizFlowMap.get(entryValue.get("srcentryid").toString());
                    bizFlowMap.remove(entryValue.get("srcentryid").toString());
                    bizFlowMap.put(entryValue.get("destentryid").toString(), bizFlowNumber);
                }
                size = objColl.size();
                for (i = 0; i < size; ++i) {
                    if (objColl.getObject(i) == null) continue;
                    this.setBizFlowByRecursionCall(updateSql, tableList, objColl.getObject(i), bizFlowMap, billInfoMap);
                }
                if (bizFlowMap != null && bizFlowMap.size() > 0) {
                    HashMap<String, String> btpRelationList = new HashMap<String, String>();
                    HashMap<String, String> bizFlowRelationToListForUpdate = new HashMap<String, String>();
                    for (int i2 = 0; i2 < btpRelationEntryColl.size(); ++i2) {
                        entryValue = btpRelationEntryColl.getObject(i2);
                        if (entryValue == null) continue;
                        btpRelationList.put(entryValue.get("srcentryid").toString(), entryValue.get("destentryid").toString());
                        if (!bizFlowMap.containsKey(entryValue.get("destentryid").toString())) continue;
                        String bizFlowRelation = (String)bizFlowMap.get(entryValue.get("destentryid").toString());
                        bizFlowRelationToListForUpdate.put(entryValue.get("destentryid").toString(), bizFlowRelation + "-" + bizFlowNumber);
                    }
                    this.setBizFlowRelationValueForBOTP(ctx, model, tableSrcList, btpRelationList, bizFlowRelationToListForUpdate, updateSql, billInfoMap);
                }
            }
            if (updateSql.length() > 0) {
                this.logger.debug("\u81ea\u52a8\u751f\u6210\u524d\u8282\u70b9\u8bbe\u7f6e\u540e\u53f0\u6d41\u7a0b\u4e32\u53f7SQL\u8bed\u53e5\uff1a" + updateSql.toString());
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            model.put("bizFlowNumber", bizFlowMap);
            model.put("SrcBillColl", (Object)objColl);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setBizFlowByRecursionCall(StringBuilder updateSql, HashMap tableList, IObjectValue objInfo, Map<String, String> bizFlowMap, Map<String, IObjectValue> billInfoMap) {
        IObjectCollection coll = null;
        String bizFlowNumber = "";
        String bizFlowRelation = "";
        if (tableList == null || tableList.size() <= 0) {
            return;
        }
        HashMap tablePropertyList = (HashMap)tableList.get("property");
        HashMap tableTypeList = (HashMap)tableList.get("type");
        if (tablePropertyList == null || tablePropertyList.size() == 0 || tableTypeList == null || tableTypeList.size() == 0) {
            return;
        }
        for (Map.Entry entry : tableTypeList.entrySet()) {
            Object key;
            EntityObjectInfo entityInfo = (EntityObjectInfo)entry.getValue();
            String value = entityInfo.getTable().getName();
            if (tablePropertyList == null || !tablePropertyList.containsKey(entry.getKey().toString()) || (coll = (IObjectCollection)objInfo.get((key = tablePropertyList.get(entry.getKey().toString())).toString())) == null || coll.size() <= 0 || !entry.getKey().toString().equals(coll.getObject(0).getBOSType().toString())) continue;
            for (int i = 0; i < coll.size(); ++i) {
                IObjectValue entryValue = coll.getObject(i);
                if (entryValue == null) continue;
                String entryID = entryValue.get(COREBILL_ENTRY_ID).toString();
                if (bizFlowMap != null && bizFlowMap.containsKey(entryID)) {
                    bizFlowNumber = bizFlowMap.get(entryID).toString();
                }
                if (StringUtils.isEmpty((String)bizFlowNumber)) continue;
                bizFlowRelation = bizFlowNumber + "#" + entryID;
                updateSql.append(" update ").append(value).append(" set ").append("FBizFlowRelation");
                updateSql.append(" = '").append(bizFlowRelation).append("',FSeq = ").append(i + 1);
                updateSql.append(",FBaseStatus = 4 where ").append(COREBILL_ENTRY_ID_KEY).append(" = '").append(entryID).append("'");
                entryValue.put(Constant.BILL_RELATION_KEY, (Object)bizFlowRelation);
                if (bizFlowMap != null && bizFlowMap.containsKey(entryID)) {
                    bizFlowMap.put(entryID, bizFlowRelation);
                }
                if (objInfo.get("number") != null) {
                    entryValue.put("billNumber", (Object)objInfo.get("number").toString());
                } else {
                    entryValue.put("billNumber", (Object)"''");
                }
                if (objInfo.get("billType") != null && objInfo.get("billType") instanceof IObjectValue) {
                    IObjectValue billType = (IObjectValue)objInfo.get("billType");
                    entryValue.put("billTypeID", (Object)billType.get("id").toString());
                } else {
                    entryValue.put("billTypeID", (Object)"''");
                }
                entryValue.put("billId", (Object)objInfo.get("id").toString());
                entryValue.put("baseStatus", (Object)4);
                billInfoMap.put(entryID, entryValue);
                this.setBizFlowByRecursionCall(updateSql, tableList, entryValue, bizFlowMap, billInfoMap);
            }
        }
    }

    private void setBizFlowRelationValueForBOTP(Context ctx, IObjectValue model, HashMap tableDestList, HashMap btpRelationList, HashMap srcBillRelationList, StringBuilder updateSql, Map<String, IObjectValue> billInfoMap) throws EASBizException, BOSException {
        IObjectValue entryValue = null;
        IObjectCollection coll = null;
        String tableName = null;
        String currBillEntryID = null;
        String bizFlowRelation = null;
        if (updateSql == null || updateSql.length() == 0) {
            updateSql = new StringBuilder();
        }
        CoreBillBaseInfo coreBillInfo = (CoreBillBaseInfo)model;
        if (tableDestList == null || tableDestList.size() == 0) {
            return;
        }
        HashMap tableDestProperty = (HashMap)tableDestList.get("property");
        HashMap tableDestType = (HashMap)tableDestList.get("type");
        if (tableDestProperty == null || tableDestProperty.size() == 0 || tableDestType == null || tableDestType.size() == 0) {
            return;
        }
        for (Map.Entry entry : tableDestType.entrySet()) {
            Object key;
            EntityObjectInfo objInfo = (EntityObjectInfo)entry.getValue();
            tableName = objInfo.getTable().getName();
            if (!tableDestProperty.containsKey(entry.getKey().toString()) || (coll = (IObjectCollection)coreBillInfo.get((key = tableDestProperty.get(entry.getKey().toString())).toString())) == null || coll.size() <= 0 || !entry.getKey().toString().equals(coll.getObject(0).getBOSType().toString())) continue;
            for (int i = 0; i < coll.size(); ++i) {
                entryValue = coll.getObject(i);
                if (btpRelationList.get(entryValue.get("id").toString()) == null || btpRelationList.get(entryValue.get("id").toString()).toString().length() <= 0 || srcBillRelationList.get(btpRelationList.get(entryValue.get("id").toString()).toString()) == null || srcBillRelationList.get(btpRelationList.get(entryValue.get("id").toString()).toString()).toString().length() <= 0) continue;
                currBillEntryID = entryValue.get("id").toString();
                bizFlowRelation = srcBillRelationList.get(btpRelationList.get(entryValue.get("id").toString()).toString()).toString() + "#" + currBillEntryID;
                updateSql.append(" update " + tableName + " set " + "FBizFlowRelation" + "='" + bizFlowRelation + "' where FID='" + currBillEntryID + "' ");
                entryValue.put(Constant.BILL_RELATION_KEY, (Object)bizFlowRelation);
                if (!billInfoMap.containsKey(btpRelationList.get(entryValue.get("id").toString()))) continue;
                IObjectValue coreInfo = billInfoMap.get(btpRelationList.get(entryValue.get("id").toString()));
                this.updateSrcBillCoreInfo(ctx, updateSql, model, tableName, currBillEntryID, coreInfo);
                this.setCoreBillInfo(model, entryValue, coreInfo);
            }
        }
    }

    private void updateSrcBillCoreInfo(Context ctx, StringBuilder updateSql, IObjectValue model, String tableName, String currBillEntryID, IObjectValue coreInfo) {
        String coreIDField = "";
        String coreEntryIDField = "";
        String coreBillTypeField = "";
        String coreNumberField = "";
        String coreEntrySeqField = "";
        if (model == null || coreInfo == null) {
            return;
        }
        String bosType = model.getBOSType().toString();
        if ("783061E3".equals(bosType) || "CC3E933B".equals(bosType)) {
            if ("783061E3".equals(bosType)) {
                coreIDField = "FPurOrderID";
                coreEntryIDField = "FPurOrderEntryID";
                coreBillTypeField = "FCoreBillTypeID";
                coreNumberField = "FPurOrderNumber";
                coreEntrySeqField = "FPurOrderEntrySeq";
            } else if ("CC3E933B".equals(bosType)) {
                coreIDField = "FSaleOrderID";
                coreEntryIDField = "FSaleOrderEntryID";
                coreBillTypeField = "FCoreBillTypeID";
                coreNumberField = "FSaleOrderNumber";
                coreEntrySeqField = "FSaleOrderEntrySeq";
            }
            updateSql.append(" update ").append(tableName).append(" set ");
            updateSql.append(coreIDField).append(" = '").append(coreInfo.get("billId").toString()).append("',");
            updateSql.append(coreEntryIDField).append(" = '").append(coreInfo.get("id").toString()).append("',");
            updateSql.append(coreBillTypeField).append(" = '").append(coreInfo.get("billTypeID").toString()).append("',");
            updateSql.append(coreNumberField).append(" = '").append(coreInfo.get("billNumber").toString()).append("',");
            updateSql.append(coreEntrySeqField).append(" = ").append(coreInfo.get("seq"));
            updateSql.append(" where fid = '").append(currBillEntryID).append("' ");
        }
    }

    private void setCoreBillInfo(IObjectValue model, IObjectValue entryValue, IObjectValue coreEntryInfo) {
        String core = "";
        String coreEntry = "";
        String coreBillType = "";
        String coreEntrySeq = "";
        String coreNumber = "";
        String bosType = model.getBOSType().toString();
        if ("783061E3".equals(bosType) || "CC3E933B".equals(bosType)) {
            if ("783061E3".equals(bosType)) {
                core = "PurOrder";
                coreEntry = "PurOrderEntry";
                coreBillType = "CoreBillType";
                coreEntrySeq = "PurOrderEntrySeq";
                coreNumber = "PurOrderNumber";
            } else if ("CC3E933B".equals(bosType)) {
                core = "SaleOrder";
                coreEntry = "SaleOrderEntry";
                coreBillType = "CoreBillType";
                coreEntrySeq = "SaleOrderEntrySeq";
                coreNumber = "SaleOrderNumber";
            }
            entryValue.put(core, coreEntryInfo.get("billId"));
            entryValue.put(coreEntry, coreEntryInfo.get("id"));
            entryValue.put(coreNumber, coreEntryInfo.get("billNumber"));
            if (coreEntryInfo.get("billTypeID") != null) {
                BillTypeInfo billType = new BillTypeInfo();
                String typeID = coreEntryInfo.get("billTypeID").toString();
                billType.setId(BOSUuid.read((String)typeID));
                entryValue.put(coreBillType, (Object)billType);
            }
            entryValue.put(coreEntrySeq, coreEntryInfo.get("seq"));
        }
    }

    private boolean setBizFlowRelationField(Context ctx, HashMap tableList) throws EASBizException, BOSException {
        boolean isOk = false;
        StringBuilder executeSql = new StringBuilder();
        if (tableList == null || tableList.size() <= 0) {
            return false;
        }
        HashMap tableTypeList = (HashMap)tableList.get("type");
        if (tableTypeList == null || tableTypeList.size() <= 0) {
            return false;
        }
        executeSql.setLength(0);
        Iterator it = tableTypeList.entrySet().iterator();
        while (it.hasNext()) {
            executeSql.setLength(0);
            Map.Entry entry = it.next();
            EntityObjectInfo objInfo = (EntityObjectInfo)entry.getValue();
            String value = objInfo.getTable().getName();
            executeSql.append("If not exists (select 1 as FID from ksql_usercolumns where ksql_col_tabname='" + value + "' and ksql_col_name='" + "FBizFlowRelation" + "') ");
            executeSql.append(" ALTER TABLE " + value + " ADD " + "FBizFlowRelation" + " CLOB(8000)");
            if (executeSql.length() <= 0) continue;
            DbUtil.execute((Context)ctx, (String)executeSql.toString());
        }
        isOk = true;
        return isOk;
    }

    protected void processDefaultValue(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        CoreBillBaseInfo info = null;
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            info = (CoreBillBaseInfo)objColl.getObject(i);
            if (info.getAuditor() == null) {
                info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            info.put("isSysBill", (Object)Boolean.TRUE);
        }
        if (objColl.size() == 1 && (info = (CoreBillBaseInfo)objColl.getObject(0)).getNumber() == null) {
            info.setNumber("*" + model.getString("number"));
        }
    }

    protected void otherBizProcess(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
    }

    protected void invokePlugInHandler(Context ctx, IObjectValue model, IObjectCollection objColl, AutoCreatePlugInCollection plugInColl) throws BOSException, EASBizException {
        AutoCreatePlugInInfo plugIn = null;
        IAutoCreatePlugInHandler handler = null;
        if (this.logger == null) {
            this.logger = new BizFlowLogger(ctx);
        }
        for (int i = 0; i < plugInColl.size(); ++i) {
            plugIn = plugInColl.get(i);
            if (plugIn == null || (handler = this.getPlugInHandler(plugIn)) == null) continue;
            this.logger.debug("\u81ea\u52a8\u751f\u6210\u540e\u8282\u70b9\u63d2\u4ef6\u540d\u79f0\uff1a" + plugIn.getPlugInClass());
            handler.execute(ctx, model, objColl);
        }
    }

    private void invokeInnerPlugInHandler(Context ctx, IObjectValue model, String destBosType, String botpName) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)destBosType) || StringUtils.isEmpty((String)botpName)) {
            return;
        }
        AutoCreatePlugInInfo plugIn = AutoCreatePlugInFactory.getLocalInstance(ctx).getAutoCreatePlugInInfo((IObjectPK)new ObjectUuidPK("phVH/Pw5uUGvlD9xHs+v5EzoQ/4="));
        if (plugIn == null) {
            return;
        }
        IAutoCreatePlugInHandler handler = this.getPlugInHandler(plugIn);
        if (handler != null) {
            this.logger.debug("\u81ea\u52a8\u751f\u6210\u540e\u8282\u70b9\u63d2\u4ef6\u540d\u79f0\uff1a" + plugIn.getPlugInClass());
            handler.execute(ctx, model, destBosType, botpName);
        }
    }

    protected IAutoCreatePlugInHandler getPlugInHandler(AutoCreatePlugInInfo plugIn) throws PlugInException {
        IAutoCreatePlugInHandler handler = null;
        String className = plugIn.getPlugInClass();
        if (StringUtil.isEmpty((String)className)) {
            return handler;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object tmpHandler = clazz.newInstance();
            if (!(tmpHandler instanceof IAutoCreatePlugInHandler)) {
                throw new PlugInException(PlugInException.PLUGINNOTIMPLINTERFACE, new String[]{plugIn.getName()});
            }
            handler = (IAutoCreatePlugInHandler)tmpHandler;
        }
        catch (ClassNotFoundException e) {
            throw new PlugInException(PlugInException.CLASSNOTFOUNT, new String[]{className});
        }
        catch (InstantiationException e1) {
            throw new PlugInException(PlugInException.CLASSNEWINSTANCEERROR, new String[]{e1.getMessage()});
        }
        catch (IllegalAccessException e2) {
            throw new PlugInException(PlugInException.CLASSNEWINSTANCEERROR, new String[]{e2.getMessage()});
        }
        return handler;
    }
}

